/*******************************************************************************
 * SteamCollisionActor generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class SteamCollisionActor extends ParticleCollisionActor
	transient
	collapsecategories;

var float StartColHeight;
var float EndColHeight;
var float StartColRadius;
var float EndColRadius;
var float DamagePerTouch;

event Locked()
{
	super.Locked();
	__NFUN_621__(true, false, false);
	return;
}

event Unlocked()
{
	super.Unlocked();
	__NFUN_621__(false, false, false);
	__NFUN_620__(StartColRadius, StartColHeight);
	return;
}

event Update()
{
	local float ColHeight, ColRadius, Alpha;

	super.Update();
	Alpha = __NFUN_196__(pLifetimeRemaining, pLifetime);
	ColHeight = __NFUN_228__(Alpha, EndColHeight, StartColHeight);
	ColRadius = __NFUN_228__(Alpha, EndColRadius, StartColRadius);
	__NFUN_620__(ColRadius, ColHeight);
	return;
}

event Touch(Actor Other)
{
	super(Actor).Touch(Other);
	// End:0x25
	if(__NFUN_173__(string(Touching), 1))
	{
		__NFUN_607__(0.5, true, 'ApplySteamDamage');
	}
	return;
}

final simulated function ApplySteamDamage()
{
	local int i;

	// End:0x16
	if(__NFUN_173__(string(Touching), 0))
	{
		__NFUN_608__('ApplySteamDamage');
		return;
	}
	i = __NFUN_166__(string(Touching), 1);
	J0x25:

	// End:0xA1 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		// End:0x97
		if(__NFUN_340__(CollisionInstigator, Touching[i]))
		{
			Touching[i].TakeDamage(CollisionInstigator, DamagePerTouch, Touching[i].Location, __NFUN_232__(0, 0, 0), class'SteamDamage',, Location);
		}
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x25;
	}
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super(InteractiveActor).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1279__(class'SteamDamage');
	return;
}

defaultproperties
{
	StartColHeight=5
	EndColHeight=30
	StartColRadius=5
	EndColRadius=30
	DamagePerTouch=2
}