/*******************************************************************************
 * Forklift_VehicleSpace_Driver generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Forklift_VehicleSpace_Driver extends Generic_VehicleSpace_Driver
	collapsecategories;

var bool bRaise;
var bool bLower;
var Veh_Forklift Forklift;

simulated function SetVehicle(VehicleBase NewVehicle)
{
	super(VehicleSpaceBase).SetVehicle(NewVehicle);
	Forklift = Veh_Forklift(Vehicle);
	return;
}

function float VehicleSpace_GetSteerGridY()
{
	return __NFUN_585__('Forklift', 'LiftGrid');
	return;
}

simulated function UpdateForkState()
{
	return;
}

state() idle
{
	simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
	{
		super(dnUsableSomething).UsableSomethingQueryInteractKeyInfoState(HUD);
		// End:0x19
		if(__NFUN_339__(Forklift, none))
		{
			return;
		}
		SetHUDKeyInfoState(HUD, 0, Forklift.CanForkMove(true), 24,, __NFUN_173__(int(Forklift.ForkState), int(1)));
		SetHUDKeyInfoState(HUD, 1, Forklift.CanForkMove(false), 25,, __NFUN_173__(int(Forklift.ForkState), int(2)));
		return;
	}

	function VehicleUpActionEnable()
	{
		bRaise = true;
		UpdateForkState();
		return;
	}

	function VehicleUpActionDisable()
	{
		bRaise = false;
		UpdateForkState();
		return;
	}

	function VehicleDownActionEnable()
	{
		bLower = true;
		UpdateForkState();
		return;
	}

	function VehicleDownActionDisable()
	{
		bLower = false;
		UpdateForkState();
		return;
	}

	simulated function UpdateForkState()
	{
		local float DestGridPt, Time;

		// End:0x2A
		if(__NFUN_148__(bRaise, __NFUN_145__(bLower)))
		{
			Forklift.StartFork(true);			
		}
		else
		{
			// End:0x54
			if(__NFUN_148__(__NFUN_145__(bRaise), bLower))
			{
				Forklift.StartFork(false);				
			}
			else
			{
				// End:0x7C
				if(__NFUN_174__(int(Forklift.ForkState), int(0)))
				{
					Forklift.StopFork();
				}
			}
		}
		// End:0xA2
		if(__NFUN_173__(int(Forklift.ForkState), int(1)))
		{
			DestGridPt = 1;			
		}
		else
		{
			// End:0xC8
			if(__NFUN_173__(int(Forklift.ForkState), int(2)))
			{
				DestGridPt = -1;				
			}
			else
			{
				DestGridPt = 0;
			}
		}
		// End:0x125
		if(__NFUN_206__(__NFUN_586__('Forklift', 'LiftGrid'), DestGridPt))
		{
			Time = __NFUN_211__(__NFUN_195__(__NFUN_199__(__NFUN_585__('Forklift', 'LiftGrid'), DestGridPt), 0.5));
			__NFUN_577__('Forklift', 'LiftGrid', DestGridPt,, Time);
		}
		return;
	}
	stop;
}

defaultproperties
{
	SteerGridName=Forklift_SteerGrid
	States=/* Array type was not detected. */
}