/*******************************************************************************
 * Lift_VehicleSpace_Driver generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Lift_VehicleSpace_Driver extends VehicleSpaceBase
	collapsecategories
	dependson(Veh_TankTemplate);

var() name DriverAnimGrid;
var Veh_Lift Lift;
var float GridX;
var float GridY;
var float RightGridY;
var float StickMoveRate;
var bool bRaise;
var bool bLower;

simulated function UpdateLiftState()
{
	return;
}

simulated function SetVehicle(VehicleBase NewVehicle)
{
	super.SetVehicle(NewVehicle);
	Lift = Veh_Lift(Vehicle);
	return;
}

function VehicleSpaceTick_FullyEntered(float DeltaTime)
{
	local Veh_TankTemplate MeqonTank;
	local PlayerPawn PlayerUser;
	local MeshInstance minst;
	local Vector2D GridPt;
	local float GridPCT;

	super.VehicleSpaceTick_FullyEntered(DeltaTime);
	MeqonTank = Veh_TankTemplate(Vehicle);
	PlayerUser = PlayerPawn(User);
	// End:0x47
	if(__NFUN_150__(__NFUN_339__(PlayerUser, none), __NFUN_339__(MeqonTank, none)))
	{
		return;
	}
	bDoOverlayEffect = false;
	RightGridY = UpdateStickAlpha(RightGridY, Lift.LiftDirection, DeltaTime, StickMoveRate);
	GridX = UpdateStickAlpha(GridX, __NFUN_194__(MeqonTank.DriverHeading), DeltaTime, StickMoveRate);
	GridY = UpdateStickAlpha(GridY, MeqonTank.DriverAccel, DeltaTime, StickMoveRate);
	PlayerUser.AnimationController.SetAnimGridState(DriverAnimGrid, GridX, GridY);
	PlayerUser.AnimationController.SetAnimGridState('LIFT_LiftGrid', 0, RightGridY);
	AnimationController.SetAnimGridState('MainGrid', GridX, GridY);
	AnimationController.SetAnimGridState('LiftGrid', 0, RightGridY);
	return;
}

function AttachComplete()
{
	super.AttachComplete();
	// End:0x22
	if(__NFUN_340__(Lift, none))
	{
		Lift.EnablePlatformMagnet();
	}
	return;
}

function DetachComplete()
{
	bRaise = false;
	bLower = false;
	UpdateLiftState();
	User.AnimationController.EmptyAnimChannel('GrabPose');
	super.DetachComplete();
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super(dnControl).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1281__(DriverAnimGrid);
	PrecacheIndex.__NFUN_1281__('LIFT_LiftGrid');
	PrecacheIndex.__NFUN_1283__('MainGrid', AnimationControllerClass, Mesh);
	PrecacheIndex.__NFUN_1283__('LiftGrid', AnimationControllerClass, Mesh);
	return;
}

state() idle
{
	simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
	{
		// End:0x2E
		if(__NFUN_201__(Lift.LiftDirection, 0))
		{
			SetHUDKeyInfoState(HUD, 0, true, 24,, true);			
		}
		else
		{
			// End:0x5C
			if(__NFUN_200__(Lift.LiftDirection, 0))
			{
				SetHUDKeyInfoState(HUD, 1, true, 25,, true);				
			}
			else
			{
				SetHUDKeyInfoState(HUD, 0, true, 24);
				SetHUDKeyInfoState(HUD, 1, true, 25);
			}
		}
		return;
	}

	function VehicleUpActionEnable()
	{
		bRaise = true;
		UpdateLiftState();
		return;
	}

	function VehicleUpActionDisable()
	{
		bRaise = false;
		UpdateLiftState();
		return;
	}

	function VehicleDownActionEnable()
	{
		bLower = true;
		UpdateLiftState();
		return;
	}

	function VehicleDownActionDisable()
	{
		bLower = false;
		UpdateLiftState();
		return;
	}

	simulated function UpdateLiftState()
	{
		// End:0x29
		if(__NFUN_148__(bRaise, __NFUN_145__(bLower)))
		{
			Lift.RaiseLift();			
		}
		else
		{
			// End:0x52
			if(__NFUN_148__(__NFUN_145__(bRaise), bLower))
			{
				Lift.LowerLift();				
			}
			else
			{
				Lift.StopLift();
			}
		}
		return;
	}
	stop;
}

defaultproperties
{
	DriverAnimGrid=LIFT_DriveGrid
	StickMoveRate=4
	bVehicleRelative=false
}