/*******************************************************************************
 * Veh_CarTemplate generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Veh_CarTemplate extends Vehicle_MeqonWheeled_CarLike
	native
	collapsecategories
	dependson(VMotor);

cpptext
{
// Stripped
}

enum ECarAxleType
{
	CARAXLE_Front,
	CARAXLE_Rear
};

var() SCarWheelAxle FrontAxle;
var() SCarWheelAxle RearAxle;
var() const noexport float FrontRearDifferential "If this is a 4WD vehicle, this is the portion of the engine output that goes to the front wheels. The remainder goes to the back." "" "(Example: 0.0 would be the same as rear-wheel drive, whereas 0.5 would be an even split.)";
var() const noexport float FrontRearDifferentialLock "Badly named -- a value between 0.0 and 1.0. For a 4WD vehicle, this controls whether the front and rear axles will spin at the same speeds. For a 2WD, it controls whether the powered axle will spin at the same speed as the engine.";
var(VehicleSound) noexport name EngineStartSoundName "VoicePack entry to play when we start our engine.";
var(VehicleSound) noexport name EngineStopSoundName "VoicePack entry to play when we stop our engine.";
var(VehicleSound) array<SVehicleGearSounds> GearSounds;
var(VehicleSound) float EngineSoundVolume;
var(VehicleSound) noexport float MinRPMPitchAdjust "Amount to adjust pitch by when we're at 0 RPMs.";
var(VehicleSound) noexport float MaxRPMPitchAdjust "Amount to adjust pitch by when we're at Max RPMs.";
var(VehicleSound) noexport float BoostPitchAdjust "Amount to adjust pitch by when we're boosting.";
var(VehicleSound) noexport float InAirPitchAdjust "Amount to adjust pitch by when we're in the air.";
var(VehicleSound) noexport Vector EngineSoundOffset "Offset from center of vehicle where engine sounds will play from.";
var float PitchAdjust;
var float PitchAdjustRate;
var() SVehiclePhysicsAxleProperties AxleProps;
var() SVehiclePhysicsGearboxProperties GearboxProps;
var() SVehiclePhysicsAxleProperties MotorAxleProps;
var() SVehiclePhysicsMotorProperties MotorProps;
var(VehicleBoost) noexport SHUDEffect BoostHUDEffect "HUD effect to apply to a PlayerPawn when they are boosting.";
var(VehicleBoost) noexport bool bHasBoost "When true, this vehicle has boosting ability.";
var bool bBoosting;
var(VehicleBoost) noexport SVehiclePhysicsMotorProperties BoostMotorProps "Motor properties to use when boosting.";
var(VehicleBoost) noexport SViewShakeInfo BoostVibration "Camera shake to apply when boosting.";
var(VehicleBoost) noexport float BoostTime "Total time boost will last when fully charged.";
var(VehicleBoost) noexport float BoostRechargeTime "Total time it takes to fully charge up the boost.";
var(VehicleBoost) noexport float BoostOverheatDelay "Total time user must wait to boost when running boost all the way down to 0.";
var(VehicleBoost) noexport float BoostFOVScale "Maximum scale to apply to the FOV while boosting.  Will ramp up to this over BoostFOVRampTime.";
var(VehicleBoost) noexport float BoostFOVRampTime "Time it takes to fade FOV scale.";
var float BoostMeter;
var float BoostOverheatTimer;
var() const class<VDifferential> DifferentialClass;
var() const class<VMotor> MotorClass;
var() const class<VGearbox> GearboxClass;
var() const class<VAxle> AxleClass;
var VMotor motor;
var VGearbox Gearbox;
var int LastGearIndex;
var Engine.Object.ESoundSlot LastEngineSlot;
var bool bWasAccel;
var float EngineSoundStartTime;
var Vector InAirVelocity;
var bool bHadGroundContactLastFrame;
var SViewShakeInfo LandingShake;
var SRumbleInfo LandingRumble;
var SRumbleInfo BounceRumble;
var SRumbleInfo BoostRumble;
var SRumbleInfo AccelRumble;
var SRumbleInfo CollisionRumble;
var dnFriendFX_Spawners DustCloud;
var() float CrashVelocity;
var() float BounceVelocity;
var() float VelDotGravity;
var() float ImpactRumbleThreshold;
var bool bPerformImpactEffects;
var bool bPerformLandingEffects;
var bool bLandingEffectsThrottled;

simulated function PreBeginPlay()
{
	super.PreBeginPlay();
	InitializeDriveTrain();
	// End:0x26
	if(__NFUN_202__(BoostTime, 0))
	{
		BoostTime = 1;
	}
	// End:0x40
	if(__NFUN_202__(BoostRechargeTime, 0))
	{
		BoostRechargeTime = 1;
	}
	return;
}

function PostVerifySelf()
{
	super(Vehicle_MeqonWheeled).PostVerifySelf();
	DustCloud = dnFriendFX_Spawners(FindOwnedActor(class'Actor', 'DustCloud'));
	return;
}

simulated function InitializeDriveTrain()
{
	local class<VMotor> LocalMotorClass;
	local class<VGearbox> LocalGearboxClass;
	local class<VAxle> LocalAxleClass;
	local class<VDifferential> LocalDifferentialClass;
	local VDifferential PrimaryDifferential, SupportDifferentials;
	local VAxle PrimaryAxle, SupportAxles;

	LocalMotorClass = MotorClass;
	LocalGearboxClass = GearboxClass;
	LocalAxleClass = AxleClass;
	LocalDifferentialClass = DifferentialClass;
	// End:0x43
	if(__NFUN_339__(LocalMotorClass, none))
	{
		LocalMotorClass = class'VMotor';
	}
	// End:0x5A
	if(__NFUN_339__(LocalGearboxClass, none))
	{
		LocalGearboxClass = class'VGearbox';
	}
	// End:0x71
	if(__NFUN_339__(LocalAxleClass, none))
	{
		LocalAxleClass = class'VAxle';
	}
	// End:0x88
	if(__NFUN_339__(LocalDifferentialClass, none))
	{
		LocalDifferentialClass = class'VDifferential';
	}
	motor = new (Level.XLevel) LocalMotorClass;
	motor.AxleProps = MotorAxleProps;
	motor.MotorProps = MotorProps;
	Gearbox = new (Level.XLevel) LocalGearboxClass;
	Gearbox.GearboxProps = GearboxProps;
	PrimaryAxle = new (Level.XLevel) LocalAxleClass;
	PrimaryAxle.AxleProps = AxleProps;
	Gearbox.PrimaryAxle = motor;
	Gearbox.SecondaryAxle = PrimaryAxle;
	// End:0x1EE
	if(__NFUN_150__(__NFUN_204__(FrontRearDifferential, 0), __NFUN_204__(FrontRearDifferential, 1)))
	{
		// End:0x1AB
		if(__NFUN_204__(FrontRearDifferential, 0))
		{
			PrimaryDifferential = BuildAxleTemplate(RearAxle);
			BuildAxleTemplate(FrontAxle);			
		}
		else
		{
			// End:0x1D6
			if(__NFUN_204__(FrontRearDifferential, 1))
			{
				PrimaryDifferential = BuildAxleTemplate(FrontAxle);
				BuildAxleTemplate(RearAxle);
			}
		}
		PrimaryDifferential.Lock = FrontRearDifferentialLock;		
	}
	else
	{
		SupportDifferentials[0] = BuildAxleTemplate(FrontAxle);
		SupportDifferentials[1] = BuildAxleTemplate(RearAxle);
		SupportAxles[0] = new (Level.XLevel) LocalAxleClass;
		SupportAxles[1] = new (Level.XLevel) LocalAxleClass;
		SupportAxles[0].AxleProps = AxleProps;
		SupportAxles[1].AxleProps = AxleProps;
		PrimaryDifferential = new (Level.XLevel) LocalDifferentialClass;
		PrimaryDifferential.Ratio = FrontRearDifferential;
		PrimaryDifferential.Lock = FrontRearDifferentialLock;
		PrimaryDifferential.PrimaryOutputAxle = SupportAxles[0];
		PrimaryDifferential.SecondaryOutputAxle = SupportAxles[1];
		SupportDifferentials[0].InputAxle = SupportAxles[0];
		SupportDifferentials[1].InputAxle = SupportAxles[1];
	}
	PrimaryDifferential.InputAxle = PrimaryAxle;
	MaybeInitializeVehicleComponent(PrimaryAxle);
	MaybeInitializeVehicleComponent(SupportAxles[0]);
	MaybeInitializeVehicleComponent(SupportAxles[1]);
	MaybeInitializeVehicleComponent(PrimaryDifferential);
	MaybeInitializeVehicleComponent(SupportDifferentials[0]);
	MaybeInitializeVehicleComponent(SupportDifferentials[1]);
	MaybeInitializeVehicleComponent(motor);
	MaybeInitializeVehicleComponent(Gearbox);
	return;
}

simulated event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
	super(VehicleBase).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
	// End:0x2F
	if(DecorationIsDead())
	{
		return;
	}
	// End:0x89
	if(bPerformImpactEffects)
	{
		// End:0x89
		if(__NFUN_201__(__NFUN_211__(__NFUN_251__(ImpactVelocity)), ImpactRumbleThreshold))
		{
			// End:0x89
			if(__NFUN_148__(__NFUN_340__(VehicleGetDriver(), none), VehicleGetDriver().bIsPlayerPawn))
			{
				PlayerPawn(VehicleGetDriver()).AddRumble(CollisionRumble);
			}
		}
	}
	// End:0xC8
	if(__NFUN_148__(__NFUN_148__(bPerformLandingEffects, __NFUN_145__(bHadGroundContactLastFrame)), __NFUN_145__(bLandingEffectsThrottled)))
	{
		// End:0xC8
		if(__NFUN_200__(__NFUN_244__(__NFUN_253__(ImpactNormal), __NFUN_640__()), -0.707))
		{
			DoLandingEffects();
		}
	}
	return;
}

event bool CausedPhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamagedActor)
{
	// End:0x47
	if(bPerformImpactEffects)
	{
		// End:0x47
		if(__NFUN_148__(__NFUN_340__(VehicleGetDriver(), none), VehicleGetDriver().bIsPlayerPawn))
		{
			PlayerPawn(VehicleGetDriver()).AddRumble(CollisionRumble);
		}
	}
	return super(KarmaActor).CausedPhysicsImpactDamage(Damage, DamageOrigin, DamageDirection, DamageType, Instigator, DamagedActor);
	return;
}

simulated function HandBrakeEnabled()
{
	local int i;

	super(Vehicle_MeqonWheeled).HandBrakeEnabled();
	i = 0;
	J0x0D:

	// End:0x9B [Loop If]
	if(__NFUN_169__(i, 2))
	{
		// End:0x55
		if(__NFUN_340__(FrontAxle.Wheels[i], none))
		{
			FrontAxle.Wheels[i].WheelProps = FrontAxle.HandbrakeWheelProps;
		}
		// End:0x91
		if(__NFUN_340__(RearAxle.Wheels[i], none))
		{
			RearAxle.Wheels[i].WheelProps = RearAxle.HandbrakeWheelProps;
		}
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x0D;
	}
	return;
}

simulated function HandBrakeDisabled()
{
	local int i;

	super(Vehicle_MeqonWheeled).HandBrakeDisabled();
	i = 0;
	J0x0D:

	// End:0x9B [Loop If]
	if(__NFUN_169__(i, 2))
	{
		// End:0x55
		if(__NFUN_340__(FrontAxle.Wheels[i], none))
		{
			FrontAxle.Wheels[i].WheelProps = FrontAxle.WheelProps;
		}
		// End:0x91
		if(__NFUN_340__(RearAxle.Wheels[i], none))
		{
			RearAxle.Wheels[i].WheelProps = RearAxle.WheelProps;
		}
		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x0D;
	}
	return;
}

final simulated event PlayEngineSound(name EngineSoundName, optional bool bStopLast, optional Engine.Object.EStopSoundRule StopSoundRule, optional float FadeOutTime)
{
	local int Index;
	local SCharacterSoundInfo Sound;

	// End:0x1A
	if(__NFUN_204__(FadeOutTime, 0))
	{
		FadeOutTime = 0.2;
	}
	// End:0x57
	if(__NFUN_684__(LastEngineSlot))
	{
		// End:0x3E
		if(bStopLast)
		{
			__NFUN_695__(LastEngineSlot, StopSoundRule);			
		}
		else
		{
			__NFUN_698__(LastEngineSlot, FadeOutTime, 0, 1, 'EngineSoundFadedOut');
		}
	}
	// End:0x211
	if(__NFUN_148__(__NFUN_342__(EngineSoundName, 'None'), FindSoundIndex(EngineSoundName, Index)))
	{
		// End:0x95
		if(__NFUN_173__(int(LastEngineSlot), int(22)))
		{
			LastEngineSlot = 23;			
		}
		else
		{
			LastEngineSlot = 22;
		}
		// End:0xE3
		if(__NFUN_170__(string(VoicePack.default.CharacterSounds[Index].SoundInfo.Slots), 1))
		{
			VoicePack.default.CharacterSounds[Index].SoundInfo.Slots.Empty();
		}
		VoicePack.default.CharacterSounds[Index].SoundInfo.Slots[0] = LastEngineSlot;
		VoicePack.default.CharacterSounds[Index].SoundInfo.Volume = EngineSoundVolume;
		// End:0x1DA
		if(__NFUN_148__(__NFUN_146__(VoicePack.default.CharacterSounds[Index].SoundInfo.SoundLocationOverride.bMakeRelativeForLocalPlayer, false), __NFUN_173__(int(VoicePack.default.CharacterSounds[Index].SoundInfo.SoundLocationOverride.OverrideType), int(0))))
		{
			VoicePack.default.CharacterSounds[Index].SoundInfo.SoundLocationOverride.OverrideType = 3;
			VoicePack.default.CharacterSounds[Index].SoundInfo.SoundLocationOverride.Location3D = EngineSoundOffset;
		}
		PlaySoundInfo(1, VoicePack.default.CharacterSounds[Index].SoundInfo);
		EngineSoundStartTime = Level.GameTimeSeconds;
	}
	return;
}

final simulated function EngineSoundFadedOut()
{
	local Engine.Object.ESoundSlot Slot;

	// End:0x19
	if(__NFUN_173__(int(LastEngineSlot), int(22)))
	{
		Slot = 23;		
	}
	else
	{
		Slot = 22;
	}
	// End:0x48
	if(__NFUN_148__(__NFUN_684__(Slot), __NFUN_202__(__NFUN_687__(Slot), 0)))
	{
		__NFUN_695__(Slot);
	}
	return;
}

simulated event float ScaleSoundPitch(bool bSpoken, float InPitch)
{
	local float RPMAlpha, PitchAdjustTarget;

	// End:0x59
	if(__NFUN_148__(__NFUN_340__(motor, none), __NFUN_201__(motor.MaxRPMs, 0)))
	{
		RPMAlpha = __NFUN_227__(__NFUN_196__(motor.RPMs, motor.MaxRPMs), 0, 1);
	}
	__NFUN_209__(PitchAdjustTarget, __NFUN_228__(RPMAlpha, MinRPMPitchAdjust, MaxRPMPitchAdjust));
	// End:0x86
	if(IsBoosting())
	{
		__NFUN_209__(PitchAdjustTarget, BoostPitchAdjust);
	}
	// End:0x9D
	if(__NFUN_145__(HasGroundContact()))
	{
		__NFUN_209__(PitchAdjustTarget, InAirPitchAdjust);
	}
	// End:0xE1
	if(__NFUN_145__(Level.bPaused))
	{
		PitchAdjust = __NFUN_229__(__NFUN_224__(1, __NFUN_195__(PitchAdjustRate, Level.TimeDeltaSeconds)), PitchAdjust, PitchAdjustTarget);
	}
	InPitch = super(Actor).ScaleSoundPitch(bSpoken, InPitch);
	return __NFUN_227__(__NFUN_198__(InPitch, PitchAdjust), __NFUN_195__(InPitch, 0.5), __NFUN_195__(InPitch, 1.5));
	return;
}

simulated function TurnIgnitionOn()
{
	super(VehicleBase).TurnIgnitionOn();
	__NFUN_607__(0.01, false, 'StartEngine');
	return;
}

function StartEngine()
{
	PlayEngineSound(EngineStartSoundName);
	return;
}

simulated function TurnIgnitionOff()
{
	super(VehicleBase).TurnIgnitionOff();
	PlayEngineSound(EngineStopSoundName);
	return;
}

simulated function bool HasOverheated()
{
	return __NFUN_201__(BoostOverheatTimer, 0);
	return;
}

simulated function Tick_NoDriver(float DeltaTime)
{
	super(VehicleBase).Tick_NoDriver(DeltaTime);
	// End:0x59
	if(__NFUN_200__(BoostMeter, 1))
	{
		BoostMeter = __NFUN_227__(__NFUN_198__(BoostMeter, __NFUN_196__(DeltaTime, BoostRechargeTime)), 0, 1);
		// End:0x59
		if(__NFUN_201__(BoostMeter, 1))
		{
			BoostMeter = 1;
		}
	}
	return;
}

function ForcePowerOff()
{
	super(VehicleBase).ForcePowerOff();
	PlayEngineSound('None',,, 2);
	bWasAccel = false;
	LastGearIndex = 0;
	Gearbox.SetGear(0);
	return;
}

function NotifyDetachComplete()
{
	bWasAccel = false;
	return;
}

simulated function BeginBoost()
{
	local PlayerPawn Driver;

	// End:0x18
	if(__NFUN_150__(bBoosting, __NFUN_145__(CanBoost())))
	{
		return;
	}
	bBoosting = true;
	motor.MotorProps.MotorConstants[0] = BoostMotorProps.MotorConstants[0];
	motor.MotorProps.MotorConstants[1] = BoostMotorProps.MotorConstants[1];
	motor.MotorProps.MotorConstants[2] = BoostMotorProps.MotorConstants[2];
	motor.MotorProps.MotorConstants[3] = BoostMotorProps.MotorConstants[3];
	motor.MotorProps.MotorConstants[4] = BoostMotorProps.MotorConstants[4];
	motor.MotorProps.MotorConstants[5] = BoostMotorProps.MotorConstants[5];
	// End:0x1CD
	if(__NFUN_148__(__NFUN_148__(__NFUN_340__(VehicleGetDriver(), none), VehicleGetDriver().bIsPlayerPawn), __NFUN_339__(CurrentDrivingVehicleSpace.MountParent, self)))
	{
		Driver = PlayerPawn(VehicleGetDriver());
		Driver.ShakeView(BoostVibration, true);
		Driver.__NFUN_577__('FOV', 'VehicleBoostFOV', BoostFOVScale,, BoostFOVRampTime);
		BoostHUDEffect.AlphaStart = 0;
		BoostHUDEffect.AlphaEnd = 1;
		BoostHUDEffect.Lifetime = 0;
		Driver.MyHUD.AddHudEffect(BoostHUDEffect);
	}
	FindAndPlaySound('BoostLoop', 1);
	return;
}

simulated function float GetBoostMeter()
{
	return BoostMeter;
	return;
}

simulated event DriverLeft(VehicleSpaceBase Space)
{
	EndBoost();
	FindAndStopSound('OverheatWarn');
	super(Vehicle_MeqonWheeled).DriverLeft(Space);
	return;
}

event DoLandingEffects()
{
	local float Speed;
	local PlayerPawn Driver;

	Driver = PlayerPawn(VehicleGetDriver());
	Speed = __NFUN_211__(__NFUN_251__(InAirVelocity));
	// End:0x1AA
	if(__NFUN_201__(__NFUN_244__(__NFUN_253__(__NFUN_640__()), __NFUN_253__(InAirVelocity)), VelDotGravity))
	{
		// End:0x87
		if(__NFUN_148__(__NFUN_201__(Speed, BounceVelocity), __NFUN_202__(Speed, CrashVelocity)))
		{
			FindAndPlaySound('ShockBounce');
			// End:0x84
			if(__NFUN_340__(Driver, none))
			{
				Driver.AddRumble(BounceRumble);
			}			
		}
		else
		{
			// End:0x194
			if(__NFUN_201__(Speed, CrashVelocity))
			{
				// End:0xDA
				if(__NFUN_148__(__NFUN_340__(CurrentDrivingVehicleSpace, none), __NFUN_340__(CurrentDrivingVehicleSpace.User, none)))
				{
					CurrentDrivingVehicleSpace.User.ShakeView(LandingShake, true);
				}
				// End:0x153
				if(__NFUN_340__(DustCloud, none))
				{
					// End:0x120
					if(__NFUN_339__(DustCloud.MountParent, none))
					{
						DustCloud.__NFUN_645__(Location);
						DustCloud.__NFUN_652__(Rotation);
					}
					DustCloud.ExecuteEffect(true);
					DustCloud.ExecuteEffect(true);
					DustCloud.ExecuteEffect(true);
				}
				FindAndPlaySound('Landing');
				// End:0x194
				if(__NFUN_340__(Driver, none))
				{
					Driver.AddRumble(LandingRumble);
					Driver.AddRumble(AccelRumble);
				}
			}
		}
		bLandingEffectsThrottled = true;
		__NFUN_607__(0.5, false, 'UnThrottleLandingEffects');
	}
	return;
}

function UnThrottleLandingEffects()
{
	bLandingEffectsThrottled = false;
	return;
}

defaultproperties
{
	FrontAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=None,AxleWidth=37,AxleOffset=70,AxleHeight=-16,DifferentialLock=0,AxleProps=(MomentOfInertia=4),WheelProps=(SteerRatio=1,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=2.8,FrictionDynamic=2.7,FrictionRolling=0.002,StiffnessLateral=18.75,StiffnessLongitudinal=18.75,Restitution=0.4,SuspensionSpringLength=24,SuspensionSpringDamping=2500,SuspensionSpringStiffness=25000,Radius=16,Mass=10,WheelClass='CarSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=1,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=2.8,FrictionDynamic=2.7,FrictionRolling=0.002,StiffnessLateral=18.75,StiffnessLongitudinal=18.75,Restitution=0.4,SuspensionSpringLength=24,SuspensionSpringDamping=2500,SuspensionSpringStiffness=25000,Radius=16,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	RearAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=None,AxleWidth=37,AxleOffset=-68,AxleHeight=-16,DifferentialLock=0,AxleProps=(MomentOfInertia=4),WheelProps=(SteerRatio=0,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=2.8,FrictionDynamic=2.7,FrictionRolling=0.002,StiffnessLateral=25,StiffnessLongitudinal=25,Restitution=0.4,SuspensionSpringLength=24,SuspensionSpringDamping=2500,SuspensionSpringStiffness=25000,Radius=16,Mass=10,WheelClass='CarSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=0,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=2.8,FrictionDynamic=2.7,FrictionRolling=0.002,StiffnessLateral=5,StiffnessLongitudinal=5,Restitution=0.4,SuspensionSpringLength=24,SuspensionSpringDamping=2500,SuspensionSpringStiffness=25000,Radius=16,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	EngineStartSoundName=EngineStart
	EngineStopSoundName=EngineStop
	EngineSoundVolume=1
	PitchAdjustRate=8
	AxleProps=(MomentOfInertia=1)
	GearboxProps=(GearRatios=/* Array type was not detected. */,Yaw=-1073741824)
	MotorAxleProps=(MomentOfInertia=1)
	MotorProps=(MotorConstants=6000,MotorConstants[1]=0,MotorConstants[2]=0,MotorConstants[3]=0,MotorConstants[4]=4,MotorConstants[5]=0)
	BoostHUDEffect=(Name=Vehicle_Boost_Blur,Texture='dt_Effects2.FrameBuffers.TurboHudBlur_FB',bFullScreen=true,bUseAlphaGraph=false,bUseAlphaRamp=false,bUseAlphaWave=false,bUseScaleXRamp=false,bUseScaleYRamp=false,bCenter=false,bMaintainAspectRatio=false,bTiled=false,bFlipInMirrorMode=false,bAlwaysFirst=false,bLimited=false,bClampAgeScale=false,bUseViewportDims=false,MaxLife=-0.5,UnderwaterTimescale=1,Lifetime=0,AlphaStart=0,AlphaEnd=0,AlphaMid=0,AlphaRampMid=0,AlphaGraph=0,AlphaGraph[1]=0,AlphaGraph[2]=0,AlphaGraph[3]=0,AlphaGraph[4]=0,AlphaGraph[5]=0,AlphaGraph[6]=0,AlphaGraph[7]=0,AlphaGraph[8]=0,AlphaGraph[9]=0,AlphaGraphTime=0,AlphaGraphTime[1]=0,AlphaGraphTime[2]=0,AlphaGraphTime[3]=0,AlphaGraphTime[4]=0,AlphaGraphTime[5]=0,AlphaGraphTime[6]=0,AlphaGraphTime[7]=0,AlphaGraphTime[8]=0,AlphaGraphTime[9]=0,AlphaGraphCount=0,AlphaWaveFreq=0,AlphaWaveAmp=0,AlphaWaveYOffset=0,Alpha=0,ScaleXStart=0,ScaleXEnd=0,ScaleXMid=0,ScaleXRampMid=0,ScaleX=0,ScaleYStart=0,ScaleYEnd=0,ScaleYMid=0,ScaleYRampMid=0,ScaleY=0,Rotation=0,RotationVelocity=0,RotationAcceleration=0,Depth=0,DepthScaleFar=0,DepthScaleNear=0,Location=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	BoostVibration=(bNoLerp=false,bToggleSign=false,Style=6,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=-1,ShakeFrequency=0.025,ShakeMagnitude=30,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=Vehicle_Boost_ViewShake)
	BoostTime=4
	BoostRechargeTime=10
	BoostOverheatDelay=5
	BoostFOVScale=1.22
	BoostFOVRampTime=0.4
	BoostMeter=1
	LastEngineSlot=23
	LandingShake=(bNoLerp=false,bToggleSign=true,Style=0,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.4,ShakeFrequency=0.07,ShakeMagnitude=800,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=Vehicle_LandingShake)
	LandingRumble=(RumbleName=Vehicle_LandingRumble,RumbleDuration=0.45,RumbleLeftMagnitude=0.85,RumbleRightMagnitude=0,FalloffActor=none,FalloffDistance=0)
	BounceRumble=(RumbleName=Vehicle_BounceRumble,RumbleDuration=0.2,RumbleLeftMagnitude=0.2,RumbleRightMagnitude=0.1,FalloffActor=none,FalloffDistance=0)
	BoostRumble=(RumbleName=Vehicle_BoostRumble,RumbleDuration=0.1,RumbleLeftMagnitude=0.3,RumbleRightMagnitude=0,FalloffActor=none,FalloffDistance=0)
	AccelRumble=(RumbleName=Vehicle_AccelRumble,RumbleDuration=0.5,RumbleLeftMagnitude=0,RumbleRightMagnitude=1,FalloffActor=none,FalloffDistance=0)
	CollisionRumble=(RumbleName=Vehicle_ImpactRumble,RumbleDuration=0.36,RumbleLeftMagnitude=0.38,RumbleRightMagnitude=0.05,FalloffActor=none,FalloffDistance=0)
	CrashVelocity=900
	BounceVelocity=25
	VelDotGravity=0.25
	ImpactRumbleThreshold=700
	ControlStiffness=16384
	HealthPrefab=0
	Mass=1000
}