/*******************************************************************************
 * Veh_RCCar generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Veh_RCCar extends Veh_RCCar_NativeBase
	collapsecategories;

var float NukeSymbolColorAlpha;
var float NukeSymbolColorFadeTime;
var Color NukeSymbolIdleColor;
var Color NukeSymbolBoostColor;
var SoftParticleSystem ExhaustEffect;
var Veh_RCCar_Light DriverLight;
var() name DestroyCarTag;

function PostVerifySelf()
{
	super(Veh_CarTemplate).PostVerifySelf();
	ExhaustEffect = SoftParticleSystem(FindMountedActor('Exhaust'));
	DriverLight = Veh_RCCar_Light(FindMountedActor(, class'Veh_RCCar_Light'));
	__NFUN_601__('Generic0', NukeSymbolIdleColor);
	__NFUN_718__('DestroyCar', DestroyCarTag);
	Suspension = RCCarSpecialPart_Suspension(FindMountedActor(, class'RCCarSpecialPart_Suspension'));
	return;
}

function TriggerFunc_DestroyCar()
{
	bCanCrushOthers = false;
	CriticalDamage();
	bUsable = false;
	return;
}

event float GetVehicleFloorHeight()
{
	return 4;
	return;
}

simulated event bool VehicleIsFullSize()
{
	return false;
	return;
}

simulated function bool VehicleCanStubToes()
{
	return __NFUN_148__(__NFUN_340__(CurrentDrivingVehicleSpace, none), __NFUN_201__(__NFUN_211__(oForwardVelocity), 75));
	return;
}

simulated event DriverEntered(VehicleSpaceBase Space)
{
	super(Vehicle_MeqonWheeled).DriverEntered(Space);
	// End:0x29
	if(__NFUN_340__(DriverLight, none))
	{
		DriverLight.LightStyle = 1;
	}
	// End:0x45
	if(__NFUN_340__(Headlight, none))
	{
		Headlight.TriggerFunc_TurnLightOn();
	}
	return;
}

simulated event DriverLeft(VehicleSpaceBase Space)
{
	super(Veh_CarTemplate).DriverLeft(Space);
	// End:0x29
	if(__NFUN_340__(DriverLight, none))
	{
		DriverLight.LightStyle = 0;
	}
	// End:0x45
	if(__NFUN_340__(Headlight, none))
	{
		Headlight.TriggerFunc_TurnLightOff();
	}
	return;
}

simulated function Tick_Internal(float DeltaTime)
{
	local float Alpha;

	// End:0x0B
	if(DecorationIsDead())
	{
		return;
	}
	super(VehicleBase).Tick_Internal(DeltaTime);
	// End:0x170
	if(__NFUN_340__(ExhaustEffect, none))
	{
		// End:0x11A
		if(__NFUN_340__(CurrentDrivingVehicleSpace, none))
		{
			// End:0x87
			if(__NFUN_148__(__NFUN_340__(motor, none), __NFUN_201__(motor.MaxRPMs, 0)))
			{
				Alpha = __NFUN_227__(__NFUN_196__(motor.RPMs, motor.MaxRPMs), 0, 1);
			}
			ExhaustEffect.SpawnPeriod = __NFUN_228__(Alpha, 0.1, 0.02);
			ExhaustEffect.AlphaMid = __NFUN_228__(Alpha, 0.1, 0.5);
			// End:0xF8
			if(bBoosting)
			{
				ExhaustEffect.SpawnNumber = __NFUN_162__(2, ExhaustEffect.default.SpawnNumber);				
			}
			else
			{
				ExhaustEffect.SpawnNumber = ExhaustEffect.default.SpawnNumber;
			}			
		}
		else
		{
			ExhaustEffect.SpawnPeriod = __NFUN_229__(0.9, ExhaustEffect.SpawnPeriod, 0.1);
			ExhaustEffect.AlphaMid = __NFUN_229__(0.9, ExhaustEffect.AlphaMid, 0);
		}
	}
	// End:0x18F
	if(bBoosting)
	{
		__NFUN_209__(NukeSymbolColorAlpha, __NFUN_196__(DeltaTime, NukeSymbolColorFadeTime));		
	}
	else
	{
		__NFUN_210__(NukeSymbolColorAlpha, __NFUN_196__(DeltaTime, NukeSymbolColorFadeTime));
	}
	NukeSymbolColorAlpha = __NFUN_227__(NukeSymbolColorAlpha, 0, 1);
	__NFUN_601__('Generic0', __NFUN_338__(NukeSymbolColorAlpha, NukeSymbolIdleColor, NukeSymbolBoostColor));
	UpdateSuspension();
	return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
	super(VehicleBase).RegisterPrecacheComponents(PrecacheIndex);
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Body_Move');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'BodyMotion_Short');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ButtSeat');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Jump');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'ST_Getup_StandShift');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_HandPat');
	PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Veh_SteerGrab');
	return;
}

defaultproperties
{
	NukeSymbolColorFadeTime=0.2
	NukeSymbolIdleColor=(B=97,G=2,R=1,A=32)
	NukeSymbolBoostColor=(B=97,G=2,R=1,A=255)
	FrontAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=Front,AxleWidth=11.5,AxleOffset=16.5,AxleHeight=1,DifferentialLock=0,AxleProps=(MomentOfInertia=0.4),WheelProps=(SteerRatio=1,BrakeRatio=5,HandbrakeRatio=0,FrictionStatic=8,FrictionDynamic=5.4,FrictionRolling=0.01,StiffnessLateral=20,StiffnessLongitudinal=20,Restitution=0.4,SuspensionSpringLength=6,SuspensionSpringDamping=200,SuspensionSpringStiffness=4000,Radius=6.2,Mass=10,WheelClass='RCCarSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=1,BrakeRatio=1,HandbrakeRatio=0,FrictionStatic=5.6,FrictionDynamic=5.4,FrictionRolling=0.002,StiffnessLateral=4,StiffnessLongitudinal=4,Restitution=0.4,SuspensionSpringLength=6,SuspensionSpringDamping=200,SuspensionSpringStiffness=4000,Radius=6.2,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	RearAxle=(DifferentialClass=none,WheelClass=none,AxleBaseTag=Rear,AxleWidth=11.85,AxleOffset=-16.5,AxleHeight=1,DifferentialLock=0,AxleProps=(MomentOfInertia=0.4),WheelProps=(SteerRatio=0,BrakeRatio=5,HandbrakeRatio=1,FrictionStatic=16,FrictionDynamic=5.4,FrictionRolling=0.01,StiffnessLateral=40,StiffnessLongitudinal=60,Restitution=0.4,SuspensionSpringLength=6,SuspensionSpringDamping=200,SuspensionSpringStiffness=4000,Radius=6.2,Mass=10,WheelClass='RCCarSpecialPart_Tire'),HandbrakeWheelProps=(SteerRatio=0,BrakeRatio=1,HandbrakeRatio=1,FrictionStatic=5.6,FrictionDynamic=5.4,FrictionRolling=0.002,StiffnessLateral=0.375,StiffnessLongitudinal=0.375,Restitution=0.4,SuspensionSpringLength=6,SuspensionSpringDamping=200,SuspensionSpringStiffness=4000,Radius=6.2,Mass=10,WheelClass='CarSpecialPart_Tire'),AxleDifferential=none,Wheels=none,Wheels[1]=none)
	FrontRearDifferentialLock=1
	GearSounds(0)=(Z=/* Unknown default property type! */,Vector=false,StopOnFootOffRule=3,UpshiftLoopName=UpShiftLoop,DownshiftLoopName=None,FootOffSlowName=FootOffSlow,FootOffFastName=FootOffFast)
	GearSounds(1)=(bStopOnFootOff=false,StopOnFootOffRule=3,UpshiftLoopName=UpShiftLoop,DownshiftLoopName=None,FootOffSlowName=FootOffSlow,FootOffFastName=FootOffFast)
	GearSounds(2)=(EngineSoundVolume=0.75,MinRPMPitchAdjust=-0.3,MaxRPMPitchAdjust=0.3,BoostPitchAdjust=0.1,InAirPitchAdjust=0.15,GearboxProps=(GearRatios=/* Array type was not detected. */,Yaw=-1085485875))
	GearSounds(3)=none
	GearSounds(4)=(bNoDoppler="",bNoDoppler=/* Unknown default property type! */,VolumePrefab=/* Unknown default property type! */)
	GearSounds(5)=none
	GearSounds(6)=none
	GearSounds(7)=none
	GearSounds(8)=(MotorProps=(MotorConstants=350,MotorConstants[1]=0,MotorConstants[2]=0,MotorConstants[3]=0,MotorConstants[4]=2.4,MotorConstants[5]=0),bHasBoost=true,BoostMotorProps=(MotorConstants=3000,MotorConstants[1]=0,MotorConstants[2]=0,MotorConstants[3]=0,MotorConstants[4]=14.5,MotorConstants[5]=0),BoostFOVScale=1.16,BoostFOVRampTime=1.4,CrashVelocity=400,ImpactRumbleThreshold=300,bPerformImpactEffects=true,bPerformLandingEffects=true,NeutralSteeringAdjust=1E-06,SteerMaxAngles=(Pitch=8710,Yaw=571015168,Roll=5060),Roll=0)
	GearSounds(9)=(BrakeTorque=100000,NeutralBrakeTorque=15000,NoDriverBrakeTorque=250000,HandbrakeTorque=2E+08,KLinearToleranceScale=0.5,KAngularToleranceScale=0.5,WheelMassType=0,bDisableAllWhenEngineOff=true,ControlStiffness=12288,ForwardVelocityThreshold=32,ExplosionMomentumScalar=1,PassedDamageScale=0.5,UpwardCorpseBoost=0.25,UpwardCorpseBoostRnd=0.2,ForwardCorpseBoost=0.2,FlipThreshold=0.3,FlipTorque=0.3,ViewDist=55,ViewElevationAngle=2308,ViewFocusOffset=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=16)
	GearSounds(10)=(DriverLegsIdleAnim=RCCar_LegsIdle,bSurviveDeath=true,DestroyedActivities=/* Array type was not detected. */,Vector=/* Unknown default property type! */)
	GearSounds(11)=(bEngineForcedOff="",MountOnSpawn=/* Array type was not detected. */,ObjectProperty=2,dnVehicles=/* Unknown default property type! */,SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.694035E-35,Y=2.81304E-17,Z=-9.15E-05),Z=-0.75),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(12)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(13)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(14)=(MountType=0,DismountPhysics=0)
	GearSounds(15)=(RenderObject=none,DrawScale=0.75)
	GearSounds(16)=(bSkipVerifySelf=false,SpawnClass='RCCarSpecialPart_SteeringWheel',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.802724E-17,Z=0),Z=7.3125),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(17)=(MountAngles=(Pitch=596517382,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(18)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(19)=(MountType=0,DismountPhysics=0)
	GearSounds(20)=(RenderObject=none,DrawScale=0.75)
	GearSounds(21)=(bSkipVerifySelf=false,SpawnClass='RCCar_Headlight',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.802793E-17,Z=0),Z=3.75),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(22)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=16384)
	GearSounds(23)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(24)=(MountType=0,DismountPhysics=0)
	GearSounds(25)=(RenderObject=none,DrawScale=0.75)
	GearSounds(26)=(bSkipVerifySelf=false,SpawnClass='RCCarSpecialPart_Suspension',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(27)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(28)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(29)=(MountType=0,DismountPhysics=0)
	GearSounds(30)=(RenderObject=none,DrawScale=0.75)
	GearSounds(31)=(bSkipVerifySelf=false,SpawnClass='p_Particles.RCCar_Exhaust',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Exhaust,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-2.33256E-17,Y=2.813631E-17,Z=-4.515),Z=9.915),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(32)=(MountAngles=(Pitch=201335302,Yaw=571015168,Roll=32768),Roll=0)
	GearSounds(33)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(34)=(MountType=0,DismountPhysics=0)
	GearSounds(35)=(RenderObject=none,DrawScale=0.75)
	GearSounds(36)=(bSkipVerifySelf=false,SpawnClass='Veh_RCCar_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.802726E-17,Z=0),Z=9),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(37)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(38)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(39)=(MountType=0,DismountPhysics=0)
	GearSounds(40)=(RenderObject=none,DrawScale=0)
	GearSounds(41)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.RC_Land.RC_Land_Spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=DustCloud,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0),MountOriginVariance=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=0)
	GearSounds(42)=(MountAngles=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(43)=(MountAnglesVariance=(Pitch=8710,Yaw=571015168,Roll=0),Roll=0)
	GearSounds(44)=(MountType=0,DismountPhysics=0)
	GearSounds(45)=(RenderObject=none,DrawScale=0)
	GearSounds(46)=(bCanBreakGlass=true,DynamicInteractionClassification=6,PhysicsMaterial='dnMaterial.dnPhysicsMaterial_RCCar',PhysicsMassType=1,KAngularDamping=3,KCenterOfMass=(X=1.291997E-41,Y=2.797242E-17,Z=0),Z=-10)
	GearSounds(47)=(GravityScale=0.5,Density=100,MinDamageVelocity=100,FixedPhysicsDamageToNotPlayer=25,FixedPhysicsDamageToPlayer=2.5,CollisionHeight=10,Mass=175,DrawType=8,DrawScale=0.75,StaticMesh='sm_class_vehicles.RC_CAR.RCBuggy',VoicePack='SoundConfig.Vehicles.VoicePack_RCCar')
	GearSounds(48)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(49)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(50)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(51)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(52)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(53)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(54)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(55)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(56)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(57)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(58)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(59)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
	GearSounds(60)=
/* Exception thrown while deserializing GearSounds
System.IO.EndOfStreamException: Unable to read beyond the end of the stream.
   at System.IO.BinaryReader.ReadByte()
   at UELib.UnrealReader.ReadIndex() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 268
   at UELib.UnrealReader.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 327
   at UELib.UObjectStream.ReadNameIndex(Int32& num) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 762
   at UELib.UnrealStreamImplementations.ReadNameReference(IUnrealStream stream) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\UnrealStream.cs:line 837
   at UELib.Core.UDefaultProperty.DeserializeTagUE1() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 204
   at UELib.Core.UDefaultProperty.DeserializeNextTag() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 193
   at UELib.Core.UDefaultProperty.Deserialize() in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 169
   at UELib.Core.UDefaultProperty.DeserializeDefaultPropertyValue(PropertyType type, DeserializeFlags& deserializeFlags) in E:\SteamLibrary\steamapps\common\DukeNukem\Tools\UnrealscriptDecompiler\Core\Classes\UDefaultProperty.cs:line 767 */
}