/*******************************************************************************
 * VehicleExtraSpecialPart_Spinner generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class VehicleExtraSpecialPart_Spinner extends dnDecoration
	abstract
	collapsecategories;

var() float SpinnerPositiveSpringStrength;
var() float SpinnerNegativeSpringStrength;
var() float SpinnerPositiveDamping;
var() float SpinnerNegativeDamping;
var float AngularVelocity;
var int AngleOffset;

event Tick(float DeltaTime)
{
	local VehicleSpecialPart_TireEx Tire;
	local float SpringStrength, Damping;
	local int AngleSign;

	super(Actor).Tick(DeltaTime);
	Tire = VehicleSpecialPart_TireEx(MountParent);
	// End:0x181
	if(__NFUN_148__(__NFUN_340__(Tire, none), __NFUN_340__(Tire.MountParent, none)))
	{
		// End:0x75
		if(__NFUN_201__(__NFUN_211__(Tire.AngularVelocity), __NFUN_211__(AngularVelocity)))
		{
			SpringStrength = SpinnerPositiveSpringStrength;
			Damping = SpinnerPositiveDamping;			
		}
		else
		{
			SpringStrength = SpinnerNegativeSpringStrength;
			Damping = SpinnerNegativeDamping;
		}
		__NFUN_209__(AngularVelocity, __NFUN_195__(__NFUN_195__(SpringStrength, DeltaTime), __NFUN_199__(Tire.AngularVelocity, AngularVelocity)));
		__NFUN_207__(AngularVelocity, __NFUN_199__(1, Damping));
		__NFUN_180__(AngleOffset, int(__NFUN_195__(AngularVelocity, DeltaTime)));
		AngleOffset = __NFUN_175__(AngleOffset, 65535);
		// End:0x119
		if(__NFUN_200__(Tire.MountOrigin.Y, 0))
		{
			AngleSign = -1;			
		}
		else
		{
			AngleSign = 1;
		}
		__NFUN_652__(__NFUN_269__(__NFUN_269__(__NFUN_265__(__NFUN_162__(AngleOffset, AngleSign), 32768, 0), __NFUN_265__(0, Tire.MountAngles.Yaw, Tire.MountAngles.Roll)), Tire.MountParent.Rotation));
	}
	return;
}

defaultproperties
{
	SpinnerPositiveSpringStrength=0.96
	SpinnerNegativeSpringStrength=0.01
	SpinnerNegativeDamping=0.015
	bNoDamage=true
	bCollisionAssumeValid=true
	bTickOnlyRecent=false
	bTickOnlyNearby=true
	IndependentRotation=true
	bCollideActors=false
}