/*******************************************************************************
 * Vehicle_MeqonWheeled_CarLike generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Vehicle_MeqonWheeled_CarLike extends Vehicle_MeqonWheeled
	native
	collapsecategories;

enum EWheelSide
{
	WHEELSIDE_Left,
	WHEELSIDE_Right
};

struct SCarWheelAxle
{
	var() class<VDifferential> DifferentialClass;
	var() noexport class<VWheel> WheelClass "What class should the wheels attached this axle be?";
	var() name AxleBaseTag;
	var() noexport float AxleWidth "How wide should this axle be? (This is the distance from one wheel to the other.";
	var() noexport float AxleOffset "How far from the center of the vehicle (along the direction the vehicle is facing) should this axle be located?" "" "(Positive numbers will push it closer to the front; negative numbers will shift it backwards.)";
	var() noexport float AxleHeight "How far from the center of the vehicle (along the Z axis) should the wheel be in its rest position.";
	var() float DifferentialLock;
	var() SVehiclePhysicsAxleProperties AxleProps;
	var() SVehiclePhysicsWheelProperties WheelProps;
	var() SVehiclePhysicsWheelProperties HandbrakeWheelProps;
	var VDifferential AxleDifferential;
	var VWheel Wheels[2];
};

var(VehicleSetup) array<SCarWheelAxle> Axles;

simulated event PreBeginPlay()
{
	local SCarWheelAxle WorkingAxle;
	local int i;

	i = __NFUN_166__(string(Axles), 1);
	J0x0F:

	// End:0x51 [Loop If]
	if(__NFUN_172__(i, 0))
	{
		WorkingAxle = Axles[i];
		BuildAxleTemplate(WorkingAxle);
		Axles[i] = WorkingAxle;
		__NFUN_185__(i);
		// [Loop Continue]
		goto J0x0F;
	}
	super.PreBeginPlay();
	return;
}

simulated function VDifferential BuildAxleTemplate(out SCarWheelAxle AxleTemplate)
{
	local class<VWheel> LocalWheelClass;
	local class<VDifferential> LocalDifferentialClass;
	local int i, NewMountIndex;
	local name BaseLeftName, BaseRightName;

	BaseLeftName = __NFUN_344__(AxleTemplate.AxleBaseTag, 'l');
	BaseRightName = __NFUN_344__(AxleTemplate.AxleBaseTag, 'R');
	LocalWheelClass = AxleTemplate.WheelClass;
	// End:0x57
	if(__NFUN_339__(LocalWheelClass, none))
	{
		LocalWheelClass = class'VWheel';
	}
	i = 0;
	J0x5E:

	// End:0x266 [Loop If]
	if(__NFUN_169__(i, 2))
	{
		AxleTemplate.Wheels[i] = new (Level.XLevel) LocalWheelClass;
		AxleTemplate.Wheels[i].SetWheelOffsets(self, __NFUN_232__(AxleTemplate.AxleOffset, __NFUN_195__(__NFUN_199__(1, float(__NFUN_162__(2, i))), AxleTemplate.AxleWidth), AxleTemplate.AxleHeight));
		AxleTemplate.Wheels[i].bFlipWheel = __NFUN_173__(i, 1);
		AxleTemplate.Wheels[i].bHasTireActor = true;
		AxleTemplate.Wheels[i].AxleProps = AxleTemplate.AxleProps;
		AxleTemplate.Wheels[i].WheelProps = AxleTemplate.WheelProps;
		// End:0x25C
		if(__NFUN_148__(__NFUN_340__(AxleTemplate.Wheels[i].WheelProps.WheelClass, none), __NFUN_357__(AxleTemplate.Wheels[i].WheelProps.WheelClass, class'VehicleSpecialPart_TireEx')))
		{
			NewMountIndex = MountOnSpawn.Add(1);
			MountOnSpawn[NewMountIndex].SpawnClass = class<VehicleSpecialPart_TireEx>(AxleTemplate.Wheels[i].WheelProps.WheelClass);
			MountOnSpawn[NewMountIndex].MountPrefab.bScaleByDrawScaleNonDefault = true;
			// End:0x241
			if(__NFUN_173__(i, 0))
			{
				MountOnSpawn[NewMountIndex].MountPrefab.ForceTag = BaseLeftName;
				// [Explicit Continue]
				goto J0x25C;
			}
			MountOnSpawn[NewMountIndex].MountPrefab.ForceTag = BaseRightName;
		}
		J0x25C:

		__NFUN_184__(i);
		// [Loop Continue]
		goto J0x5E;
	}
	LocalDifferentialClass = AxleTemplate.DifferentialClass;
	// End:0x28D
	if(__NFUN_339__(LocalDifferentialClass, none))
	{
		LocalDifferentialClass = class'VDifferential';
	}
	AxleTemplate.AxleDifferential = new (Level.XLevel) LocalDifferentialClass;
	AxleTemplate.AxleDifferential.PrimaryOutputAxle = AxleTemplate.Wheels[0];
	AxleTemplate.AxleDifferential.SecondaryOutputAxle = AxleTemplate.Wheels[1];
	MaybeInitializeVehicleComponent(AxleTemplate.Wheels[0]);
	MaybeInitializeVehicleComponent(AxleTemplate.Wheels[1]);
	return AxleTemplate.AxleDifferential;
	return;
}
