/*******************************************************************************
 * dnControlRemapperEx_VehicleSpace generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControlRemapperEx_VehicleSpace extends dnControlRemapperEx
	collapsecategories;

var VehicleSpaceBase OwnerVehicleSpace;
var Rotator LastVehicleRot;
var Rotator ViewRotOffset;
var Rotator FirstPersonFloatingCameraRotation;
var Engine.Actor.EVehiclePOV LastVehiclePOV;
var float ViewRotationTimer;

replication
{
	// Pos:0x000
	reliable if(__NFUN_173__(int(Role), int(ROLE_Authority)))
		OwnerVehicleSpace;
}

function PostVerifySelf()
{
	super(Actor).PostVerifySelf();
	OwnerVehicleSpace = VehicleSpaceBase(Owner);
	return;
}

simulated function PawnAttach(Pawn Attachee, bool bForceComplete)
{
	ViewRotOffset = __NFUN_265__(0, 0, 0);
	// End:0x4F
	if(__NFUN_148__(__NFUN_340__(OwnerVehicleSpace, none), __NFUN_340__(OwnerVehicleSpace.Vehicle, none)))
	{
		LastVehicleRot = OwnerVehicleSpace.Vehicle.Rotation;
	}
	super(ControlRemapperEx).PawnAttach(Attachee, bForceComplete);
	return;
}

simulated function PawnDetach()
{
	// End:0x71
	if(__NFUN_148__(__NFUN_148__(__NFUN_340__(CurrentPlayer, none), __NFUN_339__(CurrentPlayer.ViewMapper, self)), __NFUN_174__(int(CurrentPlayer.VehiclePOV), int(0))))
	{
		CurrentPlayer.ViewRotation = CurrentPlayer.__NFUN_873__();
		CurrentPlayer.ViewRotation.Roll = 0;
	}
	super(ControlRemapperEx).PawnDetach();
	return;
}

simulated function InputHook_ViewRotationAdjust(out int PitchAdjust, out int YawAdjust, out int RollAdjust, optional float DeltaTime)
{
	super(ControlRemapperEx).InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaTime);
	// End:0x6E
	if(__NFUN_201__(__NFUN_198__(__NFUN_198__(__NFUN_211__(float(YawAdjust)), __NFUN_211__(float(PitchAdjust))), __NFUN_211__(float(RollAdjust))), float(20)))
	{
		ViewRotationTimer = __NFUN_198__(Level.GameTimeSeconds, OwnerVehicleSpace.Vehicle.ViewOffsetFadeStartTime);
	}
	__NFUN_180__(ViewRotOffset.Yaw, YawAdjust);
	__NFUN_180__(ViewRotOffset.Pitch, PitchAdjust);
	__NFUN_180__(ViewRotOffset.Roll, RollAdjust);
	return;
}

simulated function int CalcView_InterpolateViewAxis(int Current, int Desired, float Alpha)
{
	local int diff;

	diff = __NFUN_175__(__NFUN_166__(Desired, Current), 65535);
	// End:0x30
	if(__NFUN_170__(diff, 32767))
	{
		__NFUN_181__(diff, 65536);
	}
	return __NFUN_165__(Current, int(__NFUN_195__(Alpha, float(diff))));
	return;
}

simulated function CalcView_VehicleThirdPerson(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
	local float PitchSlerpAlpha, YawSlerpAlpha, RollSlerpAlpha, DrawScaleDifference, DotVal;

	local Vector Fwd, Right, Up, GravityDir;
	local Rotator VehicleRot, temp;

	VehicleRot = __NFUN_283__(OwnerVehicleSpace.Vehicle.Rotation);
	__NFUN_279__(VehicleRot, Fwd, Right, Up);
	GravityDir = OwnerVehicleSpace.Vehicle.__NFUN_640__();
	// End:0x77
	if(__NFUN_201__(__NFUN_252__(GravityDir), 0))
	{
		GravityDir = __NFUN_253__(GravityDir);		
	}
	else
	{
		GravityDir = __NFUN_232__(0, 0, -1);
	}
	// End:0xB3
	if(__NFUN_174__(int(LastVehiclePOV), int(1)))
	{
		ViewRotOffset = __NFUN_265__(0, 0, 0);
		LastVehicleRot = VehicleRot;
	}
	// End:0x14F
	if(__NFUN_150__(__NFUN_201__(OwnerVehicleSpace.GetThrottleInput(), 0), __NFUN_204__(ViewRotationTimer, -1)))
	{
		// End:0x14F
		if(__NFUN_148__(__NFUN_201__(Level.GameTimeSeconds, ViewRotationTimer), __NFUN_272__(ViewRotOffset, __NFUN_265__(0, 0, 0))))
		{
			ViewRotOffset = __NFUN_287__(__NFUN_224__(1, __NFUN_195__(OwnerVehicleSpace.Vehicle.ViewOffsetFadeRate, Level.TimeDeltaSeconds)), ViewRotOffset, __NFUN_265__(0, 0, 0));
		}
	}
	// End:0x389
	if(__NFUN_148__(__NFUN_272__(LastVehicleRot, VehicleRot), __NFUN_200__(__NFUN_244__(Up, GravityDir), 0)))
	{
		// End:0x251
		if(OwnerVehicleSpace.Vehicle.IsBoosting())
		{
			PitchSlerpAlpha = __NFUN_224__(1, __NFUN_195__(__NFUN_195__(2, OwnerVehicleSpace.Vehicle.ViewChasePitchRate), Level.TimeDeltaSeconds));
			YawSlerpAlpha = __NFUN_224__(1, __NFUN_195__(__NFUN_195__(2, OwnerVehicleSpace.Vehicle.ViewChaseYawRate), Level.TimeDeltaSeconds));
			RollSlerpAlpha = __NFUN_224__(1, __NFUN_195__(__NFUN_195__(2, OwnerVehicleSpace.Vehicle.ViewChaseRollRate), Level.TimeDeltaSeconds));			
		}
		else
		{
			PitchSlerpAlpha = __NFUN_224__(1, __NFUN_195__(OwnerVehicleSpace.Vehicle.ViewChasePitchRate, Level.TimeDeltaSeconds));
			YawSlerpAlpha = __NFUN_224__(1, __NFUN_195__(OwnerVehicleSpace.Vehicle.ViewChaseYawRate, Level.TimeDeltaSeconds));
			RollSlerpAlpha = __NFUN_224__(1, __NFUN_195__(OwnerVehicleSpace.Vehicle.ViewChaseRollRate, Level.TimeDeltaSeconds));
		}
		// End:0x389
		if(__NFUN_145__(Level.bPaused))
		{
			LastVehicleRot.Pitch = CalcView_InterpolateViewAxis(LastVehicleRot.Pitch, VehicleRot.Pitch, PitchSlerpAlpha);
			LastVehicleRot.Yaw = CalcView_InterpolateViewAxis(LastVehicleRot.Yaw, VehicleRot.Yaw, YawSlerpAlpha);
			LastVehicleRot.Roll = CalcView_InterpolateViewAxis(LastVehicleRot.Roll, VehicleRot.Roll, RollSlerpAlpha);
		}
	}
	// End:0x3D5
	if(__NFUN_340__(OwnerVehicleSpace.Vehicle.ViewActor, none))
	{
		CameraLocation = OwnerVehicleSpace.Vehicle.ViewActor.Location;		
	}
	else
	{
		CameraLocation = OwnerVehicleSpace.Vehicle.Location;
	}
	DrawScaleDifference = __NFUN_196__(OwnerVehicleSpace.Vehicle.DrawScale, OwnerVehicleSpace.Vehicle.default.DrawScale);
	__NFUN_249__(CameraLocation, __NFUN_263__(__NFUN_235__(DrawScaleDifference, OwnerVehicleSpace.Vehicle.ViewFocusOffset), VehicleRot));
	Fwd = Vector(LastVehicleRot);
	DotVal = __NFUN_244__(Fwd, GravityDir);
	// End:0x4CE
	if(__NFUN_150__(__NFUN_150__(__NFUN_201__(DotVal, 0.99), __NFUN_200__(DotVal, -0.99)), __NFUN_201__(__NFUN_244__(GravityDir, __NFUN_232__(0, 0, -1)), 0.99)))
	{
		temp = Rotator(Fwd);		
	}
	else
	{
		Right = __NFUN_245__(Fwd, GravityDir);
		Up = __NFUN_245__(Fwd, Right);
		temp = __NFUN_282__(Fwd, Right, Up);
	}
	ViewRotOffset.Pitch = int(__NFUN_227__(float(ViewRotOffset.Pitch), -9500, 2000));
	CameraRotation = __NFUN_269__(__NFUN_265__(__NFUN_166__(ViewRotOffset.Pitch, OwnerVehicleSpace.Vehicle.ViewElevationAngle), ViewRotOffset.Yaw, ViewRotOffset.Roll), temp);
	CurrentPlayer.ViewRotation = CameraRotation;
	CurrentPlayer.PlayerCalcView_Behind(CameraLocation, CameraRotation, __NFUN_195__(OwnerVehicleSpace.Vehicle.ViewDist, DrawScaleDifference), OwnerVehicleSpace.Vehicle);
	// End:0x602
	if(bCanOffsetView)
	{
		ViewOffset.Pitch = 0;
		ViewOffset.Yaw = 0;
		ViewOffset.Roll = 0;
	}
	return;
}

simulated event CalcView(Actor CameraActor, out Vector CameraLocation, out Rotator CameraRotation)
{
	// End:0x0E
	if(__NFUN_339__(CurrentPlayer, none))
	{
		return;
	}
	// End:0x150
	if(__NFUN_150__(__NFUN_150__(__NFUN_173__(int(CurrentPlayer.VehiclePOV), int(0)), IsInterpolating()), __NFUN_173__(int(CurrentRemapperState), int(0))))
	{
		super(ControlRemapperEx).CalcView(CameraActor, CameraLocation, CameraRotation);
		// End:0x64
		if(__NFUN_339__(CurrentPlayer, none))
		{
			return;
		}
		// End:0xAB
		if(__NFUN_150__(__NFUN_174__(int(LastVehiclePOV), int(0)), __NFUN_148__(__NFUN_145__(OwnerVehicleSpace.SpaceIsFullyEntered()), __NFUN_145__(OwnerVehicleSpace.DriverIsExiting()))))
		{
			FirstPersonFloatingCameraRotation = CameraRotation;
		}
		CameraRotation = __NFUN_283__(CameraRotation);
		// End:0xED
		if(__NFUN_148__(__NFUN_169__(CameraRotation.Roll, 8192), __NFUN_170__(CameraRotation.Roll, -8192)))
		{
			CameraRotation.Roll = 0;
		}
		// End:0x12D
		if(__NFUN_272__(FirstPersonFloatingCameraRotation, CameraRotation))
		{
			FirstPersonFloatingCameraRotation = __NFUN_287__(__NFUN_224__(1, __NFUN_195__(8, Level.TimeDeltaSeconds)), FirstPersonFloatingCameraRotation, CameraRotation);
		}
		CameraRotation = FirstPersonFloatingCameraRotation;
		CurrentPlayer.ViewRotation = CameraRotation;		
	}
	else
	{
		CalcView_VehicleThirdPerson(CameraActor, CameraLocation, CameraRotation);
	}
	LastVehiclePOV = CurrentPlayer.VehiclePOV;
	return;
}

function ClearRotationTimer()
{
	ViewRotationTimer = -1;
	return;
}
