/*******************************************************************************
 * DukeDialogBoxManager generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class DukeDialogBoxManager extends Object
    dependson(UDukeSuperMessageBox)
    dependson(UDukeDesktopWindow);

const CONTROLLER_ERR_MSG = 0;
const FATAL_ERR_MSG = 1;
const DEVICE_ERR_MSG = 3;
const ONLINE_ERR_MSG = 5;
const GENERIC_MSG = 10;

struct DialogInfo
{
    var UDukeSuperMessageBox msgBox;
    var Engine.Object.EConsole_Dialog id;
    var string secretString;
    var UWindowWindow CBObj;
};

struct Region
{
    var() int X;
    var() int Y;
    var() int W;
    var() int h;
};

var array<DialogInfo> DialogStack;
var array<UDukeSuperMessageBox> DialogCache;
var DukeConsole dukeCon;
var float WinWidth;
var float WinHeight;
var Region ClippingRegion;
var localized string SignedOutTitle;
var localized string SignedOutBody;
var localized string DeviceRemovedTitle;
var localized string DeviceRemovedBody;
var localized string DeviceRemovedFatalTitle;
var localized string DeviceRemovedFatalBody;
var localized string ControllerDCTitle;
var localized string ControllerDCBody;
var localized string NetworkLostTitle;
var localized string NetworkLostBody;
var localized string PleaseWaitTitle;
var localized string DeviceInsufficientSpaceTitle;
var localized string DeviceInsufficientSpaceBody;
var localized string NoDeviceTitle;
var localized string NoDeviceBody;
var localized string NoProfileTitle;
var localized string NoProfileBody;
var localized string CorruptContentTitle;
var localized string CorruptContentBody;
var localized string CorruptContinueNoSaveTitle;
var localized string CorruptContinueNoSaveBody;
var localized string ReachedLVL40Title;
var localized string ReachedLVL40Body;
var localized string OverdriveScrewYouTitle;
var localized string OverdriveScrewYouBody;
var localized string OverdriveGoodTitle;
var localized string OverdriveGoodBody;
var localized string OverdriveTitle;
var localized string OverdriveBody;
var localized string ChatRestrictTitle;
var localized string ChatRestrictBody;
var localized string QuitConfirmTitle;
var localized string QuitConfirmBody;
var localized string QuitConfirmBodyHost;
var localized string QuitConfirmBodyMP;
var localized string QuitConfirmBodyHostMP;
var localized string KickConfirmTitle;
var localized string KickConfirmBody;
var localized string CouldNotChangeTeamTitle;
var localized string CouldNotChangeTeamBody;
var localized string LeaderboardErrorTitle;
var localized string LeaderboardErrorBody;
var localized string JoinRoomFailedReasonRoomFullTitle;
var localized string JoinRoomFailedReasonRoomFullBody;
var localized string JoinRoomFailedReasonNoSuchRoomTitle;
var localized string JoinRoomFailedReasonNoSuchRoomBody;
var localized string JoinRoomFailedReasonRejectedByHostTitle;
var localized string JoinRoomFailedReasonRejectedByHostBody;
var localized string JoinRoomFailedReasonHostTimedOutTitle;
var localized string JoinRoomFailedReasonHostTimedOutBody;
var localized string JoinRoomFailedReasonUnknownTitle;
var localized string JoinRoomFailedReasonUnknownBody;
var localized string JoinRoomFailedReasonBlockedTitle;
var localized string JoinRoomFailedReasonBlockedBody;
var localized string JoinRoomFailedReasonVerMissTitle;
var localized string JoinRoomFailedReasonVerMissBody;
var localized string JoinRoomFailedReasonAlreadyInRoomTitle;
var localized string JoinRoomFailedReasonAlreadyInRoomBody;
var localized string ShutdownReasonKickedoutTitle;
var localized string ShutdownReasonKickedoutBody;
var localized string ShutdownReasonRoomDestroyedTitle;
var localized string ShutdownReasonRoomDestroyedBody;
var localized string ShutdownReasonDisconnectedTitle;
var localized string ShutdownReasonDisconnectedBody;
var localized string ShutdownReasonDisconnectedPoorConnectionTitle;
var localized string ShutdownReasonDisconnectedPoorConnectionBody;
var localized string ShutdownReasonNetworkErrorTitle;
var localized string ShutdownReasonNetworkErrorBody;
var localized string ShutdownReasonOutOfMemoryTitle;
var localized string ShutdownReasonOutOfMemoryBody;
var localized string ShutdownReasonTimedOutTitle;
var localized string ShutdownReasonTimedOutBody;
var localized string ShutdownReasonConnectionTimedOutTitle;
var localized string ShutdownReasonConnectionTimedOutBody;
var localized string ShutdownReasonNotSignedInTitle;
var localized string ShutdownReasonNotSignedInBody;
var localized string ShutdownReasonNotSignedInLBTitle;
var localized string ShutdownReasonNotSignedInLBBody;
var localized string ShutdownReasonNotPermittedOnlineTitle;
var localized string ShutdownReasonNotPermittedOnlineBody;
var localized string ShutdownReasonSignedOutTitle;
var localized string ShutdownReasonSignedOutBody;
var localized string ShutdownReasonSigningInFailedTitle;
var localized string ShutdownReasonSigningInFailedBody;
var localized string ShutdownReasonContentErrorTitle;
var localized string ShutdownReasonContentErrorBody;
var localized string ShutdownReasonParentalControlRestrictionsTitle;
var localized string ShutdownReasonParentalControlRestrictionsBody;
var localized string ShutdownReasonFailedToHostTitle;
var localized string ShutdownReasonFailedToHostBody;
var localized string ShutdownReasonNoServiceTitle;
var localized string ShutdownReasonNoServiceBody;
var localized string ShutdownReasonVACBannedTitle;
var localized string ShutdownReasonVACBannedBody;
var localized string PrivilegeChangedTitle;
var localized string PrivilegeChangedBody;
var localized string CheatConfirmTitle;
var localized string CheatConfirmBody;
var localized string NewExtrasUnlockedTitle;
var localized string NewExtrasUnlockedBody;
var localized string SelectFilter;
var localized string NoServers;
var localized string DirtyCustomizationTitle;
var localized string DirtyCustomizationBody;
var localized string ReturnToMultiMenuTitle;
var localized string ReturnToMultiMenuBody;
var localized string OKStr;
var localized string CancelStr;
var localized string YesStr;
var localized string NoStr;
var localized string HellNoStr;
var localized string DLC_Corrupt_Title;
var localized string DLC_Corrupt_Body;
var localized string DLC_Installed_Title;
var localized string DLC_Installed_Body;
var localized string DLC_SaveMapNotFound_Title;
var localized string DLC_SaveMapNotFound_Body;
var localized string DLC_KickedMpMapNotFound_Title;
var localized string DLC_KickedMpMapNotFound_Body;
var localized string GuestProfileTitle;
var localized string GuestProfileBody;
var localized string DLC_DeviceRemovedTitle;
var localized string DLC_DeviceRemovedBody;
var localized string PSNStoreQuitConfirmTitle;
var localized string PSNStoreQuitConfirmBody;
var localized string DLC_DownloadDoneNotificationTitle;
var localized string DLC_DownloadDoneNotificationBody;
var localized string DLC_DLCContentRemovedTitle;
var localized string DLC_DLCContentRemovedBody;
var localized string FOV_ChangedWarningTitle;
var localized string FOV_ChangedWarningBoby;

function InitDialogManager(DukeConsole con)
{
    dukeCon = con;
    WinWidth = con.Root.WinWidth;
    WinHeight = con.Root.WinHeight;
    ClippingRegion.X = 0;
    ClippingRegion.Y = 0;
    ClippingRegion.W = int(WinWidth);
    ClippingRegion.h = int(WinHeight);
    return;
}

final function ShowCustomDialogBox(optional string Title, optional string body, optional MaterialEx image)
{
    local UDukeSuperMessageBox newBox;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "ShowCustomDialogBox("), Title), ", "), body), ")"));
    newBox = CreateMsgBox(2);
    newBox.DialogType = 2;
    newBox.CustomDialogImage = image;
    newBox.SetupMessageBox(Title, body, OKStr, "");
    DialogStack[DialogStack.Add(1)].msgBox = newBox;
    [-- string(DialogStack)].id = DialogStack;
    2
    [-- string(DialogStack)].CBObj = DialogStack;
    none
    [-- string(DialogStack)].secretString = DialogStack;
    ""
    return;
}

final function UDukeSuperMessageBox ShowDialogBox(Engine.Object.EConsole_Dialog dialogID, optional UWindowWindow CBObj, optional string secretKey, optional class<UDukeSuperMessageBox> derivedClass, optional bool bPlayOpenedSound)
{
    local UDukeSuperMessageBox newBox;
    local string FormattedString, WorkingString;
    local array<string> FormattingArray, ExtraStringArray;
    local int Idx;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "ShowDialogBox("), string(__NFUN_365__(class'EConsole_Dialog', int(dialogID)))), ", "), string(CBObj)), ")"));
    newBox = CreateMsgBox(dialogID, derivedClass);
    newBox.bPlayOpenedSound = bPlayOpenedSound;
    newBox.DialogType = dialogID;
    newBox.iDrawPriority = 10;
    switch(dialogID)
    {
        // End:0xF4
        case 1:
            newBox.SetupMessageBox("Debug", "No Localization is here
 We support newlines?", OKStr, CancelStr);
            // End:0x112D
            break;
        // End:0x143
        case 6:
            newBox.SetupMessageBox(DeviceRemovedTitle, DeviceRemovedBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 1;
            // End:0x112D
            break;
        // End:0x18D
        case 71:
            newBox.SetupMessageBox(DeviceRemovedFatalTitle, DeviceRemovedFatalBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 1;
            // End:0x112D
            break;
        // End:0x1D7
        case 8:
            newBox.SetupMessageBox(ControllerDCTitle, ControllerDCBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 0;
            // End:0x112D
            break;
        // End:0x222
        case 9:
            newBox.SetupMessageBox(NetworkLostTitle, NetworkLostBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x2A1
        case 3:
            newBox.SetupMessageBox("", "", "", CancelStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.PulseText = PleaseWaitTitle;
            newBox.bShowSpinner = true;
            newBox.bShowBackground = false;
            newBox.iResult = 1;
            // End:0x112D
            break;
        // End:0x306
        case 4:
            newBox.SetupMessageBox("");
            newBox.bIsConsoleErrorMsg = true;
            newBox.PulseText = PleaseWaitTitle;
            newBox.bShowSpinner = true;
            newBox.bShowBackground = false;
            // End:0x112D
            break;
        // End:0x356
        case 10:
            newBox.SetupMessageBox(DeviceInsufficientSpaceTitle, DeviceInsufficientSpaceBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 3;
            // End:0x112D
            break;
        // End:0x3A6
        case 11:
            newBox.SetupMessageBox(NoDeviceTitle, NoDeviceBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 3;
            // End:0x112D
            break;
        // End:0x3F6
        case 12:
            newBox.SetupMessageBox(NoProfileTitle, NoProfileBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x445
        case 13:
            newBox.SetupMessageBox(CorruptContentTitle, CorruptContentBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 1;
            // End:0x112D
            break;
        // End:0x471
        case 14:
            newBox.SetupMessageBox(ReachedLVL40Title, ReachedLVL40Body, NoStr, HellNoStr);
            // End:0x112D
            break;
        // End:0x498
        case 15:
            newBox.SetupMessageBox(OverdriveScrewYouTitle, OverdriveScrewYouBody, OKStr);
            // End:0x112D
            break;
        // End:0x4BF
        case 16:
            newBox.SetupMessageBox(OverdriveGoodTitle, OverdriveGoodBody, OKStr);
            // End:0x112D
            break;
        // End:0x4E6
        case 17:
            newBox.SetupMessageBox(OverdriveTitle, OverdriveBody, OKStr);
            // End:0x112D
            break;
        // End:0x51F
        case 18:
            newBox.SetupMessageBox(ChatRestrictTitle, ChatRestrictBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x54B
        case 19:
            newBox.SetupMessageBox(QuitConfirmTitle, QuitConfirmBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x577
        case 20:
            newBox.SetupMessageBox(QuitConfirmTitle, QuitConfirmBodyHost, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x5A3
        case 21:
            newBox.SetupMessageBox(QuitConfirmTitle, QuitConfirmBodyMP, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x5CF
        case 22:
            newBox.SetupMessageBox(QuitConfirmTitle, QuitConfirmBodyHostMP, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x5FB
        case 23:
            newBox.SetupMessageBox(KickConfirmTitle, KickConfirmBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x622
        case 24:
            newBox.SetupMessageBox(CouldNotChangeTeamTitle, CouldNotChangeTeamBody, OKStr);
            // End:0x112D
            break;
        // End:0x65B
        case 27:
            newBox.SetupMessageBox(LeaderboardErrorTitle, LeaderboardErrorBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x694
        case 28:
            newBox.SetupMessageBox(JoinRoomFailedReasonRoomFullTitle, JoinRoomFailedReasonRoomFullBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x6CD
        case 29:
            newBox.SetupMessageBox(JoinRoomFailedReasonNoSuchRoomTitle, JoinRoomFailedReasonNoSuchRoomBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x706
        case 30:
            newBox.SetupMessageBox(JoinRoomFailedReasonRejectedByHostTitle, JoinRoomFailedReasonRejectedByHostBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x73F
        case 31:
            newBox.SetupMessageBox(JoinRoomFailedReasonHostTimedOutTitle, JoinRoomFailedReasonHostTimedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x778
        case 32:
            newBox.SetupMessageBox(JoinRoomFailedReasonUnknownTitle, JoinRoomFailedReasonUnknownBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x7B1
        case 33:
            newBox.SetupMessageBox(JoinRoomFailedReasonBlockedTitle, JoinRoomFailedReasonBlockedBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x7EA
        case 34:
            newBox.SetupMessageBox(JoinRoomFailedReasonVerMissTitle, JoinRoomFailedReasonVerMissBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x835
        case 35:
            newBox.SetupMessageBox(JoinRoomFailedReasonAlreadyInRoomTitle, JoinRoomFailedReasonAlreadyInRoomBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x86E
        case 37:
            newBox.SetupMessageBox(ShutdownReasonKickedoutTitle, ShutdownReasonKickedoutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x8A7
        case 38:
            newBox.SetupMessageBox(ShutdownReasonRoomDestroyedTitle, ShutdownReasonRoomDestroyedBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x8E0
        case 39:
            newBox.SetupMessageBox(ShutdownReasonDisconnectedTitle, ShutdownReasonDisconnectedBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x919
        case 40:
            newBox.SetupMessageBox(ShutdownReasonDisconnectedPoorConnectionTitle, ShutdownReasonDisconnectedPoorConnectionBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x952
        case 41:
            newBox.SetupMessageBox(ShutdownReasonNetworkErrorTitle, ShutdownReasonNetworkErrorBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x98B
        case 42:
            newBox.SetupMessageBox(ShutdownReasonOutOfMemoryTitle, ShutdownReasonOutOfMemoryBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x9C4
        case 43:
            newBox.SetupMessageBox(ShutdownReasonTimedOutTitle, ShutdownReasonTimedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x9FD
        case 44:
            newBox.SetupMessageBox(ShutdownReasonConnectionTimedOutTitle, ShutdownReasonConnectionTimedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xA36
        case 45:
            newBox.SetupMessageBox(ShutdownReasonContentErrorTitle, ShutdownReasonContentErrorBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xA3B
        case 46:
        // End:0xA74
        case 5:
            newBox.SetupMessageBox(SignedOutTitle, SignedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xAAD
        case 49:
            newBox.SetupMessageBox(ShutdownReasonNotPermittedOnlineTitle, ShutdownReasonNotPermittedOnlineBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xAE6
        case 47:
            newBox.SetupMessageBox(ShutdownReasonNotSignedInTitle, ShutdownReasonNotSignedInBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xB1F
        case 48:
            newBox.SetupMessageBox(ShutdownReasonNotSignedInLBTitle, ShutdownReasonNotSignedInLBBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xB58
        case 50:
            newBox.SetupMessageBox(ShutdownReasonSignedOutTitle, ShutdownReasonSignedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xB91
        case 51:
            newBox.SetupMessageBox(ShutdownReasonSignedOutTitle, ShutdownReasonSignedOutBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xBCA
        case 52:
            newBox.SetupMessageBox(ShutdownReasonSigningInFailedTitle, ShutdownReasonSigningInFailedBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xC03
        case 53:
            newBox.SetupMessageBox(ShutdownReasonParentalControlRestrictionsTitle, ShutdownReasonParentalControlRestrictionsBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xC3C
        case 54:
            newBox.SetupMessageBox(ShutdownReasonFailedToHostTitle, ShutdownReasonFailedToHostBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xC75
        case 55:
            newBox.SetupMessageBox(ShutdownReasonNoServiceTitle, ShutdownReasonNoServiceBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xCAE
        case 57:
            newBox.SetupMessageBox(JoinRoomFailedReasonVerMissTitle, JoinRoomFailedReasonVerMissBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xCE7
        case 58:
            newBox.SetupMessageBox(ShutdownReasonVACBannedTitle, ShutdownReasonVACBannedBody, OKStr);
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xD04
        case 25:
            newBox.SetupMessageBox(SelectFilter);
            // End:0x112D
            break;
        // End:0xD28
        case 26:
            newBox.SetupMessageBox("", NoServers, OKStr);
            // End:0x112D
            break;
        // End:0xD54
        case 59:
            newBox.SetupMessageBox(DirtyCustomizationTitle, DirtyCustomizationBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0xD80
        case 60:
            newBox.SetupMessageBox(ReturnToMultiMenuTitle, ReturnToMultiMenuBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0xDCB
        case 61:
            newBox.SetupMessageBox(PrivilegeChangedTitle, PrivilegeChangedBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0xDF2
        case 68:
            newBox.SetupMessageBox(DLC_SaveMapNotFound_Title, DLC_SaveMapNotFound_Body, OKStr);
            // End:0x112D
            break;
        // End:0xDF7
        case 70:
        // End:0xE1E
        case 36:
            newBox.SetupMessageBox(DLC_KickedMpMapNotFound_Title, DLC_KickedMpMapNotFound_Body, OKStr);
            // End:0x112D
            break;
        // End:0xF19
        case 66:
            FormattingArray.Remove(0, -- string(FormattingArray));            
            __NFUN_375__("UI", "DlcNotificationsSeen", Idx, "User.ini");
            OnlineAgent(class'Engine'.static.__NFUN_503__()).GetNewDlcNames(Idx, ExtraStringArray);
            WorkingString = "";
            Idx = 0;
            J0xE95:

            // End:0xED1 [Loop If]
            if(-Idx)
            {                
                WorkingString = __NFUN_302__(__NFUN_302__(WorkingString, ExtraStringArray[Idx]), " \\n ");
                // [Loop Continue]
                Idx *= ;
            }
            FormattingArray[FormattingArray.Add(1)] = WorkingString;
            FormattedString = __NFUN_328__(DLC_Installed_Body, FormattingArray);
            newBox.SetupMessageBox(DLC_Installed_Title, FormattedString, OKStr);
            // End:0x112D
            break;
        // End:0xF63
        case 62:
            newBox.SetupMessageBox(DLC_Corrupt_Title, DLC_Corrupt_Body, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 1;
            // End:0x112D
            break;
        // End:0xF8F
        case 63:
            newBox.SetupMessageBox(CheatConfirmTitle, CheatConfirmBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0xFB6
        case 64:
            newBox.SetupMessageBox(NewExtrasUnlockedTitle, NewExtrasUnlockedBody, OKStr);
            // End:0x112D
            break;
        // End:0xFF4
        case 65:
            newBox.SetupMessageBox(CorruptContinueNoSaveTitle, CorruptContinueNoSaveBody, YesStr, NoStr);
            newBox.bIsConsoleErrorMsg = true;
            // End:0x112D
            break;
        // End:0x103F
        case 67:
            newBox.SetupMessageBox(GuestProfileTitle, GuestProfileBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 5;
            // End:0x112D
            break;
        // End:0x1089
        case 7:
            newBox.SetupMessageBox(DLC_DeviceRemovedTitle, DLC_DeviceRemovedBody, OKStr);
            newBox.bIsConsoleErrorMsg = true;
            newBox.iDrawPriority = 1;
            // End:0x112D
            break;
        // End:0x10B5
        case 69:
            newBox.SetupMessageBox(PSNStoreQuitConfirmTitle, PSNStoreQuitConfirmBody, YesStr, NoStr);
            // End:0x112D
            break;
        // End:0x10DC
        case 72:
            newBox.SetupMessageBox(DLC_DownloadDoneNotificationTitle, DLC_DownloadDoneNotificationBody, OKStr);
            // End:0x112D
            break;
        // End:0x1103
        case 73:
            newBox.SetupMessageBox(DLC_DLCContentRemovedTitle, DLC_DLCContentRemovedBody, OKStr);
            // End:0x112D
            break;
        // End:0x112A
        case 74:
            newBox.SetupMessageBox(FOV_ChangedWarningTitle, FOV_ChangedWarningBoby, OKStr);
            // End:0x112D
            break;
        // End:0xFFFF
        default:
            break;
    }
    DialogStack[DialogStack.Add(1)].msgBox = newBox;
    [-- string(DialogStack)].id = DialogStack;
    dialogID
    [-- string(DialogStack)].CBObj = DialogStack;
    CBObj
    [-- string(DialogStack)].secretString = DialogStack;
    secretKey
    UDukeRootWindow(dukeCon.Root).Desktop.StopBinks(true);
    sortByDrawOrder();
    return newBox;
    return;
}

final function DukeMessageBoxDone(UDukeSuperMessageBox returnBox, int Result)
{
    local int i;

    i = 0;
    J0x07:

    // End:0xAB [Loop If]
    if(-i)
    {        
        // End:0xA1
        if(__NFUN_339__(DialogStack[i].msgBox, returnBox))
        {
            // End:0x79
            if(__NFUN_340__(DialogStack[i].CBObj, none))
            {
                DialogStack[i].CBObj.DukeSuperMessageBoxDone(Result, DialogStack[i].id);
            }
            dukeCon.MessageBoxDone(Result, DialogStack[i].id);
            // [Explicit Break]
            goto J0xAB;
        }
        // [Loop Continue]
        i *= ;
    }
    J0xAB:

    return;
}

final function ShowWaitingForResponseDialog()
{
    OnlineAgent(class'Engine'.static.__NFUN_503__()).StartWaitingForResponse();
    ShowDialogBox(4, UDukeRootWindow(dukeCon.Root));
    return;
}

final function ShowWaitingDialog(optional UWindowWindow CallBackWindow)
{
    OnlineAgent(class'Engine'.static.__NFUN_503__()).StartWaitingForResponse();
    // End:0x48
    if(__NFUN_339__(CallBackWindow, none))
    {
        ShowDialogBox(3, UDukeRootWindow(dukeCon.Root));        
    }
    else
    {
        ShowDialogBox(3, CallBackWindow);
    }
    return;
}

final function CloseWaitingDialog()
{
    local int i;
    local UDukeSuperMessageBox msgBox;

    i = 0;
    J0x07:

    // End:0xCD [Loop If]
    if(-i)
    {        
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::DialogStack["), string(i)), "]::"), string(__NFUN_365__(class'EConsole_Dialog', int(DialogStack[i].id)))));
        // End:0xC3
        if(int(DialogStack[i].id) % int(3))
        {
            __NFUN_355__(__NFUN_303__(string(self), "::CloseWaitingDialog::Found waiting dialog"));
            msgBox = DialogStack[i].msgBox;
            // [Explicit Break]
            goto J0xCD;
        }
        // [Loop Continue]
        i *= ;
    }
    J0xCD:

    // End:0x10F
    if(__NFUN_340__(msgBox, none))
    {
        DukeMessageBoxDone(msgBox, msgBox.default.iResult);
        msgBox.Close(false);
        CloseDialog(msgBox);
    }
    return;
}

final function CloseAllWaitingDialogs()
{
    local int i;
    local array<UDukeSuperMessageBox> MessageBoxes;

    i = 0;
    J0x07:

    // End:0x73 [Loop If]
    if(-i)
    {        
        // End:0x69
        if((int(DialogStack[i].id) % int(3)) < int(DialogStack[i].id) % int(4))
        {
            MessageBoxes[MessageBoxes.Add(1)] = DialogStack[i].msgBox;
        }
        // [Loop Continue]
        i *= ;
    }
    i = 0;
    J0x7A:

    // End:0xE2 [Loop If]
    if(-i)
    {        
        DukeMessageBoxDone(MessageBoxes[i], MessageBoxes[i].default.iResult);
        MessageBoxes[i].Close(false);
        CloseDialog(MessageBoxes[i]);
        // [Loop Continue]
        i *= ;
    }
    return;
}

function CloseDialogBoxByID(Engine.Object.EConsole_Dialog dialogID)
{
    local int i;
    local UDukeSuperMessageBox msgBox;

    i = 0;
    J0x07:

    // End:0x56 [Loop If]
    if(-i)
    {        
        // End:0x4C
        if(int(DialogStack[i].id) % int(dialogID))
        {
            msgBox = DialogStack[i].msgBox;
            // [Explicit Break]
            goto J0x56;
        }
        // [Loop Continue]
        i *= ;
    }
    J0x56:

    // End:0x6D
    if(__NFUN_340__(msgBox, none))
    {
        CloseDialog(msgBox);
    }
    return;
}

function bool IsDialogBoxActive(Engine.Object.EConsole_Dialog dialogID)
{
    local int i;
    local UDukeSuperMessageBox msgBox;

    i = 0;
    J0x07:

    // End:0x3F [Loop If]
    if(-i)
    {        
        // End:0x35
        if(int(DialogStack[i].id) % int(dialogID))
        {
            return true;
        }
        // [Loop Continue]
        i *= ;
    }
    return false;
    return;
}

function CloseDialogByKey(string Key)
{
    local int i;
    local UDukeSuperMessageBox msgBox;

    i = 0;
    J0x07:

    // End:0x55 [Loop If]
    if(-i)
    {        
        // End:0x4B
        if(__NFUN_308__(DialogStack[i].secretString, Key))
        {
            msgBox = DialogStack[i].msgBox;
            // [Explicit Break]
            goto J0x55;
        }
        // [Loop Continue]
        i *= ;
    }
    J0x55:

    // End:0x6C
    if(__NFUN_340__(msgBox, none))
    {
        CloseDialog(msgBox);
    }
    return;
}

function UDukeSuperMessageBox CreateMsgBox(Engine.Object.EConsole_Dialog boxID, optional class<UDukeSuperMessageBox> classToMake)
{
    local UDukeSuperMessageBox newBox;
    local int i;

    // End:0x17
    if(__NFUN_339__(classToMake, none))
    {
        classToMake = class'UDukeSuperMessageBox';
    }
    i = 0;
    J0x1E:

    // End:0xAC [Loop If]
    if(-i)
    {        
        // End:0xA2
        if(((int(DialogCache[i].DialogType) % int(boxID)) << __NFUN_339__(DialogCache[i].Class, classToMake)) << DialogCache[i].WindowIsVisible() / )
        {
            // [Explicit Break]
            goto J0xAC;
        }
        // [Loop Continue]
        i += ;
    }
    J0xAC:

    // End:0x128
    if(__NFUN_339__(newBox, none))
    {
        newBox = new (none) classToMake;
        newBox.BeginPlay();
        InitMsgBoxVars(newBox);
        newBox.BeforeCreate();
        newBox.Created();
        newBox.AfterCreate();
        DialogCache[DialogCache.Add(1)] = newBox;        
    }
    else
    {
        InitMsgBoxVars(newBox);
    }
    return newBox;
    return;
}

function InitMsgBoxVars(UDukeSuperMessageBox newBox)
{
    newBox.WinTop = 0;
    newBox.WinLeft = 0;
    newBox.WinWidth = 1;
    newBox.WinHeight = 1;
    newBox.Root = dukeCon.Root;
    newBox.OwnerWindow = dukeCon.Root;
    // End:0xC7
    if(__NFUN_339__(newBox.OwnerWindow, none))
    {
        newBox.OwnerWindow = dukeCon.Root;
    }
    newBox.cursor = dukeCon.Root.cursor;
    newBox.bAlwaysBehind = false;
    newBox.LookAndFeel = dukeCon.Root.LookAndFeel;
    newBox.Mgr = self;
    return;
}

function sortByDrawOrder()
{
    local int i, j, Length;
    local DialogInfo tmp;

    Length = string(DialogStack);
    i = 0;
    J0x13:

    // End:0xC8 [Loop If]
    if(-i)
    {                
        j = ++ i;        
        J0x33:

        // End:0xBE [Loop If]
        if(-j)
        {            
            // End:0xB4
            if(DialogStack[i].msgBox.iDrawPriority ** DialogStack[j].msgBox.iDrawPriority)
            {
                tmp = DialogStack[i];
                DialogStack[i] = DialogStack[j];
                DialogStack[j] = tmp;
            }
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function DrawDialogs(Canvas C)
{
    local int i;
    local float dx, dy, dw, dh;
    local bool bInDigs;

    WinWidth = float(C.SizeX);
    WinHeight = float(C.SizeY);
    ClippingRegion.X = 0;
    ClippingRegion.Y = 0;
    ClippingRegion.W = C.SizeX;
    ClippingRegion.h = C.SizeY;
    // End:0x15C
    if(string(DialogStack) ** 0)
    {
        DialogStack[0].msgBox.GetDialogDimensions(C, dx, dy, dw, dh);
        DialogStack[0].msgBox.WinLeft = dx;
        DialogStack[0].msgBox.WinTop = dy;
        DialogStack[0].msgBox.WinWidth = dw;
        DialogStack[0].msgBox.WinHeight = dh;
        DialogStack[0].msgBox.ShowWindow();
        PaintClients(C, 0, 0, DialogStack[0].msgBox);
    }
    bInDigs = __NFUN_340__(dukeCon.Viewport.Actor.Level.Game, none) << dukeCon.Viewport.Actor.Level.Game.__NFUN_358__('dnMyDigs');
    // End:0x215
    if((string(DialogStack) ** 0) << dukeCon.bDontDrawMouse / )
    {
    }
    return;
}

final function PaintClients(Canvas C, float X, float Y, UDukeSuperMessageBox msgBox)
{
    local float OrgX, OrgY, ClipX, ClipY;
    local UWindowWindow Child;

    OrgX = C.OrgX;
    OrgY = C.OrgY;
    ClipX = C.ClipX;
    ClipY = C.ClipY;
    Child = msgBox;
    Child.bUWindowActive = true;
    Child.bUWindowActive = true;
    C.__NFUN_1250__(0, 0);
    C.Style = 1;
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    C.SpaceX = 0;
    C.SpaceY = 0;
    Child.BeforePaint(C, Round(X, Child.WinLeft), Round(Y, Child.WinTop));
    // End:0x60F
    if(true)
    {
        C.OrgX = C.OrgX *= FRand(Child.WinLeft, dukeCon.Root.GUIScale);
        C.OrgY = C.OrgY *= FRand(Child.WinTop, dukeCon.Root.GUIScale);
        // End:0x4FD
        if(Child.bNoClip / )
        {
            C.ClipY = FRand(Round(WinHeight, Child.WinTop) -= Child.WinHeight, dukeCon.Root.GUIScale);
            Child.ClippingRegion.X = int(Round(float(ClippingRegion.X), Child.WinLeft));
            Child.ClippingRegion.Y = int(Round(float(ClippingRegion.Y), Child.WinTop));
            Child.ClippingRegion.W = ClippingRegion.W;
            Child.ClippingRegion.h = ClippingRegion.h;
            // End:0x3AB
            if(-Child.ClippingRegion.X)
            {                
                Child.ClippingRegion.W == Child.ClippingRegion.X;
                Child.ClippingRegion.X = 0;
            }
            // End:0x405
            if(-Child.ClippingRegion.Y)
            {                
                Child.ClippingRegion.h == Child.ClippingRegion.Y;
                Child.ClippingRegion.Y = 0;
            }
            // End:0x481
            if(Repl(float(Child.ClippingRegion.W), Round(Child.WinWidth, float(Child.ClippingRegion.X))))
            {
                Child.ClippingRegion.W = int(Round(Child.WinWidth, float(Child.ClippingRegion.X)));
            }
            // End:0x4FD
            if(Repl(float(Child.ClippingRegion.h), Round(Child.WinHeight, float(Child.ClippingRegion.Y))))
            {
                Child.ClippingRegion.h = int(Round(Child.WinHeight, float(Child.ClippingRegion.Y)));
            }
        }
        // End:0x5D0
        if(Child.bNoClip < (Child.ClippingRegion.W ** 0) << Child.ClippingRegion.h ** 0)
        {
            Child.WindowEvent(10, C, Round(X, Child.WinLeft), Round(Y, Child.WinTop), 0);
            Child.AfterPaint(C, Round(X, Child.WinLeft), Round(Y, Child.WinTop));            
        }
        else
        {
            __NFUN_355__(__NFUN_303__(string(Child), "clipped"));
        }
        C.OrgX = OrgX;
        C.OrgY = OrgY;
    }
    C.ClipX = ClipX;
    C.ClipY = ClipY;
    return;
}

function bool WindowEvents(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x4F
    if(string(DialogStack) ** 0)
    {
        // End:0x4A
        if(int(msg) + int(10))
        {
            DialogStack[0].msgBox.WindowEvent(msg, C, X, Y, Key);
        }
        return true;        
    }
    else
    {
        return false;
    }
    return;
}

function bool KeyEvent(Engine.Object.EInputKey Key, Engine.Object.EInputAction Action, float Delta)
{
    local UWindow.UWindowWindow.WinMessage msg;

    // End:0x6D
    if(string(DialogStack) ** 0)
    {
        switch(Action)
        {
            // End:0x3F
            case 1:
                msg = 7;
                WindowEvents(msg, none, 0, 0, int(Key));
                return true;
            // End:0x6A
            case 3:
                msg = 6;
                WindowEvents(msg, none, 0, 0, int(Key));
                return true;
            // End:0xFFFF
            default:
                break;
            }
    }
    else
    {
        return false;
        return;
    }
}

function CloseDialog(UDukeSuperMessageBox msgBox)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x4A [Loop If]
    if(-i)
    {        
        // End:0x40
        if(__NFUN_339__(DialogStack[i].msgBox, msgBox))
        {
            DialogStack.Remove(i, 1);
            return;
        }
        // [Loop Continue]
        i *= ;
    }
    return;
}

function CloseAllDialogs()
{
    local int i;
    local array<UDukeSuperMessageBox> MessageBoxes;

    i = 0;
    J0x07:

    // End:0x3F [Loop If]
    if(-i)
    {        
        MessageBoxes[MessageBoxes.Add(1)] = DialogStack[i].msgBox;
        // [Loop Continue]
        i *= ;
    }
    i = 0;
    J0x46:

    // End:0xA4 [Loop If]
    if(-i)
    {        
        // End:0x72
        if(MessageBoxes[i].bIsConsoleErrorMsg)
        {
            // [Explicit Continue]
            goto J0x9A;
        }
        MessageBoxes[i].Close(false);
        CloseDialog(MessageBoxes[i]);
        J0x9A:

        // [Loop Continue]
        i *= ;
    }
    DialogStack.Remove(9, string(DialogStack));
    return;
}

function UDukeSuperMessageBox GetTopWindow()
{
    // End:0x21
    if(string(DialogStack) ** 0)
    {
        return [-- string(DialogStack)].msgBox;
        DialogStack
    }
    return none;
    return;
}

function bool IsDialogShown()
{
    return string(DialogStack) + 0;
    return;
}

function bool IsInGame()
{
    // End:0x28
    if(__NFUN_339__(dukeCon.GetEntryLevel(), dukeCon.GetLevel()))
    {
        return false;
    }
    return true;
    return;
}

defaultproperties
{
    SignedOutTitle="<?int?dnWindow.DukeDialogBoxManager.SignedOutTitle?>"
    SignedOutBody="<?int?dnWindow.DukeDialogBoxManager.SignedOutBody?>"
    DeviceRemovedTitle="<?int?dnWindow.DukeDialogBoxManager.DeviceRemovedTitle?>"
    DeviceRemovedBody="<?int?dnWindow.DukeDialogBoxManager.DeviceRemovedBody?>"
    DeviceRemovedFatalTitle="<?int?dnWindow.DukeDialogBoxManager.DeviceRemovedFatalTitle?>"
    DeviceRemovedFatalBody="<?int?dnWindow.DukeDialogBoxManager.DeviceRemovedFatalBody?>"
    ControllerDCTitle="<?int?dnWindow.DukeDialogBoxManager.ControllerDCTitle?>"
    ControllerDCBody="<?int?dnWindow.DukeDialogBoxManager.ControllerDCBody?>"
    NetworkLostTitle="<?int?dnWindow.DukeDialogBoxManager.NetworkLostTitle?>"
    NetworkLostBody="<?int?dnWindow.DukeDialogBoxManager.NetworkLostBody?>"
    PleaseWaitTitle="<?int?dnWindow.DukeDialogBoxManager.PleaseWaitTitle?>"
    DeviceInsufficientSpaceTitle="<?int?dnWindow.DukeDialogBoxManager.DeviceInsufficientSpaceTitle?>"
    DeviceInsufficientSpaceBody="<?int?dnWindow.DukeDialogBoxManager.DeviceInsufficientSpaceBody?>"
    NoDeviceTitle="<?int?dnWindow.DukeDialogBoxManager.NoDeviceTitle?>"
    NoDeviceBody="<?int?dnWindow.DukeDialogBoxManager.NoDeviceBody?>"
    NoProfileTitle="<?int?dnWindow.DukeDialogBoxManager.NoProfileTitle?>"
    NoProfileBody="<?int?dnWindow.DukeDialogBoxManager.NoProfileBody?>"
    CorruptContentTitle="<?int?dnWindow.DukeDialogBoxManager.CorruptContentTitle?>"
    CorruptContentBody="<?int?dnWindow.DukeDialogBoxManager.CorruptContentBody?>"
    CorruptContinueNoSaveTitle="<?int?dnWindow.DukeDialogBoxManager.CorruptContinueNoSaveTitle?>"
    CorruptContinueNoSaveBody="<?int?dnWindow.DukeDialogBoxManager.CorruptContinueNoSaveBody?>"
    ReachedLVL40Title="<?int?dnWindow.DukeDialogBoxManager.ReachedLVL40Title?>"
    ReachedLVL40Body="<?int?dnWindow.DukeDialogBoxManager.ReachedLVL40Body?>"
    OverdriveScrewYouTitle="<?int?dnWindow.DukeDialogBoxManager.OverdriveScrewYouTitle?>"
    OverdriveScrewYouBody="<?int?dnWindow.DukeDialogBoxManager.OverdriveScrewYouBody?>"
    OverdriveGoodTitle="<?int?dnWindow.DukeDialogBoxManager.OverdriveGoodTitle?>"
    OverdriveGoodBody="<?int?dnWindow.DukeDialogBoxManager.OverdriveGoodBody?>"
    OverdriveTitle="<?int?dnWindow.DukeDialogBoxManager.OverdriveTitle?>"
    OverdriveBody="<?int?dnWindow.DukeDialogBoxManager.OverdriveBody?>"
    ChatRestrictTitle="<?int?dnWindow.DukeDialogBoxManager.ChatRestrictTitle?>"
    ChatRestrictBody="<?int?dnWindow.DukeDialogBoxManager.ChatRestrictBody?>"
    QuitConfirmTitle="<?int?dnWindow.DukeDialogBoxManager.QuitConfirmTitle?>"
    QuitConfirmBody="<?int?dnWindow.DukeDialogBoxManager.QuitConfirmBody?>"
    QuitConfirmBodyHost="<?int?dnWindow.DukeDialogBoxManager.QuitConfirmBodyHost?>"
    QuitConfirmBodyMP="<?int?dnWindow.DukeDialogBoxManager.QuitConfirmBodyMP?>"
    QuitConfirmBodyHostMP="<?int?dnWindow.DukeDialogBoxManager.QuitConfirmBodyHostMP?>"
    KickConfirmTitle="<?int?dnWindow.DukeDialogBoxManager.KickConfirmTitle?>"
    KickConfirmBody="<?int?dnWindow.DukeDialogBoxManager.KickConfirmBody?>"
    CouldNotChangeTeamTitle="<?int?dnWindow.DukeDialogBoxManager.CouldNotChangeTeamTitle?>"
    CouldNotChangeTeamBody="<?int?dnWindow.DukeDialogBoxManager.CouldNotChangeTeamBody?>"
    LeaderboardErrorTitle="<?int?dnWindow.DukeDialogBoxManager.LeaderboardErrorTitle?>"
    LeaderboardErrorBody="<?int?dnWindow.DukeDialogBoxManager.LeaderboardErrorBody?>"
    JoinRoomFailedReasonRoomFullTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonRoomFullTitle?>"
    JoinRoomFailedReasonRoomFullBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonRoomFullBody?>"
    JoinRoomFailedReasonNoSuchRoomTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonNoSuchRoomTitle?>"
    JoinRoomFailedReasonNoSuchRoomBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonNoSuchRoomBody?>"
    JoinRoomFailedReasonRejectedByHostTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonRejectedByHostTitle?>"
    JoinRoomFailedReasonRejectedByHostBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonRejectedByHostBody?>"
    JoinRoomFailedReasonHostTimedOutTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonHostTimedOutTitle?>"
    JoinRoomFailedReasonHostTimedOutBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonHostTimedOutBody?>"
    JoinRoomFailedReasonUnknownTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonUnknownTitle?>"
    JoinRoomFailedReasonUnknownBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonUnknownBody?>"
    JoinRoomFailedReasonBlockedTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonBlockedTitle?>"
    JoinRoomFailedReasonBlockedBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonBlockedBody?>"
    JoinRoomFailedReasonVerMissTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonVerMissTitle?>"
    JoinRoomFailedReasonVerMissBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonVerMissBody?>"
    JoinRoomFailedReasonAlreadyInRoomTitle="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonAlreadyInRoomTitle?>"
    JoinRoomFailedReasonAlreadyInRoomBody="<?int?dnWindow.DukeDialogBoxManager.JoinRoomFailedReasonAlreadyInRoomBody?>"
    ShutdownReasonKickedoutTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonKickedoutTitle?>"
    ShutdownReasonKickedoutBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonKickedoutBody?>"
    ShutdownReasonRoomDestroyedTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonRoomDestroyedTitle?>"
    ShutdownReasonRoomDestroyedBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonRoomDestroyedBody?>"
    ShutdownReasonDisconnectedTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonDisconnectedTitle?>"
    ShutdownReasonDisconnectedBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonDisconnectedBody?>"
    ShutdownReasonDisconnectedPoorConnectionTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonDisconnectedPoorConnectionTitle?>"
    ShutdownReasonDisconnectedPoorConnectionBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonDisconnectedPoorConnectionBody?>"
    ShutdownReasonNetworkErrorTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNetworkErrorTitle?>"
    ShutdownReasonNetworkErrorBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNetworkErrorBody?>"
    ShutdownReasonOutOfMemoryTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonOutOfMemoryTitle?>"
    ShutdownReasonOutOfMemoryBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonOutOfMemoryBody?>"
    ShutdownReasonTimedOutTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonTimedOutTitle?>"
    ShutdownReasonTimedOutBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonTimedOutBody?>"
    ShutdownReasonConnectionTimedOutTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonConnectionTimedOutTitle?>"
    ShutdownReasonConnectionTimedOutBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonConnectionTimedOutBody?>"
    ShutdownReasonNotSignedInTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNotSignedInTitle?>"
    ShutdownReasonNotSignedInBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNotSignedInBody?>"
    ShutdownReasonNotSignedInLBTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNotSignedInLBTitle?>"
    ShutdownReasonNotSignedInLBBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNotSignedInLBBody?>"
    ShutdownReasonSignedOutTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonSignedOutTitle?>"
    ShutdownReasonSignedOutBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonSignedOutBody?>"
    ShutdownReasonSigningInFailedTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonSigningInFailedTitle?>"
    ShutdownReasonSigningInFailedBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonSigningInFailedBody?>"
    ShutdownReasonContentErrorTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonContentErrorTitle?>"
    ShutdownReasonContentErrorBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonContentErrorBody?>"
    ShutdownReasonParentalControlRestrictionsTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonParentalControlRestrictionsTitle?>"
    ShutdownReasonParentalControlRestrictionsBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonParentalControlRestrictionsBody?>"
    ShutdownReasonFailedToHostTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonFailedToHostTitle?>"
    ShutdownReasonFailedToHostBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonFailedToHostBody?>"
    ShutdownReasonNoServiceTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNoServiceTitle?>"
    ShutdownReasonNoServiceBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonNoServiceBody?>"
    ShutdownReasonVACBannedTitle="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonVACBannedTitle?>"
    ShutdownReasonVACBannedBody="<?int?dnWindow.DukeDialogBoxManager.ShutdownReasonVACBannedBody?>"
    PrivilegeChangedTitle="<?int?dnWindow.DukeDialogBoxManager.PrivilegeChangedTitle?>"
    PrivilegeChangedBody="<?int?dnWindow.DukeDialogBoxManager.PrivilegeChangedBody?>"
    CheatConfirmTitle="<?int?dnWindow.DukeDialogBoxManager.CheatConfirmTitle?>"
    CheatConfirmBody="<?int?dnWindow.DukeDialogBoxManager.CheatConfirmBody?>"
    NewExtrasUnlockedTitle="<?int?dnWindow.DukeDialogBoxManager.NewExtrasUnlockedTitle?>"
    NewExtrasUnlockedBody="<?int?dnWindow.DukeDialogBoxManager.NewExtrasUnlockedBody?>"
    SelectFilter="<?int?dnWindow.DukeDialogBoxManager.SelectFilter?>"
    NoServers="<?int?dnWindow.DukeDialogBoxManager.NoServers?>"
    DirtyCustomizationTitle="<?int?dnWindow.DukeDialogBoxManager.DirtyCustomizationTitle?>"
    DirtyCustomizationBody="<?int?dnWindow.DukeDialogBoxManager.DirtyCustomizationBody?>"
    ReturnToMultiMenuTitle="<?int?dnWindow.DukeDialogBoxManager.ReturnToMultiMenuTitle?>"
    ReturnToMultiMenuBody="<?int?dnWindow.DukeDialogBoxManager.ReturnToMultiMenuBody?>"
    OKStr="<?int?dnWindow.DukeDialogBoxManager.OKStr?>"
    CancelStr="<?int?dnWindow.DukeDialogBoxManager.CancelStr?>"
    YesStr="<?int?dnWindow.DukeDialogBoxManager.YesStr?>"
    NoStr="<?int?dnWindow.DukeDialogBoxManager.NoStr?>"
    HellNoStr="<?int?dnWindow.DukeDialogBoxManager.HellNoStr?>"
    GuestProfileTitle="<?int?dnWindow.DukeDialogBoxManager.GuestProfileTitle?>"
    GuestProfileBody="<?int?dnWindow.DukeDialogBoxManager.GuestProfileBody?>"
    DLC_DeviceRemovedTitle="<?int?dnWindow.DukeDialogBoxManager.DLC_DeviceRemovedTitle?>"
    DLC_DeviceRemovedBody="<?int?dnWindow.DukeDialogBoxManager.DLC_DeviceRemovedBody?>"
    PSNStoreQuitConfirmTitle="<?int?dnWindow.DukeDialogBoxManager.PSNStoreQuitConfirmTitle?>"
    PSNStoreQuitConfirmBody="<?int?dnWindow.DukeDialogBoxManager.PSNStoreQuitConfirmBody?>"
    DLC_DownloadDoneNotificationTitle="<?int?dnWindow.DukeDialogBoxManager.DLC_DownloadDoneNotificationTitle?>"
    DLC_DownloadDoneNotificationBody="<?int?dnWindow.DukeDialogBoxManager.DLC_DownloadDoneNotificationBody?>"
    FOV_ChangedWarningTitle="<?int?dnWindow.DukeDialogBoxManager.FOV_ChangedWarningTitle?>"
    FOV_ChangedWarningBoby="<?int?dnWindow.DukeDialogBoxManager.FOV_ChangedWarningBoby?>"
}