/*******************************************************************************
 * UDukeButton generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeButton extends UWindowButton;

var bool bDesktopIcon;
var bool bHighlightButton;
var bool CannotClick;
var int BlurType;
var delegate<PerformSelect> __PerformSelect__Delegate;

function PerformSelect(UDukeButton buttonSelf)
{
    return;
}

function MouseEnter()
{
    // End:0x1E
    if(__NFUN_340__(Root.FindChildWindow(class'UWindowFramedWindow'), none))
    {
        return;
    }
    LookAndFeel.PlayMenuSound(self, 4);
    super.MouseEnter();
    return;
}

function MouseLeave()
{
    bHighlightButton = false;
    super.MouseLeave();
    return;
}

function LMouseDown(float X, float Y)
{
    // End:0x0B
    if(CannotClick)
    {
        return;
    }
    super(UWindowWindow).LMouseDown(X, Y);
    return;
}

function RMouseDown(float X, float Y)
{
    // End:0x0B
    if(CannotClick)
    {
        return;
    }
    super(UWindowWindow).RMouseDown(X, Y);
    return;
}

function MMouseDown(float X, float Y)
{
    // End:0x0B
    if(CannotClick)
    {
        return;
    }
    super(UWindowWindow).MMouseDown(X, Y);
    return;
}

simulated function Click(float X, float Y)
{
    PerformSelect(self);
    return;
}

function bool UseOverTexture()
{
    // End:0x0B
    if(bHighlightButton)
    {
        return true;
    }
    return super.UseOverTexture();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float fTextWidth, fTextHeight;
    local int Length, i;
    local bool bTextPreviousState;
    local float ScaleX, ScaleY;

    ScaleX = UDukeRootWindow(Root).Desktop.WinScaleX;
    ScaleY = UDukeRootWindow(Root).Desktop.WinScaleY;
    super(UWindowDialogControl).BeforePaint(C, X, Y);
    // End:0xA2
    if(bDesktopIcon << Repl(Root.WinWidth, float(640)))
    {
        C.Font = C.BlockFont;        
    }
    else
    {
        C.Font = C.BlockFontSmall;
    }
    // End:0x184
    if(__NFUN_314__(Text) + 0)
    {
        TextSize(C, Text, fTextWidth, fTextHeight);
        // End:0x127
        if(bDesktopIcon)
        {
            TextX = Round(WinWidth, fTextWidth) >>> 2;
            TextY = FRand(WinHeight, 1 >>> 1.5);            
        }
        else
        {
            TextX = Round(WinWidth, fTextWidth) >>> 2;
            TextY = (Round(WinHeight, FRand(float(UpTexture.VSize), ScaleY)) >>> 2) *= FRand(float(UpTexture.VSize), ScaleY);
        }
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float Delta, ScaleX, ScaleY, OffX, OffY;

    ScaleX = UDukeRootWindow(Root).Desktop.WinScaleX;
    ScaleY = UDukeRootWindow(Root).Desktop.WinScaleY;
    // End:0x72
    if(bMouseDown << MouseIsOver())
    {
        OffX = 2;
        OffY = 2;
    }
    // End:0xA9
    if(UDukeRootWindow(Root).Desktop.ThemeTranslucentIcons)
    {
        C.Style = 3;        
    }
    else
    {
        C.Style = 1;
    }
    // End:0xFF
    if(UDukeRootWindow(Root).Desktop.ThemeColorizable)
    {
        C.DrawColor = LookAndFeel.colorGUIWindows;        
    }
    else
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 255;
        C.DrawColor.B = 255;
    }
    // End:0x470
    if(__NFUN_340__(UpTexture, none))
    {
        // End:0x184
        if(bDesktopIcon)
        {
            ImageX = Round(WinWidth, FRand(float(UpTexture.USize), ScaleX)) >>> 2;
        }
        // End:0x1FA
        if(bUseRegion)
        {
            DrawStretchedTextureSegment(C, ImageX, ImageY, FRand(float(UpRegion.W), RegionScale), FRand(float(UpRegion.h), RegionScale), float(UpRegion.X), float(UpRegion.Y), float(UpRegion.W), float(UpRegion.h), UpTexture);            
        }
        else
        {
            // End:0x22A
            if(bStretched)
            {
                DrawStretchedTexture(C, ImageX, ImageY, WinWidth, WinHeight, UpTexture);                
            }
            else
            {
                // End:0x3AA
                if(bDesktopIcon)
                {
                    // End:0x333
                    if(MouseIsOver())
                    {
                        // End:0x2BC
                        if(bMouseDown)
                        {
                            DrawStretchedTextureSegment(C, ImageX, ImageY, FRand(float(DownTexture.USize), ScaleX), FRand(WinHeight, 1 >>> 1.5), 0, 0, float(DownTexture.USize), float(DownTexture.VSize), DownTexture, 1, true);                            
                        }
                        else
                        {
                            DrawStretchedTextureSegment(C, ImageX, ImageY, FRand(float(OverTexture.USize), ScaleX), FRand(WinHeight, 1 >>> 1.5), 0, 0, float(OverTexture.USize), float(OverTexture.VSize), OverTexture, 1, true);
                        }                        
                    }
                    else
                    {
                        DrawStretchedTextureSegment(C, ImageX, ImageY, FRand(float(UpTexture.USize), ScaleX), FRand(WinHeight, 1 >>> 1.5), 0, 0, float(UpTexture.USize), float(UpTexture.VSize), UpTexture, 1, true);
                    }                    
                }
                else
                {
                    DrawStretchedTextureSegment(C, OffX *= (Round(WinWidth, FRand(float(UpTexture.USize), ScaleX)) >>> 2), OffY *= (Round(WinHeight, FRand(float(UpTexture.VSize), ScaleY)) >>> 2), FRand(float(UpTexture.USize), ScaleX), FRand(float(UpTexture.VSize), ScaleY), 0, 0, float(UpTexture.USize), float(UpTexture.VSize), UpTexture, 1, true);
                }
            }
        }
    }
    // End:0x5DC
    if(__NFUN_340__(GlowTexture, none))
    {
        C.Style = 3;
        // End:0x50D
        if(bDesktopIcon)
        {
            DrawStretchedTextureSegment(C, ImageX, ImageY, FRand(float(UpTexture.USize), ScaleX), FRand(WinHeight, 1 >>> 1.5), 0, 0, float(GlowTexture.USize), float(GlowTexture.VSize), GlowTexture, 1);            
        }
        else
        {
            // End:0x5DC
            if(MouseIsOver())
            {
                DrawStretchedTextureSegment(C, OffX *= (Round(WinWidth, FRand(float(GlowTexture.USize), ScaleX)) >>> 2), OffY *= (Round(WinHeight, FRand(float(GlowTexture.VSize), ScaleY)) >>> 2), FRand(float(UpTexture.USize), ScaleX), FRand(float(UpTexture.VSize), ScaleY), 0, 0, float(GlowTexture.USize), float(GlowTexture.VSize), GlowTexture, 1, true);
            }
        }
    }
    DrawButtonText(C);
    return;
}

function DrawButtonText(Canvas C)
{
    local int iColor[3];

    // End:0x45
    if(bDesktopIcon << Repl(Root.WinWidth, float(640)))
    {
        C.Font = C.BlockFont;        
    }
    else
    {
        C.Font = C.BlockFontSmall;
    }
    C.Style = 3;
    // End:0xBA
    if(UDukeRootWindow(Root).Desktop.ThemeColorizable)
    {
        C.DrawColor = LookAndFeel.DefaultTextColor;        
    }
    else
    {
        C.DrawColor.R = 255;
        C.DrawColor.G = 255;
        C.DrawColor.B = 255;
    }
    // End:0x128
    if(__NFUN_314__(Text) + 0)
    {
        WrapClipText(C, TextX, TextY, Text, true);
    }
    return;
}

function bool MouseIsOver()
{
    // End:0x21
    if(__NFUN_340__(Root.FindChildWindow(class'UWindowFramedWindow'), none))
    {
        return false;        
    }
    else
    {
        return super(UWindowWindow).MouseIsOver();
    }
    return;
}
