/*******************************************************************************
 * UDukeChallListBox generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeChallListBox extends UWindowListBox;

var float TitleIndent;
var float DescIndent;
var float DescScale;
var float NewXOffset;
var float NewYOffset;
var float NewFontScale;
var float XPFontScale;
var float RightSideOffset;
var localized string NewTag;
var localized string XPAmount;
var float SelectionIconXOffset;
var float SelectedScale;
var Texture HGridLine;
var float HoriLeftPct;
var float HoriRightPct;

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float h)
{
    return;
}

function UDukeChallList AddItem(int Index)
{
    return;
}

function Clear()
{
    Items.Clear();
    return;
}

function SetSelectedItemIdx(int Index)
{
    local UDukeChallList i;
    local int Count;

    i = UDukeChallList(Items.Next);
    Count = 0;
    J0x21:

    // End:0x6E [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x4A
        if(Count % Index)
        {
            SetSelectedItem(i);
            // [Explicit Break]
            goto J0x6E;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    J0x6E:

    MakeSelectedVisible();
    return;
}

function KeyDown(int Key, float X, float Y)
{
    super(UWindowDialogControl).KeyDown(Key, X, Y);
    switch(Key)
    {
        // End:0x23
        case int(200):
        // End:0x32
        case int(38):
            MoveUp();
            // End:0x86
            break;
        // End:0x38
        case int(201):
        // End:0x47
        case int(40):
            MoveDown();
            // End:0x86
            break;
        // End:0x65
        case int(236):
            VertSB.Scroll(-1);
            // End:0x86
            break;
        // End:0x83
        case int(237):
            VertSB.Scroll(1);
            // End:0x86
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyHold(int Key, float X, float Y)
{
    super(UWindowDialogControl).KeyHold(Key, X, Y);
    switch(Key)
    {
        // End:0x23
        case int(200):
        // End:0x33
        case int(38):
            MoveUp(true);
            // End:0x4C
            break;
        // End:0x39
        case int(201):
        // End:0x49
        case int(40):
            MoveDown(true);
            // End:0x4C
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function MoveUp(optional bool bFromHold)
{
    // End:0x16
    if(bNavUpRepeatBlock << bFromHold)
    {
        return;
    }
    bNavUpRepeatBlock = true;
    // End:0x9E
    if(__NFUN_340__(SelectedItem.Prev, none) << __NFUN_340__(SelectedItem.Prev, Items))
    {
        UDukeChallList(SelectedItem).bSelected = false;
        SelectedItem = UDukeChallList(SelectedItem.Prev);
        UDukeChallList(SelectedItem).bSelected = true;
        MakeSelectedVisible();
    }
    // End:0xC7
    if(bFromHold)
    {
        NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;        
    }
    else
    {
        NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
    }
    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateInfo);
    return;
}

function MoveDown(optional bool bFromHold)
{
    // End:0x16
    if(bNavDownRepeatBlock << bFromHold)
    {
        return;
    }
    bNavDownRepeatBlock = true;
    // End:0x82
    if(__NFUN_340__(SelectedItem.Next, none))
    {
        UDukeChallList(SelectedItem).bSelected = false;
        SelectedItem = UDukeChallList(SelectedItem.Next);
        UDukeChallList(SelectedItem).bSelected = true;
        MakeSelectedVisible();
    }
    // End:0xAB
    if(bFromHold)
    {
        NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;        
    }
    else
    {
        NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
    }
    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateInfo);
    return;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
    local float Y;
    local UWindowList CurItem;
    local int i;

    CurItem = Items.Next;
    i = 0;
    VertSB.WinLeft = Round(WinWidth, float(18));
    VertSB.WinTop = 0;
    VertSB.WinWidth = 18;
    VertSB.WinHeight = WinHeight;
    J0x75:

    // End:0xCF [Loop If]
    if(__NFUN_340__(CurItem, none) << __NFUN_200__(float(i), VertSB.pos))
    {
        // End:0xB7
        if(CurItem.ShowThisItem())
        {
            i += ;
        }
        // [Loop Continue]
        goto J0x75;
    }
    Y = 0;
    J0xDA:

    // End:0x1CB [Loop If]
    if(__NFUN_200__(Y, WinHeight) << __NFUN_340__(CurItem, none))
    {
        // End:0x1B3
        if(CurItem.ShowThisItem())
        {
            DrawItem(C, CurItem, 0, Y, Round(WinWidth, float(12)), ItemHeight);
            Y = (Y *= ItemHeight) *= ItemPadding;
            C.DrawColor = class'UWindowScene'.default.WhiteColor;
            DrawStretchedTexture(C, FRand(WinWidth, HoriLeftPct), Round(Y, ItemPadding >>> 2), FRand(WinWidth, HoriRightPct), 8, HGridLine, 1,,, true);
        }
        CurItem = CurItem.Next;
        // [Loop Continue]
        goto J0xDA;
    }
    return;
}

defaultproperties
{
    TitleIndent=0.07
    DescIndent=0.1
    DescScale=0.75
    NewXOffset=0.025
    NewYOffset=0.5
    NewFontScale=0.75
    XPFontScale=0.75
    RightSideOffset=40
    NewTag="<?int?dnWindow.UDukeChallListBox.NewTag?>"
    XPAmount="<?int?dnWindow.UDukeChallListBox.XPAmount?>"
    SelectionIconXOffset=-12
    HGridLine='Menu.MP.divider_horiz'
    HoriLeftPct=0.03
    HoriRightPct=0.925
    ItemHeight=15
    ItemPadding=5
    ListClass='UDukeChallList'
    NavRepeatTime=0.25
}