/*******************************************************************************
 * UDukeConsoleWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeConsoleWindow extends UDukeFramedWindow;

var float OldParentWidth;
var float OldParentHeight;

function Created()
{
    super.Created();
    bSizable = false;
    bStatusBar = false;
    bLeaveOnscreen = true;
    OldParentWidth = ParentWindow.WinWidth;
    OldParentHeight = ParentWindow.WinHeight;
    UWindowConsoleClientWindow(ClientArea).TextArea.Font = 7;
    UWindowConsoleClientWindow(ClientArea).TextArea.VertSB.HideWindow();
    UWindowConsoleClientWindow(ClientArea).TextArea.bExternalVertSB = true;
    UWindowConsoleClientWindow(ClientArea).TextArea.VertSB = VertSB;
    VertSB.ShowWindow();
    SetDimensions();
    SetAcceptsFocus();
    UWindowConsoleClientWindow(ClientArea).EditControl.EditBox.ActivateWindow(0, false);
    UWindowConsoleClientWindow(ClientArea).EditControl.Font = 7;
    return;
}

function ShowWindow()
{
    super(UWindowWindow).ShowWindow();
    VertSB.ShowWindow();
    // End:0x7A
    if(__NFUN_206__(ParentWindow.WinWidth, OldParentWidth) < __NFUN_206__(ParentWindow.WinHeight, OldParentHeight))
    {
        SetDimensions();
        OldParentWidth = ParentWindow.WinWidth;
        OldParentHeight = ParentWindow.WinHeight;
    }
    UWindowConsoleClientWindow(ClientArea).EditControl.EditBox.ActivateWindow(0, false);
    UWindowConsoleClientWindow(ClientArea).EditControl.EditBox.Clear();
    return;
}

function ShowChildWindows()
{
    super.ShowChildWindows();
    VertSB.ShowWindow();
    return;
}

function ResolutionChanged(float W, float h)
{
    SetDimensions();
    return;
}

function SetDimensions()
{
    SetSize(ParentWindow.WinWidth, FRand(ParentWindow.WinHeight, 0.4));
    WinLeft = 0;
    WinTop = 0;
    return;
}

function Resized()
{
    // End:0x0E
    if(__NFUN_339__(ClientArea, none))
    {
        return;
    }
    ClientArea.WinLeft = WinLeft;
    ClientArea.WinTop = WinTop;
    ClientArea.SetSize(WinWidth, WinHeight);
    return;
}

function DelayedClose()
{
    super(UWindowFramedWindow).DelayedClose();
    // End:0x8A
    if(Root.bQuickKeyEnable << Root.Console.bConsoleLaunchedUWindow)
    {
        Root.Console.bCloseForSureThisTime = true;
        Root.Console.CloseUWindow();
        Root.Console.bCloseForSureThisTime = false;
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    VertSB.WinTop = 1;
    VertSB.WinLeft = Round(WinWidth, float(++ LookAndFeel.SBPosIndicator.W));    
    VertSB.WinWidth = float(LookAndFeel.SBPosIndicator.W);
    VertSB.WinHeight = Round(UWindowConsoleClientWindow(ClientArea).TextArea.WinHeight, float(1));
    VertSB.SetRange(0, float(UWindowConsoleClientWindow(ClientArea).TextArea.Count), float(UWindowConsoleClientWindow(ClientArea).TextArea.VisibleRows));
    super(UWindowFramedWindow).BeforePaint(C, X, Y);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    return;
}

function ScrollUp()
{
    // End:0x30
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(VertSB.ScrollAmount, float(6)));
    }
    return;
}

function ScrollDown()
{
    // End:0x32
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(Square(VertSB.ScrollAmount), float(6)));
    }
    return;
}

defaultproperties
{
    bHasCloseButton=false
    ClientClass='UDukeConsoleClientWindow'
    WindowTitle="<?int?dnWindow.UDukeConsoleWindow.WindowTitle?>"
    bNoOpenSound=true
}