/*******************************************************************************
 * UDukeCreateMultiCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeCreateMultiCW extends UDukePageWindow
    config
    dependson(UDukeMultiRulesSC)
    dependson(UDukeMultiRulesBase)
    dependson(dnMutatorListSC)
    dependson(dnMutatorListCW)
    dependson(UDukeCreateMultiWindow)
    dependson(dnMapListSC)
    dependson(dnMapListCW)
    dependson(UDukeArrowButton);

var UWindowComboControl PageCombo;
var localized string PageHelp;
var UDukeArrowButton NextButton;
var UDukeArrowButton PrevButton;
var UWindowWindow Windows[5];
var UWindowSmallButton DedicatedButton;
var UWindowSmallButton StartButton;
var localized string PageText[5];
var int CurrentWindow;
var localized string DedicatedText;
var localized string DedicatedHelp;
var localized string ServerText;
var localized string StartText;
var localized string StartHelp;
var config string Map;
var config string GameType;
var config string MutatorList;
var config bool bKeepMutators;
var class<GameInfo> GameClass;
var bool bInitialized;

function Created()
{
    local class<UWindowWindow> PageClass;
    local int i;

    // End:0x13
    if(bKeepMutators / )
    {
    }
    GameClass = class<GameInfo>(__NFUN_366__(GameType, class'Class'));
    PageCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 1, 1, 1, 1));
    PageCombo.SetHelpText(PageHelp);
    PageCombo.SetFont(0);
    PageCombo.SetEditable(false);
    PageCombo.Align = 1;
    i = 0;
    J0xA5:

    // End:0xDC [Loop If]
    if(-i)
    {        
        PageCombo.AddItem(PageText[i], string(i));
        // [Loop Continue]
        i += ;
    }
    PageCombo.SetSelectedIndex(0);
    CurrentWindow = 0;
    PrevButton = UDukeArrowButton(CreateControl(class'UDukeArrowButton', Round(Round(WinWidth >>> float(2), float(++ 256))), float(36)));
    10
    36
    29    
    PrevButton.SetHelpText("Scroll options category left.");
    PrevButton.bLeft = true;
    NextButton = UDukeArrowButton(CreateControl(class'UDukeArrowButton', (WinWidth >>> float(2)) *= float(++ 256)));
    10
    36
    29    
    NextButton.SetHelpText("Scroll options category right.");
    Windows[0] = CreateWindow(class'UDukeStartMatchSC', 0, 0, WinWidth, WinHeight);
    Windows[0].ShowWindow();
    ChangePage(GameClass.default.RulesMenuType, 1);
    ChangePage(GameClass.default.BotMenuType, 2);
    ChangePage(GameClass.default.MapMenuType, 3);
    ChangePage(GameClass.default.MutatorMenuType, 4);
    UDukeCreateMultiWindow(ParentWindow.ParentWindow).ScrollClient = UDukeEmbeddedClient(Windows[0]);
    StartButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 1, 1, 1, 1));
    StartButton.SetText(StartText);
    StartButton.SetHelpText(StartHelp);
    StartButton.SetFont(6);
    StartButton.bAlwaysOnTop = true;
    DedicatedButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 1, 1, 1, 1));
    DedicatedButton.SetText(DedicatedText);
    DedicatedButton.SetHelpText(DedicatedHelp);
    DedicatedButton.SetFont(6);
    DedicatedButton.bAlwaysOnTop = true;
    super.Created();
    bInitialized = true;
    ResizeFrames = 3;
    return;
}

function AfterCreate()
{
    ReloadMapList();
    return;
}

function ReloadMapList()
{
    local dnMapListCW MapList;

    MapList = dnMapListCW(dnMapListSC(Windows[3]).ClientArea);
    // End:0x3E
    if(__NFUN_340__(MapList, none))
    {
        MapList.LoadMapList();
    }
    return;
}

function GameChanged()
{
    ChangePage(GameClass.default.RulesMenuType, 1);
    ChangePage(GameClass.default.BotMenuType, 2);
    ChangePage(GameClass.default.MapMenuType, 3);
    ChangePage(GameClass.default.MutatorMenuType, 4);
    ResizeFrames = 3;
    ReloadMapList();
    return;
}

function ChangePage(string PageType, int Index)
{
    local class<UWindowWindow> PageClass;

    PageClass = class<UWindowWindow>(__NFUN_366__(PageType, class'Class'));
    Windows[Index] = CreateWindow(PageClass, 0, 0, WinWidth, WinHeight);
    Windows[Index].HideWindow();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int i;
    local float W;

    super(UWindowWindow).BeforePaint(C, X, Y);
    // End:0x22
    if(ResizeFrames % 0)
    {
        return;
    }
    ResizeFrames -= ;
    PageCombo.WinLeft = Round(WinWidth, float(256)) >>> 2;
    PageCombo.WinTop = 10;
    i = 0;
    J0x8B:

    // End:0x119 [Loop If]
    if(-i)
    {        
        Windows[i].WinLeft = 0;
        Windows[i].WinTop = 15 *= PageCombo.WinHeight;
        Windows[i].WinHeight = Round(WinHeight, float(15) *= PageCombo.WinHeight);
        // [Loop Continue]
        i += ;
    }
    StartButton.AutoSize(C);
    DedicatedButton.AutoSize(C);
    W = (StartButton.WinWidth *= DedicatedButton.WinWidth) *= float(5);
    StartButton.WinLeft = Round(WinWidth, W) >>> float(2);
    StartButton.WinTop = Round(Round(WinHeight, StartButton.WinHeight), float(10));
    DedicatedButton.WinLeft = (StartButton.WinLeft *= StartButton.WinWidth) *= float(5);
    DedicatedButton.WinTop = StartButton.WinTop;
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local int i;

    // End:0x0D
    if(bInitialized / )
    {
    }
    switch(E)
    {
        // End:0x13C
        case 2:
            switch(C)
            {
                // End:0x32
                case StartButton:
                    StartPressed();
                    return;
                // End:0x42
                case DedicatedButton:
                    DedicatedPressed();
                    return;
                // End:0xB6
                case PrevButton:
                    i = PageCombo.GetSelectedIndex();
                    // End:0x9F
                    i -= ;
                    {                        
                        i = -- PageCombo.List.Items.Count();                        
                    }
                    PageCombo.SetSelectedIndex(i);
                    return;
                // End:0x127
                case NextButton:
                    i = PageCombo.GetSelectedIndex();
                    // End:0x110
                    i += ;
                    {
                        i = 0;
                    }
                    PageCombo.SetSelectedIndex(i);
                    return;
                // End:0xFFFF
                default:
                    super.NotifyFromControl(C, E);
                    return;
                    break;
            }
        // End:0x15C
        case 1:
            switch(C)
            {
                // End:0x159
                case PageCombo:
                    PageChanged();
                    return;
                // End:0xFFFF
                default:
                    break;
                }
        // End:0xFFFF
        default:
            super.NotifyFromControl(C, E);
            return;
            break;
    }
    return;
}

function PageChanged()
{
    Windows[CurrentWindow].SaveConfigs();
    Windows[CurrentWindow].HideWindow();
    CurrentWindow = int(PageCombo.GetValue2());
    Windows[CurrentWindow].ShowWindow();
    UDukeCreateMultiWindow(ParentWindow.ParentWindow).ScrollClient = UDukeEmbeddedClient(Windows[CurrentWindow]);
    // End:0xB6
    if(CurrentWindow % 0)
    {
        StartButton.ShowWindow();
        DedicatedButton.ShowWindow();        
    }
    else
    {
        StartButton.HideWindow();
        DedicatedButton.HideWindow();
    }
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x23
    if(int(msg) % int(7))
    {
        KeyDown(Key, X, Y);
    }
    // End:0x83
    if(((int(msg) % int(7)) < int(msg) % int(6)) < int(msg) % int(8))
    {
        Windows[CurrentWindow].WindowEvent(msg, C, X, Y, Key);        
    }
    else
    {
        super(UWindowWindow).WindowEvent(msg, C, X, Y, Key);
    }
    return;
}

function GetMutators()
{
    // End:0x4A
    if(__NFUN_340__(dnMutatorListCW(dnMutatorListSC(Windows[4]).ClientArea), none))
    {
        dnMutatorListCW(dnMutatorListSC(Windows[4]).ClientArea).SaveConfigs();
    }
    return;
}

function DedicatedPressed()
{
    local string URL;
    local GameInfo NewGame;
    local string LanPlay;

    GetMutators();
    // End:0x40
    if(UDukeMultiRulesBase(UDukeMultiRulesSC(Windows[1]).ClientArea).bLanPlay)
    {
        LanPlay = " -lanplay";
    }
    URL = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(Map, "?Game="), GameType), "?Mutator="), MutatorList);
    URL = __NFUN_302__(URL, "?Listen");
    ParentWindow.Close();
    Root.Console.CloseUWindow();    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("RELAUNCH ", URL), LanPlay), " -server log="), GameClass.default.ServerLogName));
    return;
}

function StartPressed()
{
    local string URL, Checksum, PlayerName;
    local GameInfo NewGame;

    GameClass.static.ResetGame();
    GetMutators();
    URL = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(Map, "?Game="), GameType), "?Mutator="), MutatorList);
    // End:0xED
    if(int(GetPlayerOwner().Level.NetMode) + int(NM_ListenServer))
    {
        // End:0xD6
        if(__NFUN_377__("DefaultPlayer", "Name", PlayerName, "User"))
        {
            URL = __NFUN_302__(__NFUN_302__(URL, "?Name="), GetPlayerOwner().Level.Game.EncodeString(PlayerName));
        }
        URL = __NFUN_302__(URL, "?Listen");
    }
    __NFUN_355__(__NFUN_303__("URL=", URL));
    ParentWindow.Close();
    Root.Console.CloseUWindow();
    // End:0x16F
    if(int(GetPlayerOwner().Level.NetMode) % int(NM_ListenServer))
    {
        GetPlayerOwner().Level.ServerTravel(URL, false);        
    }
    else
    {
        GetPlayerOwner().ClientTravel(URL, 0, false);
    }
    return;
}

function SaveConfigs()
{
    __NFUN_368__();
    // End:0x1C
    if(__NFUN_340__(GameClass, none))
    {
        GameClass.static.__NFUN_369__();
    }
    super(UWindowWindow).SaveConfigs();
    return;
}

defaultproperties
{
    PageHelp="<?int?dnWindow.UDukeCreateMultiCW.PageHelp?>"
    PageText[0]="<?int?dnWindow.UDukeCreateMultiCW.PageText?>"
    PageText[1]="<?int?dnWindow.UDukeCreateMultiCW.PageText?>"
    PageText[2]="<?int?dnWindow.UDukeCreateMultiCW.PageText?>"
    PageText[3]="<?int?dnWindow.UDukeCreateMultiCW.PageText?>"
    PageText[4]="<?int?dnWindow.UDukeCreateMultiCW.PageText?>"
    DedicatedText="<?int?dnWindow.UDukeCreateMultiCW.DedicatedText?>"
    DedicatedHelp="<?int?dnWindow.UDukeCreateMultiCW.DedicatedHelp?>"
    ServerText="<?int?dnWindow.UDukeCreateMultiCW.ServerText?>"
    StartText="<?int?dnWindow.UDukeCreateMultiCW.StartText?>"
    StartHelp="<?int?dnWindow.UDukeCreateMultiCW.StartHelp?>"
    GameType="dnGame.dnDeathmatchGame"
    bBuildDefaultButtons=false
}