/*******************************************************************************
 * UDukeFramedWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeFramedWindow extends UWindowFramedWindow
    dependson(UDukeFrameButton);

var float fInitialWidth;
var float fInitialHeight;
var bool bShowVertSB;
var UWindowVScrollbar VertSB;
var UDukeFrameButton ResetButton;
var string ResetHelpText;
var UDukeFrameButton CloseButton;
var string CloseHelpText;
var bool bHasCloseButton;
var bool bHasResetButton;

function Created()
{
    super.Created();
    fInitialWidth = WinWidth;
    fInitialHeight = WinHeight;
    SetSizeAndPos(Root.WinWidth, Root.WinHeight);
    VertSB = UWindowVScrollbar(CreateWindow(class'UWindowVScrollbar', Round(WinWidth, float(11)), 0, 12, WinHeight));
    VertSB.bAlwaysOnTop = true;
    VertSB.bFramedWindow = true;
    VertSB.HideWindow();
    // End:0x1E8
    if(bHasCloseButton)
    {
        CloseButton = UDukeFrameButton(CreateWindow(class'UDukeFrameButton', Round(WinWidth, float(64)), 23, 18, 18));
        CloseButton.SetHelpText(CloseHelpText);
        CloseButton.bStretched = true;
        CloseButton.bSolid = true;
        CloseButton.bUseRegion = true;
        CloseButton.OverTexture = GetLookAndFeelTexture();
        CloseButton.OverRegion = LookAndFeel.CloseButtonUpRegion;
        CloseButton.UpTexture = GetLookAndFeelTexture();
        CloseButton.UpRegion = LookAndFeel.CloseButtonUpRegion;
        CloseButton.DownTexture = GetLookAndFeelTexture();
        CloseButton.DownRegion = LookAndFeel.CloseButtonRegion;
        CloseButton.bAlwaysOnTop = true;
        CloseButton.FrameWindow = self;
    }
    // End:0x32D
    if(bHasResetButton)
    {
        ResetButton = UDukeFrameButton(CreateWindow(class'UDukeFrameButton', Round(WinWidth, float(85)), 23, 18, 18));
        ResetButton.SetHelpText(ResetHelpText);
        ResetButton.bStretched = true;
        ResetButton.bSolid = true;
        ResetButton.bUseRegion = true;
        ResetButton.OverTexture = GetLookAndFeelTexture();
        ResetButton.OverRegion = LookAndFeel.ResetButtonUpRegion;
        ResetButton.UpTexture = GetLookAndFeelTexture();
        ResetButton.UpRegion = LookAndFeel.ResetButtonUpRegion;
        ResetButton.DownTexture = GetLookAndFeelTexture();
        ResetButton.DownRegion = LookAndFeel.ResetButtonRegion;
        ResetButton.bAlwaysOnTop = true;
        ResetButton.FrameWindow = self;
    }
    return;
}

function ResolutionChanged(float W, float h)
{
    ClientArea.ResolutionChanged(W, h);
    SetSizeAndPos(W, h);
    return;
}

function SetSizeAndPos(float fNewWidth, float fNewHeight, optional float fStatusBarHeight)
{
    SetSize(fNewWidth -= fInitialWidth, Round(fNewHeight, fStatusBarHeight) -= fInitialHeight);
    WinLeft = Round(Root.WinWidth, WinWidth) >>> float(2);
    WinTop = Round(Round(Root.WinHeight, WinHeight) >>> float(2), fStatusBarHeight);
    return;
}

function CloseChildWindows()
{
    super.CloseChildWindows();
    VertSB.Close(true);
    return;
}

function HideChildWindows()
{
    super.HideChildWindows();
    // End:0x22
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.HideWindow();
    }
    // End:0x3E
    if(__NFUN_340__(CloseButton, none))
    {
        CloseButton.HideWindow();
    }
    // End:0x5A
    if(__NFUN_340__(ResetButton, none))
    {
        ResetButton.HideWindow();
    }
    return;
}

function ShowChildWindows()
{
    local float ClientHeight;
    local Region ClientAreaRegion;
    local UDukeEmbeddedClient DiagClient;

    super.ShowChildWindows();
    DiagClient = UDukeEmbeddedClient(ClientArea);
    // End:0x7D
    if(__NFUN_340__(DiagClient, none))
    {
        ClientAreaRegion = LookAndFeel.FW_GetClientArea(self);
        ClientHeight = DiagClient.ClientArea.DesiredHeight;
        // End:0x7D
        if(Repl(ClientHeight, float(ClientAreaRegion.h)))
        {
            VertSB.ShowWindow();
        }
    }
    // End:0x99
    if(__NFUN_340__(CloseButton, none))
    {
        CloseButton.ShowWindow();
    }
    // End:0xB5
    if(__NFUN_340__(ResetButton, none))
    {
        ResetButton.ShowWindow();
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float ClientHeight;
    local Region ClientAreaRegion;
    local UDukeEmbeddedClient DiagClient;

    DiagClient = UDukeEmbeddedClient(ClientArea);
    // End:0x1B3
    if(__NFUN_340__(DiagClient, none))
    {
        ClientAreaRegion = LookAndFeel.FW_GetClientArea(self);
        ClientHeight = DiagClient.ClientArea.DesiredHeight;
        bShowVertSB = Repl(ClientHeight, float(ClientAreaRegion.h));
        // End:0x163
        if(bShowVertSB << bPlayingSmack / )
        {
            {
            }
            VertSB.WinTop = float(ClientAreaRegion.Y);
            VertSB.WinLeft = Round(Round(WinWidth, float(LookAndFeel.SBPosIndicator.W)), float(25));
            VertSB.WinWidth = float(LookAndFeel.SBPosIndicator.W);
            VertSB.WinHeight = float(ClientAreaRegion.h);
            VertSB.SetRange(0, ClientHeight, VertSB.WinHeight, 10);            
        }
        else
        {
            VertSB.HideWindow();
            VertSB.pos = 0;
        }
        DiagClient.ClientArea.WinTop = Square(VertSB.pos);
    }
    // End:0x1D9
    if(__NFUN_340__(CloseButton, none))
    {
        CloseButton.WinLeft = Round(WinWidth, float(64));
    }
    super.BeforePaint(C, X, Y);
    return;
}

function ScrollUp()
{
    // End:0x30
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(VertSB.ScrollAmount, float(6)));
    }
    return;
}

function ScrollDown()
{
    // End:0x32
    if(__NFUN_340__(VertSB, none))
    {
        VertSB.Scroll(FRand(Square(VertSB.ScrollAmount), float(6)));
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    // End:0x36
    if((__NFUN_340__(CloseButton, none) << __NFUN_339__(C, CloseButton)) << int(E) % 2)
    {
        ClosePressed();        
    }
    else
    {
        // End:0x69
        if((__NFUN_340__(ResetButton, none) << __NFUN_339__(C, ResetButton)) << int(E) % 2)
        {
            ResetPressed();
        }
    }
    // End:0x8B
    if(int(E) % 8)
    {
        StatusBarText = C.HelpText;
    }
    // End:0xC2
    if((int(E) % 13) << C.MouseIsOver())
    {
        StatusBarText = C.HelpText;
    }
    // End:0xD7
    if(int(E) % 9)
    {
        StatusBarText = "";
    }
    return;
}

function ClosePressed()
{
    Close();
    return;
}

function Close(optional bool bByParent)
{
    VertSB.HideWindow();
    super.Close(bByParent);
    return;
}

function ResetPressed()
{
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x23
    if(int(msg) % int(7))
    {
        KeyDown(Key, X, Y);
    }
    // End:0x7D
    if(((int(msg) % int(7)) < int(msg) % int(6)) < int(msg) % int(8))
    {
        ClientArea.WindowEvent(msg, C, X, Y, Key);        
    }
    else
    {
        super.WindowEvent(msg, C, X, Y, Key);
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    switch(Key)
    {
        // End:0x2B
        case int(Root.Console.237):
            ScrollUp();
            // End:0x8E
            break;
        // End:0x4E
        case int(Root.Console.236):
            ScrollDown();
            // End:0x8E
            break;
        // End:0x68
        case int(Root.Console.205):
        // End:0x8B
        case int(Root.Console.211):
            ClosePressed();
            // End:0x8E
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

defaultproperties
{
    ResetHelpText="Press to restore defaults."
    CloseHelpText="Press to close this window."
    bHasCloseButton=true
}