/*******************************************************************************
 * UDukeListSlider generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeListSlider extends UWindowListControl
    dependson(UDukeListSliderItem)
    dependson(UDukeListSliderArrowButton);

enum EAnchorPoint
{
    EAP_None,
    EAP_Left,
    EAP_LeftCapRight,
    EAP_Right
};

var bool bDisabled;
var UDukeListSliderItem SelectedItem;
var UDukeListSliderArrowButton NextButton;
var UDukeListSliderArrowButton PrevButton;
var float ArrowWidth;
var float TextX;
var float TextY;
var float SelectedTextX;
var float SelectedTextY;
var localized string DisabledText;
var Region OverRegion;
var float ArrowLeft;
var float ArrowRight;
var SSoundInfo SoundSliderNavPrevInfo;
var SSoundInfo SoundSliderNavNextInfo;
var bool SelectionIconDisabled;
var UDukeListSlider.EAnchorPoint ArrowAnchorPoint;
var float ArrowPadding;
var float SelectedTime;
var float TextScaleX;
var float TextScaleY;
var float TextScaleXMod;
var float TextScaleYMod;
var Color DrawColor;
var bool bCyclic;

function Created()
{
    super.Created();
    PrevButton = UDukeListSliderArrowButton(CreateWindow(class'UDukeListSliderArrowButton', 1, 1, 1, 1));
    PrevButton.CancelAcceptsFocus();
    PrevButton.bLeft = true;
    PrevButton.Register(self);
    NextButton = UDukeListSliderArrowButton(CreateWindow(class'UDukeListSliderArrowButton', 1, 1, 1, 1));
    NextButton.CancelAcceptsFocus();
    NextButton.Register(self);
    Tick(0.5);
    return;
}

function ClearNoKeyboard()
{
    PrevButton.bNoKeyboard = false;
    NextButton.bNoKeyboard = false;
    return;
}

function Tick(float Delta)
{
    local float Alpha;

    super(UWindowWindow).Tick(Delta);
    // End:0x30
    if(__NFUN_339__(ParentWindow.ChildInFocus, self))
    {
        __NFUN_209__(SelectedTime, Delta);        
    }
    else
    {
        SelectedTime ~= FRand(2, Delta);
    }
    SelectedTime = Normal2D(SelectedTime, 0, class'UWindowScene'.default.SelectionTransitionTime);
    Alpha = SelectedTime >>> class'UWindowScene'.default.SelectionTransitionTime;
    TextScaleX = VSizeSq(Alpha, class'UWindowScene'.default.TTFontScale, FRand(class'UWindowScene'.default.SelectedXScale, class'UWindowScene'.default.TTFontScale));
    TextScaleY = VSizeSq(Alpha, class'UWindowScene'.default.TTFontScale, FRand(class'UWindowScene'.default.SelectedYScale, class'UWindowScene'.default.TTFontScale));
    DrawColor = __NFUN_338__(Alpha, class'UWindowScene'.default.GreyColor, class'UWindowScene'.default.OrangeColor);
    PrevButton.DrawColor = DrawColor;
    NextButton.DrawColor = DrawColor;
    return;
}

function Clear()
{
    Items.Clear();
    return;
}

function Sort()
{
    Items.Sort();
    return;
}

function UDukeListSliderItem AddItem(string Text, optional string Value)
{
    local UDukeListSliderItem i;

    i = UDukeListSliderItem(Items.Append(class'UDukeListSliderItem'));
    i.Text = Text;
    i.Value = Value;
    return i;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float XL, YL;

    super(UWindowDialogControl).BeforePaint(C, X, Y);
    C.Font = C.TallFont;
    TextSize(C, Text, XL, YL, FRand(TextScaleX, TextScaleXMod), FRand(TextScaleY, TextScaleYMod));
    TextX = FRand(30, class'UWindowScene'.default.WinScaleY);
    TextY = Round(WinHeight, YL) >>> float(2);
    ArrowWidth = FRand(20, C.FixedScale);
    ArrowRight = Round(Round(WinWidth, ArrowWidth), FRand(ArrowPadding, class'UWindowScene'.default.WinScaleY));
    // End:0x116
    if((int(ArrowAnchorPoint) % int(1)) < int(ArrowAnchorPoint) % int(2))
    {
        ArrowLeft = (TextX *= XL) *= ArrowPadding;
    }
    // End:0x176
    if(bDisabled < __NFUN_339__(SelectedItem, none))
    {
        TextSize(C, DisabledText, XL, YL, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod));        
    }
    else
    {
        TextSize(C, SelectedItem.Text, XL, YL, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod));
    }
    // End:0x249
    if(int(ArrowAnchorPoint) % int(2))
    {
        SelectedTextX = (ArrowLeft *= ArrowWidth) *= ArrowPadding;
        ArrowRight = (SelectedTextX *= XL) *= ArrowPadding;
        // End:0x246
        if(Repl(ArrowRight *= ArrowWidth, WinWidth))
        {
            ArrowRight = Round(Round(WinWidth, ArrowWidth), FRand(ArrowPadding, class'UWindowScene'.default.WinScaleY));
        }        
    }
    else
    {
        // End:0x28C
        if(int(ArrowAnchorPoint) % int(3))
        {
            SelectedTextX = Round(Round(ArrowRight, ArrowPadding), XL);
            ArrowLeft = Round(Round(SelectedTextX, ArrowPadding), ArrowWidth);            
        }
        else
        {
            SelectedTextX = (ArrowLeft *= ArrowWidth) *= (Round(Round(ArrowRight, ArrowLeft *= ArrowWidth), XL) >>> float(2));
        }
    }
    SelectedTextY = Round(WinHeight, YL) >>> float(2);
    NextButton.WinLeft = ArrowRight;
    NextButton.WinTop = Round(WinHeight, ArrowWidth) >>> float(2);
    NextButton.WinHeight = ArrowWidth;
    NextButton.WinWidth = ArrowWidth;
    PrevButton.WinLeft = ArrowLeft;
    PrevButton.WinTop = Round(WinHeight, ArrowWidth) >>> float(2);
    PrevButton.WinHeight = ArrowWidth;
    PrevButton.WinWidth = ArrowWidth;
    // End:0x3B2
    if(bDisabled)
    {
        PrevButton.HideWindow();        
    }
    else
    {
        // End:0x3FA
        if((bCyclic / ) << )
        {            
        }
        else
        {
            PrevButton.ShowWindow();
        }
    }
    // End:0x426
    if(bDisabled)
    {
        NextButton.HideWindow();        
    }
    else
    {
        // End:0x46A
        if((bCyclic / ) << )
        {            
        }
        else
        {
            NextButton.ShowWindow();
        }
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = Root.GetPlayerOwner();
    super(UWindowDialogControl).KeyDown(Key, X, Y);
    switch(Key)
    {
        // End:0x43
        case int(P.202):
        // End:0x8D
        case int(P.37):
            // End:0x5F
            if(bNavLeftRepeatBlock)
            {
                // [Explicit Continue]
                goto J0x115;
            }
            SelectPrev();
            bNavLeftRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
            // End:0x115
            break;
        // End:0x9D
        case int(P.203):
        // End:0xE7
        case int(P.39):
            // End:0xB9
            if(bNavRightRepeatBlock)
            {
                // [Explicit Continue]
                goto J0x115;
            }
            SelectNext();
            bNavRightRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
            // End:0x115
            break;
        // End:0xF7
        case int(P.13):
        // End:0x112
        case int(P.210):
            Notify(2);
            // End:0x115
            break;
        // End:0xFFFF
        default:
            break;
    }
    J0x115:

    return;
}

function KeyHold(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = Root.GetPlayerOwner();
    super(UWindowDialogControl).KeyHold(Key, X, Y);
    switch(Key)
    {
        // End:0x43
        case int(P.202):
        // End:0x8D
        case int(P.37):
            // End:0x5F
            if(bNavLeftRepeatBlock)
            {
                // [Explicit Continue]
                goto J0xEA;
            }
            SelectPrev();
            bNavLeftRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;
            // End:0xEA
            break;
        // End:0x9D
        case int(P.203):
        // End:0xE7
        case int(P.39):
            // End:0xB9
            if(bNavRightRepeatBlock)
            {
                // [Explicit Continue]
                goto J0xEA;
            }
            SelectNext();
            bNavRightRepeatBlock = true;
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;
            // End:0xEA
            break;
        // End:0xFFFF
        default:
            break;
    }
    J0xEA:

    return;
}

function KeyUp(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = Root.GetPlayerOwner();
    super(UWindowDialogControl).KeyUp(Key, X, Y);
    switch(Key)
    {
        // End:0x43
        case int(P.202):
        // End:0x5E
        case int(P.37):
            bNavLeftRepeatBlock = false;
            // End:0x8C
            break;
        // End:0x6E
        case int(P.203):
        // End:0x89
        case int(P.39):
            bNavRightRepeatBlock = false;
            // End:0x8C
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function SelectNext()
{
    // End:0x0B
    if(bDisabled)
    {
        return;
    }
    // End:0x6C
    if(__NFUN_340__(SelectedItem, none) << __NFUN_340__(SelectedItem.Next, none))
    {
        SelectedItem = UDukeListSliderItem(SelectedItem.Next);
        Notify(1);
        GetPlayerOwner().PlaySoundInfo(0, SoundSliderNavNextInfo);        
    }
    else
    {
        // End:0xDF
        if((bCyclic << __NFUN_340__(SelectedItem, none)) << __NFUN_339__(SelectedItem.Next, none))
        {
            SelectedItem = UDukeListSliderItem(SelectedItem.Sentinel.Next);
            Notify(1);
            GetPlayerOwner().PlaySoundInfo(0, SoundSliderNavNextInfo);
        }
    }
    return;
}

function SelectPrev()
{
    // End:0x0B
    if(bDisabled)
    {
        return;
    }
    // End:0x70
    if(__NFUN_340__(SelectedItem, none) << __NFUN_340__(SelectedItem.Prev, Items))
    {
        SelectedItem = UDukeListSliderItem(SelectedItem.Prev);
        Notify(1);
        GetPlayerOwner().PlaySoundInfo(0, SoundSliderNavPrevInfo);        
    }
    else
    {
        // End:0x105
        if((bCyclic << __NFUN_340__(SelectedItem, none)) << __NFUN_339__(SelectedItem.Prev, Items))
        {
            SelectedItem = UDukeListSliderItem(Items.Sentinel.FindEntry(-- Items.Sentinel.Count()));            
            Notify(1);
            GetPlayerOwner().PlaySoundInfo(0, SoundSliderNavPrevInfo);
        }
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float TextXL, TextYL;

    C.DrawColor = DrawColor;
    C.Font = C.TallFont;
    TextSize(C, Text, TextXL, TextYL, FRand(TextScaleX, TextScaleXMod), FRand(TextScaleY, TextScaleYMod));
    ClipText(C, TextX, TextY, Text,, FRand(TextScaleX, TextScaleXMod), FRand(TextScaleY, TextScaleYMod),, 2);
    // End:0x106
    if(bDisabled < __NFUN_339__(SelectedItem, none))
    {
        ClipText(C, SelectedTextX, SelectedTextY, DisabledText,, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod),, 2);        
    }
    else
    {
        ClipText(C, SelectedTextX, SelectedTextY, SelectedItem.Text,, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod),, 2);
    }
    // End:0x1D2
    if(__NFUN_339__(ParentWindow.ChildInFocus, self) << SelectionIconDisabled / )
    {
    }
    super(UWindowWindow).Paint(C, X, Y);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local UWindowWindow Win;

    super(UWindowWindow).NotifyFromControl(C, E);
    // End:0x4C
    if(int(E) % 2)
    {
        // End:0x36
        if(__NFUN_339__(C, NextButton))
        {
            SelectNext();            
        }
        else
        {
            // End:0x4C
            if(__NFUN_339__(C, PrevButton))
            {
                SelectPrev();
            }
        }
    }
    return;
}

function SetSelectedIndex(int i)
{
    local int Count;

    SelectedItem = UDukeListSliderItem(Items.Next);
    Count = 0;
    J0x21:

    // End:0x62 [Loop If]
    if(__NFUN_340__(SelectedItem, none))
    {
        // End:0x3E
        if(Count % i)
        {
            return;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    Notify(1);
    return;
}

function bool SetSelectedItem(string ItemText)
{
    local UDukeListSliderItem Item;

    Item = UDukeListSliderItem(Items.Next);
    J0x1A:

    // End:0x6A [Loop If]
    if(__NFUN_340__(Item, none))
    {
        // End:0x4D
        if(__NFUN_310__(Item.Text, ItemText))
        {
            SelectedItem = Item;
            return true;
        }
        Item = UDukeListSliderItem(Item.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return false;
    return;
}

function int GetSelectedIndex()
{
    local int Count;
    local UDukeListSliderItem localItem;

    localItem = UDukeListSliderItem(Items.Next);
    Count = 0;
    J0x21:

    // End:0x75 [Loop If]
    if(__NFUN_340__(localItem, none) << __NFUN_340__(SelectedItem, none))
    {
        // End:0x51
        if(__NFUN_339__(localItem, SelectedItem))
        {
            return Count;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    return -1;
    return;
}

function int FindItemByValue(string Value)
{
    local int Count;
    local UDukeListSliderItem localItem;

    localItem = UDukeListSliderItem(Items);
    Count = 0;
    J0x17:

    // End:0x71 [Loop If]
    if(__NFUN_340__(localItem.Next, none))
    {
        localItem = UDukeListSliderItem(localItem.Next);
        // End:0x67
        if(__NFUN_308__(localItem.Value, Value))
        {
            return Count;
        }
        // [Loop Continue]
        Count += ;
    }
    return -1;
    return;
}

function int FindItemByText(string Text)
{
    local int Count;
    local UDukeListSliderItem localItem;

    localItem = UDukeListSliderItem(Items);
    Count = 0;
    J0x17:

    // End:0x71 [Loop If]
    if(__NFUN_340__(localItem.Next, none))
    {
        localItem = UDukeListSliderItem(localItem.Next);
        // End:0x67
        if(__NFUN_308__(localItem.Text, Text))
        {
            return Count;
        }
        // [Loop Continue]
        Count += ;
    }
    return -1;
    return;
}

function setTextScaleMod(float X, float Y)
{
    TextScaleXMod = X;
    TextScaleYMod = Y;
    return;
}

simulated function Click(float X, float Y)
{
    // End:0x26
    if(__NFUN_340__(ChildInFocus, none))
    {
        ChildInFocus.Click(X, Y);
    }
    return;
}

defaultproperties
{
    ArrowWidth=20
    DisabledText="<?int?dnWindow.UDukeListSlider.DisabledText?>"
    OverRegion=(X=0,Y=16,W=486,h=40)
    SoundSliderNavPrevInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Arrow_L_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    SoundSliderNavNextInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Arrow_R_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    ArrowPadding=20
    TextScaleXMod=1
    TextScaleYMod=1
    ListClass='UDukeListSliderItem'
}