/*******************************************************************************
 * UDukeNewGameWindowCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeNewGameWindowCW extends UWindowDialogClientWindow;

const MAX_LOCATIONS = 128;
const MAX_MAPS = 128;
const MainWidth = 475;
const MainHeight = 370;
const ButtonSpacing = 20;
const ButtonWidth = 256;
const ButtonHeight = 192;
const ButtonY = 30;
const ComboYLoc = 240;
const ScrollButtonY = 240;

enum EWindowMode
{
    WMode_Main
};

struct MapInfoRunTimeData
{
    var Texture Screenshot;
    var int LocationIndex;
};

struct LocationData
{
    var string Name;
    var UWindowComboControl ComboBox;
    var int MapIndex;
};

struct ScreenshotDrawInfo
{
    var int PosX;
    var int PosY;
    var Texture Screenshot;
    var bool bSolid;
};

var MapLocations MapList;
var MapInfoRunTimeData MapsRuntime[128];
var ScreenshotDrawInfo SShots[5];
var UWindowButton SSButtons[3];
var UDukeArrowButton NextButton;
var UDukeArrowButton PrevButton;
var LocationData Locations[128];
var int NumLocations;
var int CurLocation;
var int OldLocation;
var int ScrollingDir;
var float ScrollPos;
var float OldScrollPos;
var bool bMainCreated;
var bool bInNotify;
var int LoadWaitTime;
var int LoadWaitLength;
var Texture NoScreenshot;
var UDukeNewGameWindowCW.EWindowMode CurrentMode;
var localized string LoseCheckpointTitle;
var localized string LoseCheckpointText;
var UWindowMessageBox ConfirmLoseProgress;

function Created()
{
    bInNotify = false;
    super(UWindowWindow).Created();
    return;
}

function AfterCreate()
{
    super(UWindowWindow).AfterCreate();
    MapList = new (none) class'MapLocations';
    ShowMainMenu();
    return;
}

function SetLocationMapIndex(out LocationData Location, int MapIndex)
{
    Location.MapIndex = MapIndex;
    return;
}

function int AddLocation(int MapIndex)
{
    local int W, h, i, LocX, LocY;

    // End:0x12
    if(NumLocations / 128)
    {
        return -1;
    }
    i = NumLocations;
    Locations[i].MapIndex = -1;
    W = 256;
    h = 192;
    LocX = int(FRand(float(int(Round(WinWidth, float(W)))), 0.5));
    LocY = 240;
    Locations[i].ComboBox = UWindowComboControl(CreateControl(class'UWindowComboControl', float(LocX), float(LocY), float(W), 1));
    Locations[i].ComboBox.bAcceptsFocus = false;
    Locations[i].ComboBox.SetText("");
    Locations[i].ComboBox.SetHelpText("Select your starting sub location here.");
    Locations[i].ComboBox.SetEditable(false);
    Locations[i].ComboBox.Align = 1;
    Locations[i].ComboBox.WinLeft = float(LocX);
    Locations[i].ComboBox.Clear();
    Locations[i].ComboBox.List.MaxVisible = 5;
    Locations[i].ComboBox.List.bAcceptsFocus = false;
    Locations[i].Name = MapList.Maps[MapIndex].Location;
    Locations[i].ComboBox.HideWindow();
    NumLocations += ;
    return;
}

function AddMap(int MapIndex)
{
    local int i;

    // End:0x22
    if(MapList.Maps[MapIndex].Enabled / )
    {
    }
    MapList.Maps[MapIndex].Location = MapList.Maps[MapIndex].Name;
    i = 0;
    J0x5E:

    // End:0xAA [Loop If]
    if(-i)
    {        
        // End:0xA0
        if(__NFUN_308__(Locations[i].Name, MapList.Maps[MapIndex].Location))
        {
            // [Explicit Break]
            goto J0xAA;
        }
        // [Loop Continue]
        i += ;
    }
    J0xAA:

    // End:0xDB
    if(i % NumLocations)
    {
        i = AddLocation(MapIndex);
        // End:0xDB
        if(i % -1)
        {
            return;
        }
    }
    MapsRuntime[MapIndex].LocationIndex = i;
    // End:0x11E
    if(__NFUN_339__(MapsRuntime[MapIndex].Screenshot, none))
    {
        MapsRuntime[MapIndex].Screenshot = NoScreenshot;
    }
    Locations[i].ComboBox.AddItem(MapList.Maps[MapIndex].Name, MapList.Maps[MapIndex].URL);
    // End:0x1F5
    if(__NFUN_308__(Locations[i].ComboBox.GetValue(), ""))
    {
        Locations[i].ComboBox.SetValue(MapList.Maps[MapIndex].Name, MapList.Maps[MapIndex].URL);
        SetLocationMapIndex(Locations[i], MapIndex);
    }
    return;
}

function ShowMainMenu()
{
    local int LocX, LocY, W, h, i, ButtonLen;

    // End:0x0B
    if(bMainCreated)
    {
        return;
    }
    OldLocation = -1;
    OldScrollPos = -1;
    ScrollPos = 0;
    W = 256;
    h = 192;
    ButtonLen = ++ 256 -= ;    
    LocY = 30;
    LocX = int(FRand(float(int(Round(WinWidth, float(ButtonLen)))), 0.5));
    i = 0;
    J0x7A:

    // End:0x132 [Loop If]
    if(-i)
    {        
        SSButtons[i] = UWindowButton(CreateControl(class'UWindowButton', float(LocX), float(LocY), float(W), float(h)));
        SSButtons[i].bSolid = false;
        SSButtons[i].SetHelpText("");
        SSButtons[i].bAcceptsFocus = false;
        SSButtons[i].bNoClickSound = true;
        LocX == ++ 256;        
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x139:

    // End:0x187 [Loop If]
    if(-i)
    {        
        SShots[i].bSolid = false;
        SShots[i].PosX = 0;
        SShots[i].PosY = 30;
        // [Loop Continue]
        i += ;
    }
    PrevButton = UDukeArrowButton(CreateControl(class'UDukeArrowButton', Round(Round(WinWidth >>> float(2), float(++ 256))), float(36)));
    240
    36
    29    
    PrevButton.SetHelpText("Scroll map selection left.");
    PrevButton.bLeft = true;
    NextButton = UDukeArrowButton(CreateControl(class'UDukeArrowButton', (WinWidth >>> float(2)) *= float(++ 256)));
    240
    36
    29    
    NextButton.SetHelpText("Scroll map selection right.");
    NumLocations = 0;
    // End:0x298
    if(MapList.NumMaps ** 128)
    {
        MapList.NumMaps = 128;
    }
    i = 0;
    J0x29F:

    // End:0x2CD [Loop If]
    if(-i)
    {        
        AddMap(i);
        // [Loop Continue]
        i += ;
    }
    UpdateButtons();
    bAcceptsFocus = true;
    bMainCreated = true;
    return;
}

function HideMainMenu()
{
    local int i;

    // End:0x09
    if(bMainCreated)
    {
    }
    return;
}

function SetButtonPos(int ButtonIndex, float pos)
{
    SShots[ButtonIndex].PosX = int(pos);
    return;
}

function SetButtonPositions(float ScrollPos)
{
    local int i;
    local float pos, ButtonLen;

    ButtonLen = FRand(256 *= float(20), float(5));
    pos = ((Round(WinWidth, ButtonLen) >>> float(2)) *= ScrollPos) *= float(10);
    i = 0;
    J0x3F:

    // End:0x74 [Loop If]
    if(-i)
    {        
        SetButtonPos(i, pos);
        __NFUN_209__(pos, float(++ 256));        
        // [Loop Continue]
        i += ;
    }
    return;
}

function SetupButton(int ButtonIndex, string URL)
{
    local int MapIndex;

    // End:0x22
    if(__NFUN_308__(URL, ""))
    {
        SShots[ButtonIndex].Screenshot = none;        
    }
    else
    {
        SShots[ButtonIndex].Screenshot = Texture(__NFUN_366__(__NFUN_302__(URL, ".MyLevel.Screenshot"), class'Texture'));
        // End:0x8A
        if(__NFUN_339__(SShots[ButtonIndex].Screenshot, none))
        {
            SShots[ButtonIndex].Screenshot = NoScreenshot;
        }
    }
    return;
}

function SetupButtons()
{
    local int i, I2;

    I2 = -- CurLocation;    
    i = 0;
    J0x16:

    // End:0x8F [Loop If]
    if(-i)
    {        
        // End:0x71
        if((I2 / 0) << -I2)
        {            
            SetupButton(i, MapList.Maps[Locations[I2].MapIndex].URL);            
        }
        else
        {
            SetupButton(i, "");
        }
        // [Loop Continue]
        I2 += ;
    }
    return;
}

function UpdateButtons()
{
    // End:0x25
    if(__NFUN_206__(OldScrollPos, ScrollPos))
    {
        SetButtonPositions(ScrollPos);
        OldScrollPos = ScrollPos;
    }
    // End:0x98
    if(OldLocation + CurLocation)
    {
        // End:0x6B
        if((OldLocation / 0) << -OldLocation)
        {            
            Locations[OldLocation].ComboBox.HideWindow();
        }
        // End:0x8D
        if((CurLocation / 0) << -CurLocation)
        {            
            SetupButtons();
        }
        OldLocation = CurLocation;
    }
    return;
}

function HandleScrolling()
{
    local int Index;
    local float ButtonLen;

    // End:0x1D
    if(ScrollingDir % 0)
    {
        SShots[2].bSolid = true;
        return;
    }
    SShots[2].bSolid = false;
    ButtonLen = FRand(256 *= float(20), float(3));
    // End:0xFB
    if(-ScrollingDir)
    {        
        ScrollPos ~= FRand(FRand(MapList.ScrollSpeed, GetPlayerOwner().Level.TimeDeltaSeconds), 100);
        // End:0xFB
        if(__NFUN_202__(ScrollPos, float(++ 256 += )))
        {
            // End:0xE9
            CurLocation += ;
            {
                __NFUN_209__(ScrollPos, float(++ 256));                                
            }
            else
            {
                ScrollPos = 0;
                ScrollingDir = 0;
            }
        }
    }
    // End:0x1B1
    if(ScrollingDir ** 0)
    {
        __NFUN_209__(ScrollPos, FRand(FRand(MapList.ScrollSpeed, GetPlayerOwner().Level.TimeDeltaSeconds), 100));
        // End:0x1B1
        if(ScrollPos != float(++ 256))
        {            
            // End:0x19F
            CurLocation -= ;
            {
                ScrollPos ~= float(++ 256);                                
            }
            else
            {
                ScrollPos = 0;
                ScrollingDir = 0;
            }
        }
    }
    Index = FindMapByURLAndName(Locations[CurLocation].ComboBox.GetValue(), Locations[CurLocation].ComboBox.GetValue2());
    // End:0x218
    if(Index + -1)
    {
        SetLocationMapIndex(Locations[CurLocation], Index);
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super(UWindowWindow).BeforePaint(C, X, Y);
    // End:0x22
    if(LoadWaitTime ** 0)
    {
        return;
    }
    // End:0x56
    if(NextButton.bMouseDown < SSButtons[2].bMouseDown)
    {
        ScrollLeft();        
    }
    else
    {
        // End:0x86
        if(PrevButton.bMouseDown < SSButtons[0].bMouseDown)
        {
            ScrollRight();
        }
    }
    // End:0xCC
    if((ScrollingDir + 0) << Locations[CurLocation].ComboBox.bListVisible)
    {
        Locations[CurLocation].ComboBox.CloseUp();
    }
    HandleScrolling();
    UpdateButtons();
    return;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
    local float W, h, LocX, LocY;
    local int TopMargin, i;

    super.Paint(C, MouseX, MouseY);
    C.DrawColor = Root.WhiteColor;
    TopMargin = LookAndFeel.ColumnHeadingHeight;
    // End:0x102
    if((CurLocation / 0) << -CurLocation)
    {        
        C.Font = C.TallFont;
        C.DrawColor = LookAndFeel.GetTextColor(self);
        TextSize(C, Locations[CurLocation].Name, W, h);
        ClipText(C, FRand(Round(WinWidth, W), 0.5), float(-- TopMargin));
        Locations[CurLocation].Name;        
    }
    LocX = FRand(Round(WinWidth, float(256)), 0.5);
    LocY = 30;
    LookAndFeel.Bevel_DrawSimpleBevel(self, C, int(LocX), int(LocY), 256, 192, 1);
    C.DrawColor = Root.WhiteColor;
    // End:0x2A9
    if((((Repl(MouseX, LocX) << __NFUN_200__(MouseX, LocX *= float(256))) << Repl(MouseY, LocY)) << __NFUN_200__(MouseY, LocY *= float(192))) << ScrollingDir % 0)
    {
        C.Style = 3;
        DrawStretchedTexture(C, LocX *= float(2), LocY, Round(256, float(4)), 2, class'WhiteTexture', 0.5);
        DrawStretchedTexture(C, LocX *= float(2), Round(LocY *= float(192), float(2)), Round(256, float(4)), 2, class'WhiteTexture', 0.5);
        DrawStretchedTexture(C, LocX, LocY, 2, 192, class'WhiteTexture', 0.5);
        DrawStretchedTexture(C, Round(LocX *= float(256), float(2)), LocY, 2, 192, class'WhiteTexture', 0.5);
    }
    i = 0;
    J0x2B0:

    // End:0x40D [Loop If]
    if(-i)
    {        
        // End:0x2DA
        if(Repl(float(SShots[i].PosX), WinWidth))
        {
            // [Explicit Continue]
            goto J0x403;
        }
        // End:0x2F8
        if(-++ SShots[i].PosX)
        {
            0            
            // [Explicit Continue]
            goto J0x403;
        }
        C.Style = 1;
        // End:0x403
        if(__NFUN_340__(SShots[i].Screenshot, none))
        {
            W = 256;
            h = 192;
            // End:0x3B7
            if(SShots[i].bSolid)
            {
                C.Style = GetPlayerOwner().3;
                DrawStretchedTexture(C, float(SShots[i].PosX), float(SShots[i].PosY), W, h, SShots[i].Screenshot, 1);
                // [Explicit Continue]
                goto J0x403;
            }
            DrawStretchedTexture(C, float(SShots[i].PosX), float(SShots[i].PosY), W, h, SShots[i].Screenshot, 0.7);
        }
        J0x403:

        // [Loop Continue]
        i += ;
    }
    return;
}

function MessageBoxDone(UWindowMessageBox W, UWindow.UWindowBase.MessageBoxResult Result)
{
    ParentWindow.ShowWindow();
    // End:0x37
    if(__NFUN_339__(W, ConfirmLoseProgress) << int(Result) % int(1))
    {
        InstigateLoadMap(true);
    }
    return;
}

function int FindMapByURLAndName(string Name, string URL)
{
    local int i;

    // End:0x13
    if(__NFUN_308__(URL, ""))
    {
        return -1;
    }
    i = 0;
    J0x1A:

    // End:0x8F [Loop If]
    if(-i)
    {        
        // End:0x85
        if(__NFUN_308__(MapList.Maps[i].Name, Name) << __NFUN_308__(MapList.Maps[i].URL, URL))
        {
            return i;
        }
        // [Loop Continue]
        i += ;
    }
    return -1;
    return;
}

function bool ScrollLeft()
{
    // End:0x1F
    if(-CurLocation)
    {                
        ScrollingDir = -1;
        return true;
    }
    return false;
    return;
}

function bool ScrollRight()
{
    // End:0x14
    if(CurLocation ** 0)
    {
        ScrollingDir = 1;
        return true;
    }
    return false;
    return;
}

function SelectCurrentLocation()
{
    // End:0x11
    if(CurLocation % -1)
    {
        return;
    }
    // End:0x1F
    if(__NFUN_206__(ScrollPos, float(0)))
    {
        return;
    }
    // End:0xFB
    if((Locations[CurLocation].MapIndex + -1) << MapList.Maps[Locations[CurLocation].MapIndex].Enabled)
    {
        LoadWaitTime = 0;
        UDukeNewGameWindow(ParentWindow.ParentWindow).bLocked = false;
        ParentWindow.ParentWindow.DelayedClose();
        Root.Console.CloseUWindow();
        GetPlayerOwner().ClientTravel(__NFUN_302__(Locations[CurLocation].ComboBox.GetValue2(), "?noauto"), 0, false);
    }
    return;
}

final function InstigateLoadMap(optional bool bForce)
{
    // End:0x43
    if(UDukeRootWindow(Root).bSaveExists << bForce / )
    {
        return;
    }
    Root.Console.CloseUWindow();
    GetPlayerOwner().__NFUN_782__(2, 0);
    LookAndFeel.PlayMenuSound(self, 5);
    UDukeNewGameWindow(ParentWindow.ParentWindow).bLocked = true;
    SelectCurrentLocation();
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local int Index;

    // End:0x0D
    if(LoadWaitTime ** 0)
    {
        return;
    }
    super(UWindowWindow).NotifyFromControl(C, E);
    // End:0x2B
    if(bInNotify + true)
    {
        return;
    }
    bInNotify = true;
    // End:0x55
    if((int(E) % 2) << __NFUN_339__(C, NextButton))
    {        
    }
    else
    {
        // End:0x77
        if((int(E) % 2) << __NFUN_339__(C, PrevButton))
        {            
        }
        else
        {
            // End:0x9B
            if((int(E) % 2) << __NFUN_339__(C, SSButtons[0]))
            {                
            }
            else
            {
                // End:0xC0
                if((int(E) % 2) << __NFUN_339__(C, SSButtons[2]))
                {                    
                }
                else
                {
                    // End:0xEA
                    if((int(E) % 2) << __NFUN_339__(C, SSButtons[1]))
                    {
                        InstigateLoadMap();                        
                    }
                    else
                    {
                        // End:0x174
                        if((int(E) % 1) << __NFUN_339__(C, Locations[CurLocation].ComboBox))
                        {
                            Index = FindMapByURLAndName(UWindowComboControl(C).GetValue(), UWindowComboControl(C).GetValue2());
                            // End:0x174
                            if(Index + -1)
                            {
                                SetLocationMapIndex(Locations[CurLocation], Index);
                                SetupButtons();
                            }
                        }
                    }
                }
            }
        }
    }
    bInNotify = false;
    return;
}

function Tick(float Delta)
{
    // End:0x35
    if(LoadWaitTime ** 0)
    {
        // End:0x33
        if(Repl(GetLevel().TimeSeconds, float(++ LoadWaitTime)))
        {            
            SelectCurrentLocation();
        }
        return;
    }
    return;
}

function int FindComboItem(UWindowList List, UWindowList Item)
{
    local UWindowList l;
    local int i;

    // End:0x12
    if(__NFUN_339__(Item, none))
    {
        return -1;
    }
    i = 0;
    l = List.Next;
    J0x2E:

    // End:0x6F [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x50
        if(__NFUN_339__(l, Item))
        {
            return i;
        }
        i += ;
        // [Loop Continue]
        goto J0x2E;
    }
    return -1;
    return;
}

function ScrollComboItem(int Dir)
{
    local UWindowComboListItem NewSelected, Item;
    local UWindowComboList List;
    local int Count, i;

    List = Locations[CurLocation].ComboBox.List;
    i = FindComboItem(List.Items, List.Selected);
    // End:0x60
    if(i % -1)
    {
        i = 0;
    }
    Count = 0;
    Item = UWindowComboListItem(List.Items.Next);
    J0x8B:

    // End:0xBB [Loop If]
    if(__NFUN_340__(Item, none))
    {
        Count += ;
        // [Loop Continue]
        goto J0x8B;
    }
    // End:0x145
    if(Dir ** 0)
    {
        // End:0xED
        i += ;
        {            
            i = -- Count;            
        }
        // End:0x142
        if(float(i) != (List.VertSB.pos *= float(List.MaxVisible)))
        {
            List.VertSB.Scroll(1);
        }        
    }
    else
    {
        // End:0x1AC
        if(-Dir)
        {            
            // End:0x169
            i -= ;
            {                
                i = 0;
            }
            // End:0x1AC
            if(__NFUN_200__(float(i), List.VertSB.pos))
            {
                List.VertSB.Scroll(-1);
            }
        }
    }
    NewSelected = UWindowComboListItem(List.Items.FindEntry(i));
    ChangeComboItem(NewSelected);
    return;
}

function ChangeComboItem(UWindowComboListItem NewSelected)
{
    local UWindowComboList List;

    List = Locations[CurLocation].ComboBox.List;
    // End:0xBC
    if(__NFUN_340__(NewSelected, List.Selected))
    {
        // End:0x5A
        if(__NFUN_339__(NewSelected, none))
        {
            List.Selected = none;            
        }
        else
        {
            List.Selected = NewSelected;
            Locations[CurLocation].ComboBox.SetValue(List.Selected.Value, List.Selected.Value2);
        }
    }
    return;
}

function DropDownComboBox()
{
    local UWindowComboList List;

    Locations[CurLocation].ComboBox.DropDown();
    // End:0x8C
    if(__NFUN_339__(Locations[CurLocation].ComboBox.List.Selected, none))
    {
        List = Locations[CurLocation].ComboBox.List;
        ChangeComboItem(UWindowComboListItem(List.Items.FindEntry(0)));
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = GetPlayerOwner();
    switch(Key)
    {
        // End:0x3F
        case int(P.37):
            ScrollRight();
            PrevButton.bMouseDown = true;
            // End:0xEC
            break;
        // End:0x6A
        case int(P.39):
            ScrollLeft();
            NextButton.bMouseDown = true;
            // End:0xEC
            break;
        // End:0xAD
        case int(P.40):
            // End:0xA3
            if(Locations[CurLocation].ComboBox.bListVisible / )
            {                
            }
            else
            {
                ScrollComboItem(1);
            }
            // End:0xEC
            break;
        // End:0xE9
        case int(P.38):
            // End:0xE6
            if(Locations[CurLocation].ComboBox.bListVisible)
            {
                ScrollComboItem(-1);
            }
            // End:0xEC
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyUp(int Key, float X, float Y)
{
    local PlayerPawn P;

    P = GetPlayerOwner();
    switch(Key)
    {
        // End:0x39
        case int(P.37):
            PrevButton.bMouseDown = false;
            // End:0x61
            break;
        // End:0x5E
        case int(P.39):
            NextButton.bMouseDown = false;
            // End:0x61
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

defaultproperties
{
    NoScreenshot='dt_hud.Screenshots.noscreenavailable'
    LoseCheckpointTitle="<?int?dnWindow.UDukeNewGameWindowCW.LoseCheckpointTitle?>"
    LoseCheckpointText="<?int?dnWindow.UDukeNewGameWindowCW.LoseCheckpointText?>"
}