/*******************************************************************************
 * UDukePlayerGrid generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukePlayerGrid extends UWindowGrid;

var localized string NameText;
var localized string FragsText;
var localized string PingText;

function Created()
{
    local float W;

    super.Created();
    RowHeight = 15;
    W = Round(WinWidth, float(7));
    AddColumn(NameText, FRand(0.64, W));
    AddColumn(FragsText, FRand(0.2, W));
    AddColumn(PingText, FRand(0.16, W));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    DrawStretchedTextureSegment(C, 0, 24, WinWidth, Round(WinHeight, float(24)), 0, 0, 1, 1, class'BlackTexture', 1);
    super.Paint(C, X, Y);
    return;
}

function PaintColumn(Canvas C, UWindowGridColumn Column, float MouseX, float MouseY)
{
    local UDukeServerList Server;
    local UDukePlayerList PlayerList, l;
    local int Visible, Count, Skipped, Y, TopMargin, BottomMargin;

    // End:0x26
    if(bShowHorizSB)
    {
        BottomMargin = LookAndFeel.SBPosIndicator.W;        
    }
    else
    {
        BottomMargin = 0;
    }
    TopMargin = 24;
    Server = UDukeInfoCW(GetParent(class'UDukeInfoCW')).Server;
    // End:0x63
    if(__NFUN_339__(Server, none))
    {
        return;
    }
    PlayerList = Server.PlayerList;
    // End:0x86
    if(__NFUN_339__(PlayerList, none))
    {
        return;
    }
    Count = PlayerList.Count();
    C.Font = C.BlockFont;
    Visible = int(Round(WinHeight, float(++ TopMargin)) >>> );    
    VertSB.SetRange(0, float(++ Count));
    float(Visible)    
    TopRow = int(VertSB.pos);
    Skipped = 0;
    Y = 1;
    l = UDukePlayerList(PlayerList.Next);
    J0x13F:

    // End:0x2D9 [Loop If]
    if(__NFUN_200__(float(Y), Round(Round(RowHeight *= WinHeight, RowHeight), float(++ TopMargin))) << )
    {        
        // End:0x2B5
        if(float(Skipped) != VertSB.pos)
        {
            switch(Column.ColumnNum)
            {
                // End:0x1E3
                case 0:
                    Column.ClipText(C, 6, float(++ Y));
                    l.PlayerName                    
                    // End:0x2A1
                    break;
                // End:0x221
                case 1:
                    Column.ClipText(C, 6, float(++ Y));
                    string(l.PlayerFrags)                    
                    // End:0x2A1
                    break;
                // End:0x260
                case 2:
                    Column.ClipText(C, 6, float(++ Y));
                    string(l.PlayerPing)                    
                    // End:0x2A1
                    break;
                // End:0x29E
                case 3:
                    Column.ClipText(C, 6, float(++ Y));
                    l.PlayerTeam                    
                    // End:0x2A1
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            Y = int(float(Y) *= RowHeight);
        }
        Skipped += ;
        // [Loop Continue]
        goto J0x13F;
    }
    return;
}

function RightClickRow(int Row, float X, float Y)
{
    return;
}

function SortColumn(UWindowGridColumn Column)
{
    UDukeInfoCW(GetParent(class'UDukeInfoCW')).Server.PlayerList.SortByColumn(Column.ColumnNum);
    return;
}

function SelectRow(int Row, optional bool bFromHold)
{
    return;
}

defaultproperties
{
    NameText="<?int?dnWindow.UDukePlayerGrid.NameText?>"
    FragsText="<?int?dnWindow.UDukePlayerGrid.FragsText?>"
    PingText="<?int?dnWindow.UDukePlayerGrid.PingText?>"
    bNoKeyboard=true
    bBrowserGrid=true
}