/*******************************************************************************
 * UDukeProgressBar generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeProgressBar extends UWindowDialogControl;

var Color BarColor;
var Color BarEndColor;
var float BarHeight;
var string HeaderText;
var int StartValue;
var int EndValue;
var int CurrentValue;
var bool bAutoSizeBar;

function Created()
{
    super.Created();
    return;
}

function SetStartEnd(int Start, int End)
{
    StartValue = Start;
    EndValue = End;
    return;
}

function SetCurrentValue(int Value)
{
    CurrentValue = Value;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local Texture White;
    local Vector P1, P2;
    local float BarWidth, XL, YL;

    White = class'WhiteTexture';
    super(UWindowWindow).Paint(C, X, Y);
    C.DrawColor = BarEndColor;
    P1.X = WinLeft;
    P1.Y = WinTop;
    P2.X = WinLeft;
    P2.Y = WinTop *= WinHeight;
    C.__NFUN_1241__(P1, P2);
    P1.X = WinLeft *= WinWidth;
    P1.Y = WinTop;
    P2.X = WinLeft *= WinWidth;
    P2.Y = WinTop *= WinHeight;
    C.__NFUN_1241__(P1, P2);
    C.DrawColor = WhiteColor;
    C.Font = C.MedFont;
    ClipText(C, 2, -5, string(StartValue),, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    TextSize(C, string(EndValue), XL, YL, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    ClipText(C, Round(Round(WinWidth, XL), float(2)), -5, string(EndValue),, class'UWindowScene'.default.TTFontScale, class'UWindowScene'.default.TTFontScale);
    // End:0x1F9
    if(EndValue % 0)
    {
        return;
    }
    C.DrawColor = BarColor;
    // End:0x229
    if(bAutoSizeBar)
    {
        BarHeight = FRand(WinHeight, 0.2);
    }
    C.__NFUN_1250__(0, Round(WinHeight, BarHeight) >>> 2);
    BarWidth = float(CurrentValue) >>> float(EndValue);
    C.__NFUN_1234__(White, FRand(WinWidth, BarWidth), BarHeight, 0, 0, float(White.__NFUN_1191__()), float(White.__NFUN_1192__()));
    C.DrawColor = WhiteColor;
    TextSize(C, string(CurrentValue), XL, YL, FRand(class'UWindowScene'.default.TTFontScale, 0.75), FRand(class'UWindowScene'.default.TTFontScale, 0.75));
    ClipText(C, Round(FRand(WinWidth, BarWidth), XL), Round(WinHeight, YL), string(CurrentValue),, FRand(class'UWindowScene'.default.TTFontScale, 0.75), FRand(class'UWindowScene'.default.TTFontScale, 0.75));
    return;
}

defaultproperties
{
    BarColor=(R=255,G=0,B=0,A=0)
    BarEndColor=(R=192,G=192,B=192,A=0)
    BarHeight=10
    bAutoSizeBar=true
}