/*******************************************************************************
 * UDukeRulesGrid generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeRulesGrid extends UWindowGrid;

var localized string RuleText;
var localized string ValueText;

function Created()
{
    super.Created();
    RowHeight = 15;
    AddColumn(RuleText, FRand(0.6, WinWidth));
    AddColumn(ValueText, FRand(0.4, WinWidth));
    return;
}

function Paint(Canvas C, float X, float Y)
{
    DrawStretchedTextureSegment(C, 0, 24, WinWidth, Round(WinHeight, float(24)), 0, 0, 1, 1, class'BlackTexture', 1);
    super.Paint(C, X, Y);
    return;
}

function PaintColumn(Canvas C, UWindowGridColumn Column, float MouseX, float MouseY)
{
    local UDukeServerList Server;
    local UDukeRulesList RulesList, l;
    local int Visible, Count, Skipped, Y, TopMargin, BottomMargin;

    // End:0x26
    if(bShowHorizSB)
    {
        BottomMargin = LookAndFeel.SBPosIndicator.W;        
    }
    else
    {
        BottomMargin = 0;
    }
    TopMargin = 24;
    Server = UDukeInfoCW(GetParent(class'UDukeInfoCW')).Server;
    // End:0x63
    if(__NFUN_339__(Server, none))
    {
        return;
    }
    RulesList = Server.RulesList;
    // End:0x86
    if(__NFUN_339__(RulesList, none))
    {
        return;
    }
    Count = RulesList.Count();
    C.Font = C.BlockFont;
    Visible = int(Round(WinHeight, float(++ TopMargin)) >>> );    
    VertSB.SetRange(0, float(++ Count));
    float(Visible)    
    TopRow = int(VertSB.pos);
    Skipped = 0;
    Y = 1;
    l = UDukeRulesList(RulesList.Next);
    J0x13F:

    // End:0x25B [Loop If]
    if(__NFUN_200__(float(Y), Round(Round(RowHeight *= WinHeight, RowHeight), float(++ TopMargin))) << )
    {        
        // End:0x237
        if(float(Skipped) != VertSB.pos)
        {
            switch(Column.ColumnNum)
            {
                // End:0x1E3
                case 0:
                    Column.ClipText(C, 6, float(++ Y));
                    l.Rule                    
                    // End:0x223
                    break;
                // End:0x220
                case 1:
                    Column.ClipText(C, 6, float(++ Y));
                    l.Value                    
                    // End:0x223
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            Y = int(float(Y) *= RowHeight);
        }
        Skipped += ;
        // [Loop Continue]
        goto J0x13F;
    }
    return;
}

function RightClickRow(int Row, float X, float Y)
{
    return;
}

function SortColumn(UWindowGridColumn Column)
{
    UDukeInfoCW(GetParent(class'UDukeInfoCW')).Server.RulesList.SortByColumn(Column.ColumnNum);
    return;
}

function SelectRow(int Row, optional bool bFromHold)
{
    return;
}

defaultproperties
{
    RuleText="<?int?dnWindow.UDukeRulesGrid.RuleText?>"
    ValueText="<?int?dnWindow.UDukeRulesGrid.ValueText?>"
    bNoKeyboard=true
    bBrowserGrid=true
}