/*******************************************************************************
 * UDukeSceneChapterSelect generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneChapterSelect extends UWindowScene;

struct SChapterEntry
{
    var string URL;
    var transient Texture Shot;
    var string SShotPaackage;
    var array<Engine.Object.EEgoAwardID> Awards;
    var bool IsDLC;
};

var UDukeListSlider ChapterList;
var localized string ChapterListText;
var localized string ChapterListHelp;
var UDukeMessageBox ConfirmChapterSelect;
var localized string ConfirmChapterSelectTitle;
var localized string ConfirmChapterSelectText;
var localized string EgoItemText;
var localized array<string> ChapterNames;
var array<SChapterEntry> Chapters;
var bool bMapImageValuesValid;
var bool bDeferredSelect;
var float MapImageLeft;
var float MapImageTop;
var float MapImageRight;
var float MapImageBottom;
var Texture DifficultyIcons[4];
var float LockedAlpha;

function Created()
{
    super.Created();
    ChapterList = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    ChapterList.SetText("");
    ChapterList.SetHelpText(ChapterListHelp);
    ChapterList.Register(self);
    ChapterList.SelectionIconDisabled = true;
    ConfirmChapterSelect = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmChapterSelect.SetupMessageBox(ConfirmChapterSelectTitle, ConfirmChapterSelectText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmChapterSelect.HideWindow();
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x128
    if(ConfirmChapterSelect.bWindowVisible / )
    {
        {
            // End:0xAA
            if(((Key % int(Root.Console.13)) < Key % int(Root.Console.210)) < Key % int(Root.Console.204))
            {
                bDeferredSelect = true;
            }            
        }
        else
        {
            // End:0x128
            if((int(msg) % int(0)) << __NFUN_340__(ChapterList.SelectedItem, none))
            {
                // End:0x128
                if((((bMapImageValuesValid << X != MapImageLeft) << __NFUN_202__(X, MapImageRight)) << Y != MapImageTop) << __NFUN_202__(Y, MapImageBottom))
                {
                    bDeferredSelect = true;
                }
            }
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function Tick(float Delta)
{
    super.Tick(Delta);
    // End:0x2B
    if(bDeferredSelect)
    {
        bDeferredSelect = false;
        NotifyFromControl(KeyButtons[0], 2);
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x8E
    if(((int(E) % 2) << __NFUN_339__(C, KeyButtons[0])) << __NFUN_340__(ChapterList.SelectedItem, none))
    {
        // End:0x6F
        if(UDukeRootWindow(Root).bSaveExists)
        {
            ShowModal(ConfirmChapterSelect);            
        }
        else
        {
            ChapterSelected(ChapterList.SelectedItem.Value);
        }
    }
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    // End:0x4C
    if((iResult ** 0) << __NFUN_339__(W, ConfirmChapterSelect))
    {
        ChapterSelected(ChapterList.SelectedItem.Value);
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local Texture MapShot;
    local float Top, Width, Height, TextAlignX, TextAlignY, Left,
	    DifficultyAlphas;

    local int i, j, Found, AwardCount, AwardCountTotal, SelectedChapter;

    local DukePlayer Duke;
    local string AwardString;

    super.Paint(C, X, Y);
    ChapterList.WinLeft = float(ButtonLeft);
    ChapterList.WinTop = float(ControlStart);
    ChapterList.WinWidth = float(ButtonWidth);
    ChapterList.WinHeight = float(ButtonHeight);
    ChapterList.ArrowLeft = FRand(16, WinScaleY);
    MapShot = none;
    // End:0x1B7
    if(__NFUN_340__(ChapterList.SelectedItem, none))
    {
        i = 0;
        J0xAD:

        // End:0x1B7 [Loop If]
        if(-i)
        {            
            // End:0x1AD
            if(__NFUN_308__(Chapters[i].URL, ChapterList.SelectedItem.Value))
            {
                // End:0x145
                if(__NFUN_339__(Chapters[i].Shot, none))
                {
                    Chapters[i].Shot = Texture(__NFUN_366__(__NFUN_302__(Chapters[i].SShotPaackage, Chapters[i].URL), class'Texture', true));
                }
                MapShot = Chapters[i].Shot;
                AwardCountTotal = string(Chapters[i].Awards);
                Duke = DukePlayer(GetPlayerOwner());
                // End:0x1AA
                if(__NFUN_340__(Duke, none))
                {
                    AwardCount = CheckEgoAwardAndSetDifficulty(Duke, i, DifficultyAlphas);
                }
                // [Explicit Break]
                goto J0x1B7;
            }
            // [Loop Continue]
            i += ;
        }
    }
    J0x1B7:

    // End:0x1CE
    if(__NFUN_339__(MapShot, none))
    {
        MapShot = class'BlackTexture';
    }
    Top = (ChapterList.WinTop *= ChapterList.WinHeight) *= float(ControlBuffer);
    Height = Round(Round(FRand(550, WinScaleY), Top), float(ControlBuffer));
    Width = FRand(Height, 16) >>> 9;
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    C.__NFUN_1250__(ChapterList.WinLeft *= FRand(0.5, Round(float(ButtonWidth), Width)), Top);
    TextAlignX = Round(C.CurX *= Width, FRand(8, WinScaleY));
    TextAlignY = Round(C.CurY *= Height, FRand(8, WinScaleY));
    MapImageLeft = C.CurX;
    MapImageTop = C.CurY;
    MapImageRight = MapImageLeft *= Width;
    MapImageBottom = MapImageTop *= Height;
    bMapImageValuesValid = true;
    C.__NFUN_1234__(MapShot, Width, Height, 0, 0, float(MapShot.__NFUN_1191__()), float(MapShot.__NFUN_1192__()));
    // End:0x47E
    if(AwardCountTotal ** 0)
    {
        AwardString = __NFUN_302__(__NFUN_302__(__NFUN_303__(EgoItemText, string(AwardCount)), "/"), string(AwardCountTotal));
        C.DrawColor = GreyColor;
        C.Font = C.TallFont;
        C.__NFUN_1238__(AwardString, Width, Height, FRand(TTFontScale, 0.75), FRand(TTFontScale, 0.75));
        C.__NFUN_1250__(Round(TextAlignX, Width *= FRand(8, C.FixedScale)), Round(TextAlignY, Height));
        C.__NFUN_1232__(AwardString, false, false, false, FRand(TTFontScale, 0.75), FRand(TTFontScale, 0.75),, 2);
    }
    C.DrawColor = WhiteColor;
    Left = MapImageLeft *= FRand(4, WinScaleY);
    Top = MapImageBottom;
    i = 3;
    J0x4BF:

    // End:0x5AA [Loop If]
    if(i / 0)
    {
        Width = FRand(float(DifficultyIcons[i].__NFUN_1191__()), WinScaleY);
        Height = FRand(float(DifficultyIcons[i].__NFUN_1192__()), WinScaleY);
        Top ~= (Height *= FRand(4, WinScaleY));
        C.__NFUN_1250__(Left, Top);
        C.__NFUN_1234__(DifficultyIcons[i], Width, Height, 0, 0, float(DifficultyIcons[i].__NFUN_1191__()), float(DifficultyIcons[i].__NFUN_1192__()),,,,, DifficultyAlphas[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

function int CheckEgoAwardAndSetDifficulty(DukePlayer Duke, int i, out float DifficultyAlphas[4])
{
    local int j, AwardCount;

    AwardCount = 0;
    j = -- string(Chapters[i].Awards);    
    J0x21:

    // End:0x67 [Loop If]
    if(j / 0)
    {
        // End:0x5D
        if(Duke.HasDiscoveredEgoAward(int(Chapters[i].Awards[j])))
        {
            // [Loop Continue]
            AwardCount += ;
        }
    }
    j = 0;
    J0x6E:

    // End:0xE6 [Loop If]
    if(-j)
    {        
        // End:0x9A
        if(i % 23)
        {
            DifficultyAlphas[j] = 0;
            // [Explicit Continue]
            goto J0xDC;
        }
        // End:0xCB
        if(Duke.HasCompletionForLevel(j, i))
        {
            DifficultyAlphas[j] = 1;
            // [Explicit Continue]
            goto J0xDC;
        }
        DifficultyAlphas[j] = LockedAlpha;
        J0xDC:

        // [Loop Continue]
        j += ;
    }
    return AwardCount;
    return;
}

function string GetTravelURL(string Chapter)
{
    return __NFUN_302__(Chapter, "?Game=dnGame.dnSinglePlayer");
    return;
}

function ChapterSelected(string Chapter)
{
    local UDukeSceneSinglePlayerDifficulty NewScene;

    // End:0x3F
    if(__NFUN_310__(Chapter, "map23"))
    {
        GetPlayerOwner().__NFUN_782__(2, 0);
        GetPlayerOwner().ClientTravel(Chapter, 0, false);        
    }
    else
    {
        NavigateForward(class'UDukeSceneSinglePlayerDifficulty');
        NewScene = UDukeSceneSinglePlayerDifficulty([-- string(UDukeRootWindow(Root).Scenes)]);
        UDukeRootWindow(Root).Scenes
        NewScene.TitleText = TitleText;
        NewScene.TravelURL = GetTravelURL(Chapter);
    }
    return;
}

function OnNavForward()
{
    local int i;
    local SChapterEntry Entry;
    local bool bLastChapterComplete;

    ChapterNames = default.ChapterNames;
    Chapters = default.Chapters;
    bLastChapterComplete = false;
    ChapterList.Clear();
    i = 0;
    J0x35:

    // End:0xFF [Loop If]
    if(-i)
    {        
        // End:0x9A
        if(DukePlayer(GetPlayerOwner()).HasCompletionForLevel(0, i))
        {
            bLastChapterComplete = true;
            ChapterList.AddItem(ChapterNames[i], Chapters[i].URL);
            // [Explicit Continue]
            goto J0xF5;
        }
        // End:0xF5
        if(__NFUN_308__(Chapters[i].URL, "map00") < bLastChapterComplete)
        {
            bLastChapterComplete = false;
            ChapterList.AddItem(ChapterNames[i], Chapters[i].URL);
        }
        J0xF5:

        // [Loop Continue]
        i += ;
    }
    ChapterList.SetSelectedIndex(0);
    super.OnNavForward();
    return;
}

defaultproperties
{
    ChapterListText="<?int?dnWindow.UDukeSceneChapterSelect.ChapterListText?>"
    ChapterListHelp="<?int?dnWindow.UDukeSceneChapterSelect.ChapterListHelp?>"
    ConfirmChapterSelectTitle="<?int?dnWindow.UDukeSceneChapterSelect.ConfirmChapterSelectTitle?>"
    ConfirmChapterSelectText="<?int?dnWindow.UDukeSceneChapterSelect.ConfirmChapterSelectText?>"
    EgoItemText="<?int?dnWindow.UDukeSceneChapterSelect.EgoItemText?>"
    ChapterNames(0)="Duke Lives"
    ChapterNames(1)="Damn! It's Late..."
    ChapterNames(2)="The Duke Cave"
    ChapterNames(3)="Mothership Battle"
    ChapterNames(4)="The Lady Killer"
    ChapterNames(5)="Vegas in Ruin"
    ChapterNames(6)="The Duke Dome"
    ChapterNames(7)="The Hive"
    ChapterNames(8)="Queen Bitch"
    ChapterNames(9)="Duke Nukem's Titty City"
    ChapterNames(10)="Crash Course"
    ChapterNames(11)="The Duke Burger"
    ChapterNames(12)="The Mighty Foot"
    ChapterNames(13)="Ghost Town"
    ChapterNames(14)="Highway Battle"
    ChapterNames(15)="Dam Top"
    ChapterNames(16)="The Shrunk Machine"
    ChapterNames(17)="The Forkstop"
    ChapterNames(18)="Generator Room"
    ChapterNames(19)="Underground"
    ChapterNames(20)="The Clarifier"
    ChapterNames(21)="Blowin' the Dam"
    ChapterNames(22)="Final Battle"
    ChapterNames(23)="Press Conference"
    Chapters(0)=(URL="map00",SShotPaackage="dt_mapshots.sp.",Awards=(21,0,23),IsDLC=false)
    Chapters(1)=(URL="map01",SShotPaackage="dt_mapshots.sp.",Awards=(21,0,26,22),IsDLC=false)
    Chapters(2)=(URL="map02",SShotPaackage="dt_mapshots.sp.",Awards=(21,10,4,9,19,18,24),IsDLC=false)
    Chapters(3)=(URL="map03",SShotPaackage="dt_mapshots.sp.",Awards=none,IsDLC=false)
    Chapters(4)=(URL="map04",SShotPaackage="dt_mapshots.sp.",Awards=(2),IsDLC=false)
    Chapters(5)=(URL="map05",SShotPaackage="dt_mapshots.sp.",Awards=(27),IsDLC=false)
    Chapters(6)=(URL="map06",SShotPaackage="dt_mapshots.sp.",Awards=(7),IsDLC=false)
    Chapters(7)=(URL="map07",SShotPaackage="dt_mapshots.sp.",Awards=(20),IsDLC=false)
    Chapters(8)=(URL="map08",SShotPaackage="dt_mapshots.sp.",Awards=(10,4,18,20,28),IsDLC=false)
    Chapters(9)=(URL="map09",SShotPaackage="dt_mapshots.sp.",Awards=(21,22,9,1,2,0,7,23,24,5,29,8,30,31),IsDLC=false)
    Chapters(10)=(URL="map10",SShotPaackage="dt_mapshots.sp.",Awards=(13),IsDLC=false)
    Chapters(11)=(URL="map11",SShotPaackage="dt_mapshots.sp.",Awards=(0,21,17,14,24),IsDLC=false)
    Chapters(12)=(URL="map12",SShotPaackage="dt_mapshots.sp.",Awards=(25,13,6),IsDLC=false)
    Chapters(13)=(URL="map13",SShotPaackage="dt_mapshots.sp.",Awards=(16),IsDLC=false)
    Chapters(14)=(URL="map14",SShotPaackage="dt_mapshots.sp.",Awards=none,IsDLC=false)
    Chapters(15)=(URL="map15",SShotPaackage="dt_mapshots.sp.",Awards=(12,32),IsDLC=false)
    Chapters(16)=(URL="map16",SShotPaackage="dt_mapshots.sp.",Awards=(12,11),IsDLC=false)
    Chapters(17)=(URL="map17",SShotPaackage="dt_mapshots.sp.",Awards=(15,11),IsDLC=false)
    Chapters(18)=(URL="map18",SShotPaackage="dt_mapshots.sp.",Awards=(0,21,33),IsDLC=false)
    Chapters(19)=(URL="map19",SShotPaackage="dt_mapshots.sp.",Awards=(20,12,16,25),IsDLC=false)
    Chapters(20)=(URL="map20",SShotPaackage="dt_mapshots.sp.",Awards=(14,17),IsDLC=false)
    Chapters(21)=(URL="map21",SShotPaackage="dt_mapshots.sp.",Awards=(15,12,34),IsDLC=false)
    Chapters(22)=(URL="map22",SShotPaackage="dt_mapshots.sp.",Awards=none,IsDLC=false)
    Chapters(23)=(URL="map23",SShotPaackage="dt_mapshots.sp.",Awards=none,IsDLC=false)
    DifficultyIcons[0]='Menu.Menu.ChapterComplete_Easy'
    DifficultyIcons[1]='Menu.Menu.ChapterComplete_Normal'
    DifficultyIcons[2]='Menu.Menu.ChapterComplete_Hard'
    DifficultyIcons[3]='Menu.Menu.ChapterComplete_Expert'
    LockedAlpha=0.2
    TitleText="<?int?dnWindow.UDukeSceneChapterSelect.TitleText?>"
    bFadeAll=true
}