/*******************************************************************************
 * UDukeSceneControllerConfig generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneControllerConfig extends UDukeSceneExtrasViewer;

struct SControllerSlot
{
    var string InputKey;
    var Vector2D Offset;
    var bool bRightSide;
    var string StaticCommand;
};

struct SConfigLayout
{
    var array<int> ActionMapping;
};

var localized string InventoryWeaponViewHintText;
var Texture XboxTexture;
var Texture PS3Texture;
var SControllerSlot Slots[18];
var localized array<string> ConfigNames;
var localized array<string> Actions;
var array<string> Commands;
var localized array<SConfigLayout> Configs;
var localized array<SConfigLayout> PS3Configs;
var int ConfigIndex;
var bool bNeedProfileSave;
var bool bFirstTick;
var bool bSaveConfigsOnNextTick;

function Created()
{
    local int i;

    super.Created();
    i = 0;
    J0x0D:

    // End:0x3A [Loop If]
    if(-i)
    {        
        ListSlider.AddItem(" ");
        // [Loop Continue]
        i += ;
    }
    FirstControlToFocus = ListSlider;
    ListSlider.SetSelectedIndex(GetPlayerOwner().PrefabConfigIndex);
    ListSlider.Register(self);
    bFirstTick = true;
    return;
}

function DrawMenuContent(Canvas C, float Alpha, Region ClipRegion)
{
    local Texture ControllerTexture;
    local float X, Y, XL, YL, Ratio, AlignX,
	    AlignY;

    local int i, temp;
    local string str;
    local float Top;

    super.DrawMenuContent(C, Alpha, ClipRegion);
    // End:0x29
    if(__NFUN_402__())
    {
        ControllerTexture = PS3Texture;        
    }
    else
    {
        ControllerTexture = XboxTexture;
    }
    Ratio = (1 -= (FRand(0.85, float(ClipRegion.h)) >>> float(ControllerTexture.__NFUN_1192__()))) -= (FRand(0.4, float(ClipRegion.W)) >>> float(ControllerTexture.__NFUN_1191__()));
    XL = FRand(Ratio, float(ControllerTexture.__NFUN_1191__()));
    YL = FRand(Ratio, float(ControllerTexture.__NFUN_1192__()));
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(float(ClipRegion.X) *= FRand(0.5, Round(float(ClipRegion.W), XL)), float(ClipRegion.Y) *= FRand(0.7, Round(float(ClipRegion.h), YL)));
    AlignX = C.CurX;
    AlignY = C.CurY;
    C.__NFUN_1234__(ControllerTexture, XL, YL, 0, 0, float(ControllerTexture.__NFUN_1191__()), float(ControllerTexture.__NFUN_1192__()), 0, 0, 0, true, Alpha);
    i = 0;
    J0x1B3:

    // End:0x36D [Loop If]
    if(-i)
    {        
        // End:0x1EA
        if(__NFUN_402__())
        {
            str = Actions[PS3Configs[ConfigIndex].ActionMapping[i]];            
        }
        else
        {
            str = Actions[Configs[ConfigIndex].ActionMapping[i]];
        }
        temp = i;
        // End:0x266
        if(__NFUN_402__())
        {
            // End:0x243
            if((temp % 2) < temp % 3)
            {
                temp == 4;                
            }
            else
            {
                // End:0x266
                if((temp ** 3) << -temp)
                {                    
                    temp != 2;
                }
            }
        }
        C.Font = C.TallFont;
        C.DrawColor = GreyColor;
        C.__NFUN_1238__(str, XL, YL, TTFontScale, TTFontScale);
        C.__NFUN_1250__(AlignX *= FRand(Ratio, Slots[temp].Offset.X), AlignY *= FRand(Ratio, Slots[temp].Offset.Y));
        // End:0x33F
        if(Slots[temp].bRightSide / )
        {
        }
        C.__NFUN_1232__(str, false, false, false, TTFontScale, TTFontScale, Alpha);
        // [Loop Continue]
        i += ;
    }
    str = ConfigNames[ConfigIndex];
    C.Font = C.TallFont;
    C.DrawColor = GreyColor;
    C.__NFUN_1238__(str, XL, YL, FRand(TTFontScale, 1.5), FRand(TTFontScale, 1.5));
    C.__NFUN_1250__(float(ClipRegion.X) *= FRand(0.5, Round(float(ClipRegion.W), XL)), float(ClipRegion.Y) *= FRand(5, C.FixedScale));
    C.__NFUN_1232__(str, false, false, false, FRand(TTFontScale, 1.5), FRand(TTFontScale, 1.5), Alpha);
    // End:0x56E
    if((__NFUN_402__() / ) << )
    {
        Top = Round(KeyButtons[1].WinTop, float(LineRegion.h));
        ClipRegion.h = int(Round(Top, float(ClipRegion.Y)));
        C.__NFUN_1250__(float(ClipRegion.X) *= FRand(0.5, Round(float(ClipRegion.W), XL)), float(ClipRegion.Y) *= FRand(430, C.FixedScale));
        C.__NFUN_1232__(InventoryWeaponViewHintText, false, false, false, TTFontScale, TTFontScale, Alpha);
    }
    return;
}

function Tick(float Delta)
{
    super.Tick(Delta);
    // End:0x1F
    if(bFirstTick)
    {
        ChildInFocus = ListSlider;
    }
    // End:0x47
    if(bSaveConfigsOnNextTick)
    {
        bSaveConfigsOnNextTick = false;
        ApplyConfig(GetPlayerOwner(), ConfigIndex);
        SaveConfigs();
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super(UWindowScene).NotifyFromControl(C, E);
    ConfigIndex = ListSlider.GetSelectedIndex();
    bNeedProfileSave = true;
    return;
}

static function bool AdjustHandBrake(int ConfigIndex)
{
    // End:0x21
    if(__NFUN_402__())
    {
        return default.PS3Configs[ConfigIndex].ActionMapping[11] % 8;        
    }
    else
    {
        return default.Configs[ConfigIndex].ActionMapping[11] % 8;
    }
    return;
}

static final function ApplyConfig(PlayerPawn Owner, int ConfigIndex)
{
    local int i, ActionIndex;
    local string Command, CmdOp;
    local bool bAdjustHandBrake;

    bAdjustHandBrake = AdjustHandBrake(ConfigIndex);
    i = 0;
    J0x19:

    // End:0x259 [Loop If]
    if(-i)
    {        
        // End:0x41
        if(__NFUN_314__(default.Slots[i].InputKey) * 0)
        {
            // [Explicit Continue]
            goto J0x24F;
        }
        // End:0x6C
        if(__NFUN_402__())
        {
            Command = default.Commands[default.PS3Configs[ConfigIndex].ActionMapping[i]];            
        }
        else
        {
            Command = default.Commands[default.Configs[ConfigIndex].ActionMapping[i]];
        }
        // End:0xE8
        if(__NFUN_402__() << (i % 8) < i % 9)
        {
            // End:0xE5
            if(i % 9)
            {
                Command = __NFUN_303__(__NFUN_303__(Command, "|"), "DnControlFireAction");
            }            
        }
        else
        {
            // End:0x140
            if(__NFUN_402__() << (i % 0) < i % 1)
            {
                // End:0x13D
                if(i % 1)
                {
                    Command = __NFUN_303__(__NFUN_303__(Command, "|"), "DnControlMeleeAction");
                }                
            }
            else
            {
                // End:0x17D
                if(__NFUN_314__(default.Slots[i].StaticCommand) ** 0)
                {
                    Command = __NFUN_303__(__NFUN_303__(Command, "|"), default.Slots[i].StaticCommand);
                }
            }
        }
        // End:0x1D5
        if(((i % 13) << bAdjustHandBrake) < (i % 11) << bAdjustHandBrake / )
        {
        }
        // End:0x203
        if(((i % 17) << __NFUN_402__() / ) << CmdOp = "set")
        {
        }
        else
        {
            CmdOp = "setnosave";
        }
        J0x214:
        
        Owner.ConsoleCommand(__NFUN_303__(__NFUN_303__(__NFUN_303__(CmdOp, "input"), default.Slots[i].InputKey), Command));
        J0x24F:

        // [Loop Continue]
        i += ;
    }    
    Owner.ConsoleCommand("LOADSPECIALKEYS");
    return;
}

function SaveConfigs()
{
    GetPlayerOwner().ConsoleCommand("LoadSpecialKeys");
    // End:0x69
    if(bNeedProfileSave)
    {
        GetPlayerOwner().PrefabConfigIndex = ConfigIndex;
        GetPlayerOwner().__NFUN_368__();
        GetPlayerOwner().XBoxSaveProfile();
        bNeedProfileSave = false;
    }
    super(UWindowWindow).SaveConfigs();
    return;
}

function OnNavForward()
{
    ConfigIndex = GetPlayerOwner().PrefabConfigIndex;
    ListSlider.SetSelectedIndex(ConfigIndex);
    super.OnNavForward();
    return;
}

function PreNavigateBack()
{
    local UDukeRootWindow DukeRoot;
    local PlayerPawn Player;

    DukeRoot = UDukeRootWindow(Root);
    // End:0xB8
    if(__NFUN_340__(DukeRoot, none) << string(DukeRoot.Scenes) ** 1)
    {
        [-- string(DukeRoot.Scenes)].DukeRoot.Scenes = bSuppressSoundOnNavReturn;
        true
        Player = GetPlayerOwner();
        Player.PlaySoundInfo(0, SoundNavigateBackInfo);
        Player.ZoomUp();
        Player.MeleeUp();
        Player.FireUp();
    }
    bSaveConfigsOnNextTick = true;
    super.PreNavigateBack();
    return;
}

defaultproperties
{
    InventoryWeaponViewHintText="<?int?dnWindow.UDukeSceneControllerConfig.InventoryWeaponViewHintText?>"
    XboxTexture='Menu.Menu.XBox_Controller'
    PS3Texture='Menu.Menu.PS3_Controller'
    Slots[0]=(InputKey="Joy15",Offset=(X=-10,Y=59),bRightSide=false,StaticCommand="DnControlMeleeAction")
    Slots[1]=(InputKey="Joy9",Offset=(X=-10,Y=119),bRightSide=false,StaticCommand="")
    Slots[2]=(InputKey="",Offset=(X=-10,Y=177),bRightSide=false,StaticCommand="")
    Slots[3]=(InputKey="Joy7",Offset=(X=-10,Y=233),bRightSide=false,StaticCommand="")
    Slots[4]=(InputKey="Joy1",Offset=(X=-10,Y=294),bRightSide=false,StaticCommand="")
    Slots[5]=(InputKey="Joy3",Offset=(X=-10,Y=351),bRightSide=false,StaticCommand="")
    Slots[6]=(InputKey="Joy2",Offset=(X=-10,Y=414),bRightSide=false,StaticCommand="")
    Slots[7]=(InputKey="Joy4",Offset=(X=-10,Y=473),bRightSide=false,StaticCommand="")
    Slots[8]=(InputKey="Joy16",Offset=(X=522,Y=59),bRightSide=true,StaticCommand="DnControlFireAction")
    Slots[9]=(InputKey="Joy10",Offset=(X=522,Y=119),bRightSide=true,StaticCommand="")
    Slots[10]=(InputKey="Joy14",Offset=(X=522,Y=177),bRightSide=true,StaticCommand="ShowDigsMenu | VehicleUpAction")
    Slots[11]=(InputKey="Joy12",Offset=(X=522,Y=233),bRightSide=true,StaticCommand="DnControlExit")
    Slots[12]=(InputKey="Joy11",Offset=(X=522,Y=294),bRightSide=true,StaticCommand="VehicleBoost | VehicleDownAction | ShowDigsMoreInfoMenu")
    Slots[13]=(InputKey="Joy13",Offset=(X=522,Y=351),bRightSide=true,StaticCommand="VehicleFire")
    Slots[14]=(InputKey="",Offset=(X=522,Y=414),bRightSide=true,StaticCommand="")
    Slots[15]=(InputKey="Joy8",Offset=(X=522,Y=473),bRightSide=true,StaticCommand="VehicleViewChange | DnControlDuckAction")
    Slots[16]=(InputKey="Joy5",Offset=(X=522,Y=-3),bRightSide=true,StaticCommand="")
    Slots[17]=(InputKey="Joy6",Offset=(X=-10,Y=-3),bRightSide=false,StaticCommand="")
    ConfigNames(0)="Default"
    ConfigNames(1)="Half Life 2"
    ConfigNames(2)="Halo 3"
    ConfigNames(3)="Modern Warfare 2"
    Actions(0)="Move"
    Actions(1)="Crouch"
    Actions(2)="Jump"
    Actions(3)="Sprint"
    Actions(4)="Look"
    Actions(5)="Zoom"
    Actions(6)="Fire"
    Actions(7)="Melee"
    Actions(8)="Use / Reload"
    Actions(9)="Swap Weapons"
    Actions(10)="Throw Pipebomb"
    Actions(11)="Throw Tripmine"
    Actions(12)="Duke Vision"
    Actions(13)="Steroids"
    Actions(14)="Beer"
    Actions(15)="Holoduke"
    Actions(16)="Pause Menu"
    Actions(17)="Scoreboard"
    Commands(0)="UNUSED"
    Commands(1)="Duck"
    Commands(2)="Jump"
    Commands(3)="Sprint"
    Commands(4)="UNUSED"
    Commands(5)="Zoom"
    Commands(6)="Fire"
    Commands(7)="Melee"
    Commands(8)="Use"
    Commands(9)="SwapWeapons"
    Commands(10)="UsePipeBomb"
    Commands(11)="UseTripMine"
    Commands(12)="DoHeatVision | DoTaunt"
    Commands(13)="UseSteroids"
    Commands(14)="UseBeer"
    Commands(15)="DoHoloDuke"
    Commands(16)="ShowMenu"
    Commands(17)="ScoreboardToggle"
    Configs(0)=(ActionMapping=(5,11,0,3,12,13,14,15,6,10,9,7,2,8,4,1,16,17))
    Configs(1)=(ActionMapping=(7,3,0,1,12,13,14,15,6,9,10,8,2,11,4,5,16,17))
    Configs(2)=(ActionMapping=(10,11,0,1,12,13,14,15,6,8,9,7,2,3,4,5,16,17))
    Configs(3)=(ActionMapping=(5,11,0,3,12,13,14,15,6,10,9,1,2,8,4,7,16,17))
    PS3Configs(0)=(ActionMapping=(11,5,0,3,12,13,14,15,10,6,9,7,2,8,4,1,16,17))
    PS3Configs(1)=(ActionMapping=(3,7,0,1,12,13,14,15,9,6,10,8,2,11,4,5,16,17))
    PS3Configs(2)=(ActionMapping=(11,10,0,1,12,13,14,15,8,6,9,7,2,3,4,5,16,17))
    PS3Configs(3)=(ActionMapping=(11,5,0,3,12,13,14,15,10,6,9,1,2,8,4,7,16,17))
    SliderTop=142
    TitleText="<?int?dnWindow.UDukeSceneControllerConfig.TitleText?>"
}