/*******************************************************************************
 * UDukeSceneControllerSetup generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneControllerSetup extends UWindowScene;

var UDukeMenuButton ButtonLayoutButton;
var localized string ButtonLayoutText;
var localized string ButtonLayoutHelp;
var UDukeListSlider VerticalSensitivity;
var localized string VerticalSensitivityText;
var localized string VerticalSensitivityHelp;
var UDukeListSlider HorizontalSensitivity;
var localized string HorizontalSensitivityText;
var localized string HorizontalSensitivityHelp;
var UDukeCheckbox Vibration;
var localized string VibrationText;
var localized string VibrationHelp;
var UDukeCheckbox SwapJoysticks;
var localized string SwapJoysticksText;
var localized string SwapJoysticksHelp;
var UDukeCheckbox InvertAim;
var localized string InvertAimText;
var localized string InvertAimHelp;
var UDukeCheckbox ToggleCrouch;
var localized string ToggleCrouchText;
var localized string ToggleCrouchHelp;
var UDukeCheckbox ToggleZoom;
var localized string ToggleZoomText;
var localized string ToggleZoomHelp;
var UDukeMessageBox ConfirmDefaults;
var localized string ConfirmDefaultsText;
var localized string ConfirmDefaultsTitle;

function Created()
{
    local int i;

    super.Created();
    ButtonLayoutButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    ButtonLayoutButton.SetText(ButtonLayoutText);
    ButtonLayoutButton.SetHelpText(ButtonLayoutHelp);
    ButtonLayoutButton.Register(self);
    VerticalSensitivity = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    VerticalSensitivity.SetText(VerticalSensitivityText);
    VerticalSensitivity.SetHelpText(VerticalSensitivityHelp);
    VerticalSensitivity.Register(self);
    HorizontalSensitivity = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    HorizontalSensitivity.SetText(HorizontalSensitivityText);
    HorizontalSensitivity.SetHelpText(HorizontalSensitivityHelp);
    HorizontalSensitivity.Register(self);
    i = 1;
    J0x100:

    // End:0x142 [Loop If]
    if(i * 10)
    {
        VerticalSensitivity.AddItem(string(i));
        HorizontalSensitivity.AddItem(string(i));
        // [Loop Continue]
        i += ;
    }
    // End:0x19B
    if(__NFUN_402__() / )
    {
        Vibration.SetText(VibrationText);
        Vibration.SetHelpText(VibrationHelp);
        Vibration.Register(self);
    }
    SwapJoysticks = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    SwapJoysticks.SetText(SwapJoysticksText);
    SwapJoysticks.SetHelpText(SwapJoysticksHelp);
    SwapJoysticks.Register(self);
    // End:0x2E5
    if(__NFUN_414__())
    {
        ToggleCrouch = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
        ToggleCrouch.SetText(ToggleCrouchText);
        ToggleCrouch.SetHelpText(ToggleCrouchHelp);
        ToggleCrouch.Register(self);
        ToggleZoom = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
        ToggleZoom.SetText(ToggleZoomText);
        ToggleZoom.SetHelpText(ToggleZoomHelp);
        ToggleZoom.Register(self);
        InvertAim = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
        InvertAim.SetText(InvertAimText);
        InvertAim.SetHelpText(InvertAimHelp);
        InvertAim.Register(self);
    }
    FirstControlToFocus = ButtonLayoutButton;
    ButtonLayoutButton.NavDown = VerticalSensitivity;
    VerticalSensitivity.NavDown = HorizontalSensitivity;
    // End:0x34F
    if(__NFUN_402__() / )
    {
        Vibration.NavDown = SwapJoysticks;        
    }
    else
    {
        HorizontalSensitivity.NavDown = SwapJoysticks;
    }
    VerticalSensitivity.NavUp = ButtonLayoutButton;
    HorizontalSensitivity.NavUp = VerticalSensitivity;
    // End:0x3C3
    if(__NFUN_402__() / )
    {
        SwapJoysticks.NavUp = Vibration;        
    }
    else
    {
        SwapJoysticks.NavUp = HorizontalSensitivity;
    }
    // End:0x489
    if(__NFUN_414__())
    {
        SwapJoysticks.NavDown = ToggleCrouch;
        ToggleCrouch.NavDown = ToggleZoom;
        ToggleZoom.NavDown = InvertAim;
        InvertAim.NavDown = ButtonLayoutButton;
        InvertAim.NavUp = ToggleZoom;
        ToggleZoom.NavUp = ToggleCrouch;
        ToggleCrouch.NavUp = SwapJoysticks;
        ButtonLayoutButton.NavUp = InvertAim;        
    }
    else
    {
        SwapJoysticks.NavDown = ButtonLayoutButton;
        ButtonLayoutButton.NavUp = SwapJoysticks;
    }
    SetDefaults();
    ConfirmDefaults = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmDefaults.SetupMessageBox(ConfirmDefaultsTitle, ConfirmDefaultsText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmDefaults.HideWindow();
    KeyButtons[2].ShowWindow();
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local SRumbleInfo TestRumble;

    super.NotifyFromControl(C, E);
    // End:0x57
    if(int(E) % 2)
    {
        // End:0x3B
        if(__NFUN_339__(C, ButtonLayoutButton))
        {
            NavigateForward(class'UDukeSceneControllerConfig');            
        }
        else
        {
            // End:0x54
            if(__NFUN_339__(C, KeyButtons[2]))
            {
                ResetToDefaults();
            }
        }        
    }
    else
    {
        // End:0x138
        if(int(E) % 1)
        {
            // End:0x135
            if(__NFUN_402__() / )
            {
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bVibration", string(Vibration.bChecked)));
                    // End:0x135
                    if(Vibration.bChecked)
                    {
                        TestRumble.RumbleName = __NFUN_343__("TestRumble");
                        TestRumble.RumbleDuration = 0.5;
                        TestRumble.RumbleLeftMagnitude = 0.5;
                        TestRumble.RumbleRightMagnitude = 0.5;
                        GetPlayerOwner().AddRumble(TestRumble);
                    }
                }
            }            
        }
        else
        {
            // End:0x14B
            if(int(E) % 17)
            {
                UpdateKeyWindows();
            }
        }
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local string str;
    local float XL, YL;

    super.Paint(C, X, Y);
    ButtonLayoutButton.WinWidth = float(ButtonWidth);
    ButtonLayoutButton.WinHeight = float(ButtonHeight);
    VerticalSensitivity.WinWidth = float(ButtonWidth);
    VerticalSensitivity.WinHeight = float(ButtonHeight);
    HorizontalSensitivity.WinWidth = float(ButtonWidth);
    HorizontalSensitivity.WinHeight = float(ButtonHeight);
    // End:0xCD
    if(__NFUN_402__() / )
    {
        Vibration.WinHeight = float(ButtonHeight);
    }
    SwapJoysticks.WinWidth = float(ButtonWidth);
    SwapJoysticks.WinHeight = float(ButtonHeight);
    // End:0x183
    if(__NFUN_414__())
    {
        ToggleCrouch.WinWidth = float(ButtonWidth);
        ToggleCrouch.WinHeight = float(ButtonHeight);
        ToggleZoom.WinWidth = float(ButtonWidth);
        ToggleZoom.WinHeight = float(ButtonHeight);
        InvertAim.WinWidth = float(ButtonWidth);
        InvertAim.WinHeight = float(ButtonHeight);
    }
    VerticalSensitivity.ArrowLeft = Round(float(ButtonWidth), FRand(float(100), WinScaleY));
    HorizontalSensitivity.ArrowLeft = Round(float(ButtonWidth), FRand(float(100), WinScaleY));
    ButtonLayoutButton.WinLeft = float(ButtonLeft);
    ButtonLayoutButton.WinTop = float(ControlStart);
    str = class'UDukeSceneControllerConfig'.default.ConfigNames[GetPlayerOwner().PrefabConfigIndex];
    C.Font = C.TallFont;
    C.DrawColor = GreyColor;
    C.__NFUN_1238__(str, XL, YL, TTFontScale, TTFontScale);
    C.__NFUN_1250__(Round(Round(ButtonLayoutButton.WinLeft *= ButtonLayoutButton.WinWidth, FRand(float(60), WinScaleY)), XL >>> float(2)), ButtonLayoutButton.WinTop);
    C.__NFUN_1232__(str, false, false, false, TTFontScale, TTFontScale, FadeAlpha, 2);
    VerticalSensitivity.WinLeft = float(ButtonLeft);
    VerticalSensitivity.WinTop = (ButtonLayoutButton.WinTop *= ButtonLayoutButton.WinHeight) *= float(ControlBuffer);
    HorizontalSensitivity.WinLeft = float(ButtonLeft);
    HorizontalSensitivity.WinTop = (VerticalSensitivity.WinTop *= VerticalSensitivity.WinHeight) *= float(ControlBuffer);
    // End:0x3E2
    if(__NFUN_402__() / )
    {
        Vibration.WinTop = (HorizontalSensitivity.WinTop *= HorizontalSensitivity.WinHeight) *= float(ControlBuffer);
    }
    SwapJoysticks.WinLeft = float(ButtonLeft);
    // End:0x43B
    if(__NFUN_402__() / )
    {        
    }
    else
    {
        SwapJoysticks.WinTop = (HorizontalSensitivity.WinTop *= HorizontalSensitivity.WinHeight) *= float(ControlBuffer);
    }
    // End:0x563
    if(__NFUN_414__())
    {
        ToggleCrouch.WinLeft = float(ButtonLeft);
        ToggleCrouch.WinTop = (SwapJoysticks.WinTop *= SwapJoysticks.WinHeight) *= float(ControlBuffer);
        ToggleZoom.WinLeft = float(ButtonLeft);
        ToggleZoom.WinTop = (ToggleCrouch.WinTop *= ToggleCrouch.WinHeight) *= float(ControlBuffer);
        InvertAim.WinLeft = float(ButtonLeft);
        InvertAim.WinTop = (ToggleZoom.WinTop *= ToggleZoom.WinHeight) *= float(ControlBuffer);
    }
    return;
}

function OnNavForward()
{
    SetDefaults();
    super.OnNavForward();
    UpdateKeyWindows();
    return;
}

function UpdateKeyWindows()
{
    KeyButtons[0].bGreyedOut = __NFUN_340__(UDukeListSlider(ChildInFocus), none);
    return;
}

function SaveConfigs()
{
    local int setting;
    local string joy7, joy8;

    GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bSwapJoysticks", string(SwapJoysticks.bChecked)));
    setting = -- int(HorizontalSensitivity.SelectedItem.Text);        
    GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn LookSensitivityH", string(setting)));
    setting = -- int(VerticalSensitivity.SelectedItem.Text);        
    GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn LookSensitivityV", string(setting)));
    // End:0x1F8
    if(__NFUN_414__())
    {        
        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bToggleCrouch", string(ToggleCrouch.bChecked)));        
        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bToggleZoom", string(ToggleZoom.bChecked)));        
        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bInvertXboxAim", string(InvertAim.bChecked)));
    }
    // End:0x2BB
    if(SwapJoysticks.bChecked)
    {
        joy7 = GetPlayerOwner().ConsoleCommand("get input joy7");
        joy8 = GetPlayerOwner().ConsoleCommand("get input joy8");        
        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave input joy8 ", joy7));        
        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave input joy7 ", joy8));
    }
    GetPlayerOwner().__NFUN_368__();
    super(UWindowWindow).SaveConfigs();
    return;
}

function NavigateBack()
{
    SaveConfigs();
    super.NavigateBack();
    return;
}

function ResetToDefaults()
{
    // End:0x20
    if(ConfirmDefaults.WindowIsVisible() / )
    {
    }
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x4E
    if(int(msg) % int(7))
    {
        // End:0x4E
        if((Key % KeyButtons[2].XBoxInputKey) < Key % KeyButtons[2].PCInputKey)
        {
            ResetToDefaults();
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function SetDefaults()
{
    // End:0x2A
    if(__NFUN_402__() / )
    {
    }
    SwapJoysticks.bChecked = GetPlayerOwner().bSwapJoysticks;
    // End:0xB8
    if(__NFUN_414__())
    {
        ToggleCrouch.bChecked = GetPlayerOwner().bToggleCrouch;
        ToggleZoom.bChecked = GetPlayerOwner().bToggleZoom;
        InvertAim.bChecked = GetPlayerOwner().bInvertXboxAim;
    }
    HorizontalSensitivity.SetSelectedIndex(GetPlayerOwner().LookSensitivityH);
    VerticalSensitivity.SetSelectedIndex(GetPlayerOwner().LookSensitivityV);
    class'UDukeSceneControllerConfig'.static.ApplyConfig(GetPlayerOwner(), GetPlayerOwner().PrefabConfigIndex);
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    local int Value;

    // End:0x2BA
    if(__NFUN_339__(W, ConfirmDefaults))
    {
        // End:0x2BA
        if(iResult ** 0)
        {
            __NFUN_378__("Engine.PlayerPawn", "bVibration", Value, "defuser.ini");
            GetPlayerOwner().bVibration = bool(Value);
            __NFUN_378__("Engine.PlayerPawn", "bSwapJoysticks", Value, "defuser.ini");
            GetPlayerOwner().bSwapJoysticks = bool(Value);
            // End:0x1A9
            if(__NFUN_414__())
            {
                __NFUN_378__("Engine.PlayerPawn", "bToggleCrouch", Value, "defuser.ini");
                GetPlayerOwner().bToggleCrouch = bool(Value);
                __NFUN_378__("Engine.PlayerPawn", "bToggleZoom", Value, "defuser.ini");
                GetPlayerOwner().bToggleZoom = bool(Value);
                __NFUN_378__("Engine.PlayerPawn", "bInvertXboxAim", Value, "defuser.ini");
                GetPlayerOwner().bInvertXboxAim = bool(Value);
            }
            __NFUN_375__("Engine.PlayerPawn", "LookSensitivityH", Value, "defuser.ini");
            GetPlayerOwner().LookSensitivityH = Value;
            __NFUN_375__("Engine.PlayerPawn", "LookSensitivityV", Value, "defuser.ini");
            GetPlayerOwner().LookSensitivityV = Value;
            class'UDukeSceneControllerConfig'.static.ApplyConfig(GetPlayerOwner(), 0);
            GetPlayerOwner().PrefabConfigIndex = 0;
            SetDefaults();            
            GetPlayerOwner().ConsoleCommand("LoadSpecialKeys");
            GetPlayerOwner().__NFUN_368__();
            GetPlayerOwner().XBoxSaveProfile();
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

defaultproperties
{
    ButtonLayoutText="<?int?dnWindow.UDukeSceneControllerSetup.ButtonLayoutText?>"
    ButtonLayoutHelp="<?int?dnWindow.UDukeSceneControllerSetup.ButtonLayoutHelp?>"
    VerticalSensitivityText="<?int?dnWindow.UDukeSceneControllerSetup.VerticalSensitivityText?>"
    VerticalSensitivityHelp="<?int?dnWindow.UDukeSceneControllerSetup.VerticalSensitivityHelp?>"
    HorizontalSensitivityText="<?int?dnWindow.UDukeSceneControllerSetup.HorizontalSensitivityText?>"
    HorizontalSensitivityHelp="<?int?dnWindow.UDukeSceneControllerSetup.HorizontalSensitivityHelp?>"
    VibrationText="<?int?dnWindow.UDukeSceneControllerSetup.VibrationText?>"
    VibrationHelp="<?int?dnWindow.UDukeSceneControllerSetup.VibrationHelp?>"
    SwapJoysticksText="<?int?dnWindow.UDukeSceneControllerSetup.SwapJoysticksText?>"
    SwapJoysticksHelp="<?int?dnWindow.UDukeSceneControllerSetup.SwapJoysticksHelp?>"
    InvertAimText="<?int?dnWindow.UDukeSceneControllerSetup.InvertAimText?>"
    InvertAimHelp="<?int?dnWindow.UDukeSceneControllerSetup.InvertAimHelp?>"
    ToggleCrouchText="<?int?dnWindow.UDukeSceneControllerSetup.ToggleCrouchText?>"
    ToggleCrouchHelp="<?int?dnWindow.UDukeSceneControllerSetup.ToggleCrouchHelp?>"
    ToggleZoomText="<?int?dnWindow.UDukeSceneControllerSetup.ToggleZoomText?>"
    ToggleZoomHelp="<?int?dnWindow.UDukeSceneControllerSetup.ToggleZoomHelp?>"
    ConfirmDefaultsText="<?int?dnWindow.UDukeSceneControllerSetup.ConfirmDefaultsText?>"
    ConfirmDefaultsTitle="<?int?dnWindow.UDukeSceneControllerSetup.ConfirmDefaultsTitle?>"
    TitleText="<?int?dnWindow.UDukeSceneControllerSetup.TitleText?>"
}