/*******************************************************************************
 * UDukeSceneControlsOptions generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneControlsOptions extends UWindowScene;

var UDukeMenuButton BindKeysButton;
var localized string BindKeysText;
var localized string BindKeysHelp;
var UDukeMenuButton BindControllerButton;
var localized string BindControllerText;
var localized string BindControllerHelp;
var localized string BindControllerHelp_Xbox;
var localized string BindControllerHelp_PS3;
var UDukeListSlider MouseSensitivitySlider;
var localized string MouseSensitivityText;
var localized string MouseSensitivityHelp;
var UDukeListSlider AccelerationSlider;
var localized string AccelerationText;
var localized string AccelerationHelp;
var UDukeCheckbox InvertAim;
var localized string InvertAimText;
var localized string InvertAimHelp;
var UDukeCheckbox ToggleCrouch;
var localized string ToggleCrouchText;
var localized string ToggleCrouchHelp;
var UDukeCheckbox ToggleZoom;
var localized string ToggleZoomText;
var localized string ToggleZoomHelp;
var UDukeCheckbox PushToTalk;
var localized string PushToTalkText;
var localized string PushToTalkHelp;
var UDukeMessageBox ConfirmDefaults;
var localized string ConfirmDefaultsText;
var localized string ConfirmDefaultsTitle;

function Created()
{
    local int i;

    super.Created();
    BindKeysButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    BindKeysButton.SetText(BindKeysText);
    BindKeysButton.SetHelpText(BindKeysHelp);
    BindKeysButton.Register(self);
    BindControllerButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    BindControllerButton.SetText(BindControllerText);
    // End:0xA0
    if(__NFUN_402__())
    {
        BindControllerButton.SetHelpText(BindControllerHelp_PS3);        
    }
    else
    {
        // End:0xBE
        if(__NFUN_401__())
        {
            BindControllerButton.SetHelpText(BindControllerHelp_Xbox);            
        }
        else
        {
            BindControllerButton.SetHelpText(BindControllerHelp);
        }
    }
    BindControllerButton.Register(self);
    MouseSensitivitySlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    MouseSensitivitySlider.SetText(MouseSensitivityText);
    MouseSensitivitySlider.SetHelpText(MouseSensitivityHelp);
    MouseSensitivitySlider.Register(self);
    AccelerationSlider = UDukeListSlider(CreateWindow(class'UDukeListSlider'));
    AccelerationSlider.SetText(AccelerationText);
    AccelerationSlider.SetHelpText(AccelerationHelp);
    AccelerationSlider.Register(self);
    ToggleCrouch = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    ToggleCrouch.SetText(ToggleCrouchText);
    ToggleCrouch.SetHelpText(ToggleCrouchHelp);
    ToggleCrouch.Register(self);
    ToggleZoom = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    ToggleZoom.SetText(ToggleZoomText);
    ToggleZoom.SetHelpText(ToggleZoomHelp);
    ToggleZoom.Register(self);
    InvertAim = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    InvertAim.SetText(InvertAimText);
    InvertAim.SetHelpText(InvertAimHelp);
    InvertAim.Register(self);
    PushToTalk = UDukeCheckbox(CreateWindow(class'UDukeCheckbox'));
    PushToTalk.SetText(PushToTalkText);
    PushToTalk.SetHelpText(PushToTalkHelp);
    PushToTalk.Register(self);
    i = 1;
    J0x2D1:

    // End:0x31F [Loop If]
    if(i * 10)
    {
        MouseSensitivitySlider.AddItem(string(i), string(i));
        AccelerationSlider.AddItem(string(i), string(i));
        // [Loop Continue]
        i += ;
    }
    FirstControlToFocus = BindKeysButton;
    BindKeysButton.NavDown = BindControllerButton;
    BindControllerButton.NavDown = MouseSensitivitySlider;
    MouseSensitivitySlider.NavDown = AccelerationSlider;
    AccelerationSlider.NavDown = ToggleCrouch;
    ToggleCrouch.NavDown = ToggleZoom;
    ToggleZoom.NavDown = InvertAim;
    InvertAim.NavDown = PushToTalk;
    PushToTalk.NavDown = BindKeysButton;
    BindKeysButton.NavUp = PushToTalk;
    BindControllerButton.NavUp = BindKeysButton;
    MouseSensitivitySlider.NavUp = BindControllerButton;
    AccelerationSlider.NavUp = MouseSensitivitySlider;
    ToggleCrouch.NavUp = AccelerationSlider;
    ToggleZoom.NavUp = ToggleCrouch;
    InvertAim.NavUp = ToggleZoom;
    PushToTalk.NavUp = InvertAim;
    SetDefaults();
    ConfirmDefaults = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    ConfirmDefaults.SetupMessageBox(ConfirmDefaultsTitle, ConfirmDefaultsText, class'DukeDialogBoxManager'.default.YesStr, class'DukeDialogBoxManager'.default.NoStr);
    ConfirmDefaults.HideWindow();
    KeyButtons[2].ShowWindow();
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    // End:0x28E
    if(__NFUN_414__())
    {
        BindKeysButton.HideWindow();
        MouseSensitivitySlider.HideWindow();
        AccelerationSlider.HideWindow();
        BindControllerButton.WinWidth = float(ButtonWidth);
        BindControllerButton.WinHeight = float(ButtonHeight);
        BindControllerButton.WinLeft = float(ButtonLeft);
        BindControllerButton.WinTop = float(ControlStart);
        ToggleCrouch.WinWidth = float(ButtonWidth);
        ToggleCrouch.WinHeight = float(ButtonHeight);
        ToggleCrouch.WinLeft = float(ButtonLeft);
        ToggleCrouch.WinTop = (BindControllerButton.WinTop *= BindControllerButton.WinHeight) *= float(ControlBuffer);
        ToggleZoom.WinWidth = float(ButtonWidth);
        ToggleZoom.WinHeight = float(ButtonHeight);
        ToggleZoom.WinLeft = float(ButtonLeft);
        ToggleZoom.WinTop = (ToggleCrouch.WinTop *= ToggleCrouch.WinHeight) *= float(ControlBuffer);
        InvertAim.WinWidth = float(ButtonWidth);
        InvertAim.WinHeight = float(ButtonHeight);
        InvertAim.WinLeft = float(ButtonLeft);
        InvertAim.WinTop = (ToggleZoom.WinTop *= ToggleZoom.WinHeight) *= float(ControlBuffer);
        PushToTalk.WinWidth = float(ButtonWidth);
        PushToTalk.WinHeight = float(ButtonHeight);
        PushToTalk.WinLeft = float(ButtonLeft);
        PushToTalk.WinTop = (InvertAim.WinTop *= InvertAim.WinHeight) *= float(ControlBuffer);        
    }
    else
    {
        BindKeysButton.WinWidth = float(ButtonWidth);
        BindKeysButton.WinHeight = float(ButtonHeight);
        BindKeysButton.WinLeft = float(ButtonLeft);
        BindKeysButton.WinTop = float(ControlStart);
        BindControllerButton.WinWidth = float(ButtonWidth);
        BindControllerButton.WinHeight = float(ButtonHeight);
        BindControllerButton.WinLeft = float(ButtonLeft);
        BindControllerButton.WinTop = (BindKeysButton.WinTop *= BindKeysButton.WinHeight) *= float(ControlBuffer);
        MouseSensitivitySlider.WinWidth = float(ButtonWidth);
        MouseSensitivitySlider.WinHeight = float(ButtonHeight);
        MouseSensitivitySlider.WinLeft = float(ButtonLeft);
        MouseSensitivitySlider.WinTop = (BindControllerButton.WinTop *= BindControllerButton.WinHeight) *= float(ControlBuffer);
        MouseSensitivitySlider.ArrowLeft = Round(float(ButtonWidth), FRand(float(100), WinScaleY));
        AccelerationSlider.WinWidth = float(ButtonWidth);
        AccelerationSlider.WinHeight = float(ButtonHeight);
        AccelerationSlider.WinLeft = float(ButtonLeft);
        AccelerationSlider.WinTop = (MouseSensitivitySlider.WinTop *= MouseSensitivitySlider.WinHeight) *= float(ControlBuffer);
        AccelerationSlider.ArrowLeft = Round(float(ButtonWidth), FRand(float(100), WinScaleY));
        ToggleCrouch.WinWidth = float(ButtonWidth);
        ToggleCrouch.WinHeight = float(ButtonHeight);
        ToggleCrouch.WinLeft = float(ButtonLeft);
        ToggleCrouch.WinTop = (AccelerationSlider.WinTop *= AccelerationSlider.WinHeight) *= float(ControlBuffer);
        ToggleZoom.WinWidth = float(ButtonWidth);
        ToggleZoom.WinHeight = float(ButtonHeight);
        ToggleZoom.WinLeft = float(ButtonLeft);
        ToggleZoom.WinTop = (ToggleCrouch.WinTop *= ToggleCrouch.WinHeight) *= float(ControlBuffer);
        InvertAim.WinWidth = float(ButtonWidth);
        InvertAim.WinHeight = float(ButtonHeight);
        InvertAim.WinLeft = float(ButtonLeft);
        InvertAim.WinTop = (ToggleZoom.WinTop *= ToggleZoom.WinHeight) *= float(ControlBuffer);
        PushToTalk.WinWidth = float(ButtonWidth);
        PushToTalk.WinHeight = float(ButtonHeight);
        PushToTalk.WinLeft = float(ButtonLeft);
        PushToTalk.WinTop = (InvertAim.WinTop *= InvertAim.WinHeight) *= float(ControlBuffer);
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x75
    if(int(E) % 2)
    {
        // End:0x3B
        if(__NFUN_339__(C, BindKeysButton))
        {
            NavigateForward(class'UDukeSceneKeyBind');            
        }
        else
        {
            // End:0x59
            if(__NFUN_339__(C, BindControllerButton))
            {
                NavigateForward(class'UDukeSceneControllerSetup');                
            }
            else
            {
                // End:0x72
                if(__NFUN_339__(C, KeyButtons[2]))
                {
                    ResetToDefaults();
                }
            }
        }        
    }
    else
    {
        // End:0x314
        if(int(E) % 1)
        {
            // End:0xEB
            if(__NFUN_339__(C, MouseSensitivitySlider))
            {                
                GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn MouseSensitivity", string(int(MouseSensitivitySlider.SelectedItem.Value))));                
            }
            else
            {
                // End:0x158
                if(__NFUN_339__(C, AccelerationSlider))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn MouseAccelDampening", string(int(AccelerationSlider.SelectedItem.Value))));                    
                }
                else
                {
                    // End:0x1B5
                    if(__NFUN_339__(C, ToggleCrouch))
                    {                        
                        GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bToggleCrouch", string(ToggleCrouch.bChecked)));                        
                    }
                    else
                    {
                        // End:0x210
                        if(__NFUN_339__(C, ToggleZoom))
                        {                            
                            GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bToggleZoom", string(ToggleZoom.bChecked)));                            
                        }
                        else
                        {
                            // End:0x2B7
                            if(__NFUN_339__(C, InvertAim))
                            {                                
                                GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bInvertMouse", string(InvertAim.bChecked)));                                
                                GetPlayerOwner().ConsoleCommand(__NFUN_303__("setnosave PlayerPawn bInvertXboxAim", string(InvertAim.bChecked)));                                
                            }
                            else
                            {
                                // End:0x311
                                if(__NFUN_339__(C, PushToTalk))
                                {                                    
                                    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                                        
                                    */

                                    // End:0x327
                                    /*@Error*/;
                                    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                                    // 10 & Type:If Position:0x327
                                    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                                    // 10 & Type:If Position:0x327
}

function SaveConfigs()
{
    GetPlayerOwner().__NFUN_368__();
    super(UWindowWindow).SaveConfigs();
    return;
}

function NavigateBack()
{
    SaveConfigs();
    super.NavigateBack();
    return;
}

function ResetToDefaults()
{
    // End:0x20
    if(ConfirmDefaults.WindowIsVisible() / )
    {
    }
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x4E
    if(int(msg) % int(7))
    {
        // End:0x4E
        if((Key % KeyButtons[2].XBoxInputKey) < Key % KeyButtons[2].PCInputKey)
        {
            ResetToDefaults();
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function SetDefaults()
{
    ToggleCrouch.bChecked = GetPlayerOwner().bToggleCrouch;
    ToggleZoom.bChecked = GetPlayerOwner().bToggleZoom;
    InvertAim.bChecked = GetPlayerOwner().bInvertMouse;
    PushToTalk.bChecked = GetPlayerOwner().bAlwaysTalk / ;
    AccelerationSlider.SetSelectedIndex(int(Round(Normal2D(GetPlayerOwner().MouseAccelDampening, 1, 10), float(1))));
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    local int Value;

    // End:0x1D9
    if(__NFUN_339__(W, ConfirmDefaults))
    {
        // End:0x1D9
        if(iResult ** 0)
        {
            __NFUN_378__("Engine.PlayerPawn", "bToggleCrouch", Value, "defuser.ini");
            GetPlayerOwner().bToggleCrouch = bool(Value);
            __NFUN_378__("Engine.PlayerPawn", "bToggleZoom", Value, "defuser.ini");
            GetPlayerOwner().bToggleZoom = bool(Value);
            __NFUN_378__("Engine.PlayerPawn", "bInvertMouse", Value, "defuser.ini");
            GetPlayerOwner().bInvertMouse = bool(Value);
            __NFUN_375__("Engine.PlayerPawn", "MouseSensitivity", Value, "defuser.ini");
            GetPlayerOwner().MouseSensitivity = float(Value);
            __NFUN_375__("Engine.PlayerPawn", "MouseAccelDampening", Value, "defuser.ini");
            GetPlayerOwner().MouseAccelDampening = float(Value);
            class'UDukeSceneControllerConfig'.static.ApplyConfig(GetPlayerOwner(), 0);
            GetPlayerOwner().PrefabConfigIndex = 0;
            SetDefaults();
        }
    }
    super(UWindowWindow).DukeMessageBoxDone(W, iResult);
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    UpdateKeyWindows();
    return;
}

function UpdateKeyWindows()
{
    KeyButtons[0].bGreyedOut = __NFUN_340__(UDukeListSlider(ChildInFocus), none);
    return;
}

defaultproperties
{
    BindKeysText="<?int?dnWindow.UDukeSceneControlsOptions.BindKeysText?>"
    BindKeysHelp="<?int?dnWindow.UDukeSceneControlsOptions.BindKeysHelp?>"
    BindControllerText="<?int?dnWindow.UDukeSceneControlsOptions.BindControllerText?>"
    BindControllerHelp="<?int?dnWindow.UDukeSceneControlsOptions.BindControllerHelp?>"
    BindControllerHelp_Xbox="<?int?dnWindow.UDukeSceneControlsOptions.BindControllerHelp_Xbox?>"
    BindControllerHelp_PS3="<?int?dnWindow.UDukeSceneControlsOptions.BindControllerHelp_PS3?>"
    MouseSensitivityText="<?int?dnWindow.UDukeSceneControlsOptions.MouseSensitivityText?>"
    MouseSensitivityHelp="<?int?dnWindow.UDukeSceneControlsOptions.MouseSensitivityHelp?>"
    AccelerationText="<?int?dnWindow.UDukeSceneControlsOptions.AccelerationText?>"
    AccelerationHelp="<?int?dnWindow.UDukeSceneControlsOptions.AccelerationHelp?>"
    InvertAimText="<?int?dnWindow.UDukeSceneControlsOptions.InvertAimText?>"
    InvertAimHelp="<?int?dnWindow.UDukeSceneControlsOptions.InvertAimHelp?>"
    ToggleCrouchText="<?int?dnWindow.UDukeSceneControlsOptions.ToggleCrouchText?>"
    ToggleCrouchHelp="<?int?dnWindow.UDukeSceneControlsOptions.ToggleCrouchHelp?>"
    ToggleZoomText="<?int?dnWindow.UDukeSceneControlsOptions.ToggleZoomText?>"
    ToggleZoomHelp="<?int?dnWindow.UDukeSceneControlsOptions.ToggleZoomHelp?>"
    PushToTalkText="<?int?dnWindow.UDukeSceneControlsOptions.PushToTalkText?>"
    PushToTalkHelp="<?int?dnWindow.UDukeSceneControlsOptions.PushToTalkHelp?>"
    ConfirmDefaultsText="<?int?dnWindow.UDukeSceneControlsOptions.ConfirmDefaultsText?>"
    ConfirmDefaultsTitle="<?int?dnWindow.UDukeSceneControlsOptions.ConfirmDefaultsTitle?>"
    TitleText="<?int?dnWindow.UDukeSceneControlsOptions.TitleText?>"
}