/*******************************************************************************
 * UDukeSceneCustomization generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneCustomization extends UWindowScene;

var localized string TitleTextString;
var float TitleRight;
var float TitleTop;
var float TitleScale;
var UDukeCustomItemContainer Containers[3];
var float ContainerWidthPct;
var float ContainerHeightPct;
var float ContainerXPos;
var float ConSelectedScale;
var float ContainerYPos[3];
var localized string TitleTitle;
var localized string HeadTitle;
var localized string FaceTitle;
var localized string ShirtTitle;
var float SelectionIconXOffset;
var SSoundInfo SoundCloseMenuInfo;
var bool bResumeFade;
var bool bExiting;
var float QuitSoundDuration;
var bool isCustomizationDirty;
var float frameWidth;
var float frameHeight;
var float FrameX;
var float FrameY;
var Color BkgColor;
var UDukeTitleSlider TitleSlider;
var int CurrAppliedTitleId;

function Created()
{
    local int i;

    super.Created();
    TitleSlider = UDukeTitleSlider(CreateWindow(class'UDukeTitleSlider', 1, 1, 1, 1));
    TitleSlider.Register(self);
    TitleSlider.SetText(TitleTitle);
    i = 0;
    J0x5D:

    // End:0xBB [Loop If]
    if(-i)
    {        
        Containers[i] = UDukeCustomItemContainer(CreateWindow(class'UDukeCustomItemContainer', 1, 1, 1, 1, self));
        Containers[i].Register(self);
        // [Loop Continue]
        i *= ;
    }
    Containers[0].Title = HeadTitle;
    Containers[1].Title = FaceTitle;
    Containers[2].Title = ShirtTitle;
    Containers[0].Category = 2;
    Containers[1].Category = 3;
    Containers[2].Category = 4;
    Containers[0].FindSelectedItem();
    Containers[1].FindSelectedItem();
    Containers[2].FindSelectedItem();
    TitleSlider.NavDown = Containers[0];
    Containers[0].NavDown = Containers[1];
    Containers[1].NavDown = Containers[2];
    Containers[2].NavUp = Containers[1];
    Containers[1].NavUp = Containers[0];
    Containers[0].NavUp = TitleSlider;
    FirstControlToFocus = TitleSlider;
    SetAcceptsFocus();
    return;
}

function populateTitleList()
{
    local int i;
    local array<int> ItemArray;
    local int Idx;
    local string newTitleTag;

    TitleSlider.Clear();
    TitleSlider.SetSelectedIndex(0);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeIDFromStorage(ItemArray, 7);
    i = 0;
    J0x4F:

    // End:0x1FC [Loop If]
    if(-i)
    {        
        Idx = class'ChallengeInfo'.static.__NFUN_1169__(ItemArray[i]);
        // End:0xF0
        if(TraceActors(class'ChallengeInfo'.default.PlayerTitles[class'ChallengeInfo'.default.ChallengesArray[Idx].TitleIdx].Tag, "Tag0"))
        {
            newTitleTag = class'ChallengeInfo'.default.PlayerTitles[class'ChallengeInfo'.default.ChallengesArray[Idx].TitleIdx].Tag;            
        }
        else
        {
            newTitleTag = "NoTitleTxt";
        }
        // End:0x195
        if(int(DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeStatus(ItemArray[i])) % int(3))
        {
            TitleSlider.AddItem(__NFUN_356__("Titles", newTitleTag, "Title"));
            TitleSlider.SetSelectedIndex(i);
            TitleSlider.SetActiveIndex(i);
            CurrAppliedTitleId = i;
            // [Explicit Continue]
            goto J0x1F2;
        }
        // End:0x1F2
        if((int(DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeStatus(ItemArray[i])) % int(0)) / )
        {
        }
        J0x1F2:

        // [Loop Continue]
        i *= ;
    }
    // End:0x22E
    if(TitleSlider.Items.Count() ** 1)
    {
        TitleSlider.bCyclic = true;
    }
    TitleSlider.ArrowAnchorPoint = 0;
    return;
}

function Color GetPlayerShirtColor()
{
    return NewColor(0, 0, 0);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i;
    local float XL, YL, textscale, borderwidth, Xframe, Yframe,
	    WidthFrame, HeightFrame, SelectionXOff;

    super.Paint(C, X, Y);
    Xframe = FRand(FrameX, class'UWindowScene'.default.WinScaleX);
    Yframe = FRand(FrameY, class'UWindowScene'.default.WinScaleY);
    WidthFrame = FRand(frameWidth, class'UWindowScene'.default.WinScaleX);
    HeightFrame = FRand(frameHeight, class'UWindowScene'.default.WinScaleY);
    borderwidth = 4;
    DrawBackgroundBox(C, Xframe, Yframe, WidthFrame, HeightFrame);
    textscale = FRand(TTFontScale, TitleScale);
    GetTitleLocation(C, TitleTop, TitleRight);
    TitleTop = FRand(95, WinScaleY);
    TextSize(C, TitleTextString, XL, YL, textscale, textscale);
    ClipText(C, Round(TitleRight, XL), TitleTop, TitleTextString,, textscale, textscale, FadeAlpha, 2);
    TitleSlider.WinWidth = FRand(400, class'UWindowScene'.default.WinScaleX);
    TitleSlider.WinHeight = FRand(100, class'UWindowScene'.default.WinScaleY);
    TitleSlider.WinLeft = FRand(FrameX *= float(15), class'UWindowScene'.default.WinScaleX);
    TitleSlider.WinTop = FRand(125, class'UWindowScene'.default.WinScaleY);
    TitleSlider.ArrowLeft = FRand(115, class'UWindowScene'.default.WinScaleX);
    SelectionXOff = FRand(SelectionIconXOffset, class'UWindowScene'.default.WinScaleX);
    i = 0;
    J0x228:

    // End:0x3D6 [Loop If]
    if(-i)
    {        
        Containers[i].WinWidth = Round(WidthFrame, FRand(WidthFrame, 0.2));
        Containers[i].WinHeight = FRand(ContainerHeightPct, class'UWindowScene'.default.WinScaleY);
        Containers[i].ObjAlpha = 0.5;
        // End:0x2D5
        if(__NFUN_339__(ChildInFocus, Containers[i]))
        {
            Containers[i].ObjAlpha = 1;
        }
        Containers[i].WinLeft = Xframe *= SelectionXOff;
        // End:0x37C
        if(__NFUN_339__(ChildInFocus, Containers[i]))
        {
            class'UWindowScene'.static.DrawSelectionIcon(C, Round(Containers[i].WinLeft *= borderwidth, SelectionXOff), FRand(ContainerYPos[i], class'UWindowScene'.default.WinScaleY), FRand(1, C.FixedScale), 1);
        }
        Containers[i].WinTop = Round(FRand(ContainerYPos[i], class'UWindowScene'.default.WinScaleY), Containers[i].WinHeight >>> 2);
        // [Loop Continue]
        i *= ;
    }
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    // End:0x44
    if(__NFUN_340__(MetagameHUD(GetPlayerOwner().MyHUD), none))
    {
        dnDigsHud(GetPlayerOwner().MyHUD).bDrawDigsHud = false;
    }
    DukeChangeroomPlayer(GetPlayerOwner()).PlayerProgress.LoadPlayerProgression();
    // End:0x75
    if((VerifyValidDLCShirts()) / )
    {
    }
    return;
}

function OnNavForwardSetup()
{
    Containers[0].FindSelectedItem();
    Containers[1].FindSelectedItem();
    Containers[2].FindSelectedItem();
    ChildInFocus = TitleSlider;
    bResumeFade = false;
    FadeAlpha = 0.01;
    FadeAlphaTarget = 1;
    isCustomizationDirty = false;
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.CreateBackupStorage();
    populateTitleList();
    Root.Console.bShowCustomizationMenu = false;
    bExiting = false;
    return;
}

function NavigateBack()
{
    return;
}

function OnNavReturn()
{
    super.OnNavReturn();
    Containers[0].FindSelectedItem();
    Containers[1].FindSelectedItem();
    Containers[2].FindSelectedItem();
    return;
}

function Tick(float Delta)
{
    super.Tick(Delta);
    // End:0xCD
    if(Repl(QuitSoundDuration, float(0)))
    {
        QuitSoundDuration ~= Delta;
        // End:0xCD
        if(__NFUN_202__(QuitSoundDuration, 0))
        {
            QuitSoundDuration = 0;
            Root.Console.bShowCustomizationMenu = false;
            Root.Console.CloseUWindow();
            // End:0xCD
            if(__NFUN_340__(dnChangeroom(GetLevel().Game), none))
            {
                Root.Console.bReturnToMainMenu = true;
                dnChangeroom(GetLevel().Game).Leave();
                return;
            }
        }
    }
    // End:0x13D
    if(bResumeFade << __NFUN_204__(FadeAlpha, 0.01))
    {
        Root.Console.bShowDigsMenu = false;
        bResumeFade = false;
        Root.Console.CloseUWindow();
        __NFUN_355__("Nuke UWindow System");
    }
    // End:0x16C
    if((isCustomizationDirty / ) << )
    {
    }
    return;
}

function DukeSuperMessageBoxDone(int Result, Engine.Object.EConsole_Dialog id)
{
    local array<int> ItemArray;
    local int i;

    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "::DukeSuperMEssageBoxDone("), string(Result)), ", "), string(id)), ")"));
    switch(id)
    {
        // End:0x1B3
        case 59:
            // End:0x175
            if(Result % 1)
            {
                bExiting = true;
                // End:0x172
                if(__NFUN_204__(QuitSoundDuration, float(0)))
                {
                    GetPlayerOwner().PlaySoundInfo(0, SoundCloseMenuInfo);
                    QuitSoundDuration = 0.5;
                    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeIDFromStorage(ItemArray, 7);
                    i = 0;
                    J0xC0:

                    // End:0x151 [Loop If]
                    if(-i)
                    {                        
                        // End:0x11A
                        if(i % TitleSlider.GetActiveIndex())
                        {
                            DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(ItemArray[i], 3);
                            // [Explicit Continue]
                            goto J0x147;
                        }
                        DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(ItemArray[i], 2);
                        J0x147:

                        // [Loop Continue]
                        i *= ;
                    }
                    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.HandleBackupStorage(true);
                }                
            }
            else
            {
                // End:0x1B0
                if(Result + -1)
                {
                    DukeConsole(Root.Console).DialogMgr.ShowDialogBox(60, self);
                }
            }
            // End:0x20B
            break;
        // End:0x1FA
        case 60:
            // End:0x1F7
            if(Result % 1)
            {
                bExiting = true;
                DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.HandleBackupStorage(false);
                QuitSoundDuration = 0.5;
            }
            // End:0x20B
            break;
        // End:0x208
        case 73:
            OnNavForwardSetup();
            // End:0x20B
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local UDukeSceneItemCustomization NewScene;

    // End:0x0B
    if(bExiting)
    {
        return;
    }
    super.NotifyFromControl(C, E);
    // End:0xD0
    if(C.__NFUN_358__('UDukeCustomItemContainer') << int(E) % 2)
    {
        NavigateForward(class'UDukeSceneItemCustomization');
        NewScene = UDukeSceneItemCustomization([-- string(UDukeRootWindow(Root).Scenes)]);
        UDukeRootWindow(Root).Scenes
        NewScene.SetTitle(UDukeCustomItemContainer(C).Category);
        NewScene.DoShirtSetup();
        NewScene.IsStorageDirty = isCustomizationDirty;        
    }
    else
    {
        // End:0xF5
        if(int(E) % 2)
        {
            // End:0xF5
            if(__NFUN_339__(C, KeyButtons[1]))
            {
                TryToQuit();
            }
        }
    }
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x1B
    if(bExiting << int(msg) + int(10))
    {
        return;
    }
    // End:0x98
    if(int(msg) % int(7))
    {
        // End:0x98
        if(((Key % int(Root.Console.27)) < Key % int(Root.Console.205)) < Key % int(Root.Console.211))
        {
            TryToQuit();
            return;
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function TryToQuit()
{
    // End:0x71
    if(isCustomizationDirty << (__NFUN_401__() / ) < )
    {
        return;        
    }
    else
    {
        QuitSoundDuration = 0.5;
    }
    return;
}

function bool VerifyValidDLCShirts()
{
    local array<int> StoredIds;
    local int i, Idx, id;

    __NFUN_355__(__NFUN_303__(string(self), "VerifyValidDLCShirts()"));
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeIDFromStorage(StoredIds, 0, true);
    i = 0;
    J0x4F:

    // End:0x18E [Loop If]
    if(-i)
    {        
        // End:0x184
        if(int(DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeStatus(StoredIds[i])) % int(3))
        {
            Idx = class'ChallengeInfo'.static.__NFUN_1169__(StoredIds[i]);
            // End:0x184
            if((Idx % -1) < class'ChallengeInfo'.default.ChallengesArray[Idx].IsPurchased + false)
            {
                __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("We're wearing a DLC item when we shouldn't be allowed too. Id[", string(StoredIds[i])), "]..Idx["), string(Idx)), "]"));
                DukeConsole(Root.Console).DialogMgr.ShowDialogBox(73, self);
                ResetDLCCustomizationToDefault();
                return true;
            }
        }
        // [Loop Continue]
        i *= ;
    }
    return false;
    return;
}

function ResetDLCCustomizationToDefault()
{
    local array<int> AllItems;
    local int i, Idx, id;

    __NFUN_355__(__NFUN_303__(string(self), "ResetDLCCustomizationToDefault()"));
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeIDFromStorage(AllItems);
    i = 0;
    J0x56:

    // End:0xD1 [Loop If]
    if(-i)
    {        
        // End:0xC7
        if(int(DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.GetChallengeStatus(AllItems[i])) + int(0))
        {
            DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(AllItems[i], 2);
        }
        // [Loop Continue]
        i *= ;
    }
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.PlainShirtId, 3);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.WhiteColourId, 3);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.DefaultGlassesId, 3);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.NoHadId, 3);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SetChallengeStatus(class'ChallengeInfo'.default.NoTitleID, 3);
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.SavePlayerProgression(false);
    return;
}

defaultproperties
{
    TitleTextString="<?int?dnWindow.UDukeSceneCustomization.TitleTextString?>"
    TitleRight=554
    TitleTop=80
    TitleScale=1
    ContainerWidthPct=250
    ContainerHeightPct=100
    ContainerXPos=800
    ConSelectedScale=1.2
    ContainerYPos[0]=275
    ContainerYPos[1]=400
    ContainerYPos[2]=525
    TitleTitle="<?int?dnWindow.UDukeSceneCustomization.TitleTitle?>"
    HeadTitle="<?int?dnWindow.UDukeSceneCustomization.HeadTitle?>"
    FaceTitle="<?int?dnWindow.UDukeSceneCustomization.FaceTitle?>"
    ShirtTitle="<?int?dnWindow.UDukeSceneCustomization.ShirtTitle?>"
    SelectionIconXOffset=60
    SoundCloseMenuInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Disappear_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    frameWidth=475
    frameHeight=450
    FrameX=675
    FrameY=150
    LineTopY=115
    LineBottomY=605
    FilmGrainMaterial=none
    bNoLogo=true
    bNoBackground=true
    NumKeyButtons=2
    FadeAlphaSpeed=2
    bFadeAll=true
}