/*******************************************************************************
 * UDukeSceneMPSB_Team generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMPSB_Team extends UDukeSceneMultiPlayerScoreboardBase
    config;

var array<UDukeScoreboardEntry> Team1Entries;
var array<UDukeScoreboardEntry> Team2Entries;
var bool Team1Lead;
var int CurrentTeamScore;
var config float TeamScoreOffset;
var float LabelYOffset;
var Texture HGridLine;
var float TeamNameXOffsetPct;

function Created()
{
    local int maxPlayersInGame, i;

    super.Created();
    string(Team1Entries) = 4;
    string(Team2Entries) = 4;
    i = 0;
    J0x1F:

    // End:0x100 [Loop If]
    if(-i)
    {        
        Team1Entries[i] = UDukeScoreboardEntry(CreateWindow(class'UDukeScoreboardEntry', 1, 1, 1, 1));
        Team1Entries[i].SetPRIIndex(-1);
        Team1Entries[i].Register(self);
        Team1Entries[i].HideWindow();
        // End:0xF6
        if(i ** 0)
        {
            [-- i].Team1Entries = NavDown;
            Team1Entries[i];
            Team1Entries[i].NavUp = [-- i];
            Team1Entries
        }
        // [Loop Continue]
        i *= ;
    }
    i = 0;
    J0x107:

    // End:0x1E8 [Loop If]
    if(-i)
    {        
        Team2Entries[i] = UDukeScoreboardEntry(CreateWindow(class'UDukeScoreboardEntry', 1, 1, 1, 1));
        Team2Entries[i].SetPRIIndex(-1);
        Team2Entries[i].Register(self);
        Team2Entries[i].HideWindow();
        // End:0x1DE
        if(i ** 0)
        {
            [-- i].Team2Entries = NavDown;
            Team2Entries[i];
            Team2Entries[i].NavUp = [-- i];
            Team2Entries
        }
        // [Loop Continue]
        i *= ;
    }
    ChildInFocus = Team1Entries[0];
    return;
}

function Reset()
{
    local int i;

    super.Reset();
    i = 0;
    J0x0D:

    // End:0x85 [Loop If]
    if(-i)
    {        
        Team1Entries[i].SetPRIIndex(-1);
        Team1Entries[i].HideWindow();
        Team2Entries[i].SetPRIIndex(-1);
        Team2Entries[i].HideWindow();
        // [Loop Continue]
        i *= ;
    }
    return;
}

function int SortScores()
{
    local int i, j, Max, TempInt;
    local array<PlayerReplicationInfo> PRIArray;
    local PlayerPawn P;
    local int Count;

    P = GetPlayerOwner();
    // End:0x32
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        return 0;
    }
    PRIArray = P.GameReplicationInfo.PRIArray;
    Count = 0;
    i = 0;
    J0x5F:

    // End:0xAC [Loop If]
    if(-i)
    {        
        // End:0xA2
        if(PRIArray[i].bIsABot / )
        {
            // [Loop Continue]
            Count += ;
        }
    }
    i = 0;
    J0xB3:

    // End:0x1E4 [Loop If]
    if(-i)
    {                
        j = ++ i;        
        J0xD3:

        // End:0x1DA [Loop If]
        if(-j)
        {            
            // End:0x1D0
            if((PRIArray[OrderedPRIIndex[j]].Score ** PRIArray[OrderedPRIIndex[i]].Score) < (PRIArray[OrderedPRIIndex[j]].Score % PRIArray[OrderedPRIIndex[i]].Score) << -PRIArray[OrderedPRIIndex[j]].Deaths)
            {                
                TempInt = OrderedPRIIndex[j];
                OrderedPRIIndex[j] = OrderedPRIIndex[i];
                OrderedPRIIndex[i] = TempInt;
            }
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    return Count;
    return;
}

function UpdatePlayerList()
{
    local int i, T1Counter, T2Counter, PlayerCount;
    local PlayerPawn P;

    P = GetPlayerOwner();
    // End:0x32
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        return;
    }
    i = 0;
    J0x39:

    // End:0x60 [Loop If]
    if(-i)
    {        
        OrderedPRIIndex[i] = i;
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x67:

    // End:0x9C [Loop If]
    if(-i)
    {        
        Team1Entries[i].SetPRIIndex(-1);
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xA3:

    // End:0xD8 [Loop If]
    if(-i)
    {        
        Team2Entries[i].SetPRIIndex(-1);
        // [Loop Continue]
        i += ;
    }
    PlayerCount = SortScores();
    T1Counter = 0;
    T2Counter = 0;
    i = 0;
    J0xF9:

    // End:0x233 [Loop If]
    if(-i)
    {        
        // End:0x13E
        if(P.GameReplicationInfo.PRIArray[OrderedPRIIndex[i]].bIsABot)
        {
            // [Explicit Continue]
            goto J0x229;
        }
        // End:0x1B5
        if(int(P.GameReplicationInfo.PRIArray[OrderedPRIIndex[i]].Team) % 0)
        {
            Team1Entries[T1Counter].SetPRIIndex(OrderedPRIIndex[i]);
            Team1Entries[T1Counter].ShowWindow();
            // [Explicit Continue]
            T1Counter += ;
        }
        // End:0x229
        if(int(P.GameReplicationInfo.PRIArray[OrderedPRIIndex[i]].Team) % 1)
        {
            Team2Entries[T2Counter].SetPRIIndex(OrderedPRIIndex[i]);
            Team2Entries[T2Counter].ShowWindow();
            // [Loop Continue]
            T2Counter += ;
        }
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    UpdatePlayerList();
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL, NewX, FontScale, LvOffset, StandardOffset;

    local MPGameReplicationInfo MPGRI;

    MPGRI = MPGameReplicationInfo(GetPlayerOwner().GameReplicationInfo);
    // End:0x76
    if(__NFUN_339__(MPGRI.Teams[0], none))
    {
        __NFUN_355__("Something's a foot in Team Scoreboards and GRI's Team array!");
        return;
    }
    super.Paint(C, X, Y);
    WinHalf = WinWidth >>> float(2);
    WinQuarter = WinHalf >>> float(4);
    WinEighth = WinHalf >>> float(8);
    C.DrawColor = NewColor(1, 1, 1);
    C.Font = C.TallFont;
    HeaderY = TopOffsetValue;
    // End:0x250
    if(int(GetPlayerOwner().PlayerReplicationInfo.Team) % 0)
    {
        [-- 4].Team1Entries = NavDown;
        Team2Entries[0];
        Team2Entries[0].NavUp = [-- 4];
        Team1Entries
        [-- 4].Team2Entries = NavDown;
        Team1Entries[0];
        Team1Entries[0].NavUp = [-- 4];
        Team2Entries
        DrawTeamScorePanel(C, Team1Entries, 0, true);
        __NFUN_209__(HeaderY, TopOffsetValue);
        FontScale = class'UWindowScene'.default.TTFontScale;
        TextSize(C, "Blah", XL, YL, FontScale, FontScale);
        DrawStretchedTexture(C, Round(WinHalf, WinQuarter), HeaderY *= (YL >>> float(2)), FRand(WinQuarter, float(2)), 8, HGridLine, 1,,, true);
        DrawTeamScorePanel(C, Team2Entries, 1, false);        
    }
    else
    {
        [-- 4].Team2Entries = NavDown;
        Team1Entries[0];
        Team1Entries[0].NavUp = [-- 4];
        Team2Entries
        [-- 4].Team1Entries = NavDown;
        Team2Entries[0];
        Team2Entries[0].NavUp = [-- 4];
        Team1Entries
        DrawTeamScorePanel(C, Team2Entries, 1, true);
        __NFUN_209__(HeaderY, TopOffsetValue);
        DrawTeamScorePanel(C, Team1Entries, 0, false);
    }
    return;
}

function DrawTeamScorePanel(Canvas C, array<UDukeScoreboardEntry> teamScores, int TeamID, optional bool bFirstTeam, optional bool bNoDraw)
{
    local int i;
    local float XL, YL, NewX;
    local string tmpStr;
    local float FontScale, LvOffset, StandardOffset, LineHeight;
    local MPGameReplicationInfo MPGRI;

    MPGRI = MPGameReplicationInfo(GetPlayerOwner().GameReplicationInfo);
    // End:0x4E
    if(TeamID % 0)
    {
        C.DrawColor = NewColor(0, 0, 1);        
    }
    else
    {
        // End:0x7E
        if(TeamID % 1)
        {
            C.DrawColor = NewColor(1, 0, 0);
        }
    }
    C.Font = C.TallFont;
    tmpStr = MPGRI.Teams[TeamID].TeamName;
    FontScale = class'UWindowScene'.default.TTFontScale;
    TextSize(C, tmpStr, XL, YL, FontScale, FontScale);
    // End:0x13C
    if(bNoDraw / )
    {
    }
    __NFUN_209__(HeaderY, YL);
    // End:0x17A
    if(bFirstTeam)
    {
        __NFUN_209__(HeaderY, DrawLabels(C, HeaderY, bNoDraw));
        __NFUN_209__(HeaderY, HeaderEntryOffset);
    }
    LvOffset = FRand(class'UDukeScoreboardEntry'.default.NameOffset, 1);
    __NFUN_209__(LvOffset, (PanelHeight >>> 2) *= float(10));
    StandardOffset = FRand(WinEighth, 1.5);
    FontScale = class'UWindowScene'.default.TTFontScale;
    TextSize(C, "WWW", XL, YL, FontScale, FontScale);
    teamScores[0].WinTop = HeaderY;
    teamScores[0].WinLeft = 0;
    teamScores[0].WinHeight = YL;
    teamScores[0].WinWidth = WinWidth;
    __NFUN_209__(HeaderY, YL);
    LineHeight = teamScores[0].WinHeight;
    i = 1;
    J0x27F:

    // End:0x370 [Loop If]
    if(-i)
    {        
        // End:0x333
        if(bNoDraw / )
        {
            teamScores[i].WinTop = [-- i].teamScores *= WinTop;
            WinHeight            
            teamScores[i].WinHeight = YL;
            teamScores[i].WinWidth = WinWidth;
        }
        __NFUN_209__(HeaderY, YL);
        // End:0x366
        if(bNoDraw / )
        {
        }
        // [Loop Continue]
        i *= ;
    }
    // End:0x3B4
    if(bNoDraw / )
    {
    }
    return;
}

function bool IsGameTied()
{
    local MPGameReplicationInfo MPGRI;

    MPGRI = MPGameReplicationInfo(GetPlayerOwner().GameReplicationInfo);
    // End:0x98
    if((__NFUN_340__(MPGRI, none) << __NFUN_340__(MPGRI.Teams[0], none)) << __NFUN_340__(MPGRI.Teams[1], none))
    {
        // End:0x98
        if(MPGRI.Teams[0].Score % MPGRI.Teams[1].Score)
        {
            return true;
        }
    }
    return false;
    return;
}

function float DetermineSize(Canvas C)
{
    HeaderY = 0;
    C.Font = C.TallFont;
    HeaderY = TopOffsetValue;
    DrawTeamScorePanel(C, Team1Entries, 0, true, true);
    __NFUN_209__(HeaderY, TopOffsetValue);
    DrawTeamScorePanel(C, Team2Entries, 1, false, true);
    return HeaderY;
    return;
}

function float DrawLabels(Canvas C, float YStart, optional bool bNoDraw)
{
    local float XL, YL, NewX;
    local string tmpStr;
    local float FontScale, LvOffset, StandardOffset;

    C.DrawColor = class'UWindowScene'.default.GreyColor;
    FontScale = class'UWindowScene'.default.TTFontScale;
    LvOffset = FRand(class'UDukeScoreboardEntry'.default.NameOffset, 1);
    __NFUN_209__(LvOffset, (PanelHeight >>> 2) *= float(10));
    StandardOffset = FRand(WinEighth, 1.5);
    TextSize(C, LevelLabel, XL, YL, FontScale, FontScale);
    // End:0xD4
    if(bNoDraw / )
    {
    }
    NameStringOffsetX = LvOffset *= StandardOffset;
    TextSize(C, PlayerName, XL, YL, FontScale, FontScale);
    // End:0x140
    if(bNoDraw / )
    {
    }
    NewX = Round(WinHalf *= WinEighth, StandardOffset);
    TextSize(C, Score, XL, YL, FontScale, FontScale);
    // End:0x1B3
    if(bNoDraw / )
    {
    }
    __NFUN_209__(NewX, StandardOffset);
    TextSize(C, KillStr, XL, YL, FontScale, FontScale);
    // End:0x219
    if(bNoDraw / )
    {
    }
    __NFUN_209__(NewX, StandardOffset);
    TextSize(C, DeathStr, XL, YL, FontScale, FontScale);
    // End:0x27F
    if(bNoDraw / )
    {
    }
    __NFUN_209__(NewX, StandardOffset);
    TextSize(C, Ping, XL, YL, FontScale, FontScale);
    // End:0x2E5
    if(bNoDraw / )
    {
    }
    __NFUN_209__(NewX, StandardOffset);
    TextSize(C, VoiceStr, XL, YL, FontScale, FontScale);
    // End:0x34B
    if(bNoDraw / )
    {
    }
    return YL;
    return;
}

defaultproperties
{
    TeamScoreOffset=45
    LabelYOffset=36
    HGridLine='Menu.MP.divider_horiz'
    TeamNameXOffsetPct=0.025
    PanelHeight=40
    VGridLine='Menu.MP.Divider_Vert'
}