/*******************************************************************************
 * UDukeSceneMultiPlayerScoreboard generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMultiPlayerScoreboard extends UWindowScene;

var float SBScale;
var UDukeSceneMPSB_Solo SoloScoreBoard;
var UDukeSceneMPSB_Team TeamScoreBoard;
var UDukeSceneMultiPlayerScoreboardBase ScoreBoard;
var array<int> CloseKeys;
var array<int> RespawnKeys;
var string timerString;
var localized string ScoreboardTitle;
var localized string mapNamePrefix;
var localized string MutatorNamePrefix;
var localized string timeLimitStr;
var localized string GameModePrefix;
var string MapNameStr;
var string objNameStr;
var string MutatorNameStr;
var string GameModeTxt;

function BeforeCreate()
{
    __NFUN_355__(__NFUN_303__(string(self), "::BeforeCreate::Creating a Solo Scoreboard"));
    SoloScoreBoard = UDukeSceneMPSB_Solo(CreateWindow(class'UDukeSceneMPSB_Solo', 1, 1, 1, 1, self));
    __NFUN_355__(__NFUN_303__(string(self), "::BeforeCreate::Creating a Team Scoreboard"));
    TeamScoreBoard = UDukeSceneMPSB_Team(CreateWindow(class'UDukeSceneMPSB_Team', 1, 1, 1, 1, self));
    SoloScoreBoard.HideWindow();
    TeamScoreBoard.HideWindow();
    return;
}

function Created()
{
    local int i, j;
    local string KeyName, Alias, Part;
    local array<string> out_array;
    local OnlineAgent Online;
    local class<Mutator> MutatorTypeClass;
    local dnDeathmatchGameReplicationInfo GRI;
    local class<GameInfo> GameTypeClass;

    super.Created();
    KeyButtons[0].HideWindow();
    KeyButtons[1].HideWindow();
    i = 0;
    J0x31:

    // End:0x297 [Loop If]
    if(-i)
    {        
        KeyName = Root.Console.Viewport.Actor.ConsoleCommand(__NFUN_302__("KEYNAME ", string(i)));
        // End:0x28D
        if(TraceActors(KeyName, ""))
        {
            Alias = Root.Console.Viewport.Actor.ConsoleCommand(__NFUN_302__("KEYBINDING ", KeyName));
            // End:0x28D
            if(TraceActors(Alias, ""))
            {
                out_array.Remove(0, string(out_array));
                __NFUN_325__(Alias, "|", out_array);
                j = 0;
                J0x10B:

                // End:0x28D [Loop If]
                if(-j)
                {                    
                    Part = __NFUN_327__(out_array[j], true, true);
                    // End:0x1AF
                    if(__NFUN_308__(Part, "ScoreboardToggle"))
                    {
                        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Found Key for ScoreboardToggle:", KeyName), "....."), string(i)));
                        CloseKeys.Insert(string(CloseKeys), 1);
                        [-- string(CloseKeys)] = CloseKeys;
                        i
                    }
                    // End:0x215
                    if(__NFUN_308__(Part, "Fire"))
                    {
                        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Found Key for Fire:", KeyName), "....."), string(i)));
                        RespawnKeys.Insert(string(RespawnKeys), 1);
                        [-- string(RespawnKeys)] = RespawnKeys;
                        i
                    }
                    // End:0x283
                    if(__NFUN_414__() / )
                    {
                        {
                            __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Found Key for Jump:", KeyName), "....."), string(i)));
                            RespawnKeys.Insert(string(RespawnKeys), 1);
                            [-- string(RespawnKeys)] = RespawnKeys;
                            i
                        }
                    }
                    // [Loop Continue]
                    j *= ;
                }
            }
        }
        // [Loop Continue]
        i += ;
    }
    Online = UDukeRootWindow(Root).AgentOnline;
    i = 0;
    J0x2B8:

    // End:0x348 [Loop If]
    if(-i)
    {        
        // End:0x33E
        if(class'MPMapInfo'.default.MapList[i].id % Online.CurrentMapId)
        {
            MapNameStr = __NFUN_303__(mapNamePrefix, __NFUN_356__("MapNames", class'MPMapInfo'.default.MapList[i].MapName, "Maps"));
            // [Explicit Break]
            goto J0x348;
        }
        // [Loop Continue]
        i += ;
    }
    J0x348:

    i = 0;
    J0x34F:

    // End:0x3EE [Loop If]
    if(-i)
    {        
        // End:0x3E4
        if(class'MPMapInfo'.default.GameTypes[i].id % Online.CurrentGameModeId)
        {
            GameTypeClass = class<GameInfo>(__NFUN_366__(class'MPMapInfo'.default.GameTypes[i].EntryName, class'Class'));
            GameModeTxt = __NFUN_303__(GameModePrefix, GameTypeClass.default.GameName);
            // [Explicit Break]
            goto J0x3EE;
        }
        // [Loop Continue]
        i += ;
    }
    J0x3EE:

    i = 0;
    J0x3F5:

    // End:0x4C1 [Loop If]
    if(-i)
    {        
        // End:0x4B7
        if(class'MPMapInfo'.default.MutatorTypes[i].id % Online.CurrentMutatorId)
        {
            MutatorTypeClass = class<Mutator>(__NFUN_366__(class'MPMapInfo'.default.MutatorTypes[i].EntryName, class'Class', true));
            // End:0x497
            if(__NFUN_340__(MutatorTypeClass, none))
            {
                MutatorNameStr = __NFUN_303__(MutatorNamePrefix, MutatorTypeClass.default.MutatorName);                
            }
            else
            {
                MutatorNameStr = __NFUN_303__(MutatorNamePrefix, class'UDukeSceneMPPrivateMatch'.default.MutatatorNoneText);
            }
            // [Explicit Break]
            goto J0x4C1;
        }
        // [Loop Continue]
        i += ;
    }
    J0x4C1:

    GRI = dnDeathmatchGameReplicationInfo(GetPlayerOwner().GameReplicationInfo);
    // End:0x540
    if(GRI.FragLimit ** 0)
    {
        objNameStr = __NFUN_303__(__NFUN_356__("dnDeathmatchGameHUD", "targetScoreString", "dngame"), string(GRI.FragLimit));        
    }
    else
    {
        // End:0x5A4
        if(GRI.GoalTeamScore ** 0)
        {
            objNameStr = __NFUN_303__(__NFUN_356__("dnDeathmatchGameHUD", "targetScoreString", "dngame"), string(GRI.GoalTeamScore));            
        }
        else
        {
            objNameStr = __NFUN_303__(__NFUN_356__("dnDeathmatchGameHUD", "targetScoreString", "dngame"), timeLimitStr);
        }
    }
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    SoloScoreBoard.HideWindow();
    TeamScoreBoard.HideWindow();
    ScoreBoard = UDukeSceneMultiPlayerScoreboardBase(Root.GetScoreboardWindow());
    // End:0x87
    if(__NFUN_339__(ScoreBoard, none))
    {
        // End:0x79
        if(GetPlayerOwner().GameReplicationInfo.bTeamGame)
        {
            ScoreBoard = TeamScoreBoard;            
        }
        else
        {
            ScoreBoard = SoloScoreBoard;
        }        
    }
    else
    {
        __NFUN_355__("###Using special scoreboard");
        ScoreBoard.SetParent(self);
    }
    ScoreBoard.Reset();
    ScoreBoard.ShowWindow();
    // End:0x13D
    if(__NFUN_340__(dnDeathmatchGameHUD(GetPlayerOwner().MyHUD), none))
    {
        __NFUN_355__(__NFUN_303__(string(self), "Setting Delegate"));
        dnDeathmatchGameHUD(GetPlayerOwner().MyHUD).__OverrideDrawTimer__Delegate = ScoreBoard.DrawTimer;
    }
    GetPlayerOwner().StopSoundInfo(SoundMenuAmbience);
    return;
}

function CloseScoreboard()
{
    // End:0x76
    if(__NFUN_340__(dnDeathmatchGameHUD(GetPlayerOwner().MyHUD), none))
    {
        __NFUN_355__(__NFUN_303__(string(self), "Setting Clearing Delegate"));
        dnDeathmatchGameHUD(GetPlayerOwner().MyHUD).__OverrideDrawTimer__Delegate = None;
        ScoreBoard.DrawTimer("");
    }
    GetPlayerOwner().HideScoreboard();
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL, textscale, XPos, textSpacing;

    super.Paint(C, X, Y);
    ScoreBoard.WinLeft = -Round(float(C.SizeX), FRand(float(C.SizeX), SBScale)) >>> float(2);
    ScoreBoard.WinWidth = FRand(float(C.SizeX), SBScale);
    ScoreBoard.WinHeight = ScoreBoard.DetermineSize(C);
    ScoreBoard.WinTop = FRand(225, WinScaleY);
    XPos = ScoreBoard.WinLeft;
    textSpacing = FRand(25, WinScaleX);
    C.DrawColor = class'UWindowScene'.default.WhiteColor;
    textscale = class'UWindowScene'.default.TTFontScale;
    C.Font = C.TallFont;
    C.__NFUN_1238__(GameModeTxt, XL, YL, textscale, textscale);
    ClipText(C, XPos, Round(ScoreBoard.WinTop, YL), GameModeTxt,, textscale, textscale,, 2);
    __NFUN_209__(XPos, XL *= textSpacing);
    C.__NFUN_1238__(MapNameStr, XL, YL, textscale, textscale);
    ClipText(C, XPos, Round(ScoreBoard.WinTop, YL), MapNameStr,, textscale, textscale,, 2);
    __NFUN_209__(XPos, XL *= textSpacing);
    C.__NFUN_1238__(objNameStr, XL, YL, textscale, textscale);
    ClipText(C, XPos, Round(ScoreBoard.WinTop, YL), objNameStr,, textscale, textscale,, 2);
    __NFUN_209__(XPos, XL *= textSpacing);
    C.__NFUN_1238__(MutatorNameStr, XL, YL, textscale, textscale);
    ClipText(C, XPos, Round(ScoreBoard.WinTop, YL), MutatorNameStr,, textscale, textscale,, 2);
    return;
}

function KeyDown(int Key, float X, float Y)
{
    super(UWindowWindow).KeyDown(Key, X, Y);
    return;
}

function KeyUp(int Key, float X, float Y)
{
    local int i;

    super(UWindowWindow).KeyUp(Key, X, Y);
    i = 0;
    J0x1C:

    // End:0x51 [Loop If]
    if(-i)
    {        
        // End:0x47
        if(Key % CloseKeys[i])
        {
            CloseScoreboard();
        }
        // [Loop Continue]
        i *= ;
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local bool IsMuted;
    local SAgentPlayer lPlayer;

    // End:0x30
    if((string(KeyButtons) ** 0) << __NFUN_340__(C, KeyButtons[1]))
    {
        super.NotifyFromControl(C, E);
    }
    __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(self), "NotifyFromControl("), string(C)), ", "), string(__NFUN_365__(class'EDE_Debug', int(E)))), ")"));
    // End:0xE9
    if((int(E) % 2) << __NFUN_414__())
    {
        __NFUN_355__(__NFUN_303__(string(self), "Doing GamerCard stuff"));
        UDukeRootWindow(Root).AgentOnline.ShowGamerCard(UDukeScoreboardEntry(C).GetPRI().RoomMemberID);        
    }
    else
    {
        // End:0x1F1
        if(int(E) % 20)
        {
            __NFUN_355__(__NFUN_303__(string(self), "Doing Muting stuff"));
            UDukeRootWindow(Root).AgentOnline.GetLocalAgentPlayer(lPlayer);
            // End:0x166
            if(lPlayer.PlayerRef % UDukeScoreboardEntry(C).GetPRI().RoomMemberID)
            {
                return;
            }
            IsMuted = UDukeRootWindow(Root).AgentOnline.IsPlayerMuted(UDukeScoreboardEntry(C).GetPRI().RoomMemberID);
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x1F1
        }
    }
}

function EscClose()
{
    return;
}

function NavigateBack()
{
    CloseScoreboard();
    super.NavigateBack();
    return;
}

defaultproperties
{
    SBScale=0.8
    ScoreboardTitle="<?int?dnWindow.UDukeSceneMultiPlayerScoreboard.ScoreboardTitle?>"
    mapNamePrefix="<?int?dnWindow.UDukeSceneMultiPlayerScoreboard.mapNamePrefix?>"
    MutatorNamePrefix="<?int?dnWindow.UDukeSceneMultiPlayerScoreboard.MutatorNamePrefix?>"
    timeLimitStr="<?int?dnWindow.UDukeSceneMultiPlayerScoreboard.timeLimitStr?>"
    FilmGrainMaterial=none
    bNoLogo=true
    bNoBackground=true
    bNoLines=true
    SoundMenuAmbience=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=(none),SlotPriority=0,VolumePrefab=0,Slots=(25),Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=false,bNoFilter=true,bNoOcclude=true,bNoAIHear=false,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    bIgnoreAllInputs=true
}