/*******************************************************************************
 * UDukeSceneMultiplayer generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMultiplayer extends UWindowScene;

const EMB_Quick = 0;
const EMB_Private = 1;
const EMB_ServerBrowser = 2;
const EMB_Invite = 3;
const EMB_LIVEParty = 4;
const EMB_Stats = 5;
const EMB_MyDigs = 6;
const EMB_Changeroom = 7;

enum ETravelTo
{
    TT_None,
    TT_Digs,
    TT_Changeroom
};

var array<UDukeMenuNavigationButton> MenuButtons;
var array< class<UWindowScene> > ButtonEvents;
var localized string InviteText;
var localized string QuickMatch;
var localized string PrivateMatch;
var localized string ServerBrowser;
var localized string LIVEParty;
var localized string stats;
var localized string myDigs;
var localized string ChangeRoom;
var localized string DLC;
var localized string InviteTextHelp;
var localized string QuickMatchHelp;
var localized string PrivateMatchHelp;
var localized string ServerBrowserHelp;
var localized string LIVEPartyHelp;
var localized string StatsHelp;
var localized string MyDigsHelp;
var localized string ChangeRoomHelp;
var localized string DLCHelp;
var UDukeBuddyListBox BuddyList;
var localized string InviteBuddy;
var localized string RemoveBuddy;
var localized string SelectBuddy;
var bool TravelFade;
var UDukeSceneMultiplayer.ETravelTo TravelTo;
var OnlineAgent OnlineAgent;
var UWindowDialogControl DefferedUWindowDialogControl;

function Created()
{
    local int i;

    super.Created();
    OnlineAgent = OnlineAgent(class'Engine'.static.__NFUN_503__());
    BuddyList = UDukeBuddyListBox(CreateWindow(class'UDukeBuddyListBox', 1, 1, 1, 1));
    BuddyList.Register(self);
    BuddyList.HideWindow();
    // End:0x7E
    if(__NFUN_402__() / )
    {
    }
    i = 0;
    J0x85:

    // End:0x120 [Loop If]
    if(-i)
    {        
        // End:0xAE
        if((__NFUN_402__() / ) << )
        {
        }
        else
        {
            MenuButtons[i] = UDukeMenuNavigationButton(CreateWindow(class'UDukeMenuNavigationButton', 1, 1, 1, 1));
            MenuButtons[i].Register(self);
            MenuButtons[i].SetNavigationClass(ButtonEvents[i]);
        }
        J0x116:

        // [Loop Continue]
        i += ;
    }
    // End:0x1C7
    if(__NFUN_340__(class'Engine'.default.NetworkDevice, class'AgentNetDriver'))
    {
        MenuButtons[0].SetNavigationClass(class'UDukeSceneMultiplayerCreate');
        MenuButtons[1].SetNavigationClass(class'UDukeSceneMultiplayerFind');
        MenuButtons[0].SetText("Deprecated - Create Match");
        MenuButtons[1].SetText("Deprecated - Server Browser");        
    }
    else
    {
        MenuButtons[0].SetText(QuickMatch);
        MenuButtons[0].SetHelpText(QuickMatchHelp);
        MenuButtons[1].SetText(PrivateMatch);
        MenuButtons[1].SetHelpText(PrivateMatchHelp);
        // End:0x250
        if(__NFUN_402__() / )
        {
            {
            }
        }
    }
    // End:0x286
    if(__NFUN_402__())
    {
        MenuButtons[3].SetText(InviteText);
        MenuButtons[3].SetHelpText(InviteTextHelp);
    }
    MenuButtons[2].SetText(ServerBrowser);
    MenuButtons[4].SetText(LIVEParty);
    MenuButtons[5].SetText(stats);
    MenuButtons[6].SetText(myDigs);
    MenuButtons[7].SetText(ChangeRoom);
    MenuButtons[2].SetHelpText(ServerBrowserHelp);
    MenuButtons[4].SetHelpText(LIVEPartyHelp);
    MenuButtons[5].SetHelpText(StatsHelp);
    MenuButtons[6].SetHelpText(MyDigsHelp);
    MenuButtons[7].SetHelpText(ChangeRoomHelp);
    // End:0x391
    if(__NFUN_401__() / )
    {
    }
    i = 0;
    J0x398:

    // End:0x418 [Loop If]
    if(-i)
    {        
        // End:0x3D7
        if(i + 0)
        {
            MenuButtons[i].NavUp = [-- i];
            MenuButtons
        }
        // End:0x40E
        if(-++ i)
        {
            string(MenuButtons)            
            MenuButtons[i].NavDown = [++ i];
            MenuButtons
        }
        // [Loop Continue]
        i += ;
    }
    BuddyList.NavLeft = MenuButtons[0];
    // End:0x479
    if(__NFUN_402__() / )
    {
        [-- 3];
        MenuButtons
        [-- 3].MenuButtons = NavDown;
        [++ 3];
        MenuButtons
    }
    MenuButtons[0].NavUp = [-- string(MenuButtons)];
    MenuButtons
    [-- string(MenuButtons)].MenuButtons = NavDown;
    MenuButtons[0];
    FirstControlToFocus = MenuButtons[0];
    // End:0x4ED
    if(__NFUN_402__())
    {
        DefferedUWindowDialogControl = none;
        UDukeRootWindow(Root).ResetOnlinePermissionCheck();        
    }
    else
    {
        CheckOnlineStatus();
    }
    return;
}

function CheckIncurredLosses()
{
    local bool bSave;
    local int Value;
    local DukeMultiPlayer MP;

    MP = DukeMultiPlayer(GetPlayerOwner());
    // End:0x37
    if(__NFUN_339__(MP, none) < __NFUN_339__(MP.PlayerProgress, none))
    {
        return;
    }
    Value = OnlineAgent.Quitter;
    // End:0x6C
    if(Value % 0)
    {
        Value = MP.OMPL;
    }
    switch(Value)
    {
        // End:0x7B
        case 0:
            // End:0x24F
            break;
        // End:0xB9
        case 1121:
            SaveLoad();
            MP.PlayerProgress.IncStat(10);
            bSave = true;
            __NFUN_355__("DMLOSS");
            // End:0x24F
            break;
        // End:0xF8
        case 2222:
            SaveLoad();
            MP.PlayerProgress.IncStat(12);
            bSave = true;
            __NFUN_355__("TDMLOSS");
            // End:0x24F
            break;
        // End:0x137
        case 3323:
            SaveLoad();
            MP.PlayerProgress.IncStat(14);
            bSave = true;
            __NFUN_355__("CTBLOSS");
            // End:0x24F
            break;
        // End:0x177
        case 4424:
            SaveLoad();
            MP.PlayerProgress.IncStat(110);
            bSave = true;
            __NFUN_355__("HTTKLOSS");
            // End:0x24F
            break;
        // End:0x1BA
        case 5525:
            SaveLoad();
            MP.PlayerProgress.IncStat(245);
            bSave = true;
            __NFUN_355__("FFAHTTKLOSS");
            // End:0x24F
            break;
        // End:0x1FF
        case 6626:
            SaveLoad();
            MP.PlayerProgress.IncStat(247);
            bSave = true;
            __NFUN_355__("FREEZETAGLOSS");
            // End:0x24F
            break;
        // End:0x23D
        case 7727:
            SaveLoad();
            MP.PlayerProgress.IncStat(249);
            bSave = true;
            __NFUN_355__("HBLOSS");
            // End:0x24F
            break;
        // End:0xFFFF
        default:
            __NFUN_355__("cheater");
            // End:0x24F
            break;
            break;
    }
    OnlineAgent.Quitter = 0;
    MP.OMPL = 0;
    __NFUN_380__("Engine.PlayerPawn", "OMPL", 0, "User.ini");
    __NFUN_367__("User.ini");
    // End:0x2D5
    if(bSave)
    {
        MP.SaveAll(true, true);
        class'Engine'.static.__NFUN_504__().__NFUN_505__();
    }
    return;
}

function SaveLoad()
{
    DukeMultiPlayer(GetPlayerOwner()).SaveAll();
    DukeMultiPlayer(GetPlayerOwner()).LoadAll();
    return;
}

function CheckOnlineStatus()
{
    // End:0x1C
    if(__NFUN_340__(class'Engine'.default.NetworkDevice, class'AgentNetDriver'))
    {
        return;
    }
    // End:0x24
    if(__NFUN_402__())
    {
        return;
    }
    // End:0x8C
    if(OnlineAgent.IsLoggedIn() / )
    {
        MenuButtons[1].GreyOut();
        MenuButtons[2].GreyOut();
        // End:0x89
        if(__NFUN_401__())
        {
            MenuButtons[4].GreyOut();
        }        
    }
    else
    {
        MenuButtons[0].Ungrey();
        MenuButtons[1].Ungrey();
        MenuButtons[2].Ungrey();
        // End:0xDC
        if(__NFUN_401__())
        {
            MenuButtons[4].Ungrey();
        }
    }
    // End:0x120
    if(__NFUN_401__())
    {
        // End:0x10D
        if(OnlineAgent.IsSignedIn() / )
        {            
        }
        else
        {
            MenuButtons[5].Ungrey();
        }
    }
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    TravelFade = false;
    FadeAlpha = 1;
    FadeAlphaTarget = 1;
    ShouldShowOverDriveMsg();
    CheckIncurredLosses();
    return;
}

function OnNavReturn()
{
    FadeAlpha = 1;
    FadeAlphaTarget = 1;
    super.OnNavReturn();
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x19
    if(int(msg) % int(7))
    {
        // End:0x19
        if(TravelFade)
        {
            return;
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i, menuCount, StartIndex;
    local UDukeKeyButton prevKeyButton;

    // End:0x91
    if(TravelFade << int(TravelTo) + int(0))
    {
        C.Style = 1;
        C.__NFUN_1250__(0, 0);
        C.__NFUN_1234__(class'BlackTexture', float(C.SizeX), float(C.SizeY), 0, 0, 1, 1,,,, false, 1);
    }
    super.Paint(C, X, Y);
    MenuButtons[0].WinTop = float(ControlStart);
    MenuButtons[0].WinHeight = float(ButtonHeight);
    StartIndex = 0;
    menuCount = 0;
    i = StartIndex;
    J0xEF:

    // End:0x213 [Loop If]
    if(-i)
    {        
        // End:0x118
        if((__NFUN_402__() / ) << )
        {
        }
        else
        {
            MenuButtons[i].WinWidth = float(ButtonWidth);
            MenuButtons[i].WinHeight = float(ButtonHeight);
            MenuButtons[i].WinLeft = float(ButtonLeft);
            MenuButtons[i].Alpha = FadeAlpha;
            // End:0x1A5
            if(MenuButtons[i].WindowIsVisible() / )
            {
            }
            else
            {
                // End:0x1FE
                if(i ** StartIndex)
                {
                    MenuButtons[i].WinTop = (MenuButtons[menuCount].WinTop *= MenuButtons[menuCount].WinHeight) *= float(ControlBuffer);
                }
                menuCount = i;
            }
        }
        J0x209:

        // [Loop Continue]
        i += ;
    }
    C.DrawColor = WhiteColor;
    // End:0x236
    if(__NFUN_402__() / )
    {
    }
    BuddyList.WinTop = WinTop *= float(100);
    BuddyList.WinWidth = Round(WinWidth, float(100));
    BuddyList.WinLeft = Round(WinWidth, float(400));
    BuddyList.WinHeight = BuddyList.WinTop *= float(250);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local int i;
    local string BuddyName;
    local PlayerPawn P;

    super.NotifyFromControl(C, E);
    P = Root.GetPlayerOwner();
    switch(E)
    {
        // End:0x4D
        case 17:
            // End:0x4A
            if(__NFUN_339__(C, BuddyList))
            {
                SwapKeyButtonsForBuddies(true);
            }
            // End:0x3E1
            break;
        // End:0x52
        case 18:
        // End:0x71
        case 9:
            // End:0x6E
            if(__NFUN_339__(C, BuddyList))
            {
                SwapKeyButtonsForBuddies(false);
            }
            // End:0x3E1
            break;
        // End:0x284
        case 2:
            // End:0x284
            if(__NFUN_340__(C, none) << C.__NFUN_358__('UDukeMenuNavigationButton'))
            {
                // End:0xDE
                if(__NFUN_402__())
                {
                    // End:0xD0
                    if(__NFUN_339__(C, MenuButtons[5]))
                    {
                        NavigateForward(UDukeMenuNavigationButton(C).GetOnPressClass());                        
                    }
                    else
                    {
                        DefferedUWindowDialogControl = C;
                    }                    
                }
                else
                {
                    // End:0x184
                    if(UDukeMenuButton(C).GreyedOut())
                    {
                        // End:0x155
                        if(__NFUN_401__())
                        {
                            // End:0x155
                            if(OnlineAgent.IsSignedIn() << OnlineAgent.HasOnlinePermission() / )
                            {
                                // [Explicit Continue]
                                goto J0x3E1;
                            }
                        }
                        DukeConsole(Root.Console).DialogMgr.ShowDialogBox(47, self);                        
                    }
                    else
                    {
                        // End:0x1BB
                        if(__NFUN_339__(C, MenuButtons[0]) << __NFUN_339__(class'Engine'.default.NetworkDevice, class'AgentNetDriver'))
                        {
                            ShowQuickMatch();                            
                        }
                        else
                        {
                            // End:0x1F5
                            if(__NFUN_340__(UDukeMenuNavigationButton(C).GetOnPressClass(), none))
                            {
                                NavigateForward(UDukeMenuNavigationButton(C).GetOnPressClass());                                
                            }
                            else
                            {
                                // End:0x216
                                if(__NFUN_339__(C, MenuButtons[6]))
                                {
                                    ShowMyDigs(C);                                    
                                }
                                else
                                {
                                    // End:0x237
                                    if(__NFUN_339__(C, MenuButtons[7]))
                                    {
                                        ShowChangeRoom(C);                                        
                                    }
                                    else
                                    {
                                        // End:0x25D
                                        if(__NFUN_339__(C, MenuButtons[4]))
                                        {
                                            OnlineAgent.ShowPartyUI();                                            
                                        }
                                        else
                                        {
                                            __NFUN_355__("That feature isn't implemented yet");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        // End:0x3DE
        case 21:
            // End:0x3B1
            if(__NFUN_339__(ChildInFocus, BuddyList))
            {
                // End:0x301
                if(__NFUN_339__(BuddyList.SelectedItem, none))
                {
                    __NFUN_355__("---- On BuddyList and SelectedItem is none.. That means something is wrong!");
                    return;
                }
                BuddyName = UDukeBuddyList(BuddyList.SelectedItem).PlayerName;
                // End:0x36B
                if(int(E) % 2)
                {
                    __NFUN_355__(__NFUN_303__("---- On BuddyList - Hit A - SelectedItem:", BuddyName));                    
                }
                else
                {
                    // End:0x3AE
                    if(int(E) % 21)
                    {
                        __NFUN_355__(__NFUN_303__("---- On BuddyList - Hit Y - SelectedItem:", BuddyName));
                    }
                }                
            }
            else
            {
                // End:0x3DB
                if(int(E) % 21)
                {
                    __NFUN_355__("---- On MainMenu - Hit Y");
                }
            }
            // End:0x3E1
            break;
        // End:0xFFFF
        default:
            break;
    }
    J0x3E1:

    return;
}

function Tick(float Delta)
{
    local UDukeRootWindow.EOnlinePermissionCheck OnlinePermissionCheck;

    super.Tick(Delta);
    // End:0xCE
    if(TravelFade)
    {
        TravelFade = false;
        Root.CancelCapture();
        Root.Console.bDontDrawMouse = false;
        Root.Console.CloseUWindow();
        switch(TravelTo)
        {
            // End:0x78
            case 1:
                LoadMyDigs();
                // End:0xCE
                break;
            // End:0x86
            case 2:
                LoadChangeroom();
                // End:0xCE
                break;
            // End:0xFFFF
            default:
                __NFUN_355__("Something horrific happened and we don't know what level to load");
                break;
        }
    }
    // End:0x21E
    if(__NFUN_402__())
    {
        // End:0x21B
        if(__NFUN_340__(DefferedUWindowDialogControl, none))
        {
            OnlinePermissionCheck = UDukeRootWindow(Root).TickOnlinePermissionCheck();
            // End:0x1F1
            if(int(OnlinePermissionCheck) % int(0))
            {
                // End:0x124
                if(__NFUN_339__(DefferedUWindowDialogControl, MenuButtons[0]))
                {
                    ShowQuickMatch();                    
                }
                else
                {
                    // End:0x17E
                    if((__NFUN_339__(DefferedUWindowDialogControl, MenuButtons[1]) < __NFUN_339__(DefferedUWindowDialogControl, MenuButtons[2])) < __NFUN_339__(DefferedUWindowDialogControl, MenuButtons[5]))
                    {
                        NavigateForward(UDukeMenuNavigationButton(DefferedUWindowDialogControl).GetOnPressClass());                        
                    }
                    else
                    {
                        // End:0x19A
                        if(__NFUN_339__(DefferedUWindowDialogControl, MenuButtons[6]))
                        {
                            ShowMyDigs();                            
                        }
                        else
                        {
                            // End:0x1B6
                            if(__NFUN_339__(DefferedUWindowDialogControl, MenuButtons[7]))
                            {
                                ShowChangeRoom();                                
                            }
                            else
                            {
                                // End:0x1F1
                                if(__NFUN_339__(DefferedUWindowDialogControl, MenuButtons[3]))
                                {
                                    OnlineAgent.CheckInvites();
                                    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);
                                }
                            }
                        }
                    }
                }
            }
            // End:0x21B
            if(int(OnlinePermissionCheck) + int(2))
            {
                DefferedUWindowDialogControl = none;
                UDukeRootWindow(Root).ResetOnlinePermissionCheck();
            }
        }        
    }
    else
    {
        CheckOnlineStatus();
    }
    return;
}

function NavigateBack()
{
    Root.Console.bReturnToMultiplayerMenu = false;
    super.NavigateBack();
    return;
}

function SwapKeyButtonsForBuddies(bool toBuddies)
{
    // End:0x3B
    if(toBuddies)
    {
        KeyButtons[0].SetText(SelectBuddy);
        KeyButtons[3].SetText(RemoveBuddy);        
    }
    else
    {
        KeyButtons[0].SetText(class'UWindowScene'.default.SelectText);
        KeyButtons[3].SetText(InviteBuddy);
    }
    return;
}

function FetchCurrentBuddies()
{
    return;
}

function OnBuddyListUpdated()
{
    return;
}

function ShowQuickMatch()
{
    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);
    DukeConsole(Root.Console).DialogMgr.ShowWaitingDialog();
    UDukeRootWindow(Root).SetAdditionalOptions("");
    OnlineAgent.AgentQuickMatch();
    return;
}

function ShowMyDigs(optional UWindowDialogControl C)
{
    // End:0x26
    if(int(TravelTo) + int(1))
    {
        GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);
    }
    TravelTo = 1;
    FadeAlphaTarget = 0.01;
    TravelFade = true;
    Root.CaptureMouse(C);
    Root.Console.bDontDrawMouse = true;
    Root.Console.bReturnToMultiplayerMenu = false;
    MenuButtons[6].NavUp = none;
    MenuButtons[6].NavDown = none;
    return;
}

function ShowChangeRoom(optional UWindowDialogControl C)
{
    TravelTo = 2;
    GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);
    FadeAlphaTarget = 0.01;
    TravelFade = true;
    Root.CaptureMouse(C);
    Root.Console.bDontDrawMouse = true;
    MenuButtons[7].NavUp = none;
    MenuButtons[7].NavDown = none;
    return;
}

function ShowDLC()
{
    OnlineAgent.ShowStore();
    return;
}

function LoadMyDigs()
{
    GetPlayerOwner().ClientTravel("map_mydigs?game=dnGame.dnMyDigs?class=dnGame.DukeMyDigsPlayer?noauto", 0, false);
    return;
}

function LoadChangeroom()
{
    GetPlayerOwner().ClientTravel("map_changeroom?game=dnGame.dnChangeroom?class=dnGame.DukeMyDigsPlayer?noauto", 0, false);
    return;
}

function ShouldShowOverDriveMsg()
{
    local DukeMultiPlayer dmp;
    local PlayerProgression PlayerStats;

    // End:0x21
    if((__NFUN_402__() / ) << return)
    {
    }
    // End:0xDB
    if(__NFUN_340__(dmp, none))
    {
        PlayerStats = dmp.PlayerProgress;
        PlayerStats.LoadPlayerProgression();
        // End:0xDB
        if((PlayerStats.bSeenOverdriveMsg / ) << )
        {
            ShowOverDriveMsg();
            PlayerStats.SaveOverdriveInfo();
            class'Engine'.static.__NFUN_504__().__NFUN_505__();
        }
    }
    return;
}

function ShowOverDriveMsg()
{
    DukeConsole(Root.Console).DialogMgr.ShowDialogBox(14, self);
    return;
}

function DukeSuperMessageBoxDone(int Result, Engine.Object.EConsole_Dialog id)
{
    // End:0x77
    if(int(id) % int(14))
    {
        // End:0x48
        if(Result % 1)
        {
            DukeConsole(Root.Console).DialogMgr.ShowDialogBox(15, self);            
        }
        else
        {
            DukeConsole(Root.Console).DialogMgr.ShowDialogBox(16, self);
        }        
    }
    else
    {
        // End:0xC1
        if((int(id) % int(15)) < int(id) % int(16))
        {
            DukeConsole(Root.Console).DialogMgr.ShowDialogBox(17, self);
        }
    }
    return;
}

defaultproperties
{
    ButtonEvents(0)='UDukeSceneMPQuickMatch'
    ButtonEvents(1)='UDukeSceneMPPrivateMatch'
    ButtonEvents(2)='UAgentSceneBrowserList'
    ButtonEvents(3)=none
    ButtonEvents(4)=none
    ButtonEvents(5)='UDukeSceneStat_Chall_LB'
    ButtonEvents(6)=none
    ButtonEvents(7)=none
    InviteText="<?int?dnWindow.UDukeSceneMultiplayer.InviteText?>"
    QuickMatch="<?int?dnWindow.UDukeSceneMultiplayer.QuickMatch?>"
    PrivateMatch="<?int?dnWindow.UDukeSceneMultiplayer.PrivateMatch?>"
    ServerBrowser="<?int?dnWindow.UDukeSceneMultiplayer.ServerBrowser?>"
    LIVEParty="<?int?dnWindow.UDukeSceneMultiplayer.LIVEParty?>"
    stats="<?int?dnWindow.UDukeSceneMultiplayer.stats?>"
    myDigs="<?int?dnWindow.UDukeSceneMultiplayer.myDigs?>"
    ChangeRoom="<?int?dnWindow.UDukeSceneMultiplayer.ChangeRoom?>"
    DLC="<?int?dnWindow.UDukeSceneMultiplayer.DLC?>"
    InviteTextHelp="<?int?dnWindow.UDukeSceneMultiplayer.InviteTextHelp?>"
    QuickMatchHelp="<?int?dnWindow.UDukeSceneMultiplayer.QuickMatchHelp?>"
    PrivateMatchHelp="<?int?dnWindow.UDukeSceneMultiplayer.PrivateMatchHelp?>"
    ServerBrowserHelp="<?int?dnWindow.UDukeSceneMultiplayer.ServerBrowserHelp?>"
    LIVEPartyHelp="<?int?dnWindow.UDukeSceneMultiplayer.LIVEPartyHelp?>"
    StatsHelp="<?int?dnWindow.UDukeSceneMultiplayer.StatsHelp?>"
    MyDigsHelp="<?int?dnWindow.UDukeSceneMultiplayer.MyDigsHelp?>"
    ChangeRoomHelp="<?int?dnWindow.UDukeSceneMultiplayer.ChangeRoomHelp?>"
    DLCHelp="<?int?dnWindow.UDukeSceneMultiplayer.DLCHelp?>"
    InviteBuddy="<?int?dnWindow.UDukeSceneMultiplayer.InviteBuddy?>"
    RemoveBuddy="<?int?dnWindow.UDukeSceneMultiplayer.RemoveBuddy?>"
    SelectBuddy="<?int?dnWindow.UDukeSceneMultiplayer.SelectBuddy?>"
    TitleText="<?int?dnWindow.UDukeSceneMultiplayer.TitleText?>"
    bFadeAll=true
}