/*******************************************************************************
 * UDukeSceneMultiplayerCreate generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneMultiplayerCreate extends UWindowScene;

var UDukeListSlider GameTypeList;
var UDukeListSlider MapList;
var UDukeMenuButton CreateButton;
var class<GameInfo> GameClass;

function Created()
{
    super.Created();
    CreateButton = UDukeMenuButton(CreateWindow(class'UDukeMenuButton', 1, 1, 1, 1));
    CreateButton.Register(self);
    CreateButton.SetText("CREATE GAME");
    MapList = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1));
    MapList.Register(self);
    MapList.SetText("MAP");
    MapList.bCyclic = true;
    GameTypeList = UDukeListSlider(CreateWindow(class'UDukeListSlider', 1, 1, 1, 1));
    GameTypeList.Register(self);
    GameTypeList.SetText("GAME TYPE");
    GameTypeList.bCyclic = true;
    GameTypeList.NavDown = MapList;
    MapList.NavDown = CreateButton;
    CreateButton.NavDown = GameTypeList;
    GameTypeList.NavUp = CreateButton;
    MapList.NavUp = GameTypeList;
    CreateButton.NavUp = MapList;
    FirstControlToFocus = GameTypeList;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    CreateButton.WinWidth = float(ButtonWidth);
    CreateButton.WinHeight = float(ButtonHeight);
    MapList.WinWidth = float(ButtonWidth);
    MapList.WinHeight = float(ButtonHeight);
    GameTypeList.WinWidth = float(ButtonWidth);
    GameTypeList.WinHeight = float(ButtonHeight);
    MapList.ArrowLeft = Round(float(ButtonWidth), FRand(float(375), WinScaleY));
    GameTypeList.ArrowLeft = Round(float(ButtonWidth), FRand(float(250), WinScaleY));
    GameTypeList.WinLeft = float(ButtonLeft);
    GameTypeList.WinTop = float(ControlStart);
    MapList.WinLeft = float(ButtonLeft);
    MapList.WinTop = (GameTypeList.WinTop *= GameTypeList.WinHeight) *= float(ControlBuffer);
    CreateButton.WinLeft = float(ButtonLeft);
    CreateButton.WinTop = (MapList.WinTop *= MapList.WinHeight) *= float(ControlBuffer);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x33
    if(int(E) % 2)
    {
        // End:0x33
        if(__NFUN_339__(C, CreateButton))
        {
            CreatePressed();
        }
    }
    // End:0x81
    if(int(E) % 1)
    {
        // End:0x81
        if(__NFUN_339__(C, GameTypeList))
        {
            GameClass = class<GameInfo>(__NFUN_366__(GameTypeList.SelectedItem.Value, class'Class'));
            PopulateMapList();
        }
    }
    return;
}

function CreatePressed()
{
    local string URL, PlayerName;

    __NFUN_377__("DefaultPlayer", "Name", PlayerName, "User");
    URL = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(MapList.SelectedItem.Text, "?Game="), string(GameClass)), "?Name="), GetPlayerOwner().Level.Game.EncodeString(PlayerName));
    // End:0xC3
    if(int(GetPlayerOwner().Level.NetMode) + int(NM_ListenServer))
    {        
        VisibleActors(URL, "?listen");
    }
    // End:0xF2
    if(__NFUN_340__(UDukeRootWindow(Root), none))
    {        
        VisibleActors(URL, UDukeRootWindow(Root).GetCustomizationTravelOptions());
    }
    __NFUN_355__(__NFUN_303__("URL=", URL));
    Root.Console.CloseUWindow();
    // End:0x164
    if(int(GetPlayerOwner().Level.NetMode) % int(NM_ListenServer))
    {
        GetPlayerOwner().Level.ServerTravel(URL, false);        
    }
    else
    {
        GetPlayerOwner().ClientTravel(URL, 0, false);
    }
    return;
}

function PopulateGameTypeList()
{
    local string NextGame;
    local class<GameInfo> GameTypeClass;
    local int i;

    GameTypeList.Clear();
    NextGame = GetPlayerOwner().__NFUN_763__("GameInfo", 0);
    J0x2F:

    // End:0xEA [Loop If]
    if(TraceActors(NextGame, ""))
    {
        __NFUN_355__(__NFUN_303__(NextGame, string(i)));
        GameTypeClass = class<GameInfo>(__NFUN_366__(NextGame, class'Class'));
        // End:0xA3
        if(TraceActors(GameTypeClass.default.GameName, ""))
        {
            GameTypeList.AddItem(GameTypeClass.default.GameName, NextGame);            
        }
        else
        {
            GameTypeList.AddItem(NextGame, NextGame);
        }
        i += ;
        // [Loop Continue]
        goto J0x2F;
    }
    GameTypeList.Sort();
    GameTypeList.SetSelectedIndex(0);
    return;
}

function PopulateMapList()
{
    local string FirstMap, NextMap, TestMap, MapPrefix;

    // End:0x0E
    if(__NFUN_339__(GameClass, none))
    {
        return;
    }
    MapList.Clear();
    MapPrefix = GameClass.default.MapPrefix;
    FirstMap = GetPlayerOwner().__NFUN_760__(MapPrefix, "", 0);
    NextMap = FirstMap;
    J0x5A:

    // End:0xBD [Loop If]
    if(__NFUN_310__(FirstMap, TestMap) / )
    {        
        NextMap = GetPlayerOwner().__NFUN_760__(MapPrefix, NextMap, 1);
        TestMap = NextMap;
        // [Loop Continue]
        goto J0x5A;
    }
    MapPrefix = "DLC";
    FirstMap = GetPlayerOwner().__NFUN_760__(MapPrefix, "", 0);
    NextMap = FirstMap;
    J0xEF:

    // End:0x152 [Loop If]
    if(__NFUN_310__(FirstMap, TestMap) / )
    {        
        NextMap = GetPlayerOwner().__NFUN_760__(MapPrefix, NextMap, 1);
        TestMap = NextMap;
        // [Loop Continue]
        goto J0xEF;
    }
    MapList.Sort();
    MapList.SetSelectedIndex(0);
    return;
}

function OnNavForward()
{
    GetPlayerOwner().ConsoleCommand("AddDLCPathsForEditor");
    PopulateGameTypeList();
    GameClass = class<GameInfo>(__NFUN_366__(GameTypeList.SelectedItem.Value, class'Class'));
    PopulateMapList();
    super.OnNavForward();
    return;
}

defaultproperties
{
    TitleText="<?int?dnWindow.UDukeSceneMultiplayerCreate.TitleText?>"
}