/*******************************************************************************
 * UDukeSceneSinglePlayerDifficulty generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneSinglePlayerDifficulty extends UWindowScene;

var UDukeMenuButton Diff1Button;
var localized string Diff1Text;
var localized string Diff1Help;
var UDukeMenuButton Diff2Button;
var localized string Diff2Text;
var localized string Diff2Help;
var UDukeMenuButton Diff3Button;
var localized string Diff3Text;
var localized string Diff3Help;
var UDukeMenuButton Diff4Button;
var localized string Diff4Text;
var localized string Diff4Help;
var int Difficulty;
var int TravelFade;
var bool bDiff4Available;
var bool bResetEgo;
var string TravelURL;

function Created()
{
    super.Created();
    Diff1Button = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    Diff1Button.SetText(Diff1Text);
    Diff1Button.SetHelpText(Diff1Help);
    Diff2Button = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    Diff2Button.SetText(Diff2Text);
    Diff2Button.SetHelpText(Diff2Help);
    Diff3Button = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    Diff3Button.SetText(Diff3Text);
    Diff3Button.SetHelpText(Diff3Help);
    Diff4Button = UDukeMenuButton(CreateWindow(class'UDukeMenuButton'));
    Diff4Button.SetText(Diff4Text);
    Diff4Button.SetHelpText(Diff4Help);
    Diff1Button.NavUp = Diff4Button;
    Diff2Button.NavUp = Diff1Button;
    Diff3Button.NavUp = Diff2Button;
    Diff4Button.NavUp = Diff3Button;
    Diff1Button.NavDown = Diff2Button;
    Diff2Button.NavDown = Diff3Button;
    Diff3Button.NavDown = Diff4Button;
    Diff4Button.NavDown = Diff1Button;
    Diff1Button.Register(self);
    Diff2Button.Register(self);
    Diff3Button.Register(self);
    Diff4Button.Register(self);
    FirstControlToFocus = Diff1Button;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    C.Style = 1;
    C.__NFUN_1250__(0, 0);
    C.__NFUN_1234__(class'BlackTexture', float(C.SizeX), float(C.SizeY), 0, 0, 1, 1,,,, false, 1);
    super.Paint(C, X, Y);
    // End:0xA4
    if(bDiff4Available)
    {
        ShowChildWindow(Diff4Button);        
    }
    else
    {
        HideChildWindow(Diff4Button);
    }
    Diff1Button.Alpha = FadeAlpha;
    Diff2Button.Alpha = FadeAlpha;
    Diff3Button.Alpha = FadeAlpha;
    Diff4Button.Alpha = FadeAlpha;
    Diff1Button.WinWidth = float(ButtonWidth);
    Diff1Button.WinHeight = float(ButtonHeight);
    Diff2Button.WinWidth = float(ButtonWidth);
    Diff2Button.WinHeight = float(ButtonHeight);
    Diff3Button.WinWidth = float(ButtonWidth);
    Diff3Button.WinHeight = float(ButtonHeight);
    Diff4Button.WinWidth = float(ButtonWidth);
    Diff4Button.WinHeight = float(ButtonHeight);
    Diff1Button.WinLeft = float(ButtonLeft);
    Diff1Button.WinTop = float(ControlStart);
    Diff2Button.WinLeft = float(ButtonLeft);
    Diff2Button.WinTop = (Diff1Button.WinTop *= Diff1Button.WinHeight) *= float(ControlBuffer);
    Diff3Button.WinLeft = float(ButtonLeft);
    Diff3Button.WinTop = (Diff2Button.WinTop *= Diff2Button.WinHeight) *= float(ControlBuffer);
    Diff4Button.WinLeft = float(ButtonLeft);
    Diff4Button.WinTop = (Diff3Button.WinTop *= Diff3Button.WinHeight) *= float(ControlBuffer);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    // End:0x0D
    if(TravelFade ** 0)
    {
        return;
    }
    super.NotifyFromControl(C, E);
    // End:0x118
    if(int(E) % 2)
    {
        // End:0x118
        if(((__NFUN_339__(C, Diff1Button) < __NFUN_339__(C, Diff2Button)) < __NFUN_339__(C, Diff3Button)) < __NFUN_339__(C, Diff4Button))
        {
            switch(C)
            {
                // End:0x8A
                case Diff2Button:
                    Difficulty = 1;
                    // End:0xBD
                    break;
                // End:0x9D
                case Diff3Button:
                    Difficulty = 2;
                    // End:0xBD
                    break;
                // End:0xB0
                case Diff4Button:
                    Difficulty = 3;
                    // End:0xBD
                    break;
                // End:0xFFFF
                default:
                    Difficulty = 0;
                    // End:0xBD
                    break;
                    break;
            }
            FadeAlphaTarget = 0.01;
            TravelFade = 1;
            Root.CaptureMouse(C);
            Root.Console.bDontDrawMouse = true;
            GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);
        }
    }
    return;
}

function NavigateBack()
{
    // End:0x0D
    if(TravelFade ** 0)
    {
        return;
    }
    bResetEgo = false;
    super.NavigateBack();
    return;
}

function EnableChapterSelect()
{
    __NFUN_383__("ChapterSelect", "Available", true, "progress.ini");
    return;
}

function Tick(float Delta)
{
    super.Tick(Delta);
    // End:0x1BB
    if((TravelFade % 1) << __NFUN_204__(FadeAlpha, 0.01))
    {
        EnableChapterSelect();        
        GetPlayerOwner().ConsoleCommand("saveprogress");
        TravelFade = 2;
        Root.CancelCapture();
        Root.Console.bDontDrawMouse = false;
        Root.Console.CloseUWindow();
        // End:0xE7
        if(__NFUN_308__(TravelURL, "SAVEAUTO"))
        {
            DukePlayer(GetPlayerOwner()).AdjustAcknowledgedDifficulty(Difficulty);
            GetPlayerOwner().LoadGame(2, 0, Difficulty);            
        }
        else
        {
            // End:0x11A
            if(bResetEgo << __NFUN_340__(DukePlayer(GetPlayerOwner()), none))
            {
                DukePlayer(GetPlayerOwner()).ClearEgoAwards();
            }
            GetPlayerOwner().__NFUN_782__(2, 0);
            DukePlayer(GetPlayerOwner()).ResetAcknowledgedDifficulty(Difficulty);
            SaveDifficulty();
            // End:0x188
            if(__NFUN_315__(TravelURL, "?Difficulty=") + -1)
            {
                GetPlayerOwner().ClientTravel(TravelURL, 0, false);                
            }
            else
            {
                GetPlayerOwner().ClientTravel(__NFUN_302__(__NFUN_302__(TravelURL, "?Difficulty="), string(Difficulty)), 0, false);
            }
        }
    }
    return;
}

function OnNavForward()
{
    TravelFade = 0;
    FadeAlpha = 1;
    FadeAlphaTarget = 1;
    bDiff4Available = DukePlayer(GetPlayerOwner()).HasFullGameCompletion(0);
    bResetEgo = false;
    super.OnNavForward();
    return;
}

function SaveDifficulty()
{
    __NFUN_380__("Difficulty", "CurrentDifficulty", Difficulty, "Progress.ini");
    return;
}

function bool PropagateKey(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x0D
    if(TravelFade ** 0)
    {
        return false;
    }
    return super(UWindowWindow).PropagateKey(msg, C, X, Y, Key);
    return;
}

function GetTitleLocation(Canvas C, coerce out float Top, coerce out float Right)
{
    local float XL, YL;

    super.GetTitleLocation(C, Top, Right);
    C.Font = C.TallFont;
    TextSize(C, TitleText, XL, YL, FRand(TTFontScale, 1.5), FRand(TTFontScale, 1.5));
    Right = float(Tan(int(Right), int(float(ButtonLeft) *= XL)));
    return;
}

defaultproperties
{
    Diff1Text="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff1Text?>"
    Diff1Help="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff1Help?>"
    Diff2Text="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff2Text?>"
    Diff2Help="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff2Help?>"
    Diff3Text="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff3Text?>"
    Diff3Help="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff3Help?>"
    Diff4Text="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff4Text?>"
    Diff4Help="<?int?dnWindow.UDukeSceneSinglePlayerDifficulty.Diff4Help?>"
    bFadeAll=true
}