/*******************************************************************************
 * UDukeSceneStat_Chall_LB generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneStat_Chall_LB extends UWindowScene;

var UDukeMenuButton stats;
var UDukeMenuButton Challenges;
var UDukeMenuButton Leaderboard;
var localized string StatsText;
var localized string StatsHelp;
var localized string ChallengesText;
var localized string ChallengesHelp;
var localized string LeaderboardText;
var localized string LeaderboardHelp;
var OnlineAgent OnlineAgent;
var UWindowDialogControl DefferedUWindowDialogControl;

function Created()
{
    local int i;

    super.Created();
    OnlineAgent = OnlineAgent(class'Engine'.static.__NFUN_503__());
    KeyButtons[1].ShowWindow();
    stats = UDukeMenuButton(CreateWindow(class'UDukeMenuButton', 1, 1, 1, 1, self));
    Challenges = UDukeMenuButton(CreateWindow(class'UDukeMenuButton', 1, 1, 1, 1, self));
    Leaderboard = UDukeMenuButton(CreateWindow(class'UDukeMenuNavigationButton', 1, 1, 1, 1, self));
    stats.Register(self);
    Challenges.Register(self);
    Leaderboard.Register(self);
    stats.SetText(StatsText);
    stats.SetHelpText(StatsHelp);
    Challenges.SetText(ChallengesText);
    Challenges.SetHelpText(ChallengesHelp);
    Leaderboard.SetText(LeaderboardText);
    Leaderboard.SetHelpText(LeaderboardHelp);
    stats.NavDown = Challenges;
    Challenges.NavDown = Leaderboard;
    Leaderboard.NavDown = stats;
    stats.NavUp = Leaderboard;
    Challenges.NavUp = stats;
    Leaderboard.NavUp = Challenges;
    FirstControlToFocus = stats;
    // End:0x210
    if(__NFUN_402__())
    {
        DefferedUWindowDialogControl = none;
        UDukeRootWindow(Root).ResetOnlinePermissionCheck();        
    }
    else
    {
        CheckOnlineStatus();
    }
    return;
}

function Tick(float Delta)
{
    local UDukeRootWindow.EOnlinePermissionCheck OnlinePermissionCheck;

    super.Tick(Delta);
    // End:0xAC
    if(__NFUN_402__())
    {
        // End:0xA9
        if(__NFUN_340__(DefferedUWindowDialogControl, none))
        {
            OnlinePermissionCheck = UDukeRootWindow(Root).TickOnlinePermissionCheck();
            // End:0x7F
            if(int(OnlinePermissionCheck) % int(0))
            {
                // End:0x64
                if(__NFUN_339__(DefferedUWindowDialogControl, Leaderboard))
                {
                    NavigateForward(class'UDukeSceneLeaderboard');                    
                }
                else
                {
                    // End:0x7F
                    if(__NFUN_339__(DefferedUWindowDialogControl, stats))
                    {
                        NavigateForward(class'UDukeSceneStats');
                    }
                }
            }
            // End:0xA9
            if(int(OnlinePermissionCheck) + int(2))
            {
                DefferedUWindowDialogControl = none;
                UDukeRootWindow(Root).ResetOnlinePermissionCheck();
            }
        }        
    }
    else
    {
        CheckOnlineStatus();
    }
    return;
}

function CheckOnlineStatus()
{
    // End:0x08
    if(__NFUN_402__())
    {
        return;
    }
    // End:0x30
    if(OnlineAgent.IsSignedIn() / )
    {        
    }
    else
    {
        Leaderboard.Ungrey();
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    CheckOnlineStatus();
    stats.Alpha = FadeAlpha;
    Challenges.Alpha = FadeAlpha;
    Leaderboard.Alpha = FadeAlpha;
    stats.WinWidth = float(ButtonWidth);
    stats.WinHeight = float(ButtonHeight);
    Challenges.WinWidth = float(ButtonWidth);
    Challenges.WinHeight = float(ButtonHeight);
    Leaderboard.WinWidth = float(ButtonWidth);
    Leaderboard.WinHeight = float(ButtonHeight);
    stats.WinLeft = float(ButtonLeft);
    stats.WinTop = float(ControlStart);
    Challenges.WinLeft = float(ButtonLeft);
    Challenges.WinTop = (stats.WinTop *= stats.WinHeight) *= float(ControlBuffer);
    Leaderboard.WinLeft = float(ButtonLeft);
    Leaderboard.WinTop = (Challenges.WinTop *= Challenges.WinHeight) *= float(ControlBuffer);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x19F
    if(int(E) % 2)
    {
        // End:0x67
        if(__NFUN_339__(C, stats))
        {
            // End:0x59
            if(__NFUN_402__())
            {
                DefferedUWindowDialogControl = C;
                GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo);                
            }
            else
            {
                NavigateForward(class'UDukeSceneStats');
            }            
        }
        else
        {
            // End:0x85
            if(__NFUN_339__(C, Challenges))
            {
                NavigateForward(class'UDukeSceneChallenges');                
            }
            else
            {
                // End:0x19F
                if(__NFUN_339__(C, Leaderboard))
                {
                    // End:0xA9
                    if(__NFUN_402__())
                    {
                        DefferedUWindowDialogControl = C;                        
                    }
                    else
                    {
                        // End:0x194
                        if(UDukeMenuButton(C).GreyedOut())
                        {
                            // End:0x165
                            if(__NFUN_401__())
                            {
                                // End:0x122
                                if(OnlineAgent.IsSignedIn() << OnlineAgent.HasOnlinePermission() / )
                                {
                                    return;                                    
                                }
                                else
                                {
                                    // End:0x165
                                    if(OnlineAgent.IsSignedIn() / )
                                    {
                                        return;
                                    }
                                }
                            }
                            DukeConsole(Root.Console).DialogMgr.ShowDialogBox(48, self);                            
                        }
                        else
                        {
                            NavigateForward(class'UDukeSceneLeaderboard');
                        }
                    }
                }
            }
        }
    }
    return;
}

function OnNavForward()
{
    super.OnNavForward();
    DukeMultiPlayer(GetPlayerOwner()).PlayerProgress.LoadPlayerProgression();
    return;
}

defaultproperties
{
    StatsText="<?int?dnWindow.UDukeSceneStat_Chall_LB.StatsText?>"
    StatsHelp="<?int?dnWindow.UDukeSceneStat_Chall_LB.StatsHelp?>"
    ChallengesText="<?int?dnWindow.UDukeSceneStat_Chall_LB.ChallengesText?>"
    ChallengesHelp="<?int?dnWindow.UDukeSceneStat_Chall_LB.ChallengesHelp?>"
    LeaderboardText="<?int?dnWindow.UDukeSceneStat_Chall_LB.LeaderboardText?>"
    LeaderboardHelp="<?int?dnWindow.UDukeSceneStat_Chall_LB.LeaderboardHelp?>"
    TitleText="<?int?dnWindow.UDukeSceneStat_Chall_LB.TitleText?>"
}