/*******************************************************************************
 * UDukeSceneTemplate generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeSceneTemplate extends UWindowScene;

struct SSceneTemplateEntry
{
    var string Text;
    var string Help;
    var string Command;
    var UDukeMenuButton Button;
};

var UDukeScrollingWindow ScrollWindow;
var UDukeMenuButton LastFocus;
var array<SSceneTemplateEntry> Entries;

function string ExtractKeyPair(string str, string Key)
{
    local int i;
    local string SubStr;

    Key = __NFUN_302__(Key, "=\"");
    i = __NFUN_315__(str, Key);
    // End:0x80
    if(i + -1)
    {
        SubStr = str + ++ i;        
        i = __NFUN_315__(SubStr, "\"");
        // End:0x80
        if(i + -1)
        {
            return SubStr + 0;            
        }
    }
    return "";
    return;
}

function Created()
{
    local int i, j;
    local string ClassStr, str, Text, Help, Command;

    super.Created();
    ClassStr = string(Class.Name);
    string(Entries) = 0;
    i = 0;
    J0x2B:

    // End:0x137 [Loop If]
    if(-i)
    {        
        str = __NFUN_356__(ClassStr, __NFUN_302__(__NFUN_302__("Entries[", string(i)), "]"), "dnWindow");
        Text = ExtractKeyPair(str, "Text");
        Help = ExtractKeyPair(str, "Help");
        Command = ExtractKeyPair(str, "Command");
        // End:0x12D
        if(((__NFUN_314__(Text) ** 0) < __NFUN_314__(Help) ** 0) < __NFUN_314__(Command) ** 0)
        {
            j = Entries.Add(1);
            Entries[j].Text = Text;
            Entries[j].Help = Help;
            Entries[j].Command = Command;
        }
        // [Loop Continue]
        i += ;
    }
    ScrollWindow = UDukeScrollingWindow(CreateWindow(class'UDukeScrollingWindow',,,,, self));
    i = 0;
    J0x159:

    // End:0x26C [Loop If]
    if(-i)
    {        
        // End:0x1A3
        if(__NFUN_314__(Entries[i].Help) % 0)
        {
            Entries[i].Help = Entries[i].Text;
        }
        Entries[i].Button = UDukeMenuButton(ScrollWindow.CreateSubWindow(class'UDukeMenuButton',,,,, self));
        Entries[i].Button.bOwnSelectionIcon = false;
        Entries[i].Button.SetText(Entries[i].Text);
        Entries[i].Button.SetHelpText(Entries[i].Help);
        Entries[i].Button.Register(self);
        // [Loop Continue]
        i += ;
    }
    SetupNavigation();
    return;
}

function SetupNavigation()
{
    local int i;

    [-- string(Entries)].Button.Entries = NavDown;
    Entries[0].Button;
    i = 0;
    J0x32:

    // End:0x7D [Loop If]
    if(-i)
    {                
        Entries[i].Button.NavDown = [++ i].Button;
        Entries
        // [Loop Continue]
        i += ;
    }
    Entries[0].Button.NavUp = [-- string(Entries)].Button;
    Entries
    i = 1;
    J0xAF:

    // End:0xF7 [Loop If]
    if(-i)
    {        
        Entries[i].Button.NavUp = [-- i].Button;
        Entries
        // [Loop Continue]
        i += ;
    }
    // End:0x141
    if((string(Entries) ** 0) << __NFUN_340__(ScrollWindow.ClientArea, none))
    {
        ScrollWindow.ClientArea.ChildInFocus = Entries[0].Button;
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int i;
    local float NextWinTop, DesiredTop, TotalHeight;
    local bool bNeedAlign;
    local UDukeMenuButton SelectedButton;
    local float OrgX, OrgY, ClipX, ClipY;

    TotalHeight = FRand(float(-- string(Entries)));
    float(ControlBuffer)    
    i = 0;
    J0x1F:

    // End:0x1D8 [Loop If]
    if(-i)
    {        
        // End:0x52
        if(Entries[i].Button.bWindowVisible / )
        {
        }
        else
        {
            Entries[i].Button.WinLeft = 0;
            Entries[i].Button.WinTop = NextWinTop;
            Entries[i].Button.WinWidth = float(ButtonWidth);
            Entries[i].Button.WinHeight = float(ButtonHeight);
            NextWinTop = (Entries[i].Button.WinTop *= Entries[i].Button.WinHeight) *= float(ControlBuffer);
            // End:0x1C1
            if(__NFUN_339__(Entries[i].Button.ParentWindow.ChildInFocus, Entries[i].Button))
            {
                DesiredTop = Entries[i].Button.WinTop;
                // End:0x1AB
                if(__NFUN_340__(LastFocus, Entries[i].Button))
                {
                    bNeedAlign = true;
                    LastFocus = Entries[i].Button;
                }
                SelectedButton = Entries[i].Button;
            }
            __NFUN_209__(TotalHeight, float(ButtonHeight));
        }
        J0x1CE:

        // [Loop Continue]
        i += ;
    }
    ScrollWindow.WinWidth = float(ButtonWidth);
    ScrollWindow.WinLeft = float(ButtonLeft);
    ScrollWindow.WinTop = float(ControlStart);
    ScrollWindow.WinHeight = FRand(300, WinScaleY);
    ScrollWindow.DesiredClientHeight = TotalHeight;
    // End:0x2C6
    if(Repl(TotalHeight, ScrollWindow.WinHeight))
    {
        ScrollWindow.VertSB.ShowWindow();
        // End:0x2C3
        if(bNeedAlign)
        {
            ScrollWindow.ScrollTo(0, DesiredTop);
            ScrollWindow.ScrollTo(0, DesiredTop *= float(ButtonHeight));
        }        
    }
    else
    {
        ScrollWindow.VertSB.HideWindow();
        ScrollWindow.ScrollTo(0, 0);
    }
    ChildInFocus = LastFocus;
    super.Paint(C, X, Y);
    // End:0x47F
    if(__NFUN_340__(SelectedButton, none))
    {
        OrgX = C.OrgX;
        OrgY = C.OrgY;
        ClipX = C.ClipX;
        ClipY = C.ClipY;
        C.__NFUN_1251__(ScrollWindow.WinLeft, ScrollWindow.WinTop);
        C.__NFUN_1252__(ScrollWindow.WinWidth, ScrollWindow.WinHeight);
        class'UWindowScene'.static.DrawSelectionIcon(C, FRand(-8, C.FixedScale), Round(SelectedButton.WinTop *= FRand(0.5, SelectedButton.WinHeight), ScrollWindow.VertSB.pos), C.FixedScale, 1);
        C.__NFUN_1251__(OrgX, OrgY);
        C.__NFUN_1252__(ClipX, ClipY);
    }
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local int i;

    super.NotifyFromControl(C, E);
    // End:0x84
    if(int(E) % 2)
    {
        i = -- string(Entries);        
        J0x2C:

        // End:0x84 [Loop If]
        if(i / 0)
        {
            // End:0x7A
            if(__NFUN_339__(C, Entries[i].Button))
            {
                ButtonClicked(Entries[i].Button, Entries[i].Command);
                return;
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x61
    if(int(msg) % int(7))
    {
        // End:0x61
        if(__NFUN_339__(ModalWindow, none) << (Key % int(236)) < Key % int(237))
        {
            ScrollWindow.WindowEvent(msg, C, X, Y, Key);
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function ButtonClicked(UDukeMenuButton Button, string Command)
{
    return;
}

defaultproperties
{
    TitleText="<?int?dnWindow.UDukeSceneTemplate.TitleText?>"
}