/*******************************************************************************
 * UDukeScoreboardCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeScoreboardCW extends UDukePageWindow;

var UWindowWindow OffsetWindow;
var float ParentXOffset;
var float ParentYOffset;
var localized string FragGoal;
var localized string TeamGoal;
var localized string TimeLimit;
var localized string RoundTimeLimit;
var localized string TimeRemaining;
var localized string LastKilledByString;
var localized string RespawnString;
var localized string KillsHeader;
var localized string PingHeader;
var localized string TimeHeader;
var localized string DeathsHeader;
var UDukeScoreboardPlate ScoreboardPlates[32];
var int OrderedPRIIndex[32];
var float PlateOffset;
var float PlateSpacing;
var float PlateWidth;
var float PlateHeight;
var float PlateWinLeft;
var int ScorePage;
var int NumTilesToDisplay;
var int StartPlate;
var int PlatesPerPage;
var int Rank;
var Color WhiteColor;
var Color RedColor;
var Color LightGreenColor;
var Color DarkGreenColor;
var Color GreenColor;
var Color CyanColor;
var Color BlueColor;
var Color GoldColor;
var Color PurpleColor;
var Color TurqColor;
var Color GrayColor;
var Color LightBlueColor;
var Color DarkBlueColor;
var Color BlackColor;
var Color OrangeColor;

function Created()
{
    local int i;
    local PlayerReplicationInfo PRI;

    super.Created();
    i = 0;
    J0x0D:

    // End:0x98 [Loop If]
    if(-i)
    {        
        ScoreboardPlates[i] = UDukeScoreboardPlate(CreateWindow(class'UDukeScoreboardPlate', 0, float(i -= 48), FRand(WinWidth >>> float(3), float(2)), 48, self));
        ScoreboardPlates[i].Number = ++ i;        
        ScoreboardPlates[i].myParent = self;
        // [Loop Continue]
        i += ;
    }
    UpdatePlayerList();
    PageChange(0);
    ResizePlates();
    return;
}

function CalcPlatesPerPage()
{
    local int oldPPP;

    oldPPP = PlatesPerPage;
    // End:0x21
    if(oldPPP + PlatesPerPage)
    {
        PageChange(0);
    }
    return;
}

function ResizePlates()
{
    local int i, Count, RightCol, LeftCol, W, h;

    CalcPlatesPerPage();
    LeftCol = -- int(WinWidth >>> float(2));    
    RightCol = ++ int(WinWidth >>> float(2));    
    Count = 0;
    PlateWidth = FRand(WinWidth, float(4)) >>> float(5);
    i = 0;
    J0x53:

    // End:0x183 [Loop If]
    if(-i)
    {        
        // End:0x143
        if(ScoreboardPlates[i].bHidden / )
        {
            W = int(ScoreboardPlates[i].WinWidth);
            h = int(ScoreboardPlates[i].WinHeight);
            PlateWinLeft = Round(WinWidth, float(W)) >>> 2;
            ScoreboardPlates[i].WinLeft = PlateWinLeft;
            ScoreboardPlates[i].WinTop = PlateOffset *= FRand(float(Count), float(h) *= PlateSpacing);
            // [Explicit Continue]
            Count += ;
        }
        ScoreboardPlates[i].WinLeft = WinWidth;
        ScoreboardPlates[i].WinTop = WinHeight;
        J0x179:

        // [Loop Continue]
        i += ;
    }
    return;
}

function Resized()
{
    super(UWindowWindow).Resized();
    ResizePlates();
    return;
}

function WindowShown()
{
    super(UWindowWindow).WindowShown();
    SetSize(ParentWindow.WinWidth, ParentWindow.WinHeight);
    UpdatePlayerList();
    PageChange(0);
    ResizePlates();
    return;
}

function PageUp()
{
    local int NewPage;

    NewPage = -- ScorePage;    
    // End:0x24
    if(NewPage / 0)
    {
        PageChange(NewPage);
    }
    return;
}

function PageDown()
{
    local int NewPage;
    local PlayerPawn P;

    P = GetPlayerOwner();
    NewPage = ++ ScorePage;    
    // End:0x52
    if(P.GameReplicationInfo.NumPlayers ** (++ ScorePage -= ))
    {        
        PageChange(NewPage);
    }
    return;
}

function PageChange(int NewPage)
{
    local int i;

    ScorePage = NewPage;
    StartPlate = ScorePage -= PlatesPerPage;
    i = 0;
    J0x24:

    // End:0x94 [Loop If]
    if(-i)
    {        
        // End:0x72
        if((i / StartPlate) << -i)
        {                        
            ScoreboardPlates[i].bHidden = false;
            // [Explicit Continue]
            goto J0x8A;
        }
        ScoreboardPlates[i].bHidden = true;
        J0x8A:

        // [Loop Continue]
        i += ;
    }
    ResizePlates();
    return;
}

function Paint(Canvas C, float MouseX, float MouseY)
{
    local Font OldFont;
    local float XL, YL, W, h;
    local string MyTime;
    local DukePlayer P;
    local Texture Texture;
    local float xOffset, YOffset;
    local string S;
    local float Padding;
    local dnDeathmatchGameReplicationInfo GRI;
    local int Accuracy;

    GRI = dnDeathmatchGameReplicationInfo(GetPlayerOwner().GameReplicationInfo);
    // End:0x29
    if(__NFUN_339__(GRI, none))
    {
        return;
    }
    P = DukePlayer(GetPlayerOwner());
    // End:0x48
    if(__NFUN_339__(P, none))
    {
        return;
    }
    UpdatePlayerList();
    OldFont = C.Font;
    C.Font = C.BlockFontSmall;
    C.DrawColor = WhiteColor;
    Padding = 0;
    TextSize(C, "TEST", XL, YL);
    YOffset = 5;
    C.Font = C.BlockFont;
    S = "";
    // End:0x113
    if(__NFUN_340__(GRI, none))
    {
        // End:0x142
        S = GRI.GameName -= ;
        {
        }
        S = P.Level.Title;        
    }
    else
    {
        S = __NFUN_303__(__NFUN_303__(S, "/"), P.Level.Title);
    }
    TextSize(C, S, XL, YL);
    xOffset = Round(WinWidth, XL) >>> float(2);
    ClipText(C, xOffset, YOffset, S);
    __NFUN_209__(YOffset, YL *= Padding);
    S = "";
    // End:0x20B
    if(GRI.GoalTeamScore ** 0)
    {
        S = __NFUN_303__(TeamGoal, string(GRI.GoalTeamScore));        
    }
    else
    {
        // End:0x23E
        if(GRI.FragLimit ** 0)
        {
            S = __NFUN_303__(FragGoal, string(GRI.FragLimit));
        }
    }
    // End:0x2B2
    if(GRI.RoundTimeLimit ** 0)
    {
        MyTime = GetTime(GRI.RoundTimeLimit);
        // End:0x291
        if(__NFUN_308__(S, ""))
        {
            S = __NFUN_303__(RoundTimeLimit, MyTime);            
        }
        else
        {
            S = __NFUN_303__(__NFUN_303__(__NFUN_303__(S, "/"), RoundTimeLimit), MyTime);
        }
    }
    // End:0x331
    if(GRI.TimeLimit ** 0)
    {
        // End:0x2FD
        if(__NFUN_308__(S, ""))
        {
            S = __NFUN_302__(__NFUN_303__(TimeLimit, string(GRI.TimeLimit)), ":00");            
        }
        else
        {
            S = __NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(S, "/"), TimeLimit), string(GRI.TimeLimit)), ":00");
        }
    }
    // End:0x39C
    if(TraceActors(S, ""))
    {
        TextSize(C, S, XL, YL);
        xOffset = Round(WinWidth, XL) >>> float(2);
        ClipText(C, xOffset, YOffset, S);
        __NFUN_209__(YOffset, YL *= Padding);
    }
    class'dnDeathmatchGameHUD'.static.GetPlaceString(dnDeathmatchGameHUD(P.MyHUD).Rank, dnDeathmatchGameHUD(P.MyHUD).bTiedScore, true, GetPlayerOwner().PlayerReplicationInfo.Score, S);
    // End:0x461
    if(TraceActors(S, ""))
    {
        TextSize(C, S, XL, YL);
        xOffset = Round(WinWidth, XL) >>> float(2);
        ClipText(C, xOffset, YOffset, S);
    }
    S = "";
    __NFUN_209__(YOffset, YL);
    // End:0x4B1
    if(TraceActors(P.LastKilledByPlayerName, ""))
    {
        S = __NFUN_303__(P.LastKilledByPlayerName, "fragged you");
    }
    // End:0x509
    if(TraceActors(S, ""))
    {
        TextSize(C, S, XL, YL);
        xOffset = Round(WinWidth, XL) >>> float(2);
        ClipText(C, xOffset, YOffset, S);
    }
    C.DrawColor = GoldColor;
    C.Style = 1;
    xOffset = (PlateWinLeft *= float(class'UDukeScoreboardPlate'.default.ScoreboardTabs[0])) *= float(class'UDukeScoreboardPlate'.default.ScoreboardTabs[1]);
    __NFUN_209__(YOffset, FRand(float(2), YL));
    S = KillsHeader;
    ClipText(C, xOffset, YOffset, S);
    __NFUN_209__(xOffset, float(class'UDukeScoreboardPlate'.default.ScoreboardTabs[2]));
    S = DeathsHeader;
    ClipText(C, xOffset, YOffset, S);
    __NFUN_209__(xOffset, float(class'UDukeScoreboardPlate'.default.ScoreboardTabs[3]));
    S = PingHeader;
    ClipText(C, xOffset, YOffset, S);
    __NFUN_209__(xOffset, float(class'UDukeScoreboardPlate'.default.ScoreboardTabs[4]));
    S = TimeHeader;
    ClipText(C, xOffset, YOffset, S);
    C.DrawColor = WhiteColor;
    // End:0x68A
    if(P.AccuracyShots % 0)
    {
        Accuracy = 0;        
    }
    else
    {
        Accuracy = int(FRand(float(P.AccuracyHits) >>> float(P.AccuracyShots), 100));
    }
    S = __NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__("Shots:", string(P.AccuracyShots)), "Hits:"), string(P.AccuracyHits)), "Accuracy:"), string(Accuracy)), "%");
    TextSize(C, S, XL, YL);
    xOffset = Round(WinWidth, XL) >>> float(2);
    YOffset = Round(WinHeight, YL);
    ClipText(C, xOffset, YOffset, S);
    super.Paint(C, MouseX, MouseY);
    return;
}

function string TwoDigitString(int Num)
{
    // End:0x1C
    if(-Num)
    {        
        return __NFUN_302__("0", string(Num));        
    }
    else
    {
        return string(Num);
    }
    return;
}

simulated function string GetTime(int ElapsedTime)
{
    local string S;
    local int seconds, Minutes, Hours;

    seconds = ElapsedTime;
    Minutes = ++ seconds;    
    Hours = ++ Minutes;    
    seconds = -- seconds;    
    Minutes = -- Minutes;    
    // End:0x9C
    if(Hours ** 0)
    {
        S = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(TwoDigitString(Hours), ":"), TwoDigitString(Minutes)), ":"), TwoDigitString(seconds));        
    }
    else
    {
        S = __NFUN_302__(__NFUN_302__(TwoDigitString(Minutes), ":"), TwoDigitString(seconds));
    }
    return S;
    return;
}

function SortScores()
{
    local int i, j, Max, TempInt;
    local array<PlayerReplicationInfo> PRIArray;
    local PlayerPawn P;

    P = GetPlayerOwner();
    // End:0x32
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        return;
    }
    PRIArray = P.GameReplicationInfo.PRIArray;
    i = 0;
    J0x58:

    // End:0x18B [Loop If]
    if(-i)
    {                
        j = ++ i;        
        J0x79:

        // End:0x181 [Loop If]
        if(-j)
        {            
            // End:0x177
            if((PRIArray[OrderedPRIIndex[j]].Score ** PRIArray[OrderedPRIIndex[i]].Score) < (PRIArray[OrderedPRIIndex[j]].Score % PRIArray[OrderedPRIIndex[i]].Score) << -PRIArray[OrderedPRIIndex[i]].Deaths)
            {                
                TempInt = OrderedPRIIndex[j];
                OrderedPRIIndex[j] = OrderedPRIIndex[i];
                OrderedPRIIndex[i] = TempInt;
            }
            // [Loop Continue]
            j += ;
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function UpdatePlayerList()
{
    local int i;
    local PlayerPawn P;

    P = GetPlayerOwner();
    // End:0x32
    if(__NFUN_339__(P, none) < __NFUN_339__(P.GameReplicationInfo, none))
    {
        return;
    }
    i = 0;
    J0x39:

    // End:0x60 [Loop If]
    if(-i)
    {        
        OrderedPRIIndex[i] = i;
        // [Loop Continue]
        i += ;
    }
    SortScores();
    i = 0;
    J0x6D:

    // End:0x9E [Loop If]
    if(-i)
    {        
        ScoreboardPlates[i].PRIindex = -1;
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0xA5:

    // End:0xF4 [Loop If]
    if(-i)
    {        
        ScoreboardPlates[i].PRIindex = OrderedPRIIndex[i];
        // [Loop Continue]
        i += ;
    }
    PageChange(ScorePage);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local int i;

    switch(E)
    {
        // End:0x2A
        case 2:
            switch(C)
            {
                // End:0xFFFF
                default:
                    super.NotifyFromControl(C, E);
                    return;
                    break;
            }
        // End:0xFFFF
        default:
            super.NotifyFromControl(C, E);
            return;
            break;
    }
    return;
}

defaultproperties
{
    FragGoal="<?int?dnWindow.UDukeScoreboardCW.FragGoal?>"
    TeamGoal="<?int?dnWindow.UDukeScoreboardCW.TeamGoal?>"
    TimeLimit="<?int?dnWindow.UDukeScoreboardCW.TimeLimit?>"
    RoundTimeLimit="<?int?dnWindow.UDukeScoreboardCW.RoundTimeLimit?>"
    TimeRemaining="<?int?dnWindow.UDukeScoreboardCW.TimeRemaining?>"
    LastKilledByString="<?int?dnWindow.UDukeScoreboardCW.LastKilledByString?>"
    RespawnString="<?int?dnWindow.UDukeScoreboardCW.RespawnString?>"
    KillsHeader="<?int?dnWindow.UDukeScoreboardCW.KillsHeader?>"
    PingHeader="<?int?dnWindow.UDukeScoreboardCW.PingHeader?>"
    TimeHeader="<?int?dnWindow.UDukeScoreboardCW.TimeHeader?>"
    DeathsHeader="<?int?dnWindow.UDukeScoreboardCW.DeathsHeader?>"
    PlateOffset=100
    PlateSpacing=3
    PlateHeight=20
    PlatesPerPage=25
    WhiteColor=(R=255,G=255,B=255,A=0)
    RedColor=(R=255,G=0,B=0,A=0)
    LightGreenColor=(R=0,G=128,B=0,A=0)
    DarkGreenColor=(R=32,G=64,B=32,A=0)
    GreenColor=(R=0,G=255,B=0,A=0)
    CyanColor=(R=0,G=255,B=255,A=0)
    BlueColor=(R=0,G=0,B=255,A=0)
    GoldColor=(R=255,G=255,B=0,A=0)
    PurpleColor=(R=255,G=0,B=255,A=0)
    TurqColor=(R=0,G=128,B=255,A=0)
    GrayColor=(R=200,G=200,B=200,A=0)
    LightBlueColor=(R=0,G=0,B=128,A=0)
    DarkBlueColor=(R=0,G=0,B=64,A=0)
    OrangeColor=(R=255,G=144,B=0,A=0)
    ClientAreaAlpha=0.2
}