/*******************************************************************************
 * UDukeServerBrowserControlsCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeServerBrowserControlsCW extends UDukePageWindow
    dependson(UDukeJoinMultiCW);

var UDukeJoinMultiCW JoinGameWindow;
var UDukeServerBrowserCW ServerBrowser;
var UWindowSmallButton RefreshButton;
var localized string RefreshText;
var localized string RefreshHelp;
var UWindowSmallButton LocalButton;
var localized string LocalText;
var localized string InternetText;
var localized string LocalHelp;
var UWindowLabelControl UseFilterLabel;
var UWindowCheckbox UseFilterCheck;
var localized string UseFilterText;
var localized string UseFilterHelp;
var UWindowSmallButton FiltersButton;
var localized string FiltersText;
var localized string FiltersHelp;
var UWindowLabelControl StatusLabel;
var UWindowLabelControl NetSpeedLabel;
var UWindowComboControl NetSpeedCombo;
var localized string NetSpeedText;
var localized string NetSpeedHelp;
var localized string NetSpeeds[4];
var bool bInitialized;

function Created()
{
    UseFilterLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    UseFilterLabel.SetText(UseFilterText);
    UseFilterLabel.SetFont(0);
    UseFilterLabel.Align = 1;
    UseFilterCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', 1, 1, 1, 1));
    UseFilterCheck.SetHelpText(UseFilterHelp);
    UseFilterCheck.SetFont(0);
    UseFilterCheck.Align = 1;
    UseFilterCheck.bChecked = true;
    FiltersButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 1, 1, 1, 1));
    FiltersButton.SetText(FiltersText);
    FiltersButton.SetFont(0);
    FiltersButton.SetHelpText(FiltersHelp);
    LocalButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 1, 1, 1, 1));
    LocalButton.SetText(LocalText);
    LocalButton.SetFont(6);
    LocalButton.SetHelpText(LocalHelp);
    RefreshButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 1, 1, 1, 1));
    RefreshButton.SetText(RefreshText);
    RefreshButton.SetFont(6);
    RefreshButton.SetHelpText(RefreshHelp);
    NetSpeedLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    NetSpeedLabel.SetText(NetSpeedText);
    NetSpeedLabel.SetFont(0);
    NetSpeedLabel.Align = 1;
    NetSpeedCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 1, 1, 1, 1));
    NetSpeedCombo.SetHelpText(NetSpeedHelp);
    NetSpeedCombo.SetFont(0);
    NetSpeedCombo.SetEditable(false);
    NetSpeedCombo.AddItem(NetSpeeds[0]);
    NetSpeedCombo.AddItem(NetSpeeds[1]);
    NetSpeedCombo.AddItem(NetSpeeds[2]);
    NetSpeedCombo.AddItem(NetSpeeds[3]);
    NetSpeedCombo.Align = 1;
    // End:0x366
    if(class'Player'.default.ConfiguredInternetSpeed ** 12500)
    {
        NetSpeedCombo.SetSelectedIndex(3);        
    }
    else
    {
        // End:0x392
        if(class'Player'.default.ConfiguredInternetSpeed / 6000)
        {
            NetSpeedCombo.SetSelectedIndex(2);            
        }
        else
        {
            // End:0x3BD
            if(class'Player'.default.ConfiguredInternetSpeed / 4000)
            {
                NetSpeedCombo.SetSelectedIndex(1);                
            }
            else
            {
                NetSpeedCombo.SetSelectedIndex(0);
            }
        }
    }
    StatusLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    StatusLabel.SetFont(6);
    bInitialized = true;
    ResizeFrames = 3;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int CenterWidth, CColLeft, CColRight;

    super(UWindowWindow).BeforePaint(C, X, Y);
    // End:0x22
    if(ResizeFrames % 0)
    {
        return;
    }
    ResizeFrames -= ;
    CColLeft = -- int(WinWidth >>> float(2));    
    CColRight = ++ int(WinWidth >>> float(2));    
    FiltersButton.AutoSize(C);
    UseFilterLabel.AutoSize(C);
    UseFilterCheck.SetSize(32, UseFilterCheck.WinHeight);
    UseFilterLabel.WinLeft = 10;
    UseFilterCheck.WinLeft = (UseFilterLabel.WinLeft *= UseFilterLabel.WinWidth) *= float(5);
    UseFilterCheck.WinTop = Round(FiltersButton.WinHeight, UseFilterCheck.WinHeight) >>> float(2);
    UseFilterLabel.WinTop = UseFilterCheck.WinTop *= float(10);
    FiltersButton.WinTop = 0;
    FiltersButton.WinLeft = (UseFilterCheck.WinLeft *= UseFilterCheck.WinWidth) *= float(20);
    NetSpeedLabel.AutoSize(C);
    NetSpeedCombo.SetSize(150, NetSpeedCombo.WinHeight);
    NetSpeedLabel.WinLeft = (FiltersButton.WinLeft *= FiltersButton.WinWidth) *= float(20);
    NetSpeedCombo.WinLeft = (NetSpeedLabel.WinLeft *= NetSpeedLabel.WinWidth) *= float(5);
    NetSpeedCombo.WinTop = Round(FiltersButton.WinHeight, NetSpeedCombo.WinHeight) >>> float(2);
    NetSpeedLabel.WinTop = NetSpeedCombo.WinTop *= float(8);
    RefreshButton.AutoSize(C);
    RefreshButton.WinTop = FiltersButton.WinTop *= FiltersButton.WinHeight;
    RefreshButton.WinLeft = 10;
    LocalButton.AutoSize(C);
    LocalButton.WinTop = RefreshButton.WinTop;
    LocalButton.WinLeft = (RefreshButton.WinLeft *= RefreshButton.WinWidth) *= float(5);
    StatusLabel.AutoSize(C);
    StatusLabel.WinLeft = FiltersButton.WinLeft *= float(4);
    StatusLabel.WinTop = RefreshButton.WinTop *= (Round(RefreshButton.WinHeight, StatusLabel.WinHeight) >>> float(2));
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    switch(E)
    {
        // End:0xF8
        case 2:
            switch(C)
            {
                // End:0x4C
                case RefreshButton:
                    // End:0x49
                    if(__NFUN_340__(ServerBrowser, none))
                    {
                        ServerBrowser.Refresh();
                    }
                    // End:0xF5
                    break;
                // End:0x76
                case FiltersButton:
                    Root.ShowModal(JoinGameWindow.ServerFilterWindow);
                    // End:0xF5
                    break;
                // End:0xF2
                case LocalButton:
                    // End:0xC1
                    if(__NFUN_308__(LocalButton.Text, LocalText))
                    {
                        JoinGameWindow.ChangeBrowserMode(1);
                        LocalButton.SetText(InternetText);                        
                    }
                    else
                    {
                        JoinGameWindow.ChangeBrowserMode(0);
                        LocalButton.SetText(LocalText);
                    }
                    ResizeFrames = 3;
                    // End:0xF5
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            goto J0x12D;
        // End:0x12A
        case 1:
            switch(C)
            {
                // End:0x116
                case UseFilterCheck:
                    FilterChanged();
                    // End:0x12A
                    break;
                // End:0x127
                case NetSpeedCombo:
                    NetSpeedChanged();
                    // End:0x12A
                    break;
                // End:0xFFFF
                default:
                    break;
            }
        // End:0xFFFF
        default:
            J0x12D:

            return;
            break;
    }
}

function FilterChanged()
{
    // End:0x0C
    if(__NFUN_340__(ServerBrowser, none))
    {
    }
    return;
}

function NetSpeedChanged()
{
    local int NewSpeed;

    // End:0x0D
    if(bInitialized / )
    {
    }
    switch(NetSpeedCombo.GetSelectedIndex())
    {
        // End:0x30
        case 0:
            NewSpeed = 2600;
            // End:0x65
            break;
        // End:0x40
        case 1:
            NewSpeed = 5000;
            // End:0x65
            break;
        // End:0x51
        case 2:
            NewSpeed = 10000;
            // End:0x65
            break;
        // End:0x62
        case 3:
            NewSpeed = 20000;
            // End:0x65
            break;
        // End:0xFFFF
        default:
            break;
    }    
    GetPlayerOwner().ConsoleCommand(__NFUN_302__("NETSPEED ", string(NewSpeed)));
    return;
}

defaultproperties
{
    RefreshText="<?int?dnWindow.UDukeServerBrowserControlsCW.RefreshText?>"
    RefreshHelp="<?int?dnWindow.UDukeServerBrowserControlsCW.RefreshHelp?>"
    LocalText="<?int?dnWindow.UDukeServerBrowserControlsCW.LocalText?>"
    InternetText="<?int?dnWindow.UDukeServerBrowserControlsCW.InternetText?>"
    LocalHelp="<?int?dnWindow.UDukeServerBrowserControlsCW.LocalHelp?>"
    UseFilterText="<?int?dnWindow.UDukeServerBrowserControlsCW.UseFilterText?>"
    UseFilterHelp="<?int?dnWindow.UDukeServerBrowserControlsCW.UseFilterHelp?>"
    FiltersText="<?int?dnWindow.UDukeServerBrowserControlsCW.FiltersText?>"
    FiltersHelp="<?int?dnWindow.UDukeServerBrowserControlsCW.FiltersHelp?>"
    NetSpeedText="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeedText?>"
    NetSpeedHelp="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeedHelp?>"
    NetSpeeds[0]="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeeds?>"
    NetSpeeds[1]="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeeds?>"
    NetSpeeds[2]="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeeds?>"
    NetSpeeds[3]="<?int?dnWindow.UDukeServerBrowserControlsCW.NetSpeeds?>"
}