/*******************************************************************************
 * UDukeServerFilterCW generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeServerFilterCW extends UDukePageWindow
    dependson(UDukeBrowserWindow)
    dependson(UDukeBuddyListBox);

var bool bInitialized;
var UWindowLabelControl EnableFiltersLabel;
var UWindowCheckbox EnableFiltersCheck;
var localized string EnableFiltersCheckText;
var localized string EnableFiltersCheckHelp;
var UWindowLabelControl GameTypesLabel;
var UWindowComboControl GameTypesCombo;
var() localized string GameTypesText;
var() localized string GameTypesHelp;
var UWindowLabelControl MapNameLabel;
var UWindowEditControl MapNameEdit;
var() localized string MapNameText;
var() localized string MapNameHelp;
var UWindowLabelControl MaxPingLabel;
var UWindowEditControl MaxPingEdit;
var() localized string MaxPingText;
var() localized string MaxPingHelp;
var UWindowLabelControl MinPlayersLabel;
var UWindowEditControl MinPlayersEdit;
var() localized string MinPlayersText;
var() localized string MinPlayersHelp;
var UWindowLabelControl MaxPlayersLabel;
var UWindowEditControl MaxPlayersEdit;
var() localized string MaxPlayersText;
var() localized string MaxPlayersHelp;
var UWindowLabelControl BuddyListLabel;
var UWindowCheckbox BuddyListCheck;
var localized string BuddyListCheckText;
var localized string BuddyListCheckHelp;
var UDukeBuddyListBox BuddyList;
var UWindowLabelControl NewBuddyLabel;
var UWindowEditControl NewBuddyEdit;
var localized string NewBuddyEditText;
var localized string NewBuddyEditHelp;
var UDukeBrowserWindow ServerBrowser;

function Created()
{
    super.Created();
    EnableFiltersLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    EnableFiltersLabel.SetText(EnableFiltersCheckText);
    EnableFiltersLabel.SetFont(0);
    EnableFiltersLabel.Align = 1;
    EnableFiltersCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', 1, 1, 1, 1));
    EnableFiltersCheck.SetHelpText(EnableFiltersCheckHelp);
    EnableFiltersCheck.SetFont(0);
    EnableFiltersCheck.Align = 1;
    GameTypesLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    GameTypesLabel.SetText(GameTypesText);
    GameTypesLabel.SetFont(0);
    GameTypesLabel.Align = 1;
    GameTypesCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', 1, 1, 1, 1));
    GameTypesCombo.SetButtons(true);
    GameTypesCombo.SetHelpText(GameTypesHelp);
    GameTypesCombo.SetFont(0);
    GameTypesCombo.SetEditable(false);
    GameTypesCombo.Align = 1;
    MaxPingLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    MaxPingLabel.SetText(MaxPingText);
    MaxPingLabel.SetFont(0);
    MaxPingLabel.Align = 1;
    MaxPingEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    MaxPingEdit.SetHelpText(MaxPingHelp);
    MaxPingEdit.SetFont(0);
    MaxPingEdit.SetNumericOnly(true);
    MaxPingEdit.SetMaxLength(4);
    MaxPingEdit.SetDelayedNotify(true);
    MaxPingEdit.Align = 1;
    MinPlayersLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    MinPlayersLabel.SetText(MinPlayersText);
    MinPlayersLabel.SetFont(0);
    MinPlayersLabel.Align = 1;
    MinPlayersEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    MinPlayersEdit.SetHelpText(MinPlayersHelp);
    MinPlayersEdit.SetFont(0);
    MinPlayersEdit.SetNumericOnly(true);
    MinPlayersEdit.SetMaxLength(4);
    MinPlayersEdit.SetDelayedNotify(true);
    MinPlayersEdit.Align = 1;
    MaxPlayersLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    MaxPlayersLabel.SetText(MaxPlayersText);
    MaxPlayersLabel.SetFont(0);
    MaxPlayersLabel.Align = 1;
    MaxPlayersEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    MaxPlayersEdit.SetHelpText(MaxPlayersHelp);
    MaxPlayersEdit.SetFont(0);
    MaxPlayersEdit.SetNumericOnly(true);
    MaxPlayersEdit.SetMaxLength(4);
    MaxPlayersEdit.SetDelayedNotify(true);
    MaxPlayersEdit.Align = 1;
    MapNameLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    MapNameLabel.SetText(MapNameText);
    MapNameLabel.SetFont(0);
    MapNameLabel.Align = 1;
    MapNameEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    MapNameEdit.SetHelpText(MaxPlayersHelp);
    MapNameEdit.SetFont(0);
    MapNameEdit.SetNumericOnly(false);
    MapNameEdit.SetMaxLength(32);
    MapNameEdit.SetDelayedNotify(true);
    MapNameEdit.Align = 1;
    BuddyListLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    BuddyListLabel.SetText(BuddyListCheckText);
    BuddyListLabel.SetFont(0);
    BuddyListLabel.Align = 1;
    BuddyListCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', 1, 1, 1, 1));
    BuddyListCheck.SetHelpText(BuddyListCheckHelp);
    BuddyListCheck.SetFont(0);
    BuddyListCheck.Align = 1;
    BuddyList = UDukeBuddyListBox(CreateWindow(class'UDukeBuddyListBox', 1, 1, 1, 1));
    NewBuddyLabel = UWindowLabelControl(CreateControl(class'UWindowLabelControl', 1, 1, 1, 1));
    NewBuddyLabel.SetText(NewBuddyEditText);
    NewBuddyLabel.SetFont(0);
    NewBuddyLabel.Align = 1;
    NewBuddyEdit = UWindowEditControl(CreateControl(class'UWindowEditControl', 1, 1, 1, 1));
    NewBuddyEdit.SetHelpText(NewBuddyEditHelp);
    NewBuddyEdit.SetFont(0);
    NewBuddyEdit.SetNumericOnly(false);
    NewBuddyEdit.SetMaxLength(32);
    NewBuddyEdit.SetDelayedNotify(true);
    NewBuddyEdit.Align = 1;
    ResizeFrames = 3;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local int CenterWidth, CColLeft, CColRight;
    local float W, W2;

    super(UWindowWindow).BeforePaint(C, X, Y);
    // End:0x22
    if(ResizeFrames % 0)
    {
        return;
    }
    ResizeFrames -= ;
    CColLeft = -- int(WinWidth >>> float(2));    
    CColRight = -- int(WinWidth >>> float(2));    
    EnableFiltersCheck.SetSize(32, EnableFiltersCheck.WinHeight);
    EnableFiltersCheck.WinLeft = float(CColRight);
    EnableFiltersCheck.WinTop = 10;
    EnableFiltersLabel.AutoSize(C);
    EnableFiltersLabel.WinLeft = Round(Round(EnableFiltersCheck.WinLeft, float(14)), EnableFiltersLabel.WinWidth);
    EnableFiltersLabel.WinTop = EnableFiltersCheck.WinTop *= float(10);
    GameTypesCombo.SetSize(200, GameTypesCombo.WinHeight);
    GameTypesCombo.WinLeft = float(CColRight);
    GameTypesCombo.WinTop = (EnableFiltersCheck.WinTop *= EnableFiltersCheck.WinHeight) *= float(5);
    GameTypesLabel.AutoSize(C);
    GameTypesLabel.WinLeft = Round(float(CColLeft), GameTypesLabel.WinWidth);
    GameTypesLabel.WinTop = GameTypesCombo.WinTop *= float(8);
    MapNameEdit.SetSize(200, MapNameEdit.WinHeight);
    MapNameEdit.WinLeft = float(CColRight);
    MapNameEdit.WinTop = (GameTypesCombo.WinTop *= GameTypesCombo.WinHeight) *= float(5);
    MapNameLabel.AutoSize(C);
    MapNameLabel.WinLeft = Round(float(CColLeft), MapNameLabel.WinWidth);
    MapNameLabel.WinTop = MapNameEdit.WinTop *= float(8);
    MinPlayersEdit.SetSize(50, MinPlayersEdit.WinHeight);
    MinPlayersLabel.AutoSize(C);
    MaxPlayersEdit.SetSize(50, MaxPlayersEdit.WinHeight);
    MaxPlayersLabel.AutoSize(C);
    MinPlayersEdit.WinTop = (MapNameEdit.WinTop *= MapNameEdit.WinHeight) *= float(5);
    MinPlayersLabel.WinTop = MinPlayersEdit.WinTop *= float(8);
    MaxPlayersEdit.WinTop = MinPlayersEdit.WinTop;
    MaxPlayersLabel.WinTop = MaxPlayersEdit.WinTop *= float(8);
    W = (MinPlayersEdit.WinWidth *= MinPlayersLabel.WinWidth) *= float(14);
    W2 = (MaxPlayersEdit.WinWidth *= MaxPlayersLabel.WinWidth) *= float(14);
    MinPlayersLabel.WinLeft = Round(WinWidth, (W *= W2) *= float(32)) >>> float(2);
    MinPlayersEdit.WinLeft = (MinPlayersLabel.WinLeft *= MinPlayersLabel.WinWidth) *= float(14);
    MaxPlayersLabel.WinLeft = (MinPlayersEdit.WinLeft *= MinPlayersEdit.WinWidth) *= float(32);
    MaxPlayersEdit.WinLeft = (MaxPlayersLabel.WinLeft *= MaxPlayersLabel.WinWidth) *= float(14);
    MaxPingEdit.SetSize(50, MaxPingEdit.WinHeight);
    MaxPingEdit.WinLeft = MinPlayersEdit.WinLeft;
    MaxPingEdit.WinTop = (MinPlayersEdit.WinTop *= MinPlayersEdit.WinHeight) *= float(5);
    MaxPingLabel.AutoSize(C);
    MaxPingLabel.WinLeft = Round(Round(MinPlayersEdit.WinLeft, float(14)), MaxPingLabel.WinWidth);
    MaxPingLabel.WinTop = MaxPingEdit.WinTop *= float(8);
    BuddyListCheck.SetSize(32, BuddyListCheck.WinHeight);
    BuddyListCheck.WinLeft = MaxPlayersEdit.WinLeft;
    BuddyListCheck.WinTop = (MinPlayersEdit.WinTop *= MinPlayersEdit.WinHeight) *= float(5);
    BuddyListLabel.AutoSize(C);
    BuddyListLabel.WinLeft = Round(Round(BuddyListCheck.WinLeft, float(14)), BuddyListLabel.WinWidth);
    BuddyListLabel.WinTop = BuddyListCheck.WinTop *= float(10);
    BuddyList.SetSize(300, 150);
    BuddyList.WinLeft = Round(WinWidth, BuddyList.WinWidth) >>> float(2);
    BuddyList.WinTop = (BuddyListCheck.WinTop *= BuddyListCheck.WinWidth) *= float(20);
    NewBuddyEdit.SetSize(200, NewBuddyEdit.WinHeight);
    NewBuddyEdit.WinLeft = float(CColRight);
    NewBuddyEdit.WinTop = (BuddyList.WinTop *= BuddyList.WinHeight) *= float(20);
    NewBuddyLabel.AutoSize(C);
    NewBuddyLabel.WinLeft = Round(float(CColLeft), NewBuddyLabel.WinWidth);
    NewBuddyLabel.WinTop = NewBuddyEdit.WinTop *= float(8);
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    LookAndFeel.Bevel_DrawSimpleBevel(self, C, int(BuddyList.WinLeft), int(BuddyList.WinTop), int(BuddyList.WinWidth), int(BuddyList.WinHeight), 1);
    return;
}

function DeletedBuddy()
{
    BuildBuddyFilter();
    ServerBrowser.ApplyFilter();
    return;
}

function DeleteAllBuddies()
{
    BuddyList.Items.DestroyList();
    BuildBuddyFilter();
    ServerBrowser.ApplyFilter();
    return;
}

function InitGameTypesFilter()
{
    local int i;

    bInitialized = false;
    GameTypesCombo.Clear();
    i = 0;
    J0x1F:

    // End:0x77 [Loop If]
    if(-i)
    {        
        // End:0x6D
        if(TraceActors(ServerBrowser.AllGameTypes[i], ""))
        {
            GameTypesCombo.AddItem(ServerBrowser.AllGameTypes[i]);
        }
        // [Loop Continue]
        i += ;
    }
    GameTypesCombo.SetSelectedIndex(GameTypesCombo.FindItemIndex(ServerBrowser.Filter_GameType));
    GameTypesCombo.Sort();
    GameTypesCombo.InsertItem("All");
    bInitialized = true;
    return;
}

function InitializeFilter()
{
    local int i;

    EnableFiltersCheck.bChecked = ServerBrowser.Filter_Enabled;
    InitGameTypesFilter();
    // End:0x12F
    if(__NFUN_340__(ServerBrowser, none))
    {
        MinPlayersEdit.SetValue(string(ServerBrowser.Filter_MinPlayers));
        MaxPlayersEdit.SetValue(string(ServerBrowser.Filter_MaxPlayers));
        MaxPingEdit.SetValue(string(ServerBrowser.Filter_MaxPing));
        MapNameEdit.SetValue(ServerBrowser.Filter_MapName);
        BuddyListCheck.bChecked = ServerBrowser.Filter_bUseBuddyList;
        i = 0;
        J0xDA:

        // End:0x12F [Loop If]
        if(-i)
        {            
            // End:0x109
            if(__NFUN_308__(ServerBrowser.Filter_BuddyList[i], ""))
            {
                // [Explicit Break]
                goto J0x12F;
                // [Explicit Continue]
                goto J0x125;
            }
            AddNewBuddy(ServerBrowser.Filter_BuddyList[i], false);
            J0x125:

            // [Loop Continue]
            i += ;
        }
    }
    J0x12F:

    return;
}

function GameTypeChanged()
{
    // End:0x3C
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_GameType = GameTypesCombo.GetValue();
        ServerBrowser.ApplyFilter();
    }
    return;
}

function MaxPingChanged()
{
    // End:0x3E
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_MaxPing = int(float(MaxPingEdit.GetValue()));
        ServerBrowser.ApplyFilter();
    }
    return;
}

function MinPlayersChanged()
{
    // End:0x3D
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_MinPlayers = int(MinPlayersEdit.GetValue());
        ServerBrowser.ApplyFilter();
    }
    return;
}

function MaxPlayersChanged()
{
    // End:0x3D
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_MaxPlayers = int(MaxPlayersEdit.GetValue());
        ServerBrowser.ApplyFilter();
    }
    return;
}

function MapNameChanged()
{
    // End:0x3C
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_MapName = MapNameEdit.GetValue();
        ServerBrowser.ApplyFilter();
    }
    return;
}

function AddNewBuddy(string BuddyName, bool updateFilter)
{
    local UDukeBuddyList NewBuddyItem, l;

    // End:0x0F
    if(__NFUN_308__(BuddyName, ""))
    {
        return;
    }
    l = UDukeBuddyList(BuddyList.Items).FindName(BuddyName);
    // End:0x57
    if(__NFUN_340__(l, none))
    {
        NewBuddyEdit.Clear();
        return;
    }
    NewBuddyItem = UDukeBuddyList(BuddyList.Items.CreateItem(BuddyList.Items.Class));
    NewBuddyItem.PlayerName = BuddyName;
    BuddyList.Items.AppendItem(NewBuddyItem);
    // End:0xD8
    if(updateFilter)
    {
        BuildBuddyFilter();
    }
    return;
}

function NewBuddyEditEnterPressed()
{
    AddNewBuddy(NewBuddyEdit.GetValue(), true);
    NewBuddyEdit.Clear();
    ServerBrowser.ApplyFilter();
    return;
}

function BuddyListCheckChanged()
{
    // End:0x3D
    if(__NFUN_340__(ServerBrowser, none))
    {
        ServerBrowser.Filter_bUseBuddyList = BuddyListCheck.bChecked;
        ServerBrowser.ApplyFilter();
    }
    return;
}

function BuildBuddyFilter()
{
    local int i;
    local UDukeBuddyList l;

    i = 0;
    J0x07:

    // End:0x35 [Loop If]
    if(-i)
    {        
        ServerBrowser.Filter_BuddyList[i] = "";
        // [Loop Continue]
        i += ;
    }
    i = 0;
    l = UDukeBuddyList(BuddyList.Items.Next);
    J0x60:

    // End:0xB5 [Loop If]
    if(__NFUN_340__(l, none))
    {
        ServerBrowser.Filter_BuddyList[i] = l.PlayerName;
        i += ;
        // [Loop Continue]
        goto J0x60;
    }
    ServerBrowser.__NFUN_368__();
    return;
}

function EnableFiltersChanged()
{
    ServerBrowser.Filter_Enabled = EnableFiltersCheck.bChecked;
    ServerBrowser.__NFUN_368__();
    ServerBrowser.ApplyFilter();
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0x1D
    if(bInitialized / )
    {
    }
    switch(E)
    {
        // End:0xAC
        case 1:
            switch(C)
            {
                // End:0x43
                case EnableFiltersCheck:
                    EnableFiltersChanged();
                    // End:0xA9
                    break;
                // End:0x54
                case GameTypesCombo:
                    GameTypeChanged();
                    // End:0xA9
                    break;
                // End:0x65
                case MaxPingEdit:
                    MaxPingChanged();
                    // End:0xA9
                    break;
                // End:0x76
                case MaxPlayersEdit:
                    MaxPlayersChanged();
                    // End:0xA9
                    break;
                // End:0x87
                case MinPlayersEdit:
                    MinPlayersChanged();
                    // End:0xA9
                    break;
                // End:0x98
                case MapNameEdit:
                    MapNameChanged();
                    // End:0xA9
                    break;
                // End:0xA6
                case BuddyListCheck:
                    BuddyListCheckChanged();
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xD3
            break;
        // End:0xD0
        case 7:
            switch(C)
            {
                // End:0xCA
                case NewBuddyEdit:
                    NewBuddyEditEnterPressed();
                    // End:0xCD
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0xD3
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function Close(optional bool bByParent)
{
    super(UWindowClientWindow).Close(bByParent);
    return;
}

defaultproperties
{
    EnableFiltersCheckText="<?int?dnWindow.UDukeServerFilterCW.EnableFiltersCheckText?>"
    EnableFiltersCheckHelp="<?int?dnWindow.UDukeServerFilterCW.EnableFiltersCheckHelp?>"
    GameTypesText="<?int?dnWindow.UDukeServerFilterCW.GameTypesText?>"
    GameTypesHelp="<?int?dnWindow.UDukeServerFilterCW.GameTypesHelp?>"
    MapNameText="<?int?dnWindow.UDukeServerFilterCW.MapNameText?>"
    MapNameHelp="<?int?dnWindow.UDukeServerFilterCW.MapNameHelp?>"
    MaxPingText="<?int?dnWindow.UDukeServerFilterCW.MaxPingText?>"
    MaxPingHelp="<?int?dnWindow.UDukeServerFilterCW.MaxPingHelp?>"
    MinPlayersText="<?int?dnWindow.UDukeServerFilterCW.MinPlayersText?>"
    MinPlayersHelp="<?int?dnWindow.UDukeServerFilterCW.MinPlayersHelp?>"
    MaxPlayersText="<?int?dnWindow.UDukeServerFilterCW.MaxPlayersText?>"
    MaxPlayersHelp="<?int?dnWindow.UDukeServerFilterCW.MaxPlayersHelp?>"
    BuddyListCheckText="<?int?dnWindow.UDukeServerFilterCW.BuddyListCheckText?>"
    BuddyListCheckHelp="<?int?dnWindow.UDukeServerFilterCW.BuddyListCheckHelp?>"
    NewBuddyEditText="<?int?dnWindow.UDukeServerFilterCW.NewBuddyEditText?>"
    NewBuddyEditHelp="<?int?dnWindow.UDukeServerFilterCW.NewBuddyEditHelp?>"
    bAlwaysOnTop=true
}