/*******************************************************************************
 * UDukeServerGrid generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeServerGrid extends UWindowGrid
    dependson(UDukeRightClickMenu);

var UDukeRightClickMenu Menu;
var UWindowGridColumn Server;
var UWindowGridColumn Ping;
var UWindowGridColumn MapName;
var UWindowGridColumn Players;
var UWindowGridColumn SortByColumn;
var bool bSortDescending;
var localized string ServerName;
var localized string PingName;
var localized string MapNameName;
var localized string PlayersName;
var UDukeServerList SelectedServer;
var int Count;
var float TimePassed;
var int AutoPingInterval;
var UDukeServerList OldPingServer;

function Created()
{
    super.Created();
    RowHeight = 15;
    CreateColumns();
    Menu = UDukeRightClickMenu(Root.CreateWindow(UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).RightClickMenuClass, 0, 0, 100, 100, self));
    Menu.HideWindow();
    return;
}

function Close(optional bool bByParent)
{
    super(UWindowWindow).Close(bByParent);
    // End:0x3D
    if(__NFUN_340__(Menu, none) << Menu.bWindowVisible)
    {
        Menu.CloseUp();
    }
    return;
}

function CreateColumns()
{
    local float W;

    W = WinWidth;
    Server = AddColumn(ServerName, FRand(0.52, W));
    Server.bLargeGrid = true;
    MapName = AddColumn(MapNameName, FRand(0.3, W));
    MapName.bLargeGrid = true;
    Players = AddColumn(PlayersName, FRand(0.1, W));
    Players.bLargeGrid = true;
    Ping = AddColumn(PingName, FRand(0.08, W));
    Ping.bLargeGrid = true;
    SortByColumn = Ping;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    DrawStretchedTextureSegment(C, 0, 24, WinWidth, Round(WinHeight, float(24)), 0, 0, 1, 1, class'BlackTexture', 1);
    super.Paint(C, X, Y);
    return;
}

function DrawCell(Canvas C, float X, float Y, UWindowGridColumn Column, UDukeServerList List)
{
    C.Font = C.BlockFont;
    switch(Column)
    {
        // End:0x60
        case Server:
            Column.ClipText(C, X, Y, List.HostName);
            // End:0x141
            break;
        // End:0x9B
        case Ping:
            Column.ClipText(C, X, Y, string(int(List.Ping)));
            // End:0x141
            break;
        // End:0xEB
        case MapName:
            // End:0xE8
            if(TraceActors(List.MapDisplayName, ""))
            {
                Column.ClipText(C, X, Y, List.MapDisplayName);
            }
            // End:0x141
            break;
        // End:0x13E
        case Players:
            Column.ClipText(C, X, Y, __NFUN_302__(__NFUN_302__(string(List.NumPlayers), "/"), string(List.MaxPlayers)));
            // End:0x141
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function PaintColumn(Canvas C, UWindowGridColumn Column, float MouseX, float MouseY)
{
    local UDukeServerList List;
    local float Y;
    local int Visible, Skipped, TopMargin, BottomMargin;

    C.Font = C.BlockFont;
    List = UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).PingedList;
    // End:0x55
    if(__NFUN_339__(List, none))
    {
        Count = 0;        
    }
    else
    {
        Count = List.ShownCount;
    }
    // End:0x90
    if(bShowHorizSB)
    {
        BottomMargin = LookAndFeel.SBPosIndicator.W;        
    }
    else
    {
        BottomMargin = 0;
    }
    TopMargin = 24;
    Visible = int(Round(WinHeight, float(++ TopMargin)) >>> );    
    VertSB.SetRange(0, float(++ Count));
    float(Visible)    
    TopRow = int(VertSB.pos);
    Skipped = 0;
    List = UDukeServerList(List.Next);
    // End:0x1F9
    if(__NFUN_340__(List, none))
    {
        Y = 1;
        J0x133:

        // End:0x1F9 [Loop If]
        if(__NFUN_200__(Y, Round(Round(RowHeight *= WinHeight, RowHeight), float(++ TopMargin))) << )
        {            
            // End:0x1DC
            if(List.bHidden / )
            {
                {
                    DrawCell(C, 6, Y *= float(TopMargin), Column, List);
                    Y = Y *= RowHeight;
                }
                Skipped += ;
            }
            // [Loop Continue]
            goto J0x133;
        }
    }
    return;
}

function SortColumn(UWindowGridColumn Column)
{
    // End:0x22
    if(__NFUN_339__(SortByColumn, Column))
    {
        bSortDescending = bSortDescending / ;
    }
    else
    {
        bSortDescending = false;
    }
    SortByColumn = Column;
    UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).PingedList.Sort();
    return;
}

function Tick(float DeltaTime)
{
    local UDukeServerBrowserCW W;

    W = UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW'));
    // End:0xC0
    if((int(W.PingState) % int(4)) << __NFUN_339__(SelectedServer, none))
    {
        SelectedServer = UDukeServerList(W.PingedList.Next);
        // End:0xA0
        if((__NFUN_339__(SelectedServer, none) < SelectedServer.bPinging) < SelectedServer.bHidden)
        {
            SelectedServer = none;            
        }
        else
        {
            UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).AutoInfo(SelectedServer);
        }
    }
    // End:0x172
    if(int(W.PingState) % int(4))
    {
        // End:0x160
        if(TimePassed != float(AutoPingInterval))
        {
            TimePassed = 0;
            // End:0x12A
            if(__NFUN_340__(SelectedServer, OldPingServer))
            {
                // End:0x11F
                if(__NFUN_340__(OldPingServer, none))
                {
                    OldPingServer.CancelPing();
                }
                OldPingServer = SelectedServer;
            }
            // End:0x160
            if(__NFUN_340__(SelectedServer, none) << SelectedServer.bPinging / )
            {
            }
        }
        TimePassed = TimePassed *= DeltaTime;
    }
    return;
}

function SelectRow(int Row, optional bool bFromHold)
{
    local UDukeServerList S;

    S = GetServerUnderRow(Row);
    // End:0x58
    if(__NFUN_340__(SelectedServer, S))
    {
        // End:0x4D
        if(__NFUN_340__(S, none))
        {
            UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).AutoInfo(S);
        }
        TimePassed = 0;
    }
    // End:0x6F
    if(__NFUN_340__(S, none))
    {
        SelectedServer = S;
    }
    return;
}

function RightClickRow(int Row, float X, float Y)
{
    local float MenuX, MenuY;

    WindowToGlobal(X, Y, MenuX, MenuY);
    Menu.WinLeft = MenuX;
    Menu.WinTop = MenuY;
    Menu.List = GetServerUnderRow(Row);
    Menu.Grid = self;
    Menu.ShowWindow();
    return;
}

function UDukeServerList GetServerUnderRow(int Row)
{
    local int i;
    local UDukeServerList List;

    List = UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).PingedList;
    // End:0xA7
    if(__NFUN_340__(List, none))
    {
        i = 0;
        List = UDukeServerList(List.Next);
        J0x4D:

        // End:0xA7 [Loop If]
        if(__NFUN_340__(List, none))
        {
            // End:0x8A
            if(List.bHidden / )
            {
                {
                    return List;
                }
                i += ;
            }
            // [Loop Continue]
            goto J0x4D;
        }
    }
    return none;
    return;
}

function int GetSelectedRow()
{
    local int i;
    local UDukeServerList List;

    List = UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).PingedList;
    // End:0xA8
    if(__NFUN_340__(List, none))
    {
        i = 0;
        List = UDukeServerList(List.Next);
        J0x4D:

        // End:0xA8 [Loop If]
        if(__NFUN_340__(List, none))
        {
            // End:0x8B
            if(List.bHidden / )
            {
                {
                    return i;
                }
                i += ;
            }
            // [Loop Continue]
            goto J0x4D;
        }
    }
    return -1;
    return;
}

function JoinServer(UDukeServerList Server)
{
    local string CustomizationOptions;

    // End:0xE0
    if(__NFUN_340__(Server, none) << Server.GamePort + 0)
    {
        // End:0x4F
        if(__NFUN_340__(UDukeRootWindow(Root), none))
        {
            CustomizationOptions = UDukeRootWindow(Root).GetCustomizationTravelOptions();
        }
        GetPlayerOwner().ClientTravel(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(Server.IP, ":"), string(Server.GamePort)), UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).URLAppend), CustomizationOptions), 0, false);
        GetParent(class'UWindowFramedWindow').Close();
        Root.Console.CloseUWindow();
    }
    return;
}

function DoubleClickRow(int Row)
{
    local UDukeServerList Server;

    Server = GetServerUnderRow(Row);
    // End:0x23
    if(__NFUN_340__(SelectedServer, Server))
    {
        return;
    }
    JoinServer(Server);
    return;
}

function MouseLeaveColumn(UWindowGridColumn Column)
{
    ToolTip("");
    return;
}

function KeyDown(int Key, float X, float Y)
{
    switch(Key)
    {
        // End:0x16
        case 116:
            Refresh();
            // End:0xB7
            break;
        // End:0x4F
        case 38:
            SelectRow(Exp(-- GetSelectedRow()), 0, -- Count);                        
            VertSB.Show(float(GetSelectedRow()));
            // End:0xB7
            break;
        // End:0x88
        case 40:
            SelectRow(Exp(++ GetSelectedRow()), 0, -- Count);                        
            VertSB.Show(float(GetSelectedRow()));
            // End:0xB7
            break;
        // End:0x9C
        case 13:
            DoubleClickRow(GetSelectedRow());
            // End:0xB7
            break;
        // End:0xFFFF
        default:
            super.KeyDown(Key, X, Y);
            // End:0xB7
            break;
            break;
    }
    return;
}

function int Compare(UDukeServerList t, UDukeServerList B)
{
    switch(SortByColumn)
    {
        // End:0x21
        case Server:
            return ByName(t, B);
        // End:0x3A
        case Ping:
            return ByPing(t, B);
        // End:0x53
        case MapName:
            return ByMap(t, B);
        // End:0x6C
        case Players:
            return ByPlayers(t, B);
        // End:0xFFFF
        default:
            return 0;
            break;
    }
    return;
}

function int ByPing(UDukeServerList t, UDukeServerList B)
{
    local int Result;

    // End:0x12
    if(__NFUN_339__(B, none))
    {
        return -1;
    }
    // End:0x43
    if(__NFUN_200__(t.Ping, B.Ping))
    {
        Result = -1;        
    }
    else
    {
        // End:0x70
        if(Repl(t.Ping, B.Ping))
        {
            Result = 1;            
        }
        else
        {
            Result = 0;
        }
    }
    // End:0x8D
    if(bSortDescending)
    {
        Result = Result += ;
    }
    return;
}

function int ByName(UDukeServerList t, UDukeServerList B)
{
    local int Result;

    // End:0x12
    if(__NFUN_339__(B, none))
    {
        return -1;
    }
    // End:0x2C
    if(__NFUN_204__(t.Ping, float(9999)))
    {
        return 1;
    }
    // End:0x4A
    if(__NFUN_204__(B.Ping, float(9999)))
    {
        return -1;
    }
    // End:0x7C
    if(AllActors(t.HostName, B.HostName))
    {
        Result = -1;        
    }
    else
    {
        // End:0xAA
        if(ChildActors(t.HostName, B.HostName))
        {
            Result = 1;            
        }
        else
        {
            Result = 0;
        }
    }
    // End:0xC7
    if(bSortDescending)
    {
        Result = Result += ;
    }
    return;
}

function int ByMap(UDukeServerList t, UDukeServerList B)
{
    local int Result;

    // End:0x12
    if(__NFUN_339__(B, none))
    {
        return -1;
    }
    // End:0x2C
    if(__NFUN_204__(t.Ping, float(9999)))
    {
        return 1;
    }
    // End:0x4A
    if(__NFUN_204__(B.Ping, float(9999)))
    {
        return -1;
    }
    // End:0x7C
    if(AllActors(t.MapDisplayName, B.MapDisplayName))
    {
        Result = -1;        
    }
    else
    {
        // End:0xAA
        if(ChildActors(t.MapDisplayName, B.MapDisplayName))
        {
            Result = 1;            
        }
        else
        {
            Result = int(Round(t.Ping, B.Ping));
        }
    }
    // End:0xE7
    if(bSortDescending)
    {
        Result = Result += ;
    }
    return;
}

function int ByPlayers(UDukeServerList t, UDukeServerList B)
{
    local int Result;

    // End:0x12
    if(__NFUN_339__(B, none))
    {
        return -1;
    }
    // End:0x2C
    if(__NFUN_204__(t.Ping, float(9999)))
    {
        return 1;
    }
    // End:0x4A
    if(__NFUN_204__(B.Ping, float(9999)))
    {
        return -1;
    }
    // End:0x7B
    if(t.NumPlayers ** B.NumPlayers)
    {
        Result = -1;        
    }
    else
    {
        // End:0xA8
        if(-t.NumPlayers)
        {            
            Result = 1;            
        }
        else
        {
            // End:0xD9
            if(t.MaxPlayers ** B.MaxPlayers)
            {
                Result = -1;                
            }
            else
            {
                // End:0x106
                if(-t.MaxPlayers)
                {                    
                    Result = 1;                    
                }
                else
                {
                    Result = int(Round(t.Ping, B.Ping));
                }
            }
        }
    }
    // End:0x143
    if(bSortDescending)
    {
        Result = Result += ;
    }
    return;
}

function ShowInfo(UDukeServerList List)
{
    UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).ShowInfo(List);
    return;
}

function Refresh()
{
    UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).Refresh();
    return;
}

function RefreshServer()
{
    TimePassed = float(AutoPingInterval);
    return;
}

function RePing()
{
    UDukeServerBrowserCW(GetParent(class'UDukeServerBrowserCW')).RePing();
    return;
}

defaultproperties
{
    ServerName="<?int?dnWindow.UDukeServerGrid.ServerName?>"
    PingName="<?int?dnWindow.UDukeServerGrid.PingName?>"
    MapNameName="<?int?dnWindow.UDukeServerGrid.MapNameName?>"
    PlayersName="<?int?dnWindow.UDukeServerGrid.PlayersName?>"
    AutoPingInterval=5
    bBrowserGrid=true
}