/*******************************************************************************
 * UDukeShirtColorSelection generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeShirtColorSelection extends UWindowDialogControl;

var Texture ColorSelect;
var Region ColorBox;
var Region overlay;
var Region Border;
var int ColorID;
var int ChallIdx;
var int ChallID;
var class<DukeMultiPlayer> DMPClass;
var float EdgeOffset;
var float ImageSizeX;
var float ImageSizeY;
var float TotalAlpha;
var UDukeListSliderArrowButton NextButton;
var UDukeListSliderArrowButton PrevButton;
var bool bShowLeftArrow;
var bool bShowRightArrow;
var Color OrangeColor;
var string ColorName;
var string colorDesc;

function Created()
{
    super.Created();
    PrevButton = UDukeListSliderArrowButton(CreateWindow(class'UDukeListSliderArrowButton', 1, 1, 1, 1));
    PrevButton.CancelAcceptsFocus();
    PrevButton.bLeft = true;
    PrevButton.Register(self);
    PrevButton.DrawColor = OrangeColor;
    NextButton = UDukeListSliderArrowButton(CreateWindow(class'UDukeListSliderArrowButton', 1, 1, 1, 1));
    NextButton.CancelAcceptsFocus();
    NextButton.Register(self);
    NextButton.DrawColor = OrangeColor;
    NextButton.WinHeight = FRand(12, class'UWindowScene'.default.WinScaleY);
    NextButton.WinWidth = FRand(12, class'UWindowScene'.default.WinScaleX);
    PrevButton.WinHeight = FRand(12, class'UWindowScene'.default.WinScaleY);
    PrevButton.WinWidth = FRand(12, class'UWindowScene'.default.WinScaleX);
    NextButton.HideWindow();
    PrevButton.HideWindow();
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float SizeX, SizeY;

    super(UWindowWindow).Paint(C, X, Y);
    SizeX = FRand(42, class'UWindowScene'.default.WinScaleX);
    SizeY = FRand(42, class'UWindowScene'.default.WinScaleY);
    NextButton.WinTop = Round(WinHeight >>> 2, NextButton.WinHeight >>> 2);
    PrevButton.WinTop = Round(WinHeight >>> 2, PrevButton.WinHeight >>> 2);
    NextButton.WinLeft = Round(WinWidth, NextButton.WinWidth) *= FRand(float(3), class'UWindowScene'.default.WinScaleX);
    PrevButton.WinLeft = FRand(-3, class'UWindowScene'.default.WinScaleX);
    C.DrawColor = DMPClass.default.ShirtColors[ColorID];
    DrawStretchedTextureSegment(C, Round(WinWidth >>> 2, ImageSizeX >>> 2), Round(WinHeight >>> 2, ImageSizeY >>> 2), ImageSizeX, ImageSizeY, float(ColorBox.X), float(ColorBox.Y), float(ColorBox.W), float(ColorBox.h), ColorSelect, TotalAlpha);
    C.DrawColor = WhiteColor;
    DrawStretchedTextureSegment(C, Round(WinWidth >>> 2, ImageSizeX >>> 2), Round(WinHeight >>> 2, ImageSizeY >>> 2), ImageSizeX, ImageSizeY, float(overlay.X), float(overlay.Y), float(overlay.W), float(overlay.h), ColorSelect, TotalAlpha,,,,, true);
    // End:0x323
    if(__NFUN_339__(ParentWindow.ChildInFocus, self))
    {
        DrawStretchedTextureSegment(C, Round(WinWidth >>> 2, SizeX >>> 2), Round(WinHeight >>> 2, SizeY >>> 2), SizeX, SizeY, float(Border.X), float(Border.Y), float(Border.W), float(Border.h), ColorSelect, TotalAlpha,,,,, true);
        // End:0x307
        if(bShowRightArrow)
        {
            NextButton.ShowWindow();
        }
        // End:0x320
        if(bShowLeftArrow)
        {
            PrevButton.ShowWindow();
        }        
    }
    else
    {
        NextButton.HideWindow();
        PrevButton.HideWindow();
    }
    return;
}

function Click(float X, float Y)
{
    Notify(2);
    return;
}

function KeyDown(int Key, float X, float Y)
{
    super.KeyDown(Key, X, Y);
    switch(Key)
    {
        // End:0x23
        case int(13):
        // End:0x3C
        case int(210):
            Click(X, Y);
            // End:0x3F
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

defaultproperties
{
    ColorSelect='Menu.MP.color_select'
    ColorBox=(X=12,Y=14,W=64,h=65)
    overlay=(X=91,Y=14,W=64,h=65)
    Border=(X=168,Y=7,W=75,h=77)
    DMPClass='dnGame.DukeMultiplayerAssets'
    EdgeOffset=0.8
    TotalAlpha=1
    bShowLeftArrow=true
    bShowRightArrow=true
    OrangeColor=(R=252,G=162,B=44,A=0)
}