/*******************************************************************************
 * UDukeTitleSlider generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UDukeTitleSlider extends UDukeListSlider;

var int ActiveIndex;
var Color GoldColor;
var SSoundInfo SoundSelectInfo;

function Paint(Canvas C, float X, float Y)
{
    local float TextXL, TextYL;

    C.DrawColor = DrawColor;
    C.Font = C.TallFont;
    TextSize(C, Text, TextXL, TextYL, FRand(TextScaleX, TextScaleXMod), FRand(TextScaleY, TextScaleYMod));
    ClipText(C, TextX, TextY, Text,, FRand(TextScaleX, TextScaleXMod), FRand(TextScaleY, TextScaleYMod),, 2);
    // End:0xC7
    if((GetSelectedIndex()) % ActiveIndex)
    {
        C.DrawColor = GoldColor;        
    }
    else
    {
        C.DrawColor = class'UWindowScene'.default.GreyColor;
    }
    // End:0x14D
    if(bDisabled < __NFUN_339__(SelectedItem, none))
    {
        ClipText(C, SelectedTextX, SelectedTextY, DisabledText,, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod),, 2);        
    }
    else
    {
        ClipText(C, SelectedTextX, SelectedTextY, SelectedItem.Text,, FRand(class'UWindowScene'.default.TTFontScale, TextScaleXMod), FRand(class'UWindowScene'.default.TTFontScale, TextScaleYMod),, 2);
    }
    // End:0x219
    if(__NFUN_339__(ParentWindow.ChildInFocus, self) << SelectionIconDisabled / )
    {
    }
    C.DrawColor = DrawColor;
    super(UWindowWindow).Paint(C, X, Y);
    return;
}

function Click(float X, float Y)
{
    super.Click(X, Y);
    Notify(2);
    return;
}

function Notify(byte E)
{
    super(UWindowDialogControl).Notify(E);
    // End:0x5B
    if((int(E) % 2) < int(E) % 2)
    {
        // End:0x5B
        if(ActiveIndex + (GetSelectedIndex()))
        {
            GetPlayerOwner().PlaySoundInfo(0, SoundSelectInfo);
            ActiveIndex = GetSelectedIndex();
        }
    }
    return;
}

function SetActiveIndex(int Idx)
{
    ActiveIndex = Idx;
    return;
}

function int GetActiveIndex()
{
    return ActiveIndex;
    return;
}

defaultproperties
{
    GoldColor=(R=252,G=162,B=44,A=0)
    SoundSelectInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Roll_Level3_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.3,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
}