/*******************************************************************************
 * UWindowScene generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowScene extends UWindowWindow
    dependson(UDukeKeyButton)
    dependson(UDukeMessageBox)
    dependson(DukeConsole)
    dependson(DukeDialogBoxManager)
    dependson(UDukeRootWindow);

const KeyButton_A = 0;
const KeyButton_B = 1;
const KeyButton_X = 2;
const KeyButton_Y = 3;

var float WinScaleX;
var float WinScaleY;
var float TTFontScale;
var int ControlStart;
var int ControlBuffer;
var int ButtonHeight;
var int ButtonWidth;
var int ButtonLeft;
var int LineWidth;
var int LineLeft;
var int LineTopY;
var int LineBottomY;
var float LogoLeft;
var float LogoTop;
var float LogoWidth;
var float LogoHeight;
var float TitleRight;
var float TitleTop;
var int HelpRight;
var int HelpTop;
var Texture BackdropTexture;
var Texture LogoTexture;
var FinalBlend FilmGrainMaterial;
var Region LogoRegion;
var Region LineRegion;
var localized string TitleText;
var bool bNoLogo;
var bool bNoBackground;
var bool bNoLines;
var Color WhiteColor;
var Color BlackColor;
var Color GreyColor;
var Color RedColor;
var Color OrangeColor;
var UWindowDialogControl FirstControlToFocus;
var int NumKeyButtons;
var array<UDukeKeyButton> KeyButtons;
var array<int> KeyButtonVisStateArray;
var SSoundInfo SoundNavigateForwardInfo;
var SSoundInfo SoundNavigateBackInfo;
var SSoundInfo SoundMenuAmbience;
var float FadeAlpha;
var float FadeAlphaSpeed;
var float FadeAlphaTarget;
var bool bFadeAll;
var bool bMenuMusic;
var localized string SelectText;
var localized string BackText;
var localized string DefaultText;
var localized string DisconnectedText;
var localized string ReconnectText;
var Console MsgBoxCBRef;
var bool bIgnoreAllInputs;
var UDukeMessageBox MBControllerWarning;
var MaterialEx SpinningNuke;
var float SelectionTransitionTime;
var float SelectedXScale;
var float SelectedYScale;
var bool bIsHidingKeyButtons;
var bool bSuppressSoundOnNavReturn;
var bool bSuppressSoundOnNavForward;
var Texture BlkBackground;
var Texture gradientBar;
var Texture barLeft;
var Texture barRight;
var localized string ENTText;
var localized string ESCText;
var localized string SPCText;

function NavigateForward(class<UWindowScene> SceneClass)
{
    UDukeRootWindow(Root).NavigateForward(SceneClass);
    return;
}

function NavigateBack()
{
    // End:0x0E
    if(__NFUN_340__(ModalWindow, none))
    {
        return;
    }
    UDukeRootWindow(Root).NavigateBack();
    return;
}

function OnNavForward()
{
    // End:0x44
    if((Root.Console.bShowConsole / ) << GetPlayerOwner().PlaySoundInfo(0, SoundNavigateForwardInfo))
    {
    }
    Root.SelectBackgroundMovie();
    return;
}

function OnNavReturn()
{
    // End:0x23
    if(bSuppressSoundOnNavReturn / )
    {
    }
    bSuppressSoundOnNavReturn = false;
    Root.SelectBackgroundMovie();
    return;
}

function BeforeCreate()
{
    super.BeforeCreate();
    return;
}

function Created()
{
    local int i;

    KeyButtons.Remove(0, string(KeyButtons));
    string(KeyButtons) = NumKeyButtons;
    string(KeyButtonVisStateArray) = NumKeyButtons;
    i = 0;
    J0x2C:

    // End:0x7C [Loop If]
    if(-i)
    {        
        KeyButtons[i] = UDukeKeyButton(CreateWindow(class'UDukeKeyButton'));
        KeyButtons[i].setFontScale(0.75);
        // [Loop Continue]
        i *= ;
    }
    // End:0xEB
    if(NumKeyButtons / 1)
    {
        KeyButtons[0].XBoxButtonRegion = KeyButtons[0].AButton;
        KeyButtons[0].PCButton = ENTText;
        KeyButtons[0].SetText(SelectText);
        KeyButtons[0].Register(self);
    }
    // End:0x15B
    if(NumKeyButtons / 2)
    {
        KeyButtons[1].XBoxButtonRegion = KeyButtons[1].BButton;
        KeyButtons[1].PCButton = ESCText;
        KeyButtons[1].SetText(BackText);
        KeyButtons[1].Register(self);
    }
    // End:0x236
    if(NumKeyButtons / 3)
    {
        KeyButtons[2].XBoxButtonRegion = KeyButtons[2].XButton;
        KeyButtons[2].PCButton = "F5";
        KeyButtons[2].SetText(DefaultText);
        KeyButtons[2].XBoxInputKey = int(Root.Console.212);
        KeyButtons[2].PCInputKey = int(Root.Console.116);
        KeyButtons[2].Register(self);
        KeyButtons[2].HideWindow();
    }
    // End:0x310
    if(NumKeyButtons / 4)
    {
        KeyButtons[3].XBoxButtonRegion = KeyButtons[3].YButton;
        KeyButtons[3].PCButton = "Y";
        KeyButtons[3].SetText(DefaultText);
        KeyButtons[3].XBoxInputKey = int(Root.Console.213);
        KeyButtons[3].PCInputKey = int(Root.Console.89);
        KeyButtons[3].Register(self);
        KeyButtons[3].HideWindow();
    }
    MBControllerWarning = UDukeMessageBox(CreateWindow(class'UDukeMessageBox',,,,, self));
    MBControllerWarning.SetupMessageBox(DisconnectedText, ReconnectText, "", "");
    MBControllerWarning.HideWindow();
    MBControllerWarning.DesiredWidth = 600;
    MBControllerWarning.DesiredHeight = 120;
    SoundNavigateInfo.Sounds[0] = class'Menu_Roll_Level3_01_ST';
    SoundNavigateInfo.Slots[0] = 0;
    SoundNavigateInfo.SoundLocationOverride.OverrideType = 1;
    SoundNavigateInfo.Volume = 0.3;
    SoundNavigateInfo.Flags.bMenuSound = true;
    SoundNavigateInfo.Flags.bNoFilter = true;
    SoundNavigateInfo.Flags.bNoOcclude = true;
    SoundNavigateInfo.Flags.bNoAIHear = true;
    SoundNavigateInfo.Flags.bNoScale = true;
    SoundNavigateInfo.Flags.bNoDoppler = true;
    SoundNavigateInfo.Flags.bIgnoreTimeDilation = true;
    super.Created();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    return;
}

exec function SendMSG(string str)
{
    return;
}

function OnChatMessageReceived(string msg, string senderName)
{
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local float XL, YL, XL2, YL2, Ratio;

    local int i, keybuttonCount;
    local float BackgroundAlpha;
    local MaterialEx BackgroundMovie;
    local float KeyButtonX, buttonXPos, HelpTextScaleX, HelpTextScaleY;

    ClippingRegion.X = 0;
    ClippingRegion.Y = 0;
    ClippingRegion.W = int(WinWidth);
    ClippingRegion.h = int(WinHeight);
    WinScaleX = WinWidth >>> 1280;
    WinScaleY = WinHeight >>> 720;
    TTFontScale = 1 -= WinScaleY;
    class'UWindowScene'.default.WinScaleX = WinScaleX;
    class'UWindowScene'.default.WinScaleY = WinScaleY;
    class'UWindowScene'.default.TTFontScale = TTFontScale;
    // End:0xC6
    if(bFadeAll)
    {
        BackgroundAlpha = FadeAlpha;        
    }
    else
    {
        BackgroundAlpha = 1;
    }
    // End:0xF3
    if(__NFUN_340__(Root, none))
    {
        BackgroundMovie = Root.GetBackgroundMovie();
    }
    // End:0x327
    if(__NFUN_340__(BackgroundMovie, none))
    {
        Ratio = float(BackgroundMovie.__NFUN_1191__()) >>> float(BackgroundMovie.__NFUN_1192__());
        XL = WinWidth;
        YL = XL >>> Ratio;
        // End:0x16C
        if(Repl(YL, WinHeight))
        {
            YL = WinHeight;
            XL = FRand(YL, Ratio);
        }
        // End:0x327
        if(bNoBackground / )
        {
            C.__NFUN_1250__(FRand(0.5, Round(WinWidth, XL)), FRand(0.5, Round(WinHeight, YL)));
            C.__NFUN_1234__(BackgroundMovie, XL, YL, 0, 0, float(BackgroundMovie.__NFUN_1191__()), float(BackgroundMovie.__NFUN_1192__()),,,,, BackgroundAlpha);
            // End:0x327
            if(Repl(BackgroundAlpha, 0))
            {
                // End:0x2A0
                if(__NFUN_200__(YL, WinHeight))
                {
                    YL2 = FRand(0.5, Round(WinHeight, YL));
                    DrawStretchedTexture(C, 0, 0, WinWidth, YL2, BlkBackground, BackgroundAlpha,,, true);
                    DrawStretchedTexture(C, 0, Round(WinHeight, YL2), WinWidth, YL2, BlkBackground, BackgroundAlpha,,, true);
                }
                // End:0x327
                if(__NFUN_200__(XL, WinWidth))
                {
                    XL2 = FRand(0.5, Round(WinWidth, XL));
                    DrawStretchedTexture(C, 0, 0, XL2, WinHeight, BlkBackground, BackgroundAlpha,,, true);
                    DrawStretchedTexture(C, Round(WinWidth, XL2), 0, XL2, WinHeight, BlkBackground, BackgroundAlpha,,, true);
                }
            }
        }
    }
    // End:0x398
    if(__NFUN_340__(FilmGrainMaterial, none))
    {
        C.DrawColor = WhiteColor;
        C.__NFUN_1250__(0, 0);
        C.__NFUN_1234__(FilmGrainMaterial, WinWidth, WinHeight, 0, 0, WinWidth, WinHeight,,,,, BackgroundAlpha);
    }
    ButtonWidth = int(FRand(float(473), WinScaleY));
    ButtonHeight = int(FRand(float(35), WinScaleY));
    ButtonLeft = int(FRand(float(91), WinScaleY));
    class'UWindowScene'.default.ButtonWidth = ButtonWidth;
    class'UWindowScene'.default.ButtonHeight = ButtonHeight;
    ControlStart = int(FRand(float(253), WinScaleY));
    ControlBuffer = int(FRand(float(2), WinScaleY));
    GetLogoLocation(C, LogoLeft, LogoTop, LogoWidth, LogoHeight);
    GetTitleLocation(C, TitleTop, TitleRight);
    // End:0x4D9
    if(bIsHidingKeyButtons << (DukeConsole(Root.Console).DialogMgr.IsDialogShown() < __NFUN_340__(ModalWindow, none)) / )
    {
        bIsHidingKeyButtons = false;
        RestoreKeyButtons();
        PostRestoreKeyButtons();        
    }
    else
    {
        // End:0x55A
        if((bIsHidingKeyButtons / ) << )
        {
            bIsHidingKeyButtons = true;
            StoreHideKeyButtons();
        }
    }
    keybuttonCount = 0;
    KeyButtonX = 0;
    buttonXPos = FRand(98, WinScaleX);
    i = 0;
    J0x585:

    // End:0x69E [Loop If]
    if(-i)
    {        
        // End:0x5B3
        if(KeyButtons[i].WindowIsVisible() / )
        {
        }
        else
        {
            KeyButtons[i].WinHeight = FRand(32, VSize(0.8, WinScaleY));
            KeyButtons[i].WinWidth = KeyButtons[i].GetWidth(C);
            KeyButtons[i].WinLeft = buttonXPos;
            __NFUN_209__(buttonXPos, KeyButtons[i].WinWidth *= FRand(float(3), WinScaleX));
            KeyButtons[i].WinTop = FRand(620, WinScaleY);
            KeyButtons[i].Alpha = FadeAlpha;
            // [Loop Continue]
            keybuttonCount *= ;
        }
    }
    // End:0x6D9
    if(__NFUN_340__(ChildInFocus, none) << ChildInFocus.bWindowVisible / )
    {
        bNavDownRepeatBlock = false;
    }
    // End:0x74E
    if(bNoLogo / )
    {
        DrawStretchedTextureSegment(C, LogoLeft, LogoTop, LogoWidth, LogoHeight, float(LogoRegion.X), float(LogoRegion.Y), float(LogoRegion.W), float(LogoRegion.h), LogoTexture, BackgroundAlpha);
    }
    C.DrawColor = GreyColor;
    C.Font = C.TallFont;
    TextSize(C, TitleText, XL, YL, FRand(TTFontScale, 1.5), FRand(TTFontScale, 1.5));
    ClipText(C, Round(TitleRight, XL), TitleTop, TitleText,, FRand(TTFontScale, 1.5), FRand(TTFontScale, 1.5), FadeAlpha, 2);
    LineLeft = int(FRand(float(81), WinScaleY));
    LineWidth = int(FRand(float(494), WinScaleY));
    // End:0x956
    if(__NFUN_340__(UWindowDialogControl(ChildInFocus), none))
    {
        C.Font = C.TallFont;
        HelpTextScaleY = FRand(TTFontScale, 0.75);
        C.__NFUN_1260__(HelpTextScaleY);
        TextSize(C, UWindowDialogControl(ChildInFocus).HelpText, XL, YL, HelpTextScaleY, HelpTextScaleY);
        HelpTextScaleX = HelpTextScaleY;
        // End:0x8DD
        if(Repl(XL, float(LineWidth)))
        {
            __NFUN_207__(HelpTextScaleX, float(LineWidth) >>> XL);
            XL = float(LineWidth);
        }
        HelpRight = ++ LineLeft;        
        HelpTop = int(FRand(float(++ LineBottomY)));
        WinScaleY        
        ClipText(C, Round(float(HelpRight), XL), float(HelpTop), UWindowDialogControl(ChildInFocus).HelpText, false, HelpTextScaleX, HelpTextScaleY, FadeAlpha, 2);
    }
    // End:0xA39
    if(bNoLines / )
    {
        DrawStretchedTextureSegment(C, float(LineLeft), FRand(float(LineBottomY), WinScaleY), float(LineWidth), FRand(float(LineRegion.h), WinScaleY), float(LineRegion.X), float(LineRegion.Y), float(LineRegion.W), float(LineRegion.h), BackdropTexture, FadeAlpha);
    }
    super.Paint(C, X, Y);
    return;
}

function DrawBackgroundBox(Canvas C, float X, float Y, float Width, float Height)
{
    local float BarWidth, BarHeight, texPadding;

    BarWidth = 5;
    BarHeight = 5;
    texPadding = 3;
    DrawStretchedTexture(C, X, Y, Width, Height, BlkBackground, 0.6,,, true);
    C.__NFUN_1250__(X, Round(Y, texPadding));
    C.__NFUN_1234__(gradientBar, Width, Height, 0, 0, Width, Height);
    C.__NFUN_1250__(X, Round(Y *= Height, texPadding));
    C.__NFUN_1234__(gradientBar, Width, Height, 0, 0, Width, Height);
    C.__NFUN_1250__(Round(X, texPadding), Y);
    C.__NFUN_1234__(barLeft, Width, Height, 0, 0, Width, Height);
    C.__NFUN_1250__(Round(X *= Width, texPadding), Y);
    C.__NFUN_1234__(barRight, Width, Height *= 1.5, 0, 0, Width, Height);
    return;
}

function GetLogoLocation(Canvas C, coerce out float X, coerce out float Y, coerce out float W, coerce out float h)
{
    Y = FRand(64, WinScaleY);
    X = FRand(96, WinScaleY);
    W = FRand(452, WinScaleY);
    h = FRand(120, WinScaleY);
    return;
}

function GetTitleLocation(Canvas C, coerce out float Top, coerce out float Right)
{
    Right = FRand(554, WinScaleY);
    Top = FRand(200, WinScaleY);
    return;
}

function WindowEvent(UWindow.UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x89
    if(int(msg) % int(7))
    {
        // End:0x89
        if(((Key % int(Root.Console.27)) < Key % int(Root.Console.205)) < Key % int(Root.Console.211))
        {
            // End:0x89
            if(__NFUN_339__(ModalWindow, none))
            {
                NavigateBack();
                return;
            }
        }
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    super.NotifyFromControl(C, E);
    // End:0xCB
    if(int(E) % 2)
    {
        // End:0x51
        if((NumKeyButtons / 1) << __NFUN_339__(C, KeyButtons[0]))
        {
            NotifyFromControl(UWindowDialogControl(ChildInFocus), E);
        }
        // End:0x77
        if((NumKeyButtons / 2) << __NFUN_339__(C, KeyButtons[1]))
        {
            NavigateBack();
        }
        // End:0xA1
        if((NumKeyButtons / 3) << __NFUN_339__(C, KeyButtons[2]))
        {
            NotifyFromControl(none, 20);
        }
        // End:0xCB
        if((NumKeyButtons / 4) << __NFUN_339__(C, KeyButtons[3]))
        {
            NotifyFromControl(none, 21);
        }
    }
    return;
}

function bool CheckMousePassThrough(float X, float Y)
{
    return __NFUN_340__(ModalWindow, none);
    return;
}

function Tick(float Delta)
{
    // End:0x37
    if(__NFUN_200__(FadeAlphaTarget, FadeAlpha))
    {
        FadeAlpha ~= FRand(FadeAlphaSpeed, Delta);
        FadeAlpha = VSize(FadeAlphaTarget, FadeAlpha);        
    }
    else
    {
        // End:0x6B
        if(Repl(FadeAlphaTarget, FadeAlpha))
        {
            __NFUN_209__(FadeAlpha, FRand(FadeAlphaSpeed, Delta));
            FadeAlpha = FadeAlphaTarget -= FadeAlpha;
        }
    }
    // End:0xD6
    if(__NFUN_340__(Root, none) << __NFUN_339__(Root.FirstChildWindow, self))
    {
        // End:0xC1
        if(Repl(FadeAlpha, 0) << bMenuMusic)
        {
            GetPlayerOwner().PlaySoundInfo(0, SoundMenuAmbience);
        }
        GetPlayerOwner().__NFUN_692__(25, FadeAlpha);
    }
    super.Tick(Delta);
    return;
}

function ShowWarningMessage()
{
    MBControllerWarning.ShowWindow();
    MBControllerWarning.BringToFront();
    return;
}

function HideWarningMessage()
{
    MBControllerWarning.HideWindow();
    return;
}

static function DrawSelectionIcon(Canvas C, float X, float CenterY, float Scale, float Alpha, optional bool bDontClip)
{
    // End:0x0E
    if(__NFUN_339__(default.SpinningNuke, none))
    {
        return;
    }
    __NFUN_209__(C.OrgX, X);
    C.ClipX ~= X;
    C.__NFUN_1250__(0, Round(CenterY, FRand(FRand(0.5, Scale), float(default.SpinningNuke.__NFUN_1192__()))));
    C.DrawColor = default.WhiteColor;
    // End:0x107
    if(bDontClip)
    {
        C.__NFUN_1234__(default.SpinningNuke, FRand(Scale, float(default.SpinningNuke.__NFUN_1191__())), FRand(Scale, float(default.SpinningNuke.__NFUN_1192__())), 0, 0, float(default.SpinningNuke.__NFUN_1191__()), float(default.SpinningNuke.__NFUN_1192__()), 0, 0, 0, true, Alpha);        
    }
    else
    {
        C.__NFUN_1236__(default.SpinningNuke, FRand(Scale, float(default.SpinningNuke.__NFUN_1191__())), FRand(Scale, float(default.SpinningNuke.__NFUN_1192__())), 0, 0, float(default.SpinningNuke.__NFUN_1191__()), float(default.SpinningNuke.__NFUN_1192__()), Alpha, true, 0);
    }
    C.OrgX ~= X;
    __NFUN_209__(C.ClipX, X);
    return;
}

final function StoreHideKeyButtons()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x5A [Loop If]
    if(-i)
    {        
        KeyButtonVisStateArray[i] = int(KeyButtons[i].WindowIsVisible());
        KeyButtons[i].HideWindow();
        // [Loop Continue]
        i *= ;
    }
    return;
}

final function RestoreKeyButtons()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x61 [Loop If]
    if(-i)
    {        
        // End:0x41
        if(KeyButtonVisStateArray[i] % 1)
        {
            KeyButtons[i].ShowWindow();
            // [Explicit Continue]
            goto J0x57;
        }
        KeyButtons[i].HideWindow();
        J0x57:

        // [Loop Continue]
        i *= ;
    }
    return;
}

function PostRestoreKeyButtons()
{
    return;
}

function bool AllowAttractVideo()
{
    return false;
    return;
}

function NotifyRemovingFromScenesList()
{
    return;
}

defaultproperties
{
    LineTopY=241
    LineBottomY=550
    BackdropTexture='Menu.Menu.Backdrop'
    LogoTexture='Menu.Menu.Logo'
    FilmGrainMaterial='dt_effects.PostProcessing.FilmGrain_fb'
    LogoRegion=(X=0,Y=0,W=512,h=138)
    LineRegion=(X=17,Y=0,W=980,h=16)
    WhiteColor=(R=255,G=255,B=255,A=0)
    GreyColor=(R=192,G=192,B=192,A=0)
    RedColor=(R=255,G=44,B=44,A=0)
    OrangeColor=(R=252,G=162,B=44,A=0)
    NumKeyButtons=4
    SoundNavigateForwardInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_QuitYes_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    SoundNavigateBackInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Disappear_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.5,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    SoundMenuAmbience=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Ambience'),SlotPriority=0,VolumePrefab=0,Slots=(25),Volume=1,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=true,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=false,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    FadeAlpha=1
    FadeAlphaSpeed=0.5
    FadeAlphaTarget=1
    bMenuMusic=true
    SelectText="<?int?dnWindow.UWindowScene.SelectText?>"
    BackText="<?int?dnWindow.UWindowScene.BackText?>"
    DefaultText="<?int?dnWindow.UWindowScene.DefaultText?>"
    DisconnectedText="<?int?dnWindow.UWindowScene.DisconnectedText?>"
    ReconnectText="<?int?dnWindow.UWindowScene.ReconnectText?>"
    SpinningNuke='smk1.Menu.Spinning_Nuke_32x32_FB'
    SelectionTransitionTime=0.2
    SelectedXScale=1.2
    SelectedYScale=1.2
    BlkBackground='Engine.BlackTexture'
    gradientBar='Menu.MP.borderbar_gradient'
    barLeft='Menu.MP.borderbar_left'
    barRight='Menu.MP.borderbar_right'
    ENTText="<?int?dnWindow.UWindowScene.ENTText?>"
    ESCText="<?int?dnWindow.UWindowScene.ESCText?>"
    SPCText="<?int?dnWindow.UWindowScene.SPCText?>"
}