//=============================================================================
// FollowingSound
//
// - an ambient sound that follows the player around
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//=============================================================================
class FollowingSound extends Effects;

var byte FullVol;  // the volume the sound plays at before beginning to fade out when turned off
var float time;
// var float WaterZ;

function AttachToOwner()
{
	SetLocation( Owner.Location + Owner.CollisionRadius*vector(Owner.Rotation) );
	SetBase( Owner );
}

event BaseChange()
{
//	BroadcastMessage( self @ "Base=" $ Base );
	if ( Base==None && Owner!=None && !Owner.bDeleteMe && !bDeleteMe )
	{
//		BroadcastMessage( "  attempting to recover" );
		AttachToOwner();
	}
}/*
event Destroyed()
{
	BroadcastMessage( self @ "Destroyed" );
}*/

simulated function FadeIn( Actor Other )
{
	SetOwner( Other );
/*	if ( Owner.Region.Zone.bWaterZone )
	{
		WaterZ = Owner.Location.Z;
		SetPhysics( PHYS_None );
	}
*/
	GotoState( 'FadingIn' );
}

simulated function FadeOut()
{
	GotoState( 'FadingOut' );
}
/*
simulated function Tick( float dt )
{
	local vector v;

	if ( Owner.Region.Zone.bWaterZone )
	{
		v = Owner.Location;
		v.Z = WaterZ;
		SetLocation( v );
	}
}
*/
function bool OwnerUnderwater()
{
	if ( Pawn(Owner)!=None && Pawn(Owner).HeadRegion.Zone.bWaterZone
		/*&& Pawn(Owner).HeadRegion.Zone.AmbientSound!=None*/ )
	{
		SoundVolume = 0;
		return true;
	}
	return false;
}

auto state idle
{
}

state On
{
	simulated function Tick( float dt )
	{
		if ( !class'Precipitator'.default.bWeatherEnabled )
			SoundVolume = 0;
		else if ( !OwnerUnderwater() )
			SoundVolume = FullVol;
	}
/*
Begin:
	if ( class'Precipitator'.default.bWeatherEnabled )
		SoundVolume = FullVol;
	else
		SoundVolume = 0;
	Sleep( 0.1 );
	Goto( 'Begin' );
*/
}

state FadingIn
{
	simulated function Tick( float dt )
	{
//		Global.Tick(dt);

		if ( !class'Precipitator'.default.bWeatherEnabled )
		{
			time = 0.5;
			GotoState( 'On' );
			return;
		}

		time += dt;
		if ( time >= 0.5 )
		{
			time = 0.5;
			SoundVolume = FullVol;
			GotoState( 'On' );
			return;
		}

		if ( !OwnerUnderwater() )
			SoundVolume = sqrt(time*2) * FullVol;
	}
// putting SetBase() in FadeIn() or BeginState() apparently happened too soon when
// initially spawning directly into a PrecipitationZone in a level and wasn't sticking,
// but apparently the Begin label happens a frame later or something and sticks
Begin:
	AttachToOwner();
}

state FadingOut
{
	simulated function Tick( float dt )
	{
		time -= dt;
		if ( time<=0 || !class'Precipitator'.default.bWeatherEnabled )
		{
			Destroy();
			return;
		}

		if ( !OwnerUnderwater() )
			SoundVolume = sqrt(time*2) * FullVol;

//		Global.Tick(dt);
	}

	event BaseChange()
	{
		if ( time>0 && class'Precipitator'.default.bWeatherEnabled )
			Global.BaseChange();
	}
}

defaultproperties
{
//	Physics=PHYS_Trailer
	SoundVolume=0
	SoundRadius=16
}
