class Hailstone extends Raindrop;

function Landed( vector HitNormal )
{
	if ( Rand(2) == 0 )
		PlaySound( Sound'RockHit1',, 0.25,, 500, 1.5 + 0.5*FRand() );
	else
		PlaySound( Sound'RockHit2',, 0.25,, 500, 1.5 + 0.5*FRand() );
	Velocity = 0.1 * ( MirrorVectorByNormal( Velocity, HitNormal ) + vrand()*VSize(Velocity) );
	Acceleration = 2*Region.Zone.ZoneGravity;
	SetTimer( 2.0 + FRand(), false );
//	SetTimer( 2*(2.0 + FRand()) / (1 + 0.004*VSize(Owner.Target.Location-Location)), false );
	GotoState( 'Fading' );
}

function ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.bWaterZone )
	{
		if ( precipitator(Owner) != None && LastRendered() < 0.1 )
			precipitator(Owner).WaterImpact( Location, vect(0,0,1) );

		Velocity *= 0.075 - 0.05*FRand();
		SetTimer( 0.5 + FRand(), false );
//		SetTimer( 0.5 + FRand() / (1+0.1*VSize(Owner.Target.Location-Location)), false );
		Acceleration = -Velocity / TimerRate;
		GotoState( 'Fading' );
	}
}

state Fading
{
	function Landed( vector HitNormal )
	{
		// if we land on a steep slope, or hit a slope hard enough, bounce again
		if ( HitNormal.Z<0.25 || (HitNormal.Z<1 && (Velocity dot Velocity)>10000*HitNormal.Z) )
			Velocity = 0.25 * ( MirrorVectorByNormal( Velocity, HitNormal ) );
		else
		{
			SetPhysics( PHYS_None );
			bCollideWorld = false;
		}
	}

	simulated function Tick( float dt )
	{
		ScaleGlow = default.ScaleGlow * (1-TimerCounter/TimerRate);
	}

	function BeginState()
	{
		PrePivot = vect(0,0,0);
		SetRotation( RotRand(true) );
		Mesh = LodMesh'Rockchip1';
		Skin = Texture'WhiteTexture';
		DrawScale = lerp( 0.75, DrawScale, default.DrawScale );
		LifeSpan = TimerRate;
	}
}

defaultproperties
{
	bBounce=true
}
