//==============================================================================
// PrecipitationSound
//
// - an ambient sound that changes depending on if weather is enabled
//
// - set NoWeatherSound to change to a different sound when weather is disabled
// - leave NoWeatherSound as None to simply disable the sound when weather is disabled
// - leave AmbientSound as None for a sound that only takes effect when weather is disabled
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//==============================================================================
class PrecipitationSound extends AmbientSound;

// sound properties that take effect when weather is disabled
var() Sound NoWeatherSound;
var() byte NoWeatherVolume;
var() byte NoWeatherRadius;
var() byte NoWeatherPitch;

// copies of regular sound properties, so we know what to switch back to if weather is re-enabled
var Sound WeatherSound;
var byte WeatherVolume;
var byte WeatherRadius;
var byte WeatherPitch;

function PreBeginPlay()
{
	Super.PreBeginPlay();
	WeatherSound = AmbientSound;
	WeatherVolume = SoundVolume;
	WeatherRadius = SoundRadius;
	WeatherPitch = SoundPitch;
}

simulated function Tick( float dt )
{
	if ( (PrecipitationZone(Region.Zone)==None || PrecipitationZone(Region.Zone).bWeatherActive) && class'Precipitator'.default.bWeatherEnabled )
	{
		AmbientSound = WeatherSound;
		SoundVolume = WeatherVolume;
		SoundRadius = WeatherRadius;
		SoundPitch = WeatherPitch;
	}
	else
	{
		AmbientSound = NoWeatherSound;
		SoundVolume = NoWeatherVolume;
		SoundRadius = NoWeatherRadius;
		SoundPitch = NoWeatherPitch;
	}
}

defaultproperties
{
	NoWeatherVolume=190
	NoWeatherRadius=64
	NoWeatherPitch=64
	bStatic=false
}
