//=============================================================================
// Raindrop
//
// - a raindrop, used by PrecipitationZones
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//=============================================================================
class Raindrop extends Effects;

#exec TEXTURE IMPORT NAME=raindrop FILE=textures\raindrop.bmp GROUP=Skins

function PostBeginPlay()
{
	if ( !region.zone.IsA('PrecipitationZone') )
	{
		Destroy();
		return;
	}

	Super.PostBeginPlay();

	Randomize();
//	SetTimer( LifeSpan, false );
//	LifeSpan = 0;
}

function Randomize()
{
	Velocity.Z = -900 - FRand()*800;
	Velocity += PrecipitationZone(region.zone).Wind;

	SetRotation( rotator(Velocity) );
	// offset the mesh from Location, so the tip is aligned with our Location
	// Precipitator.MakeSlanty() would need to do this too to maintain perfect alignment
	// but for the speed of the drop and the relative subtlety of the slant it's not very noticable
	// forward tip ~35 units from center
	// fattest bit ~27 units from center
	PrePivot = -Normal(Velocity) * 27 * DrawScale;

	DrawScale = Default.DrawScale * (1 + FRand()*4);
	ScaleGlow = 0.3 + FRand()*0.6;
	if ( !Precipitator(Owner).ControllingZone.bSlanty )
		InitialState = 'NoSlant';
}

function Timer()
{
	Recycle();
}

simulated function Tick( float dt )
{
	SetRotation(
		rotator( Velocity - Owner.Target.Velocity*vect(0.2,0.2,0) )
	);
}
state NoSlant
{
	simulated function Tick( float dt );
}

function Landed( vector HitNormal )
{
	if ( precipitator(Owner) != None && LastRendered() < 0.1 )
		precipitator(Owner).Impact( Location-CollisionHeight*vect(0,0,1), HitNormal );

	Recycle();
}

function HitWall( vector HitNormal, Actor HitWall )
{
	Landed( HitNormal );
}

function ZoneChange( ZoneInfo NewZone )
{
	if ( NewZone.bWaterZone )
	{
		if ( precipitator(Owner) != None && LastRendered() < 0.1 )
			precipitator(Owner).WaterImpact( Location, vect(0,0,1) );

		Recycle();
	}
}

function Recycle()
{
//	if ( precipitator(Owner) == None || !precipitator(Owner).Recycle(self) )
		Destroy();
//	else
//	{
//		Randomize();
//		SetTimer( Default.LifeSpan, false );
//	}
}
/*
function Destroyed()
{
	if ( precipitator(Owner) != None )
		precipitator(Owner).RecycleFailed();

	Super.Destroyed();
}
*/
defaultproperties
{
     Physics=PHYS_Projectile
     LifeSpan=1.0
     DrawType=DT_Mesh
     Style=STY_Translucent
     Mesh=LodMesh'DeusExItems.Tracer'
     Skin=Texture'precipitation.Skins.raindrop'
     DrawScale=0.2  // 0.25
//     bCollideActors=true
     bCollideWorld=true
     // setting a collision size was causing them to fall through movers for some reason
     // this was taller than the actual drop anyway
//     CollisionHeight=20
}
