//=============================================================================
// RaindropRing
//
// - spawned when a raindrop hits water
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//=============================================================================
class RaindropRing extends Effects;

simulated function Tick(float deltaTime)
{
	DrawScale += 4.0 * deltaTime;
	ScaleGlow = LifeSpan / Default.LifeSpan;
}

function PostBeginPlay()
{
	local Rotator rot;

	Super.PostBeginPlay();


	DrawScale *= 0.5 + FRand()/2;
	
	LifeSpan -= FRand()*0.2;

	rot.Pitch = 16384;
	rot.Roll = 0;
	rot.Yaw = Rand(65535);
	SetRotation(rot);
}

defaultproperties
{
     LifeSpan=0.300000
     DrawType=DT_Mesh
     Style=STY_Translucent
     Skin=Texture'DeusExItems.Skins.FlatFXTex46'
     Mesh=LodMesh'DeusExItems.FlatFX'
     DrawScale=0.01
     bUnlit=true
}
