//=============================================================================
// SnowZone
//
// - a PrecipitationZone preconfigured for snow
//
// - also includes a static footstep function for custom player/scripted pawn classes to use
//	(see PrecipDemo.precipDemoPlayer for an example of its use)
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//=============================================================================
class SnowZone extends PrecipitationZone;

#exec TEXTURE IMPORT NAME=SnowZone FILE=textures\SnowZone.bmp GROUP=Icons Mips=Off Flags=2

#exec AUDIO IMPORT FILE=sounds\snowstep1.wav NAME=snowstep1 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep2.wav NAME=snowstep2 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep3.wav NAME=snowstep3 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep4.wav NAME=snowstep4 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep5.wav NAME=snowstep5 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep6.wav NAME=snowstep6 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep7.wav NAME=snowstep7 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep8.wav NAME=snowstep8 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep9.wav NAME=snowstep9 GROUP=Footsteps
#exec AUDIO IMPORT FILE=sounds\snowstep10.wav NAME=snowstep10 GROUP=Footsteps

var Sound SnowSteps[10];

// static function for spawning footprints in the snow
// also returns a random snow footstep sound for you
// P is the pawn who's walking in the snow
// StepSide is a persistent (non-local) variable in P to keep track of which foot to step with
// PrintClass can be used to specify a custom footprint (needs to subclass Precipitation.Footprint for SetFoot())
// see PrecipDemo.precipDemoPlayer for an example of this function's use
static function Sound SnowStep( Pawn P, out float StepSide, optional class<Footprint> PrintClass )
{
	local vector start, end, hitLoc, hitNorm;
	local Footprint print;

	if ( PrintClass == None )
		PrintClass = class'Footprint';

	start = P.Location + P.Velocity*P.CollisionRadius/P.GroundSpeed
		+ StepSide*P.CollisionRadius*(vect(0,0.5,0)>>P.Rotation);
	end = start - P.CollisionHeight*vect(0,0,2);
	P.Trace( hitLoc, hitNorm, end, start, false );
	print = P.Spawn( PrintClass,,, hitLoc, rot(16384,0,0) );
	if ( print != None )
	{
		print.SetFoot( StepSide );
		print.ReattachDecal( vector(P.Rotation) );
	}
	StepSide = -StepSide;

	return default.SnowSteps[  Rand( ArrayCount(default.SnowSteps) )  ];
}

defaultproperties
{
	PrecipRad=975  // 1400
	PrecipFreq=0.03
//	PrecipDensity=7
	PrecipClass=class'Precipitation.Snowflake'
	AltPrecipClass=None
	bSlanty=false
	PrecipitatorClass=class'Precipitation.SnowPrecipitator'

	ejectSpeed=0.0
	numPerSpawn=1
	particleTexture=Texture'Precipitation.Skins.snowflake'
	particleLifeSpan=1
	particleDrawScale=0.1  // 0.07  // 0.25
	bRandomEject=false
	bGravity=false

	bWaterParticles=true
	WaterImpactClass=None
	WaterImpactSpawnProb=0.0

	PrecipNoise=None
	NoiseVolume=0
	NoiseMult=0
	NoisePitch=0
	bSplashyFeet=false

	Texture=Texture'Precipitation.Icons.SnowZone'

	SnowSteps(0)=Sound'Precipitation.Footsteps.snowstep1'
	SnowSteps(1)=Sound'Precipitation.Footsteps.snowstep2'
	SnowSteps(2)=Sound'Precipitation.Footsteps.snowstep3'
	SnowSteps(3)=Sound'Precipitation.Footsteps.snowstep4'
	SnowSteps(4)=Sound'Precipitation.Footsteps.snowstep5'
	SnowSteps(5)=Sound'Precipitation.Footsteps.snowstep6'
	SnowSteps(6)=Sound'Precipitation.Footsteps.snowstep7'
	SnowSteps(7)=Sound'Precipitation.Footsteps.snowstep8'
	SnowSteps(8)=Sound'Precipitation.Footsteps.snowstep9'
	SnowSteps(9)=Sound'Precipitation.Footsteps.snowstep10'
}
