//=============================================================================
// Snowflake
//
// - a snowflake, used with SnowZones
//
// v0.2 (c)2005-14 Smoke39 - smoke39@gmail.com
//=============================================================================
class Snowflake extends Raindrop;

// snowflake texture courtesy of The Nameless Mod by Off Topic Productions
#exec TEXTURE IMPORT NAME=snowflake FILE=textures\snowflake.bmp GROUP=Skins

var float targetScale;

function Randomize()
{
	local float f;

	Velocity.Z = -300 - FRand()*100;
	Velocity += PrecipitationZone(region.zone).Wind;
	f = FRand();
	targetScale = default.DrawScale * (1 + f);  // default.DrawScale * (1 + f*2.3);
	DrawScale = 0;//Default.DrawScale * (1 + f*2.3);
	LifeSpan *= 1 + f/2;
	SetTimer( 0.1, true );
}

simulated function Tick( float dt )
{
	DrawScale += dt * 3 * default.DrawScale;
	if ( DrawScale >= targetScale )
	{
		DrawScale = targetScale;
		Disable( 'Tick' );
	}
}

function Timer()
{
	Acceleration = VRand() * 100;
}

defaultproperties
{
	LifeSpan=4.000000
	DrawType=DT_Sprite
	Texture=Texture'Precipitation.Skins.snowflake'  // 'Effects.Generated.WtrDrpSmall'
	DrawScale=0.1  // 0.07  // 0.150000
	CollisionHeight=0
}
