//
// DEUS_EX CNN - SerialNumber.h
//
// Serial number encryption info - Note that I'm not using TCHAR's
//
// This data is meaningless...we just use it to search through the serialized files.
// At serialization time, we replace these numbers with the username and company name
// (or email address) XORed with these numbers.
//
// It is important that the xor value in sDeusExSerialInfo does not match any byte
// in the key stream, and the key stream can not contain any zeros
//

#ifndef __SERIALNUMBER_H
#define __SERIALNUMBER_H

#define SERIALNUMBER_LEN 64
#define CHECKSUM_LEN 4

#if defined(SERIALNUMBER_XOR1)
	#define XOR 0xBA
#elif defined(SERIALNUMBER_XOR2)
	#define XOR 0x16
#elif defined(SERIALNUMBER_XOR3)
	#define XOR 0x63
#endif

static unsigned char SerialNumberKey[SERIALNUMBER_LEN] = {		0x47^XOR, 0x61^XOR, 0x0F^XOR, 0x75^XOR, 0x67^XOR, 0xB2^XOR, 0x69^XOR, 0x0E^XOR,
																0xC9^XOR, 0x5E^XOR, 0x41^XOR, 0x49^XOR, 0x6E^XOR, 0xA1^XOR, 0x54^XOR, 0x75^XOR,
																0x51^XOR, 0x10^XOR, 0xF6^XOR, 0xC1^XOR, 0xC7^XOR, 0x3C^XOR, 0x70^XOR, 0x19^XOR,
																0x5D^XOR, 0x85^XOR, 0x88^XOR, 0xC5^XOR, 0x17^XOR, 0xDE^XOR, 0x28^XOR, 0x47^XOR,
																0xE6^XOR, 0x49^XOR, 0xBC^XOR, 0x20^XOR, 0x8A^XOR, 0xE6^XOR, 0x86^XOR, 0xB2^XOR,
																0x80^XOR, 0x22^XOR, 0xB6^XOR, 0x58^XOR, 0x8B^XOR, 0xFF^XOR, 0xDC^XOR, 0xDD^XOR,
																0xEA^XOR, 0x7E^XOR, 0xD4^XOR, 0xD9^XOR, 0x1D^XOR, 0x68^XOR, 0xEE^XOR, 0xB7^XOR,
																0xC1^XOR, 0x97^XOR, 0xE2^XOR, 0xB8^XOR, 0xEE^XOR, 0x24^XOR, 0x5C^XOR, 0x74^XOR	};

static unsigned char SerialNumberCrypt[SERIALNUMBER_LEN] = {	0x9E^XOR, 0xB0^XOR, 0xA9^XOR, 0x81^XOR, 0x43^XOR, 0xEA^XOR, 0xCA^XOR, 0xFF^XOR,
																0xE5^XOR, 0x1A^XOR, 0x81^XOR, 0x17^XOR, 0x3D^XOR, 0x80^XOR, 0xBB^XOR, 0x29^XOR,
																0xEB^XOR, 0x0A^XOR, 0x02^XOR, 0x97^XOR, 0x22^XOR, 0x1D^XOR, 0x18^XOR, 0x9A^XOR,
																0xFA^XOR, 0x15^XOR, 0xD9^XOR, 0x3E^XOR, 0x4B^XOR, 0x62^XOR, 0x7C^XOR, 0x9F^XOR,
																0x48^XOR, 0xF2^XOR, 0xFF^XOR, 0x5B^XOR, 0x12^XOR, 0x8F^XOR, 0x6D^XOR, 0xB3^XOR,
																0x31^XOR, 0x0E^XOR, 0x90^XOR, 0x90^XOR, 0xBE^XOR, 0x40^XOR, 0xA2^XOR, 0xCB^XOR,
																0xBB^XOR, 0x42^XOR, 0x95^XOR, 0x25^XOR, 0x41^XOR, 0x91^XOR, 0xA5^XOR, 0x23^XOR,
																0xF1^XOR, 0x9B^XOR, 0x8A^XOR, 0x89^XOR, 0xFB^XOR, 0x73^XOR, 0x39^XOR, 0x44^XOR	};

#if defined(SERIALNUMBER_XOR1)
	static unsigned char SerialNumberChecksum[CHECKSUM_LEN] = { 0xE5, 0x18, 0x04, 0x38 };
#elif defined(SERIALNUMBER_XOR2)
	static unsigned char SerialNumberChecksum[CHECKSUM_LEN] = { 0x5D, 0xA8, 0x71, 0xBA };
#elif defined(SERIALNUMBER_XOR3)
	static unsigned char SerialNumberChecksum[CHECKSUM_LEN] = { 0xBE, 0x3F, 0xD7, 0xF2 };
#endif

#undef XOR

#endif // __SERIALNUMBER_H
