//================================================================================
// MTLDeathMatch.
//================================================================================
class MTLDeathMatch extends DeathMatchGame;

var MTLManager Z55;

event InitGame (string Z56, out string Z57)
{
	Class'V34'.V37(self,Z56,Z57);
}

function PreBeginPlay ()
{
	if ( Level.NetMode != 0 )
	{
		if ( Z55 == None )
		{
			Z55=Spawn(Class'MTLManager');
		}
		Z55.Z91=self;
	}
	Super.PreBeginPlay();
}

function PostBeginPlay ()
{
	if ( Level.NetMode != 0 )
	{
		V30(Level.SpawnNotify).V00();
	}
	Super.PostBeginPlay();
}

function bool ApproveClass (Class<PlayerPawn> S40)
{
	return True;
}

function ScoreKill (Pawn VC7, Pawn Z58)
{
}

function Killed (Pawn VC7, Pawn Z58, name VC8)
{
	Super.Killed(VC7,Z58,VC8);
	BaseMutator.ScoreKill(VC7,Z58);
}

function ChangeOption (out string Options, string OptionKey, string Z67)
{
	local string NewOptions;
	local string CurOption;
	local string CurKey;
	local string CurValue;

	NewOptions="";
JL0008:
	if ( GrabOption(Options,CurOption) )
	{
		GetKeyValue(CurOption,CurKey,CurValue);
		if ( CurKey ~= OptionKey )
		{
			CurValue=Z67;
		}
		NewOptions=NewOptions $ "?" $ CurKey $ "=" $ CurValue;
		goto JL0008;
	}
	Options=NewOptions;
}

event PreLogin (string Z56, string Z59, out string Z57, out string Z5A)
{
	Super.PreLogin(Z56,Z59,Z57,Z5A);
	if (! Z57 == "" ) goto JL0026;
JL0026:
	if ( (Len(Z56) > 800) || HasOption(Z56,string('LoadGame')) )
	{
		Z57="PreLogin Failed.";
	}
}

event PlayerPawn Login (string Portal, string Z56, out string Z57, Class<PlayerPawn> SpawnClass)
{
	local MTLPlayer Z5B;
	local string Z68;
	local string Z69;
	local int Z6A;

	if ( (MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Z57=TooManyPlayers;
		return None;
	}
	SpawnClass=DefaultPlayerClass;
	Z68=ParseOption(Z56,"Class");
	Z6A=InStr(Z68,".");
	if ( Z6A != -1 )
	{
		Z69=Mid(Z68,Z6A + 1);
		Z68=Left(Z68,Z6A);
	} else {
		Z69=Z68;
		Z68="";
	}
	if ( (Z69 ~= "MPNSF") || (Z69 ~= "MTLNSF") )
	{
		SpawnClass=Class'MTLNSF';
	} else {
		if ( (Z69 ~= "MPUNATCO") || (Z69 ~= "MTLUNATCO") )
		{
			SpawnClass=Class'MTLUNATCO';
		} else {
			if ( (Z69 ~= "MPMJ12") || (Z69 ~= "MTLMJ12") )
			{
				SpawnClass=Class'MTLMJ12';
			}
		}
	}
	ChangeOption(Z56,"Class",string(SpawnClass));
	Z5B=MTLPlayer(Super.Login(Portal,Z56,Z57,SpawnClass));
	if ( Z5B != None )
	{
		Z5B.V52(Z5B.PlayerReplicationInfo.PlayerName);
	}
	return Z5B;
}

function SetupAbilities (DeusExPlayer Z5E)
{
	local MTLPlayer Z5B;

	Z5B=MTLPlayer(Z5E);
	if ( Z5B == None )
	{
		return;
	}
	if ( Z5B.V7E )
	{
		Z5B.V7E=False;
		return;
	}
	Z5B.SkillPointsAvail=SkillsAvail;
	Z5B.SkillPointsTotal=SkillsAvail;
	if ( bAugsAllowed )
	{
		GrantAugs(Z5B,InitialAugs);
	}
}

event PostLogin (PlayerPawn Z5F)
{
	local MTLPlayer Z5B;

	Z5B=MTLPlayer(Z5F);
	Z5B.V70=Class'V34'.V59(Z5B);
	Z5B.V6F=Z55;
	if ( Z5B.bAdmin )
	{
		Z5B.PlayerReplicationInfo.bAdmin=True;
		Log(Z5B.V26(),'AdminLogin');
	}
	Z55.V43(Z5B);
	Super.PostLogin(Z5B);
}

function Logout (Pawn Z60)
{
	Super.Logout(Z60);
	if ( Z60.IsA('PlayerPawn') &&  !Z60.IsA('Spectator') && (PlayerPawn(Z60).GameReplicationInfo == None) )
	{
		NumPlayers++;
	}
}

function bool SetEndCams (string Z6B)
{
	local Pawn V9B;
	local Pawn Z6C;

	GetWinningPlayer(Z6C);
	V9B=Level.PawnList;
JL001F:
	if ( V9B != None )
	{
		if ( V9B.IsA('PlayerPawn') )
		{
			PlayerPawn(V9B).bBehindView=True;
			PlayerPawn(V9B).ViewTarget=Z6C;
		}
		V9B.ClientGameEnded();
		V9B.GotoState('GameEnded');
		V9B=V9B.nextPawn;
		goto JL001F;
	}
	return True;
}

simulated function RefreshScoreArray (DeusExPlayer Z5F)
{
	local int i;
	local int Z66;
	local PlayerReplicationInfo lpri;
	local PlayerPawn pp;

	if ( Z5F == None )
	{
		return;
	}
	pp=Z5F.UnknownFunction720();
	if ( (pp == None) || (pp.GameReplicationInfo == None) )
	{
		return;
	}
	scorePlayers=0;
	i=0;
JL0050:
	if ( i < 32 )
	{
		lpri=pp.GameReplicationInfo.PRIArray[i];
		if ( (lpri != None) && ( !lpri.bIsSpectator || lpri.bWaitingPlayer) )
		{
			scoreArray[scorePlayers].PlayerName=lpri.PlayerName;
			scoreArray[scorePlayers].Score=lpri.Score;
			scoreArray[scorePlayers].Deaths=lpri.Deaths;
			scoreArray[scorePlayers].Streak=lpri.Streak;
			scoreArray[scorePlayers].Team=lpri.Team;
			scoreArray[scorePlayers].PlayerID=lpri.PlayerID;
			scorePlayers++;
		}
		i++;
		goto JL0050;
	}
}

defaultproperties
{
    DefaultPlayerClass=Class'MTLJCDenton'
    GameReplicationInfoClass=Class'MTLGRI'
    NetPriority=10.00
}
