//================================================================================
// MTLTeam.
//================================================================================
class MTLTeam extends TeamDMGame;

var Class<MTLPlayer> V1F;
var Class<MTLPlayer> V1E;
var MTLManager Z55;

event InitGame (string Z56, out string Z57)
{
	Class'V34'.V37(self,Z56,Z57);
}

function PreBeginPlay ()
{
	if ( Level.NetMode != 0 )
	{
		if ( Z55 == None )
		{
			Z55=Spawn(Class'MTLManager');
		}
		Z55.Z91=self;
	}
	Super.PreBeginPlay();
}

function PostBeginPlay ()
{
	if ( Level.NetMode != 0 )
	{
		V30(Level.SpawnNotify).V00();
	}
	Super.PostBeginPlay();
}

function bool ApproveClass (Class<PlayerPawn> S40)
{
	return True;
}

function ScoreKill (Pawn VC7, Pawn Z58)
{
}

function Killed (Pawn VC7, Pawn Z58, name VC8)
{
	Super.Killed(VC7,Z58,VC8);
	BaseMutator.ScoreKill(VC7,Z58);
}

event PreLogin (string Z56, string Z59, out string Z57, out string Z5A)
{
	Super.PreLogin(Z56,Z59,Z57,Z5A);
	if (! Z57 == "" ) goto JL0026;
JL0026:
	if ( (Len(Z56) > 800) || HasOption(Z56,string('LoadGame')) )
	{
		Z57="PreLogin Failed.";
	}
}

event PlayerPawn Login (string Portal, string Z56, out string Z57, Class<PlayerPawn> SpawnClass)
{
	local MTLPlayer Z5B;
	local int Z5C;
	local string Z5D;

	if ( (MaxPlayers > 0) && (NumPlayers >= MaxPlayers) )
	{
		Z57=TooManyPlayers;
		return None;
	}
	Z5C=128;
	if ( HasOption(Z56,"Team") )
	{
		Z5D=ParseOption(Z56,"Team");
		if ( Z5D != "" )
		{
			Z5C=int(Z5D);
		}
	}
	if (  !ApproveTeam(Z5C) )
	{
		Z5C=128;
	}
	if ( Z5C == 128 )
	{
		Z5C=GetAutoTeam();
	}
	if ( Z5C == 1 )
	{
		SpawnClass=V1E;
	} else {
		SpawnClass=V1F;
	}
	ChangeOption(Z56,"Class",string(SpawnClass));
	ChangeOption(Z56,"Team",string(Z5C));
	Z5B=MTLPlayer(Super(DeusExMPGame).Login(Portal,Z56,Z57,SpawnClass));
	if ( Z5B != None )
	{
		Z5B.V52(Z5B.PlayerReplicationInfo.PlayerName);
	}
	return Z5B;
}

function SetupAbilities (DeusExPlayer Z5E)
{
	local MTLPlayer Z5B;

	Z5B=MTLPlayer(Z5E);
	if ( Z5B == None )
	{
		return;
	}
	if ( Z5B.V7E )
	{
		Z5B.V7E=False;
		return;
	}
	Z5B.SkillPointsAvail=SkillsAvail;
	Z5B.SkillPointsTotal=SkillsAvail;
	if ( bAugsAllowed )
	{
		GrantAugs(Z5B,InitialAugs);
	}
}

event PostLogin (PlayerPawn Z5F)
{
	local MTLPlayer Z5B;

	Z5B=MTLPlayer(Z5F);
	Z5B.V70=Class'V34'.V59(Z5B);
	Z5B.V6F=Z55;
	if ( Z5B.bAdmin )
	{
		Z5B.PlayerReplicationInfo.bAdmin=True;
		Log(Z5B.V26(),'AdminLogin');
	}
	Z55.V43(Z5B);
	Super.PostLogin(Z5B);
}

function Logout (Pawn Z60)
{
	Super.Logout(Z60);
	if ( Z60.IsA('PlayerPawn') &&  !Z60.IsA('Spectator') && (PlayerPawn(Z60).GameReplicationInfo == None) )
	{
		NumPlayers++;
	}
}

function SetTeam (DeusExPlayer Z5F)
{
	if ( Z5F.IsA(V1F.Name) )
	{
		Z5F.PlayerReplicationInfo.Team=0;
		Z5F.MultiplayerNotifyMsg(Z5F.0);
	} else {
		if ( Z5F.IsA(V1E.Name) )
		{
			Z5F.PlayerReplicationInfo.Team=1;
			Z5F.MultiplayerNotifyMsg(Z5F.1);
		} else {
			Log("Warning: Player:" $ string(Z5F) $ " has chosen an invalid team!");
		}
	}
}

function bool ChangeTeam (Pawn Z61, int NewTeam)
{
	local Class<MTLPlayer> Z62;
	local MTLPlayer Z63;

	if (  !ApproveTeam(NewTeam) )
	{
		NewTeam=128;
	}
	if ( NewTeam == 128 )
	{
		if ( PlayerPawn(Z61) != None )
		{
			NewTeam=PlayerPawn(Z61).PlayerReplicationInfo.Team;
		} else {
			return False;
		}
	}
	if (  !Super(DeusExMPGame).ChangeTeam(Z61,NewTeam) )
	{
		return False;
	}
	Z63=MTLPlayer(Z61);
	if ( Z63 == None )
	{
		return False;
	}
	if ( NewTeam == 0 )
	{
		Z62=V1F;
	} else {
		if ( NewTeam == 1 )
		{
			Z62=V1E;
		} else {
			return False;
		}
	}
	return Class'V34'.V38(Z63,Z62);
}

simulated function bool ArePlayersAllied (DeusExPlayer Z64, DeusExPlayer Z65)
{
	if ( (Z64 == None) || (Z65 == None) || (Z64.PlayerReplicationInfo == None) || (Z65.PlayerReplicationInfo == None) )
	{
		return False;
	}
	return Z64.PlayerReplicationInfo.Team == Z65.PlayerReplicationInfo.Team;
}

simulated function RefreshScoreArray (DeusExPlayer Z5F)
{
	local int i;
	local int Z66;
	local PlayerReplicationInfo lpri;
	local PlayerPawn pp;

	if ( Z5F == None )
	{
		return;
	}
	pp=Z5F.UnknownFunction720();
	if ( (pp == None) || (pp.GameReplicationInfo == None) )
	{
		return;
	}
	scorePlayers=0;
	i=0;
JL0050:
	if ( i < 32 )
	{
		lpri=pp.GameReplicationInfo.PRIArray[i];
		if ( (lpri != None) && ( !lpri.bIsSpectator || lpri.bWaitingPlayer) )
		{
			scoreArray[scorePlayers].PlayerName=lpri.PlayerName;
			scoreArray[scorePlayers].Score=lpri.Score;
			scoreArray[scorePlayers].Deaths=lpri.Deaths;
			scoreArray[scorePlayers].Streak=lpri.Streak;
			scoreArray[scorePlayers].Team=lpri.Team;
			scoreArray[scorePlayers].PlayerID=lpri.PlayerID;
			scorePlayers++;
		}
		i++;
		goto JL0050;
	}
}

defaultproperties
{
    V1F=Class'MTLUNATCO'
    V1E=Class'MTLNSF'
    DefaultPlayerClass=Class'MTLUNATCO'
    GameReplicationInfoClass=Class'MTLGRI'
    NetPriority=10.00
}
