//==============================================================================
//
// this is an example player class that shows how to use the default rainy footstep sound
// and snow footprints/footstep sound effects built into Precipitation
//
// also includes a different method of selecting random footstep sounds from arrays
// because GOSH isn't that nicer?  feel free to copy it wholesale in your mod if you like it
//
// this file is in the public domain
//
//==============================================================================
class precipDemoPlayer extends JCDentonMale;

// PRECIPITATION
// used to keep track of which foot to step with in the snow
// set this to 1 or -1 in defaultproperties
var float StepSide;

// footstep sounds - put into arrays for simpler footstep randomization code
// (not Precipitation-related, just makes PlayFootStep() easier to read)
var Sound SwimSounds[2],  WaterSteps[3];
var Sound CarpetSteps[4], GrassSteps[4];
var Sound MetalSteps[4],  TileSteps[4];
var Sound WoodSteps[4],   StoneSteps[4];

// copied from DeusExPlayer
// uses PrecipitationZone.RainStep() and SnowZone.SnowStep()
simulated function PlayFootStep()
{
	local Sound stepSound;
	local float rnd;
	local float speedFactor, massFactor;
	local float volume, pitch, range;
	local float radius, mult;
	local float volumeMultiplier;
	local DeusExPlayer pp;
	local bool bOtherPlayer;
	local float RainstepVolMod;

	// Only do this on ourself, since this takes into account aug stealth and such
	if ( Level.NetMode != NM_StandAlone )
		pp = DeusExPlayer( GetPlayerPawn() );

	if ( pp != Self )
		bOtherPlayer = True;
	else
		bOtherPlayer = False;

	rnd = FRand();

	volumeMultiplier = 1.0;
	if (IsInState('PlayerSwimming') || (Physics == PHYS_Swimming))
	{
		volumeMultiplier = 0.5;
		stepSound = SwimSounds[ rand(ArrayCount(SwimSounds)) ];
	}
	else if (FootRegion.Zone.bWaterZone)
	{
		volumeMultiplier = 1.0;
		stepSound = WaterSteps[ rand(ArrayCount(WaterSteps)) ];
	}
	else
	{
		switch(FloorMaterial)
		{
			// PRECIPITATION
			// in a proper mod, you'll want to put all your snowy surface textures in a 'Snow' group
			// and make this "case 'Snow':" (I'm only using paper 'cause it has a white texture
			//     I'm using in the demo map in lieu of any proper custom snow textures)
			// if you've already got snow textures in a bunch of maps that aren't in their own group
			// that would be a pain in the neck to change, you can test against specific textures instead
			// (DeusExPlayer.GetFloorMaterial() already gets the texture in addition to the group --
			//     you'd just need to modify it to actually save that result)
			// SnowStep() requires a persistent (non-local) variable for which foot to step with
			// and returns a random snowy footstep sound for you
			case 'Paper':
				StepSound = class'SnowZone'.static.SnowStep( self, StepSide );
				break;

			case 'Textile':
			// PRECIPITATION
			// this is only commented out because I've hijacked the Paper texture group for snow, as noted above
//			case 'Paper':
				volumeMultiplier = 0.7;
				stepSound = CarpetSteps[ rand(ArrayCount(CarpetSteps)) ];
				break;
			case 'Foliage':
			case 'Earth':
				volumeMultiplier = 0.6;
				stepSound = GrassSteps[ rand(ArrayCount(GrassSteps)) ];
				break;
			case 'Metal':
			case 'Ladder':
				volumeMultiplier = 1.0;
				stepSound = MetalSteps[ rand(ArrayCount(MetalSteps)) ];
				break;
			case 'Ceramic':
			case 'Glass':
			case 'Tiles':
				volumeMultiplier = 0.7;
				stepSound = TileSteps[ rand(ArrayCount(TileSteps)) ];
				break;
			case 'Wood':
				volumeMultiplier = 0.7;
				stepSound = WoodSteps[ rand(ArrayCount(TileSteps)) ];
				break;
			case 'Brick':
			case 'Concrete':
			case 'Stone':
			case 'Stucco':
			default:
				volumeMultiplier = 0.7;
				stepSound = StoneSteps[ rand(ArrayCount(StoneSteps)) ];
				break;
		}
	}

	// compute sound volume, range and pitch, based on mass and speed
	if (IsInState('PlayerSwimming') || (Physics == PHYS_Swimming))
		speedFactor = WaterSpeed/180.0;
	else
		speedFactor = VSize(Velocity)/180.0;

	massFactor  = Mass/150.0;
	radius      = 375.0;
	volume      = (speedFactor+0.2) * massFactor;
	range       = radius * volume;
	pitch       = (volume+0.5);
	volume      = FClamp(volume, 0, 1.0) * 0.5;		// Hack to compensate for increased footstep volume.											
	range       = FClamp(range, 0.01, radius*4);
	pitch       = FClamp(pitch, 1.0, 1.5);

	// AugStealth decreases our footstep volume
	volume *= RunSilentValue;

	// PRECIPITATION
	// check for running in the rain, then multiply the sound volume by the return value below
	// (only for the sound effect, not the AI sound event)
	RainstepVolMod = class'PrecipitationZone'.static.RainStep( self, FloorMaterial, volume, range, pitch );

	if ( Level.NetMode == NM_Standalone )
		PlaySound( stepSound, SLOT_Interact, volume*RainstepVolMod,, range, pitch );
	else	// special case for multiplayer
	{
		if ( !bIsWalking )
		{
			// Tone down player's own footsteps
			if ( !bOtherPlayer )
			{
				volume *= 0.33;
				PlaySound(stepSound, SLOT_Interact, volume*RainstepVolMod, , range, pitch);
			}
			else // Exagerate other players sounds (range slightly greater than distance you see with vision aug)
			{
				volume *= 2.0;
				range = (class'AugVision'.Default.mpAugValue * 1.2);
				volume = FClamp(volume, 0, 1.0);
				PlaySound(stepSound, SLOT_Interact, volume*RainstepVolMod, , range, pitch);
			}
		}
	}
	AISendEvent('LoudNoise', EAITYPE_Audio, volume*volumeMultiplier, range*volumeMultiplier);
}

defaultproperties
{
	// PRECIPITATION
	// need to set StepSide to 1 or -1
	// (0 would have you hopping on one leg, and if you really want to,
	//     changing the magnitude can change the spacing between the left and right footprints)
	StepSide=1

	// all them footstep sound arrays - not for Precipitation
	// but feel free to use it if you like this method
	SwimSounds(0)=Sound'DeusExSounds.Player.Swimming'
	SwimSounds(1)=Sound'DeusExSounds.Player.Treading'
	WaterSteps(0)=Sound'DeusExSounds.Player.WaterStep1'
	WaterSteps(1)=Sound'DeusExSounds.Player.WaterStep2'
	WaterSteps(2)=Sound'DeusExSounds.Player.WaterStep3'
	CarpetSteps(0)=Sound'DeusExSounds.Player.CarpetStep1'
	CarpetSteps(1)=Sound'DeusExSounds.Player.CarpetStep2'
	CarpetSteps(2)=Sound'DeusExSounds.Player.CarpetStep3'
	CarpetSteps(3)=Sound'DeusExSounds.Player.CarpetStep4'
	GrassSteps(0)=Sound'DeusExSounds.Player.GrassStep1'
	GrassSteps(1)=Sound'DeusExSounds.Player.GrassStep2'
	GrassSteps(2)=Sound'DeusExSounds.Player.GrassStep3'
	GrassSteps(3)=Sound'DeusExSounds.Player.GrassStep4'
	MetalSteps(0)=Sound'DeusExSounds.Player.MetalStep1'
	MetalSteps(1)=Sound'DeusExSounds.Player.MetalStep2'
	MetalSteps(2)=Sound'DeusExSounds.Player.MetalStep3'
	MetalSteps(3)=Sound'DeusExSounds.Player.MetalStep4'
	TileSteps(0)=Sound'DeusExSounds.Player.TileStep1'
	TileSteps(1)=Sound'DeusExSounds.Player.TileStep2'
	TileSteps(2)=Sound'DeusExSounds.Player.TileStep3'
	TileSteps(3)=Sound'DeusExSounds.Player.TileStep4'
	WoodSteps(0)=Sound'DeusExSounds.Player.WoodStep1'
	WoodSteps(1)=Sound'DeusExSounds.Player.WoodStep2'
	WoodSteps(2)=Sound'DeusExSounds.Player.WoodStep3'
	WoodSteps(3)=Sound'DeusExSounds.Player.WoodStep4'
	StoneSteps(0)=Sound'DeusExSounds.Player.StoneStep1'
	StoneSteps(1)=Sound'DeusExSounds.Player.StoneStep2'
	StoneSteps(2)=Sound'DeusExSounds.Player.StoneStep3'
	StoneSteps(3)=Sound'DeusExSounds.Player.StoneStep4'
}
