//=============================================================================
// CommandEvent.
//
// Author: Francesco Biscazzo
// Date: 2017
//
// Description: A SpecialEvent that, when triggered, executes a command.
//=============================================================================
class CommandEvent extends SpecialEvent;

var() String command;
var() bool bInstigatorContext; //If true, use instigator context instead than this SpecialEvent context.
	
function Trigger(Actor other, Pawn eventInstigator) {
	super.Trigger(other, eventInstigator);
	
	if (!bInstigatorContext)
		ConsoleCommand(command);
	else if (eventInstigator != None)
		eventInstigator.ConsoleCommand(command);
}